/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.security.filters;

import com.erudika.para.core.App;
import com.erudika.para.core.User;
import com.erudika.para.core.utils.Para;
import com.erudika.para.core.utils.ParaObjectUtils;
import com.erudika.para.core.utils.Utils;
import com.erudika.para.server.security.AuthenticatedUserDetails;
import com.erudika.para.server.security.SecurityUtils;
import com.erudika.para.server.security.UserAuthentication;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;

public class GitHubAuthFilter
extends AbstractAuthenticationProcessingFilter {
    private final CloseableHttpClient httpclient;
    private final ObjectReader jreader = ParaObjectUtils.getJsonReader(Map.class);
    private static final String PROFILE_URL = "https://api.github.com/user";
    private static final String TOKEN_URL = "https://github.com/login/oauth/access_token";
    private static final String PAYLOAD = "code={0}&redirect_uri={1}&client_id={2}&client_secret={3}";
    public static final String GITHUB_ACTION = "github_auth";

    public GitHubAuthFilter(String defaultFilterProcessesUrl) {
        super(defaultFilterProcessesUrl);
        int timeout = 30;
        this.httpclient = HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout((long)timeout, TimeUnit.SECONDS).setConnectionRequestTimeout((long)timeout, TimeUnit.SECONDS).build()).build();
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String authCode;
        String requestURI = request.getRequestURI();
        UserAuthentication userAuth = null;
        if (requestURI.endsWith(GITHUB_ACTION) && !StringUtils.isBlank((CharSequence)(authCode = request.getParameter("code")))) {
            String appid = SecurityUtils.getAppidFromAuthRequest(request);
            String redirectURI = SecurityUtils.getRedirectUrl(request);
            App app = (App)Para.getDAO().read(App.id((String)(appid == null ? Para.getConfig().getRootAppIdentifier() : appid)));
            String[] keys = Para.getConfig().getOAuthKeysForApp(app, "gh:");
            String entity = Utils.formatMessage((String)PAYLOAD, (Object[])new Object[]{authCode, Utils.urlEncode((String)redirectURI), keys[0], keys[1]});
            HttpPost tokenPost = new HttpPost(TOKEN_URL);
            tokenPost.setHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
            tokenPost.setHeader("Accept", (Object)"application/json");
            tokenPost.setEntity((HttpEntity)new StringEntity(entity));
            try (CloseableHttpResponse resp1 = this.httpclient.execute((ClassicHttpRequest)tokenPost);){
                if (resp1 != null && resp1.getEntity() != null) {
                    Map token = (Map)this.jreader.readValue(resp1.getEntity().getContent());
                    if (token != null && token.containsKey("access_token")) {
                        userAuth = this.getOrCreateUser(app, (String)token.get("access_token"));
                    } else {
                        this.logger.info((Object)("Authentication request failed with status '" + resp1.getReasonPhrase() + "' - " + token));
                    }
                    EntityUtils.consumeQuietly((HttpEntity)resp1.getEntity());
                } else {
                    this.logger.info((Object)("Authentication request failed with status '" + (resp1 != null ? resp1.getReasonPhrase() : "null") + "' and empty response body."));
                }
            }
        }
        return SecurityUtils.checkIfActive(userAuth, SecurityUtils.getAuthenticatedUser(userAuth), true);
    }

    public UserAuthentication getOrCreateUser(App app, String accessToken) throws IOException {
        UserAuthentication userAuth = null;
        User user = new User();
        if (accessToken != null) {
            HttpGet profileGet = new HttpGet(PROFILE_URL);
            profileGet.setHeader("Authorization", (Object)("token " + accessToken));
            profileGet.setHeader("Accept", (Object)"application/json");
            Map profile = null;
            try (CloseableHttpResponse resp2 = this.httpclient.execute((ClassicHttpRequest)profileGet);){
                HttpEntity respEntity = resp2.getEntity();
                if (respEntity != null) {
                    profile = (Map)this.jreader.readValue(respEntity.getContent());
                    EntityUtils.consumeQuietly((HttpEntity)respEntity);
                }
            }
            if (profile != null && profile.containsKey("id")) {
                Integer githubId = (Integer)profile.get("id");
                String pic = (String)profile.get("avatar_url");
                String email = (String)profile.get("email");
                String name = (String)profile.get("name");
                if (StringUtils.isBlank((CharSequence)email)) {
                    email = this.fetchUserEmail(githubId, accessToken);
                }
                user.setAppid(this.getAppid(app));
                user.setIdentifier("gh:" + githubId);
                user.setEmail(email);
                user = User.readUserForIdentifier((User)user);
                if (user == null) {
                    user = new User();
                    user.setActive(Boolean.valueOf(true));
                    user.setAppid(this.getAppid(app));
                    user.setEmail((String)(StringUtils.isBlank((CharSequence)email) ? Utils.getNewId() + "@github.com" : email));
                    user.setName(StringUtils.isBlank((CharSequence)name) ? "No Name" : name);
                    user.setPassword(Utils.generateSecurityToken());
                    user.setPicture(GitHubAuthFilter.getPicture(pic));
                    user.setIdentifier("gh:" + githubId);
                    String id = user.create();
                    if (id == null) {
                        throw new AuthenticationServiceException("Authentication failed: cannot create new user.");
                    }
                } else if (this.updateUserInfo(user, pic, email, name)) {
                    user.update();
                }
                userAuth = new UserAuthentication(new AuthenticatedUserDetails(user));
            } else {
                this.logger.info((Object)"Authentication request failed because user profile doesn't contain the expected attributes");
            }
        }
        return SecurityUtils.checkIfActive(userAuth, user, false);
    }

    private boolean updateUserInfo(User user, String pic, String email, String name) {
        String picture = GitHubAuthFilter.getPicture(pic);
        boolean update = false;
        if (!StringUtils.equals((CharSequence)user.getPicture(), (CharSequence)picture)) {
            user.setPicture(picture);
            update = true;
        }
        if (!StringUtils.isBlank((CharSequence)email) && !StringUtils.equals((CharSequence)user.getEmail(), (CharSequence)email)) {
            user.setEmail(email);
            update = true;
        }
        if (!StringUtils.isBlank((CharSequence)name) && !StringUtils.equals((CharSequence)user.getName(), (CharSequence)name)) {
            user.setName(name);
            update = true;
        }
        return update;
    }

    private static String getPicture(String pic) {
        if (pic != null) {
            if (pic.contains("?")) {
                return pic.substring(0, pic.indexOf(63));
            }
            return pic;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String fetchUserEmail(Integer githubId, String accessToken) {
        HttpGet emailsGet = new HttpGet("https://api.github.com/user/emails");
        emailsGet.setHeader("Authorization", (Object)("token " + accessToken));
        emailsGet.setHeader("Accept", (Object)"application/json");
        String defaultEmail = githubId + "@github.com";
        try (CloseableHttpResponse resp = this.httpclient.execute((ClassicHttpRequest)emailsGet);){
            HttpEntity respEntity = resp.getEntity();
            if (respEntity == null) return defaultEmail;
            try (InputStream is = respEntity.getContent();){
                MappingIterator emails = this.jreader.readValues(is);
                if (emails != null) {
                    String email = null;
                    while (emails.hasNext()) {
                        Map next = (Map)emails.next();
                        email = (String)next.get("email");
                        if (!next.containsKey("primary") || !((Boolean)next.get("primary")).booleanValue()) continue;
                    }
                    String string = email;
                    return string;
                }
            }
            EntityUtils.consumeQuietly((HttpEntity)respEntity);
            return defaultEmail;
        }
        catch (IOException e) {
            this.logger.warn((Object)("Failed to fetch user email from GitHub, using default: " + defaultEmail));
        }
        return defaultEmail;
    }

    private String getAppid(App app) {
        return app == null ? null : app.getAppIdentifier();
    }
}

