/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.security.filters;

import com.erudika.para.core.App;
import com.erudika.para.core.User;
import com.erudika.para.core.utils.Para;
import com.erudika.para.core.utils.ParaObjectUtils;
import com.erudika.para.core.utils.Utils;
import com.erudika.para.server.security.AuthenticatedUserDetails;
import com.erudika.para.server.security.SecurityUtils;
import com.erudika.para.server.security.UserAuthentication;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;

public class GenericOAuth2Filter
extends AbstractAuthenticationProcessingFilter {
    private static final Logger LOG = LoggerFactory.getLogger(GenericOAuth2Filter.class);
    private final CloseableHttpClient httpclient;
    private final ObjectReader jreader = ParaObjectUtils.getJsonReader(Map.class);
    private static final String PAYLOAD = "code={0}&redirect_uri={1}&scope={2}&client_id={3}&client_secret={4}&grant_type=authorization_code";
    private static final String REFRESH_PAYLOAD = "refresh_token={0}&scope={1}&client_id={2}&client_secret={3}&grant_type=refresh_token";
    public static final String OAUTH2_ACTION = "oauth2_auth";
    public static final String OAUTH2_SECOND_ACTION = "oauth2second_auth";
    public static final String OAUTH2_THIRD_ACTION = "oauth2third_auth";

    public GenericOAuth2Filter(String defaultFilterProcessesUrl) {
        super(defaultFilterProcessesUrl);
        int timeout = 30;
        this.httpclient = HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout((long)timeout, TimeUnit.SECONDS).setConnectionRequestTimeout((long)timeout, TimeUnit.SECONDS).build()).build();
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String requestURI = request.getRequestURI();
        UserAuthentication userAuth = null;
        boolean isSecond = requestURI.endsWith(OAUTH2_SECOND_ACTION);
        boolean isThird = requestURI.endsWith(OAUTH2_THIRD_ACTION);
        if (requestURI.endsWith(OAUTH2_ACTION) || isSecond || isThird) {
            String alias = isThird ? "third" : (isSecond ? "second" : "");
            String authCode = request.getParameter("code");
            if (!StringUtils.isBlank((CharSequence)authCode)) {
                String appid = SecurityUtils.getAppidFromAuthRequest(request);
                App app = (App)Para.getDAO().read(App.id((String)(appid == null ? Para.getConfig().getRootAppIdentifier() : appid)));
                Map<String, Object> token = this.tokenRequest(app, authCode, SecurityUtils.getRedirectUrl(request), alias);
                if (token != null) {
                    if (token.containsKey("access_token")) {
                        userAuth = this.getOrCreateUser(app, token.get("access_token") + Para.getConfig().separator() + token.get("refresh_token") + Para.getConfig().separator() + token.get("id_token"));
                    } else {
                        LOG.info("OAuth 2.0 token request failed with response " + token);
                    }
                }
            }
        }
        return SecurityUtils.checkIfActive(userAuth, SecurityUtils.getAuthenticatedUser(userAuth), true);
    }

    public UserAuthentication getOrCreateUser(App app, String accessToken) throws IOException {
        return this.getOrCreateUser(app, accessToken, null);
    }

    public UserAuthentication getOrCreateUser(App app, String accessToken, String alias) throws IOException {
        UserAuthentication userAuth = null;
        User user = new User();
        if (accessToken != null) {
            String[] tokens = accessToken.split(Para.getConfig().separator());
            String refreshToken = null;
            String idToken = null;
            if (tokens.length > 0) {
                accessToken = tokens[0];
            }
            if (tokens.length > 1) {
                refreshToken = tokens[1];
            }
            if (tokens.length > 2) {
                idToken = tokens[2];
            }
            boolean tokenDelegationEnabled = this.isAccessTokenDelegationEnabled(app, alias);
            Map<String, Object> profile = this.fetchProfileFromIDP(app, accessToken, idToken, alias);
            String accountIdParam = Para.getConfig().getSettingForApp(app, GenericOAuth2Filter.configKey("parameters.id", alias), "sub");
            String pictureParam = Para.getConfig().getSettingForApp(app, GenericOAuth2Filter.configKey("parameters.picture", alias), "picture");
            String emailDomain = Para.getConfig().getSettingForApp(app, GenericOAuth2Filter.configKey("domain", alias), "paraio.com");
            String emailParam = Para.getConfig().getSettingForApp(app, GenericOAuth2Filter.configKey("parameters.email", alias), "email");
            String nameParam = Para.getConfig().getSettingForApp(app, GenericOAuth2Filter.configKey("parameters.name", alias), "name");
            String gnParam = Para.getConfig().getSettingForApp(app, GenericOAuth2Filter.configKey("parameters.given_name", alias), "given_name");
            String fnParam = Para.getConfig().getSettingForApp(app, GenericOAuth2Filter.configKey("parameters.family_name", alias), "family_name");
            if (profile.containsKey(accountIdParam)) {
                Object accid = profile.get(accountIdParam);
                String oauthAccountId = accid instanceof String ? (String)accid : String.valueOf(accid);
                String email = this.getEmailFromProfile(profile, emailParam, oauthAccountId, emailDomain);
                String pic = this.getPictureFromProfile(profile, pictureParam);
                String name = this.getNameFromProfile(profile, nameParam);
                String gname = this.getGivenNameFromProfile(profile, gnParam);
                String fname = this.getFirstNameFromProfile(profile, fnParam);
                user.setAppid(this.getAppid(app));
                user.setIdentifier(this.oauthPrefix(alias).concat(oauthAccountId));
                user.setEmail(email);
                user = User.readUserForIdentifier((User)user);
                if (user == null) {
                    user = new User();
                    user.setActive(Boolean.valueOf(true));
                    user.setAppid(this.getAppid(app));
                    user.setEmail(email);
                    user.setName(StringUtils.isBlank((CharSequence)name) ? this.getFullName(gname, fname) : name);
                    user.setPassword(Utils.generateSecurityToken());
                    if (tokenDelegationEnabled) {
                        user.setIdpAccessToken(accessToken);
                        user.setIdpRefreshToken(refreshToken);
                        user.setIdpIdToken(idToken);
                        this.printTokenDebugInfo(user);
                    }
                    user.setPicture(GenericOAuth2Filter.getPicture(app, user, accessToken, alias, pic));
                    user.setIdentifier(this.oauthPrefix(alias).concat(oauthAccountId));
                    String id = user.create();
                    if (id == null) {
                        throw new AuthenticationServiceException("Authentication failed: cannot create new user.");
                    }
                } else if (this.updateUserInfo(app, user, pic, email, name, accessToken, refreshToken, idToken, alias, tokenDelegationEnabled)) {
                    user.update();
                }
                userAuth = new UserAuthentication(new AuthenticatedUserDetails(user));
            } else {
                LOG.error("Authentication was successful but OAuth 2 parameter names not configured properly - 'id' property not found in user data (data." + accountIdParam + " = null). The names available are: " + (profile != null ? profile.keySet() : null));
            }
        }
        return SecurityUtils.checkIfActive(userAuth, user, false);
    }

    private boolean updateUserInfo(App app, User user, String pic, String email, String name, String accessToken, String refreshToken, String idToken, String alias, boolean tokenDelegationEnabled) {
        String picture = GenericOAuth2Filter.getPicture(app, user, accessToken, alias, pic);
        boolean update = false;
        if (!StringUtils.equals((CharSequence)user.getPicture(), (CharSequence)picture)) {
            user.setPicture(picture);
            update = true;
        }
        if (!StringUtils.isBlank((CharSequence)email) && !StringUtils.equals((CharSequence)user.getEmail(), (CharSequence)email)) {
            user.setEmail(email);
            update = true;
        }
        if (!StringUtils.isBlank((CharSequence)name) && !StringUtils.equals((CharSequence)user.getName(), (CharSequence)name)) {
            user.setName(name);
            update = true;
        }
        if (tokenDelegationEnabled) {
            user.setIdpAccessToken(accessToken);
            user.setIdpRefreshToken(refreshToken);
            user.setIdpIdToken(idToken);
            this.printTokenDebugInfo(user);
            update = true;
        }
        return update;
    }

    public boolean isAccessTokenDelegationEnabled(App app, User user) {
        return this.isAccessTokenDelegationEnabled(app, this.oauthAlias(user.getIdentifier()));
    }

    private boolean isAccessTokenDelegationEnabled(App app, String alias) {
        return Boolean.parseBoolean(Para.getConfig().getSettingForApp(app, GenericOAuth2Filter.configKey("token_delegation_enabled", alias), "false"));
    }

    public boolean isValidAccessToken(App app, User user) {
        try {
            String alias = this.oauthAlias(user.getIdentifier());
            Map<String, Object> profile = this.fetchProfileFromIDP(app, user.getIdpAccessToken(), null, alias);
            if (user.getIdpRefreshToken() != null) {
                this.refreshTokens(app, user);
                profile = this.fetchProfileFromIDP(app, user.getIdpAccessToken(), null, alias);
            }
            return profile != null && profile.containsKey(Para.getConfig().getSettingForApp(app, GenericOAuth2Filter.configKey("parameters.id", alias), "sub"));
        }
        catch (Exception e) {
            LOG.debug("Invalid access token {}", (Throwable)e);
            return false;
        }
    }

    private Map<String, Object> fetchProfileFromIDP(App app, String accessToken, String idToken, String alias) throws IOException {
        HashMap<String, Object> profile = new HashMap<String, Object>();
        if (StringUtils.contains((CharSequence)idToken, (CharSequence)".")) {
            String idTokenDecoded = Utils.base64dec((String)StringUtils.substringBetween((String)idToken, (String)"."));
            profile.putAll((Map)this.jreader.readValue(idTokenDecoded));
        }
        String acceptHeader = Para.getConfig().getSettingForApp(app, GenericOAuth2Filter.configKey("accept_header", alias), "");
        HttpGet profileGet = new HttpGet(Para.getConfig().getSettingForApp(app, GenericOAuth2Filter.configKey("profile_url", alias), ""));
        profileGet.setHeader("Authorization", (Object)("Bearer " + accessToken));
        if (!StringUtils.isBlank((CharSequence)acceptHeader)) {
            profileGet.setHeader("Accept", (Object)acceptHeader);
        }
        try (CloseableHttpResponse resp2 = this.httpclient.execute((ClassicHttpRequest)profileGet);){
            HttpEntity respEntity = resp2.getEntity();
            String error = null;
            if (respEntity != null) {
                if (resp2.getCode() == 200) {
                    profile.putAll((Map)this.jreader.readValue(respEntity.getContent()));
                } else {
                    error = IOUtils.toString((InputStream)respEntity.getContent(), (String)Para.getConfig().defaultEncoding());
                }
            }
            if (profile.isEmpty() || error != null) {
                LOG.error("OAuth 2 provider did not return any valid user information - response code {} {}, app '{}', payload {}", new Object[]{resp2.getCode(), resp2.getReasonPhrase(), app.getId(), Utils.abbreviate((String)error, (int)1000)});
            }
            EntityUtils.consumeQuietly((HttpEntity)respEntity);
        }
        catch (Exception e) {
            LOG.error("Failed to fetch profile form IDP for app {} - {}", (Object)app.getId(), (Object)e.getMessage());
        }
        return profile;
    }

    private void refreshTokens(App app, User user) throws IOException {
        Map<String, Object> token = this.tokenRequest(app, user.getIdpRefreshToken(), null, this.oauthAlias(user.getIdentifier()));
        if (token != null && token.containsKey("access_token")) {
            if (this.isAccessTokenDelegationEnabled(app, user)) {
                user.setIdpAccessToken((String)token.get("access_token"));
                user.setIdpIdToken((String)token.get("id_token"));
            } else {
                user.setIdpAccessToken("");
                user.setIdpIdToken("");
            }
            String newRefresh = (String)token.get("refresh_token");
            if (!StringUtils.equals((CharSequence)newRefresh, (CharSequence)user.getIdpRefreshToken())) {
                user.setIdpRefreshToken(newRefresh);
            }
            this.printTokenDebugInfo(user);
            user.update();
        }
    }

    private Map<String, Object> tokenRequest(App app, String authCodeOrRefreshToken, String redirectURI, String alias) throws IOException {
        String[] keys = Para.getConfig().getOAuthKeysForApp(app, this.oauthPrefix(alias));
        String scope = Para.getConfig().getSettingForApp(app, GenericOAuth2Filter.configKey("scope", alias), "");
        String entity = redirectURI == null ? Utils.formatMessage((String)REFRESH_PAYLOAD, (Object[])new Object[]{authCodeOrRefreshToken, URLEncoder.encode(scope, "UTF-8"), keys[0], keys[1]}) : Utils.formatMessage((String)PAYLOAD, (Object[])new Object[]{authCodeOrRefreshToken, Utils.urlEncode((String)redirectURI), URLEncoder.encode(scope, "UTF-8"), keys[0], keys[1]});
        String acceptHeader = Para.getConfig().getSettingForApp(app, GenericOAuth2Filter.configKey("accept_header", alias), "");
        HttpPost tokenPost = new HttpPost(Para.getConfig().getSettingForApp(app, GenericOAuth2Filter.configKey("token_url", alias), ""));
        tokenPost.setHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
        tokenPost.setEntity((HttpEntity)new StringEntity(entity));
        if (!StringUtils.isBlank((CharSequence)acceptHeader)) {
            tokenPost.setHeader("Accept", (Object)acceptHeader);
        }
        Map tokens = null;
        try (CloseableHttpResponse resp1 = this.httpclient.execute((ClassicHttpRequest)tokenPost);){
            if (resp1 != null && resp1.getEntity() != null) {
                tokens = (Map)this.jreader.readValue(resp1.getEntity().getContent());
                EntityUtils.consumeQuietly((HttpEntity)resp1.getEntity());
            } else {
                LOG.info("Authentication request failed with status '" + (resp1 != null ? resp1.getReasonPhrase() : "null") + "' and empty response body.");
            }
        }
        return tokens;
    }

    private String oauthPrefix(String alias) {
        if ("third".equalsIgnoreCase(alias)) {
            return "oa2third:";
        }
        if ("second".equalsIgnoreCase(alias)) {
            return "oa2second:";
        }
        return "oa2:";
    }

    private String oauthAlias(String identifier) {
        if (identifier.startsWith("oa2third:")) {
            return "third";
        }
        if (identifier.startsWith("oa2second:")) {
            return "second";
        }
        return "";
    }

    private static String configKey(String key, String alias) {
        if (StringUtils.isBlank((CharSequence)alias)) {
            return "security.oauth." + key;
        }
        return "security.oauth" + alias + "." + key;
    }

    private static String getPicture(App app, User user, String accessToken, String alias, String pic) {
        if (pic != null) {
            String avatar = pic;
            if ("true".equals(Para.getConfig().getSettingForApp(app, GenericOAuth2Filter.configKey("download_avatars", alias), "false"))) {
                avatar = GenericOAuth2Filter.fetchAvatar(app.getAppIdentifier().trim(), user.getId(), accessToken, pic);
            } else if (pic.contains("?")) {
                avatar = pic.substring(0, pic.indexOf(63));
            }
            return avatar;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String fetchAvatar(String appid, String userid, String accessToken, String avatarUrl) {
        if (accessToken == null) return avatarUrl;
        HttpGet avatarGet = new HttpGet(avatarUrl);
        avatarGet.setHeader("Authorization", (Object)("Bearer " + accessToken));
        try (CloseableHttpResponse resp = HttpClientBuilder.create().build().execute((ClassicHttpRequest)avatarGet);){
            HttpEntity respEntity = resp.getEntity();
            if (respEntity == null) return avatarUrl;
            if (!respEntity.getContentType().startsWith("image")) return avatarUrl;
            String ctype = respEntity.getContentType();
            String string = Para.getFileStore().store(Optional.ofNullable(appid).orElse("para") + "/" + userid + "." + StringUtils.substringAfter((String)ctype, (String)"/"), respEntity.getContent());
            return string;
        }
        catch (Exception e) {
            LOG.error(null, (Throwable)e);
        }
        return avatarUrl;
    }

    private String getAppid(App app) {
        return app == null ? null : app.getAppIdentifier();
    }

    private String getFullName(String gname, String fname) {
        if (StringUtils.isBlank((CharSequence)fname)) {
            return StringUtils.isBlank((CharSequence)gname) ? "No Name" : gname;
        }
        if (StringUtils.isBlank((CharSequence)gname)) {
            return StringUtils.isBlank((CharSequence)fname) ? "No Name" : fname;
        }
        return gname + " " + fname;
    }

    private String getEmailFromProfile(Map<String, Object> profile, String emailParam, String oauthAccountId, String emailDomain) {
        Object email = (String)profile.get(emailParam);
        if (StringUtils.isBlank((CharSequence)email)) {
            JsonNode profileTree;
            JsonNode nodeAtPath;
            if (emailParam.startsWith("/") && !(nodeAtPath = (profileTree = ParaObjectUtils.getJsonMapper().valueToTree(profile)).at(emailParam)).isMissingNode()) {
                email = nodeAtPath.asText((String)email);
            }
            if (StringUtils.isBlank((CharSequence)email)) {
                if (Utils.isValidEmail((String)oauthAccountId)) {
                    email = oauthAccountId;
                } else if (!StringUtils.isBlank((CharSequence)emailDomain)) {
                    email = oauthAccountId.concat("@").concat(emailDomain);
                } else {
                    LOG.warn("Blank email attribute for OAuth2 user '{}'.", (Object)oauthAccountId);
                    email = oauthAccountId + "@scoold.com";
                }
            }
        }
        return email;
    }

    private String getPictureFromProfile(Map<String, Object> profile, String pictureParam) {
        JsonNode profileTree;
        JsonNode nodeAtPath;
        String pic = (String)profile.get(pictureParam);
        if (StringUtils.isBlank((CharSequence)pic) && pictureParam.startsWith("/") && !(nodeAtPath = (profileTree = ParaObjectUtils.getJsonMapper().valueToTree(profile)).at(pictureParam)).isMissingNode()) {
            pic = nodeAtPath.asText(pic);
        }
        return pic;
    }

    private String getNameFromProfile(Map<String, Object> profile, String nameParam) {
        JsonNode profileTree;
        JsonNode nodeAtPath;
        String name = (String)profile.get(nameParam);
        if (StringUtils.isBlank((CharSequence)name) && nameParam.startsWith("/") && !(nodeAtPath = (profileTree = ParaObjectUtils.getJsonMapper().valueToTree(profile)).at(nameParam)).isMissingNode()) {
            name = nodeAtPath.asText(name);
        }
        return name;
    }

    private String getGivenNameFromProfile(Map<String, Object> profile, String gnParam) {
        JsonNode profileTree;
        JsonNode nodeAtPath;
        String gname = (String)profile.get(gnParam);
        if (StringUtils.isBlank((CharSequence)gname) && gnParam.startsWith("/") && !(nodeAtPath = (profileTree = ParaObjectUtils.getJsonMapper().valueToTree(profile)).at(gnParam)).isMissingNode()) {
            gname = nodeAtPath.asText(gname);
        }
        return gname;
    }

    private String getFirstNameFromProfile(Map<String, Object> profile, String fnParam) {
        JsonNode profileTree;
        JsonNode nodeAtPath;
        String fname = (String)profile.get(fnParam);
        if (StringUtils.isBlank((CharSequence)fname) && fnParam.startsWith("/") && !(nodeAtPath = (profileTree = ParaObjectUtils.getJsonMapper().valueToTree(profile)).at(fnParam)).isMissingNode()) {
            fname = nodeAtPath.asText(fname);
        }
        return fname;
    }

    private void printTokenDebugInfo(User user) {
        try {
            LOG.debug("Updated OAuth2 tokens for user " + user.getId() + ":\nidpAccessTokenPayload: " + Utils.base64dec((String)user.getIdpAccessTokenPayload()) + "\nidpIdTokenPayload: " + Utils.base64dec((String)user.getIdpIdTokenPayload()) + "\nidpRefreshToken: " + user.getIdpRefreshToken());
        }
        catch (Exception e) {
            LOG.debug(null, (Throwable)e);
        }
    }
}

