/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.security;

import com.erudika.para.core.App;
import com.erudika.para.core.utils.Para;
import com.erudika.para.server.rest.RestUtils;
import com.erudika.para.server.security.AjaxRequestMatcher;
import com.erudika.para.server.security.RestRequestMatcher;
import com.erudika.para.server.security.SecurityUtils;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;

public class SimpleAuthenticationFailureHandler
extends SimpleUrlAuthenticationFailureHandler {
    private RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        App app;
        String appid = SecurityUtils.getAppidFromAuthRequest(request);
        if (!StringUtils.isBlank((CharSequence)appid) && (app = (App)Para.getDAO().read(App.id((String)appid))) != null) {
            String customURI = (String)app.getSetting("signin_failure");
            if (app.isRootApp() && StringUtils.isBlank((CharSequence)customURI)) {
                customURI = Para.getConfig().signinFailurePath();
            }
            if (StringUtils.contains((CharSequence)customURI, (CharSequence)"cause=?")) {
                customURI = customURI.replace("cause=?", "cause=" + exception.getMessage());
            }
            if (!StringUtils.isBlank((CharSequence)customURI)) {
                this.redirectStrategy.sendRedirect(request, response, customURI);
                return;
            }
        }
        if (this.isRestRequest(request)) {
            RestUtils.returnStatusResponse(response, 401, exception.getMessage());
        } else {
            super.onAuthenticationFailure(request, response, exception);
        }
    }

    protected boolean isRestRequest(HttpServletRequest request) {
        return RestRequestMatcher.INSTANCE.matches(request) || AjaxRequestMatcher.INSTANCE.matches(request);
    }
}

