/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.security;

import com.erudika.para.server.rest.RestUtils;
import com.erudika.para.server.security.AjaxRequestMatcher;
import com.erudika.para.server.security.RestRequestMatcher;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;

public class SimpleAuthenticationEntryPoint
extends LoginUrlAuthenticationEntryPoint {
    public SimpleAuthenticationEntryPoint(String loginFormUrl) {
        super(loginFormUrl);
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        if (this.isPreflight(request)) {
            response.setStatus(204);
        } else if (this.isRestRequest(request)) {
            RestUtils.returnStatusResponse(response, 401, authException.getMessage());
        } else {
            super.commence(request, response, authException);
        }
    }

    private boolean isPreflight(HttpServletRequest request) {
        return "OPTIONS".equals(request.getMethod());
    }

    protected boolean isRestRequest(HttpServletRequest request) {
        return RestRequestMatcher.INSTANCE.matches(request) || AjaxRequestMatcher.INSTANCE.matches(request);
    }
}

