/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.security;

import com.erudika.para.core.cache.Cache;
import com.erudika.para.core.utils.Para;
import com.erudika.para.server.security.CachedCsrfTokenRepository;
import com.erudika.para.server.security.JWTRestfulAuthFilter;
import com.erudika.para.server.security.SimpleAuthenticationFailureHandler;
import com.erudika.para.server.security.SimpleAuthenticationSuccessHandler;
import com.erudika.para.server.security.SimpleRememberMeServices;
import com.erudika.para.server.security.SimpleUserService;
import com.erudika.para.server.security.filters.AmazonAuthFilter;
import com.erudika.para.server.security.filters.FacebookAuthFilter;
import com.erudika.para.server.security.filters.GenericOAuth2Filter;
import com.erudika.para.server.security.filters.GitHubAuthFilter;
import com.erudika.para.server.security.filters.GoogleAuthFilter;
import com.erudika.para.server.security.filters.LdapAuthFilter;
import com.erudika.para.server.security.filters.LinkedInAuthFilter;
import com.erudika.para.server.security.filters.MicrosoftAuthFilter;
import com.erudika.para.server.security.filters.PasswordAuthFilter;
import com.erudika.para.server.security.filters.PasswordlessAuthFilter;
import com.erudika.para.server.security.filters.SAMLAuthFilter;
import com.erudika.para.server.security.filters.SAMLMetadataFilter;
import com.erudika.para.server.security.filters.SlackAuthFilter;
import com.erudika.para.server.security.filters.TwitterAuthFilter;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.RememberMeServices;

public class SecurityModule
extends AbstractModule {
    private CachedCsrfTokenRepository csrfTokenRepository;
    private SimpleAuthenticationSuccessHandler successHandler;
    private SimpleAuthenticationFailureHandler failureHandler;
    private SimpleRememberMeServices rememberMeServices;
    private PasswordAuthFilter passwordFilter;
    private PasswordlessAuthFilter passwordlessFilter;
    private FacebookAuthFilter facebookFilter;
    private GoogleAuthFilter googleFilter;
    private LinkedInAuthFilter linkedinFilter;
    private TwitterAuthFilter twitterFilter;
    private GitHubAuthFilter githubFilter;
    private MicrosoftAuthFilter microsoftFilter;
    private SlackAuthFilter slackFilter;
    private AmazonAuthFilter amazonFilter;
    private GenericOAuth2Filter oauth2Filter;
    private LdapAuthFilter ldapFilter;
    private SAMLAuthFilter samlFilter;
    private SAMLMetadataFilter samlMetaFilter;
    private JWTRestfulAuthFilter jwtFilter;

    protected void configure() {
    }

    @Provides
    public CachedCsrfTokenRepository getCsrfTokenRepository(Cache cache) {
        if (this.csrfTokenRepository == null) {
            this.csrfTokenRepository = new CachedCsrfTokenRepository();
            this.csrfTokenRepository.setCache(cache);
        }
        return this.csrfTokenRepository;
    }

    public void setCsrfTokenRepository(CachedCsrfTokenRepository csrfTokenRepository) {
        this.csrfTokenRepository = csrfTokenRepository;
    }

    @Provides
    public SimpleAuthenticationSuccessHandler getSuccessHandler() {
        if (this.successHandler == null) {
            this.successHandler = new SimpleAuthenticationSuccessHandler();
            this.successHandler.setDefaultTargetUrl(Para.getConfig().signinSuccessPath());
            this.successHandler.setTargetUrlParameter(Para.getConfig().returnToPath());
            this.successHandler.setUseReferer(false);
        }
        return this.successHandler;
    }

    public void setSuccessHandler(SimpleAuthenticationSuccessHandler successHandler) {
        this.successHandler = successHandler;
    }

    @Provides
    public SimpleAuthenticationFailureHandler getFailureHandler() {
        if (this.failureHandler == null) {
            this.failureHandler = new SimpleAuthenticationFailureHandler();
            this.failureHandler.setDefaultFailureUrl(Para.getConfig().signinFailurePath());
        }
        return this.failureHandler;
    }

    public void setFailureHandler(SimpleAuthenticationFailureHandler failureHandler) {
        this.failureHandler = failureHandler;
    }

    @Provides
    public SimpleRememberMeServices getRemembeMeServices() {
        if (this.rememberMeServices == null) {
            String authCookie = Para.getConfig().authCookieName();
            this.rememberMeServices = new SimpleRememberMeServices(Para.getConfig().appSecretKey(), new SimpleUserService());
            this.rememberMeServices.setAlwaysRemember(Para.getConfig().rememberMeEnabled());
            this.rememberMeServices.setTokenValiditySeconds(Para.getConfig().sessionTimeoutSec());
            this.rememberMeServices.setCookieName(authCookie);
            this.rememberMeServices.setParameter(authCookie.concat("-remember-me"));
        }
        return this.rememberMeServices;
    }

    public void setRememberMeServices(SimpleRememberMeServices rememberMeServices) {
        this.rememberMeServices = rememberMeServices;
    }

    @Provides
    public PasswordAuthFilter getPasswordFilter() {
        if (this.passwordFilter == null) {
            this.passwordFilter = new PasswordAuthFilter("/password_auth");
            this.passwordFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.getSuccessHandler());
            this.passwordFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.getFailureHandler());
            this.passwordFilter.setRememberMeServices((RememberMeServices)this.getRemembeMeServices());
        }
        return this.passwordFilter;
    }

    public void setPasswordFilter(PasswordAuthFilter passwordFilter) {
        this.passwordFilter = passwordFilter;
    }

    @Provides
    public PasswordlessAuthFilter getPasswordlessFilter() {
        if (this.passwordlessFilter == null) {
            this.passwordlessFilter = new PasswordlessAuthFilter("/passwordless_auth");
            this.passwordlessFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.getSuccessHandler());
            this.passwordlessFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.getFailureHandler());
            this.passwordlessFilter.setRememberMeServices((RememberMeServices)this.getRemembeMeServices());
        }
        return this.passwordlessFilter;
    }

    public void setPasswordlessFilter(PasswordlessAuthFilter passwordlessFilter) {
        this.passwordlessFilter = passwordlessFilter;
    }

    @Provides
    public FacebookAuthFilter getFacebookFilter() {
        if (this.facebookFilter == null) {
            this.facebookFilter = new FacebookAuthFilter("/facebook_auth");
            this.facebookFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.getSuccessHandler());
            this.facebookFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.getFailureHandler());
            this.facebookFilter.setRememberMeServices((RememberMeServices)this.getRemembeMeServices());
        }
        return this.facebookFilter;
    }

    public void setFacebookFilter(FacebookAuthFilter facebookFilter) {
        this.facebookFilter = facebookFilter;
    }

    @Provides
    public GoogleAuthFilter getGoogleFilter() {
        if (this.googleFilter == null) {
            this.googleFilter = new GoogleAuthFilter("/google_auth");
            this.googleFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.getSuccessHandler());
            this.googleFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.getFailureHandler());
            this.googleFilter.setRememberMeServices((RememberMeServices)this.getRemembeMeServices());
        }
        return this.googleFilter;
    }

    public void setGoogleFilter(GoogleAuthFilter googleFilter) {
        this.googleFilter = googleFilter;
    }

    @Provides
    public LinkedInAuthFilter getLinkedinFilter() {
        if (this.linkedinFilter == null) {
            this.linkedinFilter = new LinkedInAuthFilter("/linkedin_auth");
            this.linkedinFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.getSuccessHandler());
            this.linkedinFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.getFailureHandler());
            this.linkedinFilter.setRememberMeServices((RememberMeServices)this.getRemembeMeServices());
        }
        return this.linkedinFilter;
    }

    public void setLinkedinFilter(LinkedInAuthFilter linkedinFilter) {
        this.linkedinFilter = linkedinFilter;
    }

    @Provides
    public TwitterAuthFilter getTwitterFilter() {
        if (this.twitterFilter == null) {
            this.twitterFilter = new TwitterAuthFilter("/twitter_auth");
            this.twitterFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.getSuccessHandler());
            this.twitterFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.getFailureHandler());
            this.twitterFilter.setRememberMeServices((RememberMeServices)this.getRemembeMeServices());
        }
        return this.twitterFilter;
    }

    public void setTwitterFilter(TwitterAuthFilter twitterFilter) {
        this.twitterFilter = twitterFilter;
    }

    @Provides
    public GitHubAuthFilter getGithubFilter() {
        if (this.githubFilter == null) {
            this.githubFilter = new GitHubAuthFilter("/github_auth");
            this.githubFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.getSuccessHandler());
            this.githubFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.getFailureHandler());
            this.githubFilter.setRememberMeServices((RememberMeServices)this.getRemembeMeServices());
        }
        return this.githubFilter;
    }

    public void setGithubFilter(GitHubAuthFilter githubFilter) {
        this.githubFilter = githubFilter;
    }

    @Provides
    public MicrosoftAuthFilter getMicrosoftFilter() {
        if (this.microsoftFilter == null) {
            this.microsoftFilter = new MicrosoftAuthFilter("/microsoft_auth");
            this.microsoftFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.getSuccessHandler());
            this.microsoftFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.getFailureHandler());
            this.microsoftFilter.setRememberMeServices((RememberMeServices)this.getRemembeMeServices());
        }
        return this.microsoftFilter;
    }

    public void setMicrosoftFilter(MicrosoftAuthFilter microsoftFilter) {
        this.microsoftFilter = microsoftFilter;
    }

    @Provides
    public SlackAuthFilter getSlackFilter() {
        if (this.slackFilter == null) {
            this.slackFilter = new SlackAuthFilter("/slack_auth");
            this.slackFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.getSuccessHandler());
            this.slackFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.getFailureHandler());
            this.slackFilter.setRememberMeServices((RememberMeServices)this.getRemembeMeServices());
        }
        return this.slackFilter;
    }

    public void setSlackFilter(SlackAuthFilter slackFilter) {
        this.slackFilter = slackFilter;
    }

    @Provides
    public AmazonAuthFilter getAmazonFilter() {
        if (this.amazonFilter == null) {
            this.amazonFilter = new AmazonAuthFilter("/amazon_auth");
            this.amazonFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.getSuccessHandler());
            this.amazonFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.getFailureHandler());
            this.amazonFilter.setRememberMeServices((RememberMeServices)this.getRemembeMeServices());
        }
        return this.amazonFilter;
    }

    public void setAmazonFilter(AmazonAuthFilter amazonFilter) {
        this.amazonFilter = amazonFilter;
    }

    @Provides
    public GenericOAuth2Filter getGenericOAuth2Filter() {
        if (this.oauth2Filter == null) {
            this.oauth2Filter = new GenericOAuth2Filter("/oauth2_auth");
            this.oauth2Filter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.getSuccessHandler());
            this.oauth2Filter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.getFailureHandler());
            this.oauth2Filter.setRememberMeServices((RememberMeServices)this.getRemembeMeServices());
        }
        return this.oauth2Filter;
    }

    public void setGenericOAuth2Filter(GenericOAuth2Filter oauth2Filter) {
        this.oauth2Filter = oauth2Filter;
    }

    @Provides
    public LdapAuthFilter getLdapAuthFilter() {
        if (this.ldapFilter == null) {
            this.ldapFilter = new LdapAuthFilter("/ldap_auth");
            this.ldapFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.getSuccessHandler());
            this.ldapFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.getFailureHandler());
            this.ldapFilter.setRememberMeServices((RememberMeServices)this.getRemembeMeServices());
        }
        return this.ldapFilter;
    }

    public void setLdapAuthFilter(LdapAuthFilter ldapFilter) {
        this.ldapFilter = ldapFilter;
    }

    @Provides
    public SAMLAuthFilter getSamlAuthFilter() {
        if (this.samlFilter == null) {
            this.samlFilter = new SAMLAuthFilter("/saml_auth/*");
            this.samlFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.getSuccessHandler());
            this.samlFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.getFailureHandler());
            this.samlFilter.setRememberMeServices((RememberMeServices)this.getRemembeMeServices());
        }
        return this.samlFilter;
    }

    public void setSamlAuthFilter(SAMLAuthFilter samlFilter) {
        this.samlFilter = samlFilter;
    }

    @Provides
    public SAMLMetadataFilter getSamlMetadataFilter() {
        if (this.samlMetaFilter == null) {
            this.samlMetaFilter = new SAMLMetadataFilter();
        }
        return this.samlMetaFilter;
    }

    public void setSamlMetadataFilter(SAMLMetadataFilter samleMetaFilter) {
        this.samlMetaFilter = samleMetaFilter;
    }

    @Provides
    public JWTRestfulAuthFilter getJWTAuthFilter(FacebookAuthFilter fbAuth, GoogleAuthFilter gpAuth, GitHubAuthFilter ghAuth, LinkedInAuthFilter liAuth, TwitterAuthFilter twAuth, MicrosoftAuthFilter msAuth, SlackAuthFilter slAuth, AmazonAuthFilter azAuth, GenericOAuth2Filter oAuth2, LdapAuthFilter ldAuth, PasswordAuthFilter pwAuth, PasswordlessAuthFilter plAuth) {
        if (this.jwtFilter == null) {
            this.jwtFilter = new JWTRestfulAuthFilter("/jwt_auth");
            this.jwtFilter.setFacebookAuth(fbAuth);
            this.jwtFilter.setGoogleAuth(gpAuth);
            this.jwtFilter.setGithubAuth(ghAuth);
            this.jwtFilter.setLinkedinAuth(liAuth);
            this.jwtFilter.setTwitterAuth(twAuth);
            this.jwtFilter.setMicrosoftAuth(msAuth);
            this.jwtFilter.setSlackAuth(slAuth);
            this.jwtFilter.setAmazonAuth(azAuth);
            this.jwtFilter.setGenericOAuth2Auth(oAuth2);
            this.jwtFilter.setLdapAuth(ldAuth);
            this.jwtFilter.setPasswordAuth(pwAuth);
            this.jwtFilter.setPasswordlessAuth(plAuth);
        }
        return this.jwtFilter;
    }

    public void setJwtFilter(JWTRestfulAuthFilter jwtFilter) {
        this.jwtFilter = jwtFilter;
    }
}

