/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.security;

import com.erudika.para.core.utils.Para;
import com.erudika.para.server.ParaServer;
import com.erudika.para.server.security.CachedCsrfTokenRepository;
import com.erudika.para.server.security.CsrfProtectionRequestMatcher;
import com.erudika.para.server.security.IgnoredRequestMatcher;
import com.erudika.para.server.security.JWTAuthenticationProvider;
import com.erudika.para.server.security.JWTRestfulAuthFilter;
import com.erudika.para.server.security.LDAPAuthenticationProvider;
import com.erudika.para.server.security.RestAuthFilter;
import com.erudika.para.server.security.RestRequestMatcher;
import com.erudika.para.server.security.SimpleAccessDeniedHandler;
import com.erudika.para.server.security.SimpleAuthenticationEntryPoint;
import com.erudika.para.server.security.SimpleRememberMeServices;
import com.erudika.para.server.security.SimpleRequestCache;
import com.erudika.para.server.security.filters.AmazonAuthFilter;
import com.erudika.para.server.security.filters.FacebookAuthFilter;
import com.erudika.para.server.security.filters.GenericOAuth2Filter;
import com.erudika.para.server.security.filters.GitHubAuthFilter;
import com.erudika.para.server.security.filters.GoogleAuthFilter;
import com.erudika.para.server.security.filters.LdapAuthFilter;
import com.erudika.para.server.security.filters.LinkedInAuthFilter;
import com.erudika.para.server.security.filters.MicrosoftAuthFilter;
import com.erudika.para.server.security.filters.PasswordAuthFilter;
import com.erudika.para.server.security.filters.PasswordlessAuthFilter;
import com.erudika.para.server.security.filters.SAMLAuthFilter;
import com.erudika.para.server.security.filters.SAMLMetadataFilter;
import com.erudika.para.server.security.filters.SlackAuthFilter;
import com.erudika.para.server.security.filters.TwitterAuthFilter;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import java.util.HashSet;
import java.util.LinkedList;
import javax.annotation.security.DeclareRoles;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.RememberMeAuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.rememberme.RememberMeAuthenticationFilter;
import org.springframework.security.web.authentication.session.NullAuthenticatedSessionStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.firewall.DefaultHttpFirewall;
import org.springframework.security.web.firewall.HttpFirewall;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
@DeclareRoles(value={"ROLE_USER", "ROLE_MOD", "ROLE_ADMIN", "ROLE_APP"})
public class SecurityConfig
extends WebSecurityConfigurerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(SecurityConfig.class);
    private static final String[] DEFAULT_ROLES = new String[]{"USER", "MOD", "ADMIN", "APP"};
    private final CachedCsrfTokenRepository csrfTokenRepository = ParaServer.getInstance(CachedCsrfTokenRepository.class);
    private final SimpleRememberMeServices rememberMeServices = ParaServer.getInstance(SimpleRememberMeServices.class);
    private final PasswordAuthFilter passwordFilter = ParaServer.getInstance(PasswordAuthFilter.class);
    private final PasswordlessAuthFilter passwordlessFilter = ParaServer.getInstance(PasswordlessAuthFilter.class);
    private final FacebookAuthFilter facebookFilter = ParaServer.getInstance(FacebookAuthFilter.class);
    private final GoogleAuthFilter googleFilter = ParaServer.getInstance(GoogleAuthFilter.class);
    private final LinkedInAuthFilter linkedinFilter = ParaServer.getInstance(LinkedInAuthFilter.class);
    private final TwitterAuthFilter twitterFilter = ParaServer.getInstance(TwitterAuthFilter.class);
    private final GitHubAuthFilter githubFilter = ParaServer.getInstance(GitHubAuthFilter.class);
    private final MicrosoftAuthFilter microsoftFilter = ParaServer.getInstance(MicrosoftAuthFilter.class);
    private final SlackAuthFilter slackFilter = ParaServer.getInstance(SlackAuthFilter.class);
    private final AmazonAuthFilter amazonFilter = ParaServer.getInstance(AmazonAuthFilter.class);
    private final GenericOAuth2Filter oauth2Filter = ParaServer.getInstance(GenericOAuth2Filter.class);
    private final LdapAuthFilter ldapFilter = ParaServer.getInstance(LdapAuthFilter.class);
    private final SAMLAuthFilter samlFilter = ParaServer.getInstance(SAMLAuthFilter.class);
    private final SAMLMetadataFilter samlMetaFilter = ParaServer.getInstance(SAMLMetadataFilter.class);
    private final JWTRestfulAuthFilter jwtFilter = ParaServer.getInstance(JWTRestfulAuthFilter.class);
    private final RestAuthFilter restAuthFilter = ParaServer.getInstance(RestAuthFilter.class);

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        RememberMeAuthenticationProvider rmeProvider = new RememberMeAuthenticationProvider(Para.getConfig().appSecretKey());
        auth.authenticationProvider((AuthenticationProvider)rmeProvider);
        JWTAuthenticationProvider jwtProvider = new JWTAuthenticationProvider();
        auth.authenticationProvider((AuthenticationProvider)jwtProvider);
        LDAPAuthenticationProvider ldapProvider = new LDAPAuthenticationProvider();
        auth.authenticationProvider((AuthenticationProvider)ldapProvider);
    }

    public void configure(WebSecurity web) throws Exception {
        DefaultHttpFirewall firewall = new DefaultHttpFirewall();
        firewall.setAllowUrlEncodedSlash(true);
        web.httpFirewall((HttpFirewall)firewall);
    }

    protected void configure(HttpSecurity http) throws Exception {
        String signinPath = Para.getConfig().signinPath();
        String signoutPath = Para.getConfig().signoutPath();
        String accessDeniedPath = Para.getConfig().accessDeniedPath();
        String signoutSuccessPath = Para.getConfig().signoutSuccessPath();
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().requestMatchers(new RequestMatcher[]{IgnoredRequestMatcher.INSTANCE})).permitAll();
        http.authorizeRequests().requestMatchers(new RequestMatcher[]{RestRequestMatcher.INSTANCE});
        this.parseProtectedResources(http, Para.getConfig().protectedPaths());
        if (Para.getConfig().csrfProtectionEnabled()) {
            http.csrf().requireCsrfProtectionMatcher(CsrfProtectionRequestMatcher.INSTANCE).csrfTokenRepository((CsrfTokenRepository)this.csrfTokenRepository);
        } else {
            http.csrf().disable();
        }
        http.sessionManagement().enableSessionUrlRewriting(false);
        http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.NEVER);
        http.sessionManagement().sessionAuthenticationStrategy((SessionAuthenticationStrategy)new NullAuthenticatedSessionStrategy());
        http.exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)new SimpleAuthenticationEntryPoint(signinPath));
        http.exceptionHandling().accessDeniedHandler((AccessDeniedHandler)new SimpleAccessDeniedHandler(accessDeniedPath));
        http.requestCache().requestCache((RequestCache)new SimpleRequestCache());
        http.logout().logoutUrl(signoutPath).logoutSuccessUrl(signoutSuccessPath);
        http.rememberMe().rememberMeServices((RememberMeServices)this.rememberMeServices);
        this.registerAuthFilters(http);
        if (this.jwtFilter != null) {
            this.jwtFilter.setAuthenticationManager(this.authenticationManager());
            http.addFilterBefore((Filter)this.jwtFilter, RememberMeAuthenticationFilter.class);
        }
        if (this.restAuthFilter != null) {
            http.addFilterBefore((Filter)this.restAuthFilter, RememberMeAuthenticationFilter.class);
        }
    }

    private void registerAuthFilters(HttpSecurity http) throws Exception {
        if (this.passwordFilter != null) {
            this.passwordFilter.setAuthenticationManager(this.authenticationManager());
            http.addFilterAfter((Filter)this.passwordFilter, BasicAuthenticationFilter.class);
        }
        if (this.passwordlessFilter != null) {
            this.passwordlessFilter.setAuthenticationManager(this.authenticationManager());
            http.addFilterAfter((Filter)this.passwordlessFilter, BasicAuthenticationFilter.class);
        }
        if (this.facebookFilter != null) {
            this.facebookFilter.setAuthenticationManager(this.authenticationManager());
            http.addFilterAfter((Filter)this.facebookFilter, BasicAuthenticationFilter.class);
        }
        if (this.googleFilter != null) {
            this.googleFilter.setAuthenticationManager(this.authenticationManager());
            http.addFilterAfter((Filter)this.googleFilter, BasicAuthenticationFilter.class);
        }
        if (this.linkedinFilter != null) {
            this.linkedinFilter.setAuthenticationManager(this.authenticationManager());
            http.addFilterAfter((Filter)this.linkedinFilter, BasicAuthenticationFilter.class);
        }
        if (this.twitterFilter != null) {
            this.twitterFilter.setAuthenticationManager(this.authenticationManager());
            http.addFilterAfter((Filter)this.twitterFilter, BasicAuthenticationFilter.class);
        }
        if (this.githubFilter != null) {
            this.githubFilter.setAuthenticationManager(this.authenticationManager());
            http.addFilterAfter((Filter)this.githubFilter, BasicAuthenticationFilter.class);
        }
        if (this.microsoftFilter != null) {
            this.microsoftFilter.setAuthenticationManager(this.authenticationManager());
            http.addFilterAfter((Filter)this.microsoftFilter, BasicAuthenticationFilter.class);
        }
        if (this.slackFilter != null) {
            this.slackFilter.setAuthenticationManager(this.authenticationManager());
            http.addFilterAfter((Filter)this.slackFilter, BasicAuthenticationFilter.class);
        }
        if (this.amazonFilter != null) {
            this.amazonFilter.setAuthenticationManager(this.authenticationManager());
            http.addFilterAfter((Filter)this.amazonFilter, BasicAuthenticationFilter.class);
        }
        if (this.oauth2Filter != null) {
            this.oauth2Filter.setAuthenticationManager(this.authenticationManager());
            http.addFilterAfter((Filter)this.oauth2Filter, BasicAuthenticationFilter.class);
        }
        if (this.ldapFilter != null) {
            this.ldapFilter.setAuthenticationManager(this.authenticationManager());
            http.addFilterAfter((Filter)this.ldapFilter, BasicAuthenticationFilter.class);
        }
        if (this.samlFilter != null) {
            this.samlFilter.setAuthenticationManager(this.authenticationManager());
            http.addFilterAfter((Filter)this.samlFilter, BasicAuthenticationFilter.class);
        }
        http.addFilterAfter((Filter)this.samlMetaFilter, BasicAuthenticationFilter.class);
    }

    private void parseProtectedResources(HttpSecurity http, ConfigObject protectedResources) throws Exception {
        for (ConfigValue cv : protectedResources.values()) {
            LinkedList<String> patterns = new LinkedList<String>();
            LinkedList<String> roles = new LinkedList<String>();
            HashSet<HttpMethod> methods = new HashSet<HttpMethod>();
            for (ConfigValue configValue : (ConfigList)cv) {
                try {
                    if (configValue instanceof ConfigList) {
                        for (ConfigValue role : (ConfigList)configValue) {
                            String r = ((String)role.unwrapped()).toUpperCase().trim();
                            HttpMethod m = HttpMethod.resolve((String)r);
                            if (m != null) {
                                methods.add(m);
                                continue;
                            }
                            roles.add(r);
                        }
                        continue;
                    }
                    patterns.add((String)configValue.unwrapped());
                }
                catch (Exception e) {
                    logger.error("Invalid config syntax for protected resource: {}.", (Object)configValue.render(), (Object)e);
                }
            }
            String[] rolz = roles.isEmpty() ? DEFAULT_ROLES : roles.toArray(new String[0]);
            String[] patternz = patterns.toArray(new String[0]);
            if (methods.isEmpty()) {
                ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(patternz)).hasAnyRole(rolz);
                continue;
            }
            for (HttpMethod method : methods) {
                ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(method, patternz)).hasAnyRole(rolz);
            }
        }
    }
}

