/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.security;

import com.erudika.para.core.cache.Cache;
import com.erudika.para.core.utils.Para;
import com.erudika.para.core.utils.Utils;
import com.erudika.para.server.utils.HttpUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.DefaultCsrfToken;
import org.springframework.util.Assert;

public class CachedCsrfTokenRepository
implements CsrfTokenRepository {
    private static final Logger logger = LoggerFactory.getLogger(CachedCsrfTokenRepository.class);
    private String parameterName = "_csrf";
    private final String headerName = "X-CSRF-TOKEN";
    private final Map<String, Object[]> localCache = new ConcurrentHashMap<String, Object[]>();
    private Cache cache;

    public Cache getCache() {
        return this.cache;
    }

    @Inject
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void saveToken(CsrfToken t, HttpServletRequest request, HttpServletResponse response) {
        String ident = this.getIdentifierFromCookie(request);
        if (StringUtils.isBlank((CharSequence)ident) && StringUtils.isBlank((CharSequence)HttpUtils.getStateParam(Para.getConfig().authCookieName(), request))) {
            ident = Utils.generateSecurityToken((int)16);
            this.storeAnonIdentCookie(ident, request, response);
        }
        if (ident != null) {
            CsrfToken token = this.loadToken(request);
            if (token == null) {
                String anonid = HttpUtils.getStateParam(this.anonymousCsrfCookieName(), request);
                if (anonid != null) {
                    token = this.loadTokenFromCache(ident);
                    if (token == null) {
                        HttpUtils.removeStateParam(Para.getConfig().csrfCookieName(), request, response);
                        HttpUtils.removeStateParam(this.anonymousCsrfCookieName(), request, response);
                        this.removeTokenFromCache(ident);
                        return;
                    }
                } else {
                    token = this.generateToken(null);
                }
                this.storeTokenInCache(ident, token);
            }
            this.storeTokenAsCookie(token, request, response);
        }
    }

    public CsrfToken loadToken(HttpServletRequest request) {
        CsrfToken token = null;
        String ident = this.getIdentifierFromCookie(request);
        if (ident != null) {
            String key = ident.concat(this.parameterName);
            token = this.loadTokenFromCache(key);
            String anonid = HttpUtils.getStateParam(this.anonymousCsrfCookieName(), request);
            if (anonid != null) {
                CsrfToken anonToken = this.loadTokenFromCache(anonid);
                if (!ident.equals(anonid) && anonToken != null && token != null) {
                    this.storeTokenInCache(ident, anonToken);
                    token = anonToken;
                }
            }
        }
        return this.isValidButNotInCookie(token, request) ? null : token;
    }

    private void storeTokenInCache(String key, CsrfToken token) {
        if (!key.endsWith(this.parameterName)) {
            key = key.concat(this.parameterName);
        }
        if (Para.getConfig().isCacheEnabled()) {
            this.cache.put(Para.getConfig().getRootAppIdentifier(), key, (Object)token, Long.valueOf(Para.getConfig().sessionTimeoutSec()));
        } else {
            this.localCache.put(key, new Object[]{token, System.currentTimeMillis()});
        }
    }

    private CsrfToken loadTokenFromCache(String key) {
        if (!key.endsWith(this.parameterName)) {
            key = key.concat(this.parameterName);
        }
        CsrfToken token = null;
        if (Para.getConfig().isCacheEnabled()) {
            token = (CsrfToken)this.cache.get(Para.getConfig().getRootAppIdentifier(), key);
        } else {
            Object[] arr = this.localCache.get(key);
            if (arr != null && arr.length == 2) {
                boolean expired;
                boolean bl = expired = (Long)arr[1] + (long)(Para.getConfig().sessionTimeoutSec() * 1000) < System.currentTimeMillis();
                if (expired) {
                    this.removeTokenFromCache(key);
                } else {
                    token = (CsrfToken)arr[0];
                }
            }
        }
        return token;
    }

    private void removeTokenFromCache(String key) {
        if (!key.endsWith(this.parameterName)) {
            key = key.concat(this.parameterName);
        }
        if (Para.getConfig().isCacheEnabled()) {
            this.cache.remove(key);
        } else {
            this.localCache.remove(key);
        }
    }

    private String getIdentifierFromCookie(HttpServletRequest request) {
        String cookie = HttpUtils.getStateParam(Para.getConfig().authCookieName(), request);
        String ident = null;
        if (cookie != null) {
            String[] ctokens = Utils.base64dec((String)cookie).split(":");
            ident = Utils.base64dec((String)Utils.urlDecode((String)ctokens[0]));
        }
        if (ident == null) {
            ident = HttpUtils.getStateParam(this.anonymousCsrfCookieName(), request);
        }
        return ident;
    }

    private String getTokenFromCookie(HttpServletRequest request) {
        String tokenInCookie = HttpUtils.getStateParam(Para.getConfig().csrfCookieName(), request);
        if (!StringUtils.isBlank((CharSequence)tokenInCookie)) {
            return tokenInCookie;
        }
        return "";
    }

    private void storeTokenAsCookie(CsrfToken token, HttpServletRequest request, HttpServletResponse response) {
        if (this.isValidButNotInCookie(token, request)) {
            Cookie c = new Cookie(Para.getConfig().csrfCookieName(), token.getToken());
            c.setMaxAge(Para.getConfig().sessionTimeoutSec());
            c.setHttpOnly(false);
            c.setSecure("https".equalsIgnoreCase(request.getScheme()));
            c.setPath("/");
            response.addCookie(c);
        }
    }

    private void storeAnonIdentCookie(String anonid, HttpServletRequest request, HttpServletResponse response) {
        Cookie c = new Cookie(this.anonymousCsrfCookieName(), anonid);
        c.setMaxAge(Para.getConfig().sessionTimeoutSec());
        c.setHttpOnly(false);
        c.setSecure("https".equalsIgnoreCase(request.getScheme()));
        c.setPath("/");
        response.addCookie(c);
    }

    private boolean isValidButNotInCookie(CsrfToken token, HttpServletRequest request) {
        return token != null && !StringUtils.isBlank((CharSequence)token.getToken()) && !StringUtils.equals((CharSequence)this.getTokenFromCookie(request), (CharSequence)token.getToken());
    }

    public CsrfToken generateToken(HttpServletRequest request) {
        return new DefaultCsrfToken("X-CSRF-TOKEN", this.parameterName, Utils.generateSecurityToken());
    }

    public void setParameterName(String parameterName) {
        Assert.hasLength((String)parameterName, (String)"parameterName cannot be null or empty");
        this.parameterName = parameterName;
    }

    public void setHeaderName(String parameterName) {
        Assert.hasLength((String)parameterName, (String)"parameterName cannot be null or empty");
        this.parameterName = parameterName;
    }

    private String anonymousCsrfCookieName() {
        return Para.getConfig().csrfCookieName() + "-anonid";
    }
}

