/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.persistence;

import com.erudika.para.core.persistence.DAO;
import com.erudika.para.core.persistence.MockDAO;
import com.erudika.para.core.utils.Para;
import com.erudika.para.server.persistence.AWSDynamoDAO;
import com.google.inject.AbstractModule;
import java.util.ServiceLoader;
import org.apache.commons.lang3.StringUtils;

public class PersistenceModule
extends AbstractModule {
    protected void configure() {
        String selectedDAO = Para.getConfig().daoPlugin();
        if (StringUtils.isBlank((CharSequence)selectedDAO)) {
            if ("embedded".equals(Para.getConfig().environment())) {
                this.bindToDefault();
            } else {
                this.bind(DAO.class).to(AWSDynamoDAO.class).asEagerSingleton();
            }
        } else if ("dynamodb".equalsIgnoreCase(selectedDAO) || AWSDynamoDAO.class.getSimpleName().equalsIgnoreCase(selectedDAO)) {
            this.bind(DAO.class).to(AWSDynamoDAO.class).asEagerSingleton();
        } else {
            DAO daoPlugin = this.loadExternalDAO(selectedDAO);
            if (daoPlugin != null) {
                this.bind(DAO.class).to(daoPlugin.getClass()).asEagerSingleton();
            } else {
                this.bindToDefault();
            }
        }
    }

    void bindToDefault() {
        this.bind(DAO.class).to(MockDAO.class).asEagerSingleton();
    }

    final DAO loadExternalDAO(String classSimpleName) {
        ServiceLoader<DAO> daoLoader = ServiceLoader.load(DAO.class, Para.getParaClassLoader());
        for (DAO dao : daoLoader) {
            if (dao == null || !classSimpleName.equalsIgnoreCase(dao.getClass().getSimpleName())) continue;
            return dao;
        }
        return null;
    }
}

