/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.persistence;

import com.erudika.para.core.App;
import com.erudika.para.core.ParaObject;
import com.erudika.para.core.utils.Pager;
import com.erudika.para.core.utils.Para;
import com.erudika.para.core.utils.ParaObjectUtils;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.services.applicationautoscaling.ApplicationAutoScalingClient;
import software.amazon.awssdk.services.applicationautoscaling.ApplicationAutoScalingClientBuilder;
import software.amazon.awssdk.services.applicationautoscaling.model.MetricType;
import software.amazon.awssdk.services.applicationautoscaling.model.PolicyType;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension;
import software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClientBuilder;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexDescription;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;
import software.amazon.awssdk.services.dynamodb.model.ListTablesResponse;
import software.amazon.awssdk.services.dynamodb.model.Projection;
import software.amazon.awssdk.services.dynamodb.model.ProjectionType;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputExceededException;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.Replica;
import software.amazon.awssdk.services.dynamodb.model.ReplicaUpdate;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.awssdk.services.dynamodb.model.StreamViewType;
import software.amazon.awssdk.services.dynamodb.model.TableDescription;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

public final class AWSDynamoUtils {
    private static final String LOCAL_ENDPOINT = "http://localhost:8000";
    private static final String AWS_REGION = new DefaultAwsRegionProviderChain().getRegion().id();
    private static Map<String, DynamoDbClient> ddbClients;
    private static Map<String, ApplicationAutoScalingClient> aasClients;
    private static List<String> replicaRegions;
    private static final Logger logger;

    private AWSDynamoUtils() {
    }

    public static DynamoDbClient getClient() {
        return AWSDynamoUtils.getClient(AWS_REGION);
    }

    private static DynamoDbClient getClient(String region) {
        if (ddbClients != null && ddbClients.containsKey(region)) {
            return ddbClients.get(region);
        }
        DynamoDbClient ddbClient = Para.getConfig().inProduction() ? DynamoDbClient.create() : (DynamoDbClient)((DynamoDbClientBuilder)((DynamoDbClientBuilder)DynamoDbClient.builder().endpointOverride(URI.create(LOCAL_ENDPOINT))).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)"local", (String)"null")))).build();
        if (ddbClients == null) {
            ddbClients = new HashMap<String, DynamoDbClient>();
            ddbClients.put(region, ddbClient);
            AWSDynamoUtils.getReplicaRegions().stream().filter(r -> !r.equals(region)).forEach(r -> ddbClients.put((String)r, (DynamoDbClient)((DynamoDbClientBuilder)DynamoDbClient.builder().region(Region.of((String)r))).build()));
        }
        AWSDynamoUtils.getAutoScalingClient(region);
        return ddbClient;
    }

    private static ApplicationAutoScalingClient getAutoScalingClient(String region) {
        if (aasClients == null) {
            aasClients = new HashMap<String, ApplicationAutoScalingClient>();
            aasClients.put(region, ApplicationAutoScalingClient.create());
            AWSDynamoUtils.getReplicaRegions().stream().filter(r -> !r.equals(region)).forEach(r -> aasClients.put((String)r, (ApplicationAutoScalingClient)((ApplicationAutoScalingClientBuilder)ApplicationAutoScalingClient.builder().region(Region.of((String)r))).build()));
        }
        return aasClients.get(region);
    }

    protected static void shutdownClient() {
        if (ddbClients != null) {
            ddbClients.values().stream().filter(c -> c != null).forEach(client -> client.close());
            ddbClients = null;
        }
        if (aasClients != null) {
            aasClients.values().stream().filter(c -> c != null).forEach(client -> client.close());
            aasClients = null;
        }
    }

    public static boolean existsTable(String appid) {
        if (StringUtils.isBlank((CharSequence)appid)) {
            return false;
        }
        try {
            DescribeTableResponse res = AWSDynamoUtils.getClient().describeTable(b -> b.tableName(AWSDynamoUtils.getTableNameForAppid(appid)));
            return res != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean createTable(String appid) {
        return AWSDynamoUtils.createTable(appid, Para.getConfig().awsDynamoMaxInitialReadCapacity(), Para.getConfig().awsDynamoMaxInitialWriteCapacity());
    }

    public static boolean createTable(String appid, int maxReadCapacity, int maxWriteCapacity) {
        boolean replicate;
        if (StringUtils.isBlank((CharSequence)appid)) {
            return false;
        }
        if (StringUtils.containsWhitespace((CharSequence)appid)) {
            logger.warn("DynamoDB table name contains whitespace. The name '{}' is invalid.", (Object)appid);
            return false;
        }
        if (AWSDynamoUtils.existsTable(appid)) {
            logger.warn("DynamoDB table '{}' already exists.", (Object)appid);
            return false;
        }
        String table = AWSDynamoUtils.getTableNameForAppid(appid);
        boolean created = AWSDynamoUtils.createTableInternal(appid, maxReadCapacity, maxWriteCapacity, AWS_REGION);
        boolean bl = replicate = !AWSDynamoUtils.getReplicaRegions().isEmpty() && !App.isRoot((String)appid);
        if (created && replicate) {
            Para.asyncExecute(() -> {
                LinkedList<Replica> replicas = new LinkedList<Replica>();
                replicas.add((Replica)Replica.builder().regionName(AWS_REGION).build());
                AWSDynamoUtils.getReplicaRegions().stream().filter(r -> !r.equals(AWS_REGION)).forEach(region -> {
                    logger.info("Replicating DynamoDB table '{}' in region {}...", (Object)table, region);
                    replicas.add((Replica)Replica.builder().regionName(region).build());
                    AWSDynamoUtils.createTableInternal(appid, maxReadCapacity, maxWriteCapacity, region);
                });
                AWSDynamoUtils.getClient().createGlobalTable(b -> b.globalTableName(table).replicationGroup((Collection)replicas));
            });
        }
        if (Para.getConfig().awsDynamoBackupsEnabled()) {
            logger.info("Enabling backups for table '{}'...", (Object)table);
            AWSDynamoUtils.getClient().updateContinuousBackups(t -> t.tableName(table).pointInTimeRecoverySpecification(p -> p.pointInTimeRecoveryEnabled(Boolean.valueOf(true))));
        }
        return created;
    }

    private static boolean createTableInternal(String appid, int maxReadCapacity, int maxWriteCapacity, String region) {
        boolean replicate = !AWSDynamoUtils.getReplicaRegions().isEmpty() && !App.isRoot((String)appid);
        try {
            String table = AWSDynamoUtils.getTableNameForAppid(appid);
            CreateTableRequest.Builder ctr = CreateTableRequest.builder().tableName(table).sseSpecification(b2 -> b2.enabled(Boolean.valueOf(Para.getConfig().awsDynamoEncryptionEnabled()))).keySchema(new KeySchemaElement[]{(KeySchemaElement)KeySchemaElement.builder().attributeName("key").keyType(KeyType.HASH).build()}).attributeDefinitions(new AttributeDefinition[]{(AttributeDefinition)AttributeDefinition.builder().attributeName("key").attributeType(ScalarAttributeType.S).build()});
            if (replicate) {
                ctr.streamSpecification(s -> s.streamEnabled(Boolean.valueOf(replicate)).streamViewType(StreamViewType.NEW_AND_OLD_IMAGES));
            }
            if (Para.getConfig().awsDynamoProvisionedBillingEnabled()) {
                ctr.billingMode(BillingMode.PROVISIONED);
                ctr.provisionedThroughput(b4 -> b4.readCapacityUnits(Long.valueOf(1L)).writeCapacityUnits(Long.valueOf(1L)));
            } else {
                ctr.billingMode(BillingMode.PAY_PER_REQUEST);
            }
            CreateTableResponse tbl = AWSDynamoUtils.getClient(region).createTable((CreateTableRequest)ctr.build());
            AWSDynamoUtils.waitForActive(table, region);
            logger.info("Created DynamoDB table '{}', status {}.", (Object)table, (Object)tbl.tableDescription().tableStatus());
            if (replicate && Para.getConfig().awsDynamoProvisionedBillingEnabled()) {
                logger.info("Enabling autoscaling for DynamoDB table '{}'...", (Object)table);
                ApplicationAutoScalingClient aasClient = AWSDynamoUtils.getAutoScalingClient(region);
                aasClient.registerScalableTarget(t -> t.serviceNamespace(ServiceNamespace.DYNAMODB).resourceId("table/" + table).scalableDimension(ScalableDimension.DYNAMODB_TABLE_READ_CAPACITY_UNITS).minCapacity(Integer.valueOf(1)).maxCapacity(Integer.valueOf(maxReadCapacity)));
                aasClient.registerScalableTarget(t -> t.serviceNamespace(ServiceNamespace.DYNAMODB).resourceId("table/" + table).scalableDimension(ScalableDimension.DYNAMODB_TABLE_WRITE_CAPACITY_UNITS).minCapacity(Integer.valueOf(1)).maxCapacity(Integer.valueOf(maxWriteCapacity)));
                aasClient.putScalingPolicy(s -> s.policyName(table + "-autoscale-reads").resourceId("table/" + table).serviceNamespace(ServiceNamespace.DYNAMODB).scalableDimension(ScalableDimension.DYNAMODB_TABLE_READ_CAPACITY_UNITS).policyType(PolicyType.TARGET_TRACKING_SCALING).targetTrackingScalingPolicyConfiguration(t -> t.predefinedMetricSpecification(p -> p.predefinedMetricType(MetricType.DYNAMO_DB_READ_CAPACITY_UTILIZATION)).targetValue(Double.valueOf(70.0)).scaleInCooldown(Integer.valueOf(60)).scaleOutCooldown(Integer.valueOf(60))));
                aasClient.putScalingPolicy(s -> s.policyName(table + "-autoscale-writes").resourceId("table/" + table).serviceNamespace(ServiceNamespace.DYNAMODB).scalableDimension(ScalableDimension.DYNAMODB_TABLE_WRITE_CAPACITY_UNITS).policyType(PolicyType.TARGET_TRACKING_SCALING).targetTrackingScalingPolicyConfiguration(t -> t.predefinedMetricSpecification(p -> p.predefinedMetricType(MetricType.DYNAMO_DB_WRITE_CAPACITY_UTILIZATION)).targetValue(Double.valueOf(70.0)).scaleInCooldown(Integer.valueOf(60)).scaleOutCooldown(Integer.valueOf(60))));
                AWSDynamoUtils.waitForActive(table, region);
            }
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean updateTable(String appid, long readCapacity, long writeCapacity) {
        if (StringUtils.isBlank((CharSequence)appid) || StringUtils.containsWhitespace((CharSequence)appid)) {
            return false;
        }
        String table = AWSDynamoUtils.getTableNameForAppid(appid);
        try {
            AWSDynamoUtils.getClient().updateTable(b -> b.tableName(table).provisionedThroughput(b1 -> b1.readCapacityUnits(Long.valueOf(readCapacity)).writeCapacityUnits(Long.valueOf(writeCapacity))));
            return true;
        }
        catch (Exception e) {
            logger.error("Could not update table '{}' - table is not active or no change to capacity: {}", (Object)table, (Object)e.getMessage());
            return false;
        }
    }

    public static boolean deleteTable(String appid) {
        if (StringUtils.isBlank((CharSequence)appid) || !AWSDynamoUtils.existsTable(appid)) {
            return false;
        }
        try {
            String table = AWSDynamoUtils.getTableNameForAppid(appid);
            if (!AWSDynamoUtils.getReplicaRegions().isEmpty() && !App.isRoot((String)appid)) {
                LinkedList replicaUpdates = new LinkedList();
                AWSDynamoUtils.getReplicaRegions().stream().forEach(region -> {
                    logger.info("Removing replica from global table '{}' in region {}...", (Object)table, region);
                    replicaUpdates.add((ReplicaUpdate)ReplicaUpdate.builder().delete(d -> d.regionName(region)).build());
                });
                try {
                    AWSDynamoUtils.getClient().updateGlobalTable(b -> b.globalTableName(table).replicaUpdates((Collection)replicaUpdates));
                    AWSDynamoUtils.getReplicaRegions().stream().forEach(region -> {
                        DynamoDbAsyncClient asyncdb = (DynamoDbAsyncClient)((DynamoDbAsyncClientBuilder)DynamoDbAsyncClient.builder().region(Region.of((String)region))).build();
                        asyncdb.deleteTable((T b) -> b.tableName(table));
                        logger.info("Deleted DynamoDB table '{}' in region {}.", (Object)table, region);
                    });
                }
                catch (Exception ex) {
                    logger.error(null, (Throwable)ex);
                }
            } else {
                AWSDynamoUtils.getClient().deleteTable((T b) -> b.tableName(table));
                logger.info("Deleted DynamoDB table '{}'.", (Object)table);
            }
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean createSharedTable(long readCapacity, long writeCapacity) {
        if (StringUtils.isBlank((CharSequence)Para.getConfig().sharedTableName()) || StringUtils.containsWhitespace((CharSequence)Para.getConfig().sharedTableName()) || AWSDynamoUtils.existsTable(Para.getConfig().sharedTableName())) {
            return false;
        }
        String table = AWSDynamoUtils.getTableNameForAppid(Para.getConfig().sharedTableName());
        try {
            GlobalSecondaryIndex secIndex = (GlobalSecondaryIndex)GlobalSecondaryIndex.builder().indexName(AWSDynamoUtils.getSharedIndexName()).provisionedThroughput(b -> b.readCapacityUnits(Long.valueOf(1L)).writeCapacityUnits(Long.valueOf(1L))).projection((Projection)Projection.builder().projectionType(ProjectionType.ALL).build()).keySchema(new KeySchemaElement[]{(KeySchemaElement)KeySchemaElement.builder().attributeName("appid").keyType(KeyType.HASH).build(), (KeySchemaElement)KeySchemaElement.builder().attributeName("id").keyType(KeyType.RANGE).build()}).build();
            AttributeDefinition[] attributes = new AttributeDefinition[]{(AttributeDefinition)AttributeDefinition.builder().attributeName("key").attributeType(ScalarAttributeType.S).build(), (AttributeDefinition)AttributeDefinition.builder().attributeName("appid").attributeType(ScalarAttributeType.S).build(), (AttributeDefinition)AttributeDefinition.builder().attributeName("id").attributeType(ScalarAttributeType.S).build()};
            CreateTableResponse tbl = AWSDynamoUtils.getClient().createTable((T b) -> b.tableName(table).keySchema(new KeySchemaElement[]{(KeySchemaElement)KeySchemaElement.builder().attributeName("key").keyType(KeyType.HASH).build()}).sseSpecification(b2 -> b2.enabled(Boolean.valueOf(Para.getConfig().awsDynamoEncryptionEnabled()))).attributeDefinitions(attributes).globalSecondaryIndexes(new GlobalSecondaryIndex[]{secIndex}).provisionedThroughput(b6 -> b6.readCapacityUnits(Long.valueOf(readCapacity)).writeCapacityUnits(Long.valueOf(writeCapacity))));
            logger.info("Waiting for DynamoDB table to become ACTIVE...");
            AWSDynamoUtils.waitForActive(table, AWS_REGION);
            logger.info("Created shared table '{}', status {}.", (Object)table, (Object)tbl.tableDescription().tableStatus());
            if (Para.getConfig().awsDynamoBackupsEnabled()) {
                logger.info("Enabling backups for shared table '{}'...", (Object)table);
                AWSDynamoUtils.getClient().updateContinuousBackups(t -> t.tableName(table).pointInTimeRecoverySpecification(p -> p.pointInTimeRecoveryEnabled(Boolean.valueOf(true))));
            }
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
            return false;
        }
        return true;
    }

    public static Map<String, Object> getTableStatus(String appid) {
        if (StringUtils.isBlank((CharSequence)appid)) {
            return Collections.emptyMap();
        }
        try {
            TableDescription td = AWSDynamoUtils.getClient().describeTable(b -> b.tableName(AWSDynamoUtils.getTableNameForAppid(appid))).table();
            HashMap<String, Object> dbStatus = new HashMap<String, Object>();
            dbStatus.put("id", appid);
            dbStatus.put("status", td.tableStatus().name());
            dbStatus.put("created", td.creationDateTime().toEpochMilli());
            dbStatus.put("sizeBytes", td.tableSizeBytes());
            dbStatus.put("itemCount", td.itemCount());
            dbStatus.put("readCapacityUnits", td.provisionedThroughput().readCapacityUnits());
            dbStatus.put("writeCapacityUnits", td.provisionedThroughput().writeCapacityUnits());
            return dbStatus;
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public static List<String> listAllTables() {
        String lastKey;
        int items = 100;
        ListTablesResponse ltr = AWSDynamoUtils.getClient().listTables(b -> b.limit(Integer.valueOf(items)));
        LinkedList<String> tables = new LinkedList<String>();
        do {
            tables.addAll(ltr.tableNames());
            logger.info("Found {} tables. Total found: {}.", (Object)ltr.tableNames().size(), (Object)tables.size());
            if (ltr.lastEvaluatedTableName() == null) break;
            lastKey = ltr.lastEvaluatedTableName();
        } while (!(ltr = AWSDynamoUtils.getClient().listTables(b -> b.limit(Integer.valueOf(items)).exclusiveStartTableName(lastKey))).tableNames().isEmpty());
        return tables;
    }

    public static String getTableNameForAppid(String appIdentifier) {
        if (StringUtils.isBlank((CharSequence)appIdentifier)) {
            return null;
        }
        if (AWSDynamoUtils.isSharedAppid(appIdentifier)) {
            appIdentifier = Para.getConfig().sharedTableName();
        }
        return App.isRoot((String)appIdentifier) || appIdentifier.startsWith("para".concat("-")) ? appIdentifier : "para-" + appIdentifier;
    }

    public static String getKeyForAppid(String key, String appIdentifier) {
        if (StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)appIdentifier)) {
            return key;
        }
        if (AWSDynamoUtils.isSharedAppid(appIdentifier)) {
            return AWSDynamoUtils.keyPrefix(appIdentifier) + key;
        }
        return key;
    }

    protected static <P extends ParaObject> Map<String, AttributeValue> toRow(P so, Class<? extends Annotation> filter) {
        HashMap<String, AttributeValue> row = new HashMap<String, AttributeValue>();
        if (so == null) {
            return row;
        }
        for (Map.Entry entry : ParaObjectUtils.getAnnotatedFields(so, filter).entrySet()) {
            Object value = entry.getValue();
            if (value == null || StringUtils.isBlank((CharSequence)value.toString())) continue;
            row.put((String)entry.getKey(), (AttributeValue)AttributeValue.builder().s(value.toString()).build());
        }
        if (so.getVersion() != null && so.getVersion() > 0L) {
            row.put("version", (AttributeValue)AttributeValue.builder().n(so.getVersion().toString()).build());
        } else {
            row.remove("version");
        }
        return row;
    }

    protected static <P extends ParaObject> P fromRow(Map<String, AttributeValue> row) {
        if (row == null || row.isEmpty()) {
            return null;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        for (Map.Entry<String, AttributeValue> col : row.entrySet()) {
            props.put(col.getKey(), col.getValue().s());
        }
        props.put("version", row.getOrDefault("version", (AttributeValue)AttributeValue.builder().n("0").build()).n());
        return (P)ParaObjectUtils.setAnnotatedFields(props);
    }

    protected static <P extends ParaObject> void batchGet(Map<String, KeysAndAttributes> kna, Map<String, P> results, int backoff) {
        if (kna == null || kna.isEmpty() || results == null) {
            return;
        }
        try {
            BatchGetItemResponse result = AWSDynamoUtils.getClient().batchGetItem(b -> b.returnConsumedCapacity(ReturnConsumedCapacity.TOTAL).requestItems(kna));
            if (result == null) {
                return;
            }
            List res = (List)result.responses().get(kna.keySet().iterator().next());
            for (Map map : res) {
                P obj = AWSDynamoUtils.fromRow(map);
                if (obj == null) continue;
                results.put(obj.getId(), obj);
            }
            logger.debug("batchGet(): total {}, cc {}", (Object)res.size(), (Object)result.consumedCapacity());
            if (result.unprocessedKeys() != null && !result.unprocessedKeys().isEmpty()) {
                Thread.sleep((long)backoff * 1000L);
                for (Map.Entry entry : result.unprocessedKeys().entrySet()) {
                    logger.warn("UNPROCESSED DynamoDB read requests for keys {} in table {}!", (Object)((KeysAndAttributes)entry.getValue()).keys().stream().flatMap(r -> r.values().stream().map(v -> v.s())).collect(Collectors.joining(",")), entry.getKey());
                }
                AWSDynamoUtils.batchGet(result.unprocessedKeys(), results, backoff * 2);
            }
        }
        catch (ProvisionedThroughputExceededException ex) {
            logger.warn("Read capacity exceeded for table '{}'. Retrying request in {} seconds.", (Object)kna.keySet().iterator().next(), (Object)backoff);
            try {
                Thread.sleep((long)backoff * 1000L);
                AWSDynamoUtils.batchGet(kna, results, backoff * 2);
            }
            catch (InterruptedException ie) {
                logger.error(null, (Throwable)ie);
                Thread.currentThread().interrupt();
            }
        }
        catch (InterruptedException ie) {
            logger.error(null, (Throwable)ie);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            logger.error("Failed to execute batch read operation on table '{}'", (Object)kna.keySet().iterator().next(), (Object)e);
        }
    }

    protected static void batchWrite(Map<String, List<WriteRequest>> items, int backoff) {
        if (items == null || items.isEmpty()) {
            return;
        }
        try {
            logger.debug("batchWrite(): requests {}, backoff {}", (Object)items.values().iterator().next().size(), (Object)backoff);
            BatchWriteItemResponse result = AWSDynamoUtils.getClient().batchWriteItem(b -> b.returnConsumedCapacity(ReturnConsumedCapacity.TOTAL).requestItems(items));
            if (result == null) {
                return;
            }
            logger.debug("batchWrite(): success - consumed capacity {}", (Object)result.consumedCapacity());
            if (result.unprocessedItems() != null && !result.unprocessedItems().isEmpty()) {
                Thread.sleep((long)backoff * 1000L);
                for (Map.Entry entry : result.unprocessedItems().entrySet()) {
                    logger.warn("UNPROCESSED DynamoDB write requests for keys {} in table {}!", (Object)((List)entry.getValue()).stream().map(r -> r.getValueForField("key", String.class).orElse("")).collect(Collectors.joining(",")), entry.getKey());
                }
                AWSDynamoUtils.batchWrite(result.unprocessedItems(), backoff * 2);
            }
        }
        catch (ProvisionedThroughputExceededException ex) {
            logger.warn("Write capacity exceeded for table '{}'. Retrying request in {} seconds.", (Object)items.keySet().iterator().next(), (Object)backoff);
            try {
                Thread.sleep((long)backoff * 1000L);
                AWSDynamoUtils.batchWrite(items, backoff * 2);
            }
            catch (InterruptedException ie) {
                logger.error(null, (Throwable)ie);
                Thread.currentThread().interrupt();
            }
        }
        catch (InterruptedException ie) {
            logger.error(null, (Throwable)ie);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            logger.error("Failed to execute batch write operation on table '{}'", (Object)items.keySet().iterator().next(), (Object)e);
            AWSDynamoUtils.throwIfNecessary(e);
        }
    }

    public static <P extends ParaObject> List<P> readPageFromTable(String appid, Pager p) {
        Pager pager = p != null ? p : new Pager();
        ScanRequest.Builder scanRequest = ScanRequest.builder().tableName(AWSDynamoUtils.getTableNameForAppid(appid)).limit(Integer.valueOf(pager.getLimit())).returnConsumedCapacity(ReturnConsumedCapacity.TOTAL);
        if (!StringUtils.isBlank((CharSequence)pager.getLastKey())) {
            scanRequest.exclusiveStartKey(Collections.singletonMap("key", (AttributeValue)AttributeValue.builder().s(pager.getLastKey()).build()));
        }
        ScanResponse result = AWSDynamoUtils.getClient().scan((ScanRequest)scanRequest.build());
        String lastKey = null;
        LinkedList<P> results = new LinkedList<P>();
        for (Map item : result.items()) {
            P obj = AWSDynamoUtils.fromRow(item);
            if (obj == null) continue;
            lastKey = ((AttributeValue)item.get("key")).s();
            results.add(obj);
        }
        if (result.lastEvaluatedKey() != null && !result.lastEvaluatedKey().isEmpty()) {
            pager.setLastKey(((AttributeValue)result.lastEvaluatedKey().get("key")).s());
        } else if (!results.isEmpty()) {
            pager.setLastKey(lastKey);
        }
        return results;
    }

    public static <P extends ParaObject> List<P> readPageFromSharedTable(String appid, Pager pager) {
        LinkedList<P> results = new LinkedList<P>();
        if (StringUtils.isBlank((CharSequence)appid)) {
            return results;
        }
        QueryResponse pages = AWSDynamoUtils.queryGSI(appid, pager);
        if (pages != null) {
            for (Map item : pages.items()) {
                P obj = AWSDynamoUtils.fromRow(item);
                if (obj == null) continue;
                results.add(obj);
            }
        }
        if (!results.isEmpty() && pager != null) {
            pager.setLastKey(((ParaObject)results.peekLast()).getId());
        }
        return results;
    }

    private static QueryResponse queryGSI(String appid, Pager p) {
        Pager pager = p != null ? p : new Pager();
        GlobalSecondaryIndexDescription index = AWSDynamoUtils.getSharedGlobalIndex();
        QueryRequest.Builder query = QueryRequest.builder().limit(Integer.valueOf(pager.getLimit())).keyConditionExpression("appid = :aid").expressionAttributeValues(Collections.singletonMap(":aid", (AttributeValue)AttributeValue.builder().s(appid).build()));
        if (!StringUtils.isBlank((CharSequence)pager.getLastKey())) {
            HashMap<String, AttributeValue> startKey = new HashMap<String, AttributeValue>(3);
            startKey.put("appid", (AttributeValue)AttributeValue.builder().s(appid).build());
            startKey.put("id", (AttributeValue)AttributeValue.builder().s(pager.getLastKey()).build());
            startKey.put("key", (AttributeValue)AttributeValue.builder().s(AWSDynamoUtils.getKeyForAppid(pager.getLastKey(), appid)).build());
            query.exclusiveStartKey(startKey);
        }
        return index != null ? AWSDynamoUtils.getClient().query((QueryRequest)query.indexName(index.indexName()).tableName(AWSDynamoUtils.getTableNameForAppid(Para.getConfig().sharedTableName())).build()) : null;
    }

    public static void deleteAllFromSharedTable(String appid) {
        QueryResponse pages;
        if (StringUtils.isBlank((CharSequence)appid) || !AWSDynamoUtils.isSharedAppid(appid)) {
            return;
        }
        Pager pager = new Pager(25);
        Map lastKey = null;
        while ((pages = AWSDynamoUtils.queryGSI(appid, pager)) != null) {
            LinkedList<WriteRequest> deletePage = new LinkedList<WriteRequest>();
            for (Map item : pages.items()) {
                String key = ((AttributeValue)item.get("key")).s();
                if (!StringUtils.startsWith((CharSequence)key, (CharSequence)AWSDynamoUtils.keyPrefix(appid))) continue;
                logger.debug("Preparing to delete '{}' from shared table, appid: '{}'.", (Object)key, (Object)appid);
                pager.setLastKey(((AttributeValue)item.get("id")).s());
                deletePage.add((WriteRequest)WriteRequest.builder().deleteRequest(b -> b.key(Collections.singletonMap("key", (AttributeValue)AttributeValue.builder().s(key).build()))).build());
            }
            lastKey = pages.lastEvaluatedKey();
            logger.info("Deleting {} items belonging to app '{}', from shared table...", (Object)deletePage.size(), (Object)appid);
            if (!deletePage.isEmpty()) {
                AWSDynamoUtils.batchWrite(Collections.singletonMap(AWSDynamoUtils.getTableNameForAppid(appid), deletePage), 1);
            }
            if (lastKey != null && !lastKey.isEmpty()) continue;
        }
    }

    public static GlobalSecondaryIndexDescription getSharedGlobalIndex() {
        try {
            DescribeTableResponse t = AWSDynamoUtils.getClient().describeTable(b -> b.tableName(AWSDynamoUtils.getTableNameForAppid(Para.getConfig().sharedTableName())));
            return t.table().globalSecondaryIndexes().stream().filter(gsi -> gsi.indexName().equals(AWSDynamoUtils.getSharedIndexName())).findFirst().orElse(null);
        }
        catch (Exception e) {
            logger.info("Could not get shared index: {}.", (Object)e.getMessage());
            return null;
        }
    }

    public static boolean isSharedAppid(String appIdentifier) {
        return StringUtils.startsWith((CharSequence)appIdentifier, (CharSequence)" ");
    }

    public static List<String> getReplicaRegions() {
        if (!StringUtils.isBlank((CharSequence)Para.getConfig().awsDynamoReplicaRegions()) && replicaRegions == null) {
            replicaRegions = new LinkedList<String>();
            String[] regions = Para.getConfig().awsDynamoReplicaRegions().split("\\s*,\\s*");
            if (regions != null && regions.length > 0) {
                for (String region : regions) {
                    if (StringUtils.isBlank((CharSequence)region)) continue;
                    replicaRegions.add(region);
                }
            }
        }
        return Optional.ofNullable(replicaRegions).orElse(Collections.emptyList());
    }

    private static String getSharedIndexName() {
        return "GSI_" + Para.getConfig().sharedTableName();
    }

    private static String keyPrefix(String appIdentifier) {
        return StringUtils.join((Object[])new String[]{StringUtils.trim((String)appIdentifier), "_"});
    }

    private static void waitForActive(String table, String region) {
        WaiterResponse waiterResponse = AWSDynamoUtils.getClient(region).waiter().waitUntilTableExists(r -> r.tableName(table));
        if (!waiterResponse.matched().response().isPresent()) {
            logger.warn("DynamoDB table {} did not become active!", (Object)table);
        }
    }

    protected static void throwIfNecessary(Throwable t) {
        if (t != null && Para.getConfig().exceptionOnWriteErrorsEnabled()) {
            throw new RuntimeException("DAO write operation failed! - " + t.getMessage(), t);
        }
    }

    static {
        logger = LoggerFactory.getLogger(AWSDynamoUtils.class);
        Para.addDestroyListener(() -> AWSDynamoUtils.shutdownClient());
    }
}

