/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.email;

import com.erudika.para.core.email.Emailer;
import com.erudika.para.core.utils.Para;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.mail.javamail.MimeMessagePreparator;

public class JavaMailEmailer
implements Emailer {
    private static final Logger logger = LoggerFactory.getLogger(JavaMailEmailer.class);
    private static final ExecutorService EXECUTOR = Executors.newFixedThreadPool(Para.getConfig().executorThreads());
    private JavaMailSender mailSender;

    public JavaMailEmailer(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }

    public boolean sendEmail(final List<String> emails, final String subject, final String body) {
        if (emails == null || emails.isEmpty()) {
            return false;
        }
        this.asyncExecute(new Runnable(){

            @Override
            public void run() {
                MimeMessagePreparator preparator = new MimeMessagePreparator(){

                    public void prepare(MimeMessage mimeMessage) throws Exception {
                        MimeMessageHelper msg = new MimeMessageHelper(mimeMessage);
                        Iterator emailz = emails.iterator();
                        msg.setTo((String)emailz.next());
                        while (emailz.hasNext()) {
                            msg.addBcc((String)emailz.next());
                        }
                        msg.setSubject(subject);
                        msg.setFrom(Para.getConfig().supportEmail());
                        msg.setText(body, true);
                    }
                };
                try {
                    JavaMailEmailer.this.mailSender.send(preparator);
                    logger.debug("Email sent to {}, {}", (Object)emails, (Object)subject);
                }
                catch (MailException ex) {
                    logger.error("Failed to send email. {}", (Object)ex.getMessage());
                }
            }
        });
        return true;
    }

    private void asyncExecute(Runnable runnable) {
        if (runnable != null) {
            try {
                EXECUTOR.execute(runnable);
            }
            catch (RejectedExecutionException ex) {
                logger.warn(ex.getMessage());
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    logger.error(null, (Throwable)e);
                }
            }
        }
    }
}

