/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.cache;

import com.erudika.para.core.cache.Cache;
import com.erudika.para.core.utils.Para;
import com.erudika.para.server.cache.CaffeineCache;
import com.google.inject.AbstractModule;
import java.util.ServiceLoader;
import org.apache.commons.lang3.StringUtils;

public class CacheModule
extends AbstractModule {
    protected void configure() {
        String selectedCache = Para.getConfig().cachePlugin();
        if (StringUtils.isBlank((CharSequence)selectedCache) || "inmemory".equalsIgnoreCase(selectedCache)) {
            this.bindToDefault();
        } else {
            Cache cachePlugin = this.loadExternalCache(selectedCache);
            if (cachePlugin != null) {
                this.bind(Cache.class).to(cachePlugin.getClass()).asEagerSingleton();
            } else {
                this.bindToDefault();
            }
        }
    }

    void bindToDefault() {
        this.bind(Cache.class).to(CaffeineCache.class).asEagerSingleton();
    }

    final Cache loadExternalCache(String classSimpleName) {
        ServiceLoader<Cache> cacheLoader = ServiceLoader.load(Cache.class, Para.getParaClassLoader());
        for (Cache cache : cacheLoader) {
            if (cache == null || !classSimpleName.equalsIgnoreCase(cache.getClass().getSimpleName())) continue;
            return cache;
        }
        return null;
    }
}

