/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server.aop;

import com.erudika.para.core.ParaObject;
import com.erudika.para.core.annotations.Cached;
import com.erudika.para.core.annotations.Indexed;
import com.erudika.para.core.cache.Cache;
import com.erudika.para.core.listeners.IOListener;
import com.erudika.para.core.metrics.Metrics;
import com.erudika.para.core.persistence.DAO;
import com.erudika.para.core.search.Search;
import com.erudika.para.core.utils.Para;
import com.erudika.para.core.utils.Utils;
import com.erudika.para.core.validation.ValidationUtils;
import com.erudika.para.server.aop.AOPUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexAndCacheAspect
implements MethodInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(IndexAndCacheAspect.class);
    private Search search;
    private Cache cache;

    public Search getSearch() {
        return this.search;
    }

    @Inject
    public void setSearch(Search search) {
        this.search = search;
    }

    public Cache getCache() {
        return this.cache;
    }

    @Inject
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public Object invoke(MethodInvocation mi) throws Throwable {
        if (!Modifier.isPublic(mi.getMethod().getModifiers())) {
            return mi.proceed();
        }
        Method daoMethod = mi.getMethod();
        Object[] args = mi.getArguments();
        String appid = AOPUtils.getFirstArgOfString(args);
        Method superMethod = null;
        Indexed indexedAnno = null;
        Cached cachedAnno = null;
        try {
            superMethod = DAO.class.getMethod(daoMethod.getName(), daoMethod.getParameterTypes());
            indexedAnno = Para.getConfig().isSearchEnabled() ? superMethod.getAnnotation(Indexed.class) : null;
            cachedAnno = Para.getConfig().isCacheEnabled() ? superMethod.getAnnotation(Cached.class) : null;
            this.detectNestedInvocations(daoMethod);
        }
        catch (Exception e) {
            logger.error("Error in AOP layer!", (Throwable)e);
        }
        Set ioListeners = Para.getIOListeners();
        for (IOListener ioListener : ioListeners) {
            ioListener.onPreInvoke(superMethod, args);
            logger.debug("Executed {}.onPreInvoke().", (Object)ioListener.getClass().getName());
        }
        Object result = this.handleIndexing(indexedAnno, appid, daoMethod, args, mi);
        Object cachingResult = this.handleCaching(cachedAnno, appid, daoMethod, args, mi);
        if (result == null && cachingResult != null) {
            result = cachingResult;
        }
        if (indexedAnno == null && cachedAnno == null) {
            result = this.invokeDAO(appid, daoMethod, mi);
        }
        for (IOListener ioListener : ioListeners) {
            ioListener.onPostInvoke(superMethod, args, result);
            logger.debug("Executed {}.onPostInvoke().", (Object)ioListener.getClass().getName());
        }
        return result;
    }

    private Object invokeDAO(String appid, Method daoMethod, MethodInvocation mi) throws Throwable {
        try (Metrics.Context context = Metrics.time((String)appid, daoMethod.getDeclaringClass(), (String[])new String[]{daoMethod.getName()});){
            Object object = mi.proceed();
            return object;
        }
    }

    private Object handleIndexing(Indexed indexedAnno, String appid, Method daoMethod, Object[] args, MethodInvocation mi) throws Throwable {
        Object result = null;
        if (indexedAnno != null) {
            switch (indexedAnno.action()) {
                case ADD: {
                    result = this.addToIndexOperation(appid, daoMethod, args, mi);
                    break;
                }
                case REMOVE: {
                    result = this.removeFromIndexOperation(appid, daoMethod, args, mi);
                    break;
                }
                case ADD_ALL: {
                    result = this.addToIndexBatchOperation(appid, daoMethod, args, mi);
                    break;
                }
                case REMOVE_ALL: {
                    result = this.removeFromIndexBatchOperation(appid, daoMethod, args, mi);
                    break;
                }
            }
        }
        return result;
    }

    private Object handleCaching(Cached cachedAnno, String appid, Method daoMethod, Object[] args, MethodInvocation mi) throws Throwable {
        Object result = null;
        if (cachedAnno != null) {
            switch (cachedAnno.action()) {
                case GET: {
                    result = this.readFromCacheOperation(appid, daoMethod, args, mi);
                    break;
                }
                case PUT: {
                    this.addToCacheOperation(appid, args);
                    break;
                }
                case DELETE: {
                    this.removeFromCacheOperation(appid, args);
                    break;
                }
                case GET_ALL: {
                    result = this.readFromCacheBatchOperation(appid, daoMethod, args, mi);
                    break;
                }
                case PUT_ALL: {
                    this.addToCacheBatchOperation(appid, args);
                    break;
                }
                case DELETE_ALL: {
                    this.removeFromCacheBatchOperation(appid, args);
                    break;
                }
            }
        }
        return result;
    }

    private Object addToIndexOperation(String appid, Method daoMethod, Object[] args, MethodInvocation mi) throws Throwable {
        ParaObject addMe = AOPUtils.getArgOfParaObject(args);
        CharSequence[] errors = ValidationUtils.validateObject((ParaObject)addMe);
        Object result = null;
        if (addMe != null && errors.length == 0) {
            AOPUtils.checkAndFixType(addMe);
            if (addMe.getStored().booleanValue()) {
                result = this.invokeDAO(appid, daoMethod, mi);
                if (addMe.getVersion() == -1L) {
                    logger.warn("DAO operation failed for object '{}' due to version mismatch. Indexing and caching will be skipped.", (Object)addMe.getId());
                }
            }
            if (addMe.getIndexed().booleanValue() && addMe.getVersion() >= 0L) {
                try (Metrics.Context context = Metrics.time((String)appid, this.search.getClass(), (String[])new String[]{"index"});){
                    this.search.index(appid, addMe);
                    logger.debug("{}: Indexed {}->{}", new Object[]{this.getClass().getSimpleName(), appid, addMe.getId()});
                }
            }
        } else {
            logger.warn("{}: Invalid object {}->{} errors: [{}]. Changes weren't persisted.", new Object[]{this.getClass().getSimpleName(), appid, addMe, String.join((CharSequence)"; ", errors)});
        }
        return result;
    }

    private Object removeFromIndexOperation(String appid, Method daoMethod, Object[] args, MethodInvocation mi) throws Throwable {
        Object result = this.invokeDAO(appid, daoMethod, mi);
        ParaObject removeMe = AOPUtils.getArgOfParaObject(args);
        AOPUtils.checkAndFixType(removeMe);
        try (Metrics.Context context = Metrics.time((String)appid, this.search.getClass(), (String[])new String[]{"unindex"});){
            this.search.unindex(appid, removeMe);
            logger.debug("{}: Unindexed {}->{}", new Object[]{this.getClass().getSimpleName(), appid, removeMe == null ? null : removeMe.getId()});
        }
        return result;
    }

    private Object addToIndexBatchOperation(String appid, Method daoMethod, Object[] args, MethodInvocation mi) throws Throwable {
        List<ParaObject> addUs = AOPUtils.getArgOfListOfType(args, ParaObject.class);
        LinkedList<ParaObject> indexUs = new LinkedList<ParaObject>();
        List<ParaObject> removedObjects = AOPUtils.removeNotStoredNotIndexed(addUs, indexUs);
        Object result = this.invokeDAO(appid, daoMethod, mi);
        List indexUsFiltered = indexUs.stream().filter(p -> p.getVersion() >= 0L).collect(Collectors.toList());
        if (!indexUs.isEmpty() && indexUsFiltered.isEmpty()) {
            logger.warn("DAO batch operation failed for {} objects due to version mismatch or rollback. Indexing and caching for these objects will be skipped.", (Object)indexUs.size());
        }
        try (Metrics.Context context = Metrics.time((String)appid, this.search.getClass(), (String[])new String[]{"indexAll"});){
            this.search.indexAll(appid, indexUsFiltered);
        }
        if (addUs != null) {
            addUs.addAll(removedObjects);
        }
        logger.debug("{}: Indexed all {}->{}", new Object[]{this.getClass().getSimpleName(), appid, indexUs.size()});
        return result;
    }

    private Object removeFromIndexBatchOperation(String appid, Method daoMethod, Object[] args, MethodInvocation mi) throws Throwable {
        List<ParaObject> removeUs = AOPUtils.getArgOfListOfType(args, ParaObject.class);
        Object result = this.invokeDAO(appid, daoMethod, mi);
        try (Metrics.Context context = Metrics.time((String)appid, this.search.getClass(), (String[])new String[]{"unindexAll"});){
            this.search.unindexAll(appid, removeUs);
        }
        logger.debug("{}: Unindexed all {}->{}", new Object[]{this.getClass().getSimpleName(), appid, removeUs == null ? null : Integer.valueOf(removeUs.size())});
        return result;
    }

    private Object readFromCacheOperation(String appid, Method daoMethod, Object[] args, MethodInvocation mi) throws Throwable {
        Object result = null;
        String getMeId = args != null && args.length > 1 ? (String)args[1] : null;
        try (Metrics.Context context = Metrics.time((String)appid, this.cache.getClass(), (String[])new String[]{"get"});){
            result = this.cache.get(appid, getMeId);
        }
        if (result != null) {
            logger.debug("{}: Cache hit: {}->{}", new Object[]{this.getClass().getSimpleName(), appid, getMeId});
        } else if (getMeId != null && (result = this.invokeDAO(appid, daoMethod, mi)) != null && ((ParaObject)result).getCached().booleanValue()) {
            context = Metrics.time((String)appid, this.cache.getClass(), (String[])new String[]{"put"});
            try {
                this.cache.put(appid, getMeId, result);
            }
            finally {
                if (context != null) {
                    context.close();
                }
            }
            logger.debug("{}: Cache miss: {}->{}", new Object[]{this.getClass().getSimpleName(), appid, getMeId});
        }
        return result;
    }

    private void addToCacheOperation(String appid, Object[] args) {
        ParaObject putMe = AOPUtils.getArgOfParaObject(args);
        if (putMe != null && putMe.getCached().booleanValue() && putMe.getVersion() >= 0L) {
            try (Metrics.Context context = Metrics.time((String)appid, this.cache.getClass(), (String[])new String[]{"put"});){
                this.cache.put(appid, putMe.getId(), (Object)putMe);
            }
            logger.debug("{}: Cache put: {}->{}", new Object[]{this.getClass().getSimpleName(), appid, putMe.getId()});
        }
    }

    private void removeFromCacheOperation(String appid, Object[] args) {
        ParaObject deleteMe = AOPUtils.getArgOfParaObject(args);
        if (deleteMe != null) {
            try (Metrics.Context context = Metrics.time((String)appid, this.cache.getClass(), (String[])new String[]{"remove"});){
                this.cache.remove(appid, deleteMe.getId());
            }
            logger.debug("{}: Cache delete: {}->{}", new Object[]{this.getClass().getSimpleName(), appid, deleteMe.getId()});
        }
    }

    private Object readFromCacheBatchOperation(String appid, Method daoMethod, Object[] args, MethodInvocation mi) throws Throwable {
        Object result = Collections.emptyMap();
        List<String> getUs = AOPUtils.getArgOfListOfType(args, String.class);
        if (getUs != null) {
            Map cached;
            try (Metrics.Context context = Metrics.time((String)appid, this.cache.getClass(), (String[])new String[]{"getAll"});){
                cached = this.cache.getAll(appid, getUs);
            }
            logger.debug("{}: Cache getAll(): {}->{}", new Object[]{this.getClass().getSimpleName(), appid, getUs});
            if (cached.size() < getUs.size()) {
                logger.debug("{}: Cache getAll() will read from DB: {}", (Object)this.getClass().getSimpleName(), (Object)appid);
                result = this.invokeDAO(appid, daoMethod, mi);
                if (result != null) {
                    for (String id : getUs) {
                        ParaObject obj;
                        logger.debug("{}: Cache getAll() got from DB: {}", (Object)this.getClass().getSimpleName(), (Object)id);
                        if (cached.containsKey(id) || (obj = (ParaObject)((Map)result).get(id)) == null || !obj.getCached().booleanValue()) continue;
                        try (Metrics.Context context = Metrics.time((String)appid, this.cache.getClass(), (String[])new String[]{"put"});){
                            this.cache.put(appid, obj.getId(), (Object)obj);
                        }
                        logger.debug("{}: Cache miss on readAll: {}->{}", new Object[]{this.getClass().getSimpleName(), appid, id});
                    }
                }
            }
            if (result == null || result.isEmpty()) {
                result = cached;
            }
        }
        return result;
    }

    private void addToCacheBatchOperation(String appid, Object[] args) {
        List<ParaObject> putUs = AOPUtils.getArgOfListOfType(args, ParaObject.class);
        if (putUs != null && !putUs.isEmpty()) {
            LinkedHashMap<String, ParaObject> map1 = new LinkedHashMap<String, ParaObject>(putUs.size());
            for (ParaObject obj : putUs) {
                if (obj == null || !obj.getCached().booleanValue() || obj.getVersion() < 0L) continue;
                map1.put(obj.getId(), obj);
            }
            if (!map1.isEmpty()) {
                try (Metrics.Context context = Metrics.time((String)appid, this.cache.getClass(), (String[])new String[]{"putAll"});){
                    this.cache.putAll(appid, map1);
                }
            }
            logger.debug("{}: Cache put page: {}->{}", new Object[]{this.getClass().getSimpleName(), appid, map1.keySet()});
        }
    }

    private void removeFromCacheBatchOperation(String appid, Object[] args) {
        List<ParaObject> deleteUs = AOPUtils.getArgOfListOfType(args, ParaObject.class);
        if (deleteUs != null && !deleteUs.isEmpty()) {
            ArrayList<String> list = new ArrayList<String>(deleteUs.size());
            for (ParaObject paraObject : deleteUs) {
                list.add(paraObject.getId());
            }
            try (Metrics.Context context = Metrics.time((String)appid, this.cache.getClass(), (String[])new String[]{"removeAll"});){
                this.cache.removeAll(appid, list);
            }
            logger.debug("{}: Cache delete page: {}->{}", new Object[]{this.getClass().getSimpleName(), appid, list});
        }
    }

    private void detectNestedInvocations(Method daoMethod) {
        if (!Para.getConfig().inProduction() && !daoMethod.getName().startsWith("read")) {
            StackTraceElement[] stackTraceElements;
            for (StackTraceElement stackTraceElement : stackTraceElements = Thread.currentThread().getStackTrace()) {
                if (!daoMethod.getDeclaringClass().getName().equals(stackTraceElement.getClassName()) || daoMethod.getName().equals(stackTraceElement.getMethodName())) continue;
                throw new RuntimeException(Utils.formatMessage((String)"Method {0}.{1}() was invoked from another method in the same class - {2}.{3}(). DAO implementations should avoid this as it causes objects to be indexed and cached twice per request.", (Object[])new Object[]{daoMethod.getDeclaringClass().getSimpleName(), daoMethod.getName(), stackTraceElement.getClassName(), stackTraceElement.getMethodName()}));
            }
        }
    }
}

