/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.server;

import ch.qos.logback.access.jetty.RequestLogImpl;
import com.erudika.para.core.listeners.IOListener;
import com.erudika.para.core.listeners.InitializeListener;
import com.erudika.para.core.listeners.WebhookIOListener;
import com.erudika.para.core.rest.CustomResourceHandler;
import com.erudika.para.core.utils.Para;
import com.erudika.para.server.aop.AOPModule;
import com.erudika.para.server.cache.CacheModule;
import com.erudika.para.server.email.EmailModule;
import com.erudika.para.server.metrics.MetricsUtils;
import com.erudika.para.server.persistence.PersistenceModule;
import com.erudika.para.server.queue.QueueModule;
import com.erudika.para.server.rest.Api1;
import com.erudika.para.server.search.SearchModule;
import com.erudika.para.server.security.SecurityModule;
import com.erudika.para.server.storage.StorageModule;
import com.erudika.para.server.utils.HealthUtils;
import com.erudika.para.server.utils.filters.CORSFilter;
import com.erudika.para.server.utils.filters.ErrorFilter;
import com.erudika.para.server.utils.filters.GZipServletFilter;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.util.Modules;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.Banner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.ApplicationPidFileWriter;
import org.springframework.boot.web.embedded.jetty.JettyServerCustomizer;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.boot.web.servlet.server.ServletWebServerFactory;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.core.Ordered;

@SpringBootApplication
public class ParaServer
extends SpringBootServletInitializer
implements Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(ParaServer.class);
    private static LinkedList<CustomResourceHandler> customResourceHandlers;
    private static Injector injector;
    @Value(value="${server.ssl.enabled:false}")
    private boolean sslEnabled;

    public static Module[] getCoreModules() {
        return new Module[]{new PersistenceModule(), new SearchModule(), new CacheModule(), new QueueModule(), new AOPModule(), new EmailModule(), new StorageModule(), new SecurityModule()};
    }

    public static void initialize(Module ... modules) {
        Stage stage = Para.getConfig().inProduction() ? Stage.PRODUCTION : Stage.DEVELOPMENT;
        List<Module> coreModules = Arrays.asList(modules);
        List<Module> externalModules = ParaServer.getExternalModules();
        if (coreModules.isEmpty() && externalModules.isEmpty()) {
            LOG.warn("No implementing modules found. Aborting...");
            ParaServer.destroy();
            return;
        }
        injector = !externalModules.isEmpty() ? Guice.createInjector((Stage)stage, (Module[])new Module[]{Modules.override(coreModules).with(externalModules)}) : Guice.createInjector((Stage)stage, coreModules);
        Para.addInitListener((InitializeListener)HealthUtils.getInstance());
        Para.addInitListener((InitializeListener)MetricsUtils.getInstance());
        Para.getInitListeners().forEach(initListener -> ParaServer.injectInto(initListener));
        if (Para.getConfig().webhooksEnabled()) {
            Para.addIOListener((IOListener)new WebhookIOListener());
        }
        Para.initialize();
        if (Para.getConfig().queuePollingEnabled() || Para.getConfig().webhooksEnabled()) {
            Para.getQueue().startPolling();
        }
    }

    public static void destroy() {
        Para.getDestroyListeners().forEach(destroyListener -> ParaServer.injectInto(destroyListener));
        Para.destroy();
    }

    public static void injectInto(Object obj) {
        if (obj == null) {
            return;
        }
        if (injector == null) {
            ParaServer.handleNotInitializedError();
        }
        injector.injectMembers(obj);
    }

    public static <T> T getInstance(Class<T> type) {
        if (injector == null) {
            ParaServer.handleNotInitializedError();
        }
        return (T)injector.getInstance(type);
    }

    public static List<CustomResourceHandler> getCustomResourceHandlers() {
        if (customResourceHandlers == null) {
            customResourceHandlers = new LinkedList();
            ServiceLoader<CustomResourceHandler> loader = ServiceLoader.load(CustomResourceHandler.class, Para.getParaClassLoader());
            for (CustomResourceHandler handler : loader) {
                if (handler == null) continue;
                ParaServer.injectInto(handler);
                customResourceHandlers.add(handler);
            }
        }
        return Collections.unmodifiableList(customResourceHandlers);
    }

    private static List<Module> getExternalModules() {
        ServiceLoader<Module> moduleLoader = ServiceLoader.load(Module.class, Para.getParaClassLoader());
        ArrayList<Module> externalModules = new ArrayList<Module>();
        for (Module module : moduleLoader) {
            externalModules.add(module);
        }
        return externalModules;
    }

    private static void handleNotInitializedError() {
        throw new IllegalStateException("Call ParaServer.initialize() first!");
    }

    public int getOrder() {
        return 1;
    }

    @Bean
    public ServletRegistrationBean<?> apiV1RegistrationBean() {
        String path = "/v1/*";
        ServletRegistrationBean reg = new ServletRegistrationBean((Servlet)new ServletContainer((ResourceConfig)new Api1()), new String[]{path});
        LOG.debug("Initializing Para API v1 [{}]...", (Object)path);
        reg.setName(Api1.class.getSimpleName());
        reg.setAsyncSupported(true);
        reg.setEnabled(true);
        reg.setOrder(3);
        return reg;
    }

    @Bean
    public FilterRegistrationBean<?> gzipFilterRegistrationBean() {
        String path = "/v1/*";
        FilterRegistrationBean frb = new FilterRegistrationBean((Filter)new GZipServletFilter(), new ServletRegistrationBean[0]);
        LOG.debug("Initializing GZip filter [{}]...", (Object)path);
        frb.addUrlPatterns(new String[]{path});
        frb.setAsyncSupported(true);
        frb.setEnabled(Para.getConfig().gzipEnabled());
        frb.setMatchAfter(true);
        frb.setOrder(20);
        return frb;
    }

    @Bean
    public FilterRegistrationBean<?> corsFilterRegistrationBean() {
        String path = "/v1/*";
        LOG.debug("Initializing CORS filter [{}]...", (Object)path);
        FilterRegistrationBean frb = new FilterRegistrationBean((Filter)new CORSFilter(), new ServletRegistrationBean[0]);
        frb.addInitParameter("cors.support.credentials", "true");
        frb.addInitParameter("cors.allowed.methods", "GET,POST,PATCH,PUT,DELETE,HEAD,OPTIONS");
        frb.addInitParameter("cors.exposed.headers", "Cache-Control,Content-Length,Content-Type,Date,ETag,Expires");
        frb.addInitParameter("cors.allowed.headers", "Origin,Accept,X-Requested-With,Content-Type,Access-Control-Request-Method,Access-Control-Request-Headers,X-Amz-Credential,X-Amz-Date,Authorization");
        frb.addUrlPatterns(new String[]{path, "/jwt_auth"});
        frb.setAsyncSupported(true);
        frb.setEnabled(Para.getConfig().corsEnabled());
        frb.setMatchAfter(false);
        frb.setOrder(Integer.MIN_VALUE);
        return frb;
    }

    @Bean
    public ServletWebServerFactory jettyConfigBean() {
        JettyServletWebServerFactory jef = new JettyServletWebServerFactory();
        jef.setRegisterDefaultServlet(true);
        jef.addServerCustomizers(new JettyServerCustomizer[]{server -> {
            if (Para.getConfig().accessLogEnabled()) {
                HandlerCollection handlers = new HandlerCollection();
                for (Handler handler : server.getHandlers()) {
                    handlers.addHandler(handler);
                }
                RequestLogHandler reqLogs = new RequestLogHandler();
                reqLogs.setServer(server);
                RequestLogImpl rli = new RequestLogImpl();
                rli.setResource("/logback-access.xml");
                rli.setQuiet(true);
                rli.start();
                reqLogs.setRequestLog((RequestLog)rli);
                handlers.addHandler((Handler)reqLogs);
                server.setHandler((Handler)handlers);
            }
            for (Connector y : server.getConnectors()) {
                for (ConnectionFactory cf : y.getConnectionFactories()) {
                    if (!(cf instanceof HttpConnectionFactory)) continue;
                    HttpConnectionFactory dcf = (HttpConnectionFactory)cf;
                    if (Para.getConfig().inProduction()) {
                        ForwardedRequestCustomizer frc = new ForwardedRequestCustomizer(){

                            public void customize(Connector connector, HttpConfiguration config, Request request) {
                                super.customize(connector, config, request);
                                String cfProto = request.getHeader("CloudFront-Forwarded-Proto");
                                if (StringUtils.isBlank((CharSequence)cfProto)) {
                                    cfProto = request.getHeader("X-Forwarded-Proto");
                                }
                                if (StringUtils.equalsIgnoreCase((CharSequence)cfProto, (CharSequence)config.getSecureScheme())) {
                                    request.setScheme(cfProto);
                                    request.setSecure(true);
                                }
                            }
                        };
                        HttpConfiguration httpConfiguration = dcf.getHttpConfiguration();
                        httpConfiguration.addCustomizer((HttpConfiguration.Customizer)frc);
                    }
                    dcf.getHttpConfiguration().setSendServerVersion(false);
                    dcf.getHttpConfiguration().setIdleTimeout(TimeUnit.MINUTES.toMillis(5L));
                }
            }
        }});
        String contextPath = Para.getConfig().serverContextPath();
        if (StringUtils.length((CharSequence)contextPath) > 1 && contextPath.charAt(0) == '/') {
            jef.setContextPath(contextPath);
        }
        for (String k : jef.getInitParameters().keySet()) {
            System.out.println(">> " + k + "=" + (String)jef.getInitParameters().get(k));
        }
        HashMap<String, String> params = new HashMap<String, String>(jef.getInitParameters());
        params.put("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        jef.setInitParameters(params);
        jef.getSession().getCookie().setName("sess");
        jef.getSession().getCookie().setMaxAge(Duration.ofSeconds(1L));
        jef.getSession().getCookie().setHttpOnly(Boolean.valueOf(true));
        jef.setPort(Para.getConfig().serverPort());
        LOG.info("Instance #{} initialized and listening on http{}://localhost:{}", new Object[]{Para.getConfig().workerId(), this.sslEnabled ? "s" : "", jef.getPort()});
        return jef;
    }

    @PreDestroy
    public void preDestroy() {
        ParaServer.destroy();
    }

    protected SpringApplicationBuilder configure(SpringApplicationBuilder app) {
        return ParaServer.builder(app, true, new Class[0]);
    }

    public static SpringApplicationBuilder builder(SpringApplicationBuilder b, boolean isWar, Class<?> ... sources) {
        b.profiles(new String[]{Para.getConfig().environment()});
        b.sources(new Class[]{ParaServer.class});
        b.sources((Class[])sources);
        b.web(WebApplicationType.SERVLET);
        b.bannerMode(Banner.Mode.OFF);
        if (Para.getConfig().pidFileEnabled()) {
            b.listeners(new ApplicationListener[]{new ApplicationPidFileWriter("para_" + Para.getConfig().serverPort() + ".pid")});
        }
        if (isWar) {
            b.sources(new Class[]{ErrorFilter.class});
        }
        ParaServer.initialize(ParaServer.getCoreModules());
        return b;
    }

    public static void main(String[] args) {
        ParaServer.builder(new SpringApplicationBuilder(new Class[0]), false, new Class[0]).run(args);
    }
}

