/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.core.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import com.erudika.para.core.App;
import com.erudika.para.core.rest.CustomResourceHandler;
import java.io.Closeable;

public final class Metrics {
    public static final String SYSTEM_METRICS_NAME = "_system";

    private Metrics() {
    }

    public static Context time(String appid, Class<?> clazz, String ... names) {
        String className = Metrics.getClassName(clazz);
        Timer systemTimer = Metrics.getTimer(SYSTEM_METRICS_NAME, className, names);
        Timer appTimer = appid == null || appid.isEmpty() ? null : Metrics.getTimer(appid, className, names);
        return new Context(systemTimer, appTimer);
    }

    public static Counter counter(String appid, Class<?> clazz, String ... names) {
        String className = Metrics.getClassName(clazz);
        return Metrics.getCounter(App.isRoot(appid) ? SYSTEM_METRICS_NAME : appid, className, names);
    }

    private static Timer getTimer(String registryName, String className, String ... names) {
        return SharedMetricRegistries.getOrCreate((String)registryName).timer(MetricRegistry.name((String)className, (String[])names));
    }

    private static Counter getCounter(String registryName, String className, String ... names) {
        return SharedMetricRegistries.getOrCreate((String)registryName).counter(MetricRegistry.name((String)className, (String[])names));
    }

    public static String getClassName(Class<?> clazz) {
        if (clazz.getSimpleName().contains("EnhancerByGuice")) {
            clazz = clazz.getSuperclass();
        }
        if (CustomResourceHandler.class.isAssignableFrom(clazz)) {
            return clazz.getCanonicalName();
        }
        return clazz.getSimpleName();
    }

    public static final class Context
    implements Closeable {
        private final Timer.Context systemContext;
        private final Timer.Context appContext;

        private Context(Timer systemTimer, Timer appTimer) {
            this.systemContext = systemTimer.time();
            this.appContext = appTimer == null ? null : appTimer.time();
        }

        @Override
        public void close() {
            this.systemContext.stop();
            if (this.appContext != null) {
                this.appContext.stop();
            }
        }
    }
}

