/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.core;

import com.erudika.para.core.Linker;
import com.erudika.para.core.ParaObject;
import com.erudika.para.core.Votable;
import com.erudika.para.core.annotations.Locked;
import com.erudika.para.core.annotations.Stored;
import com.erudika.para.core.utils.CoreUtils;
import com.erudika.para.core.utils.Pager;
import com.erudika.para.core.utils.Para;
import com.erudika.para.core.utils.ParaObjectUtils;
import com.erudika.para.core.utils.Utils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;

public class Vote
implements ParaObject {
    private static final long serialVersionUID = 1L;
    @Stored
    @Locked
    private String id;
    @Stored
    @Locked
    private Long timestamp;
    @Stored
    @Locked
    private String type;
    @Stored
    @Locked
    private String appid;
    @Stored
    @Locked
    private String parentid;
    @Stored
    @Locked
    private String creatorid;
    @Stored
    private Long updated;
    @Stored
    private String name;
    @Stored
    private Long version;
    @Stored
    private Boolean stored;
    @Stored
    private Boolean indexed;
    @Stored
    private Boolean cached;
    @Stored
    @Locked
    @NotBlank
    private String value;
    @Stored
    @Locked
    @NotNull
    private Integer expiresAfter;
    @Stored
    @Locked
    @NotNull
    private Integer lockedAfter;

    public Vote() {
        this(null, null, null);
    }

    public Vote(String voterid, String voteeid, Votable.VoteValue value) {
        this.creatorid = voterid;
        this.parentid = voteeid;
        this.timestamp = Utils.timestamp();
        this.setName(this.getType());
        this.value = value != null ? value.toString() : null;
        this.expiresAfter = Para.getConfig().voteExpiresAfterSec();
        this.lockedAfter = Para.getConfig().voteLockedAfterSec();
    }

    @Override
    public final String getId() {
        if (this.getCreatorid() != null && this.getParentid() != null && this.id == null) {
            this.id = this.getType().concat(Para.getConfig().separator()).concat(this.getCreatorid()).concat(Para.getConfig().separator()).concat(this.getParentid());
        }
        return this.id;
    }

    public Vote up() {
        this.value = Votable.VoteValue.UP.toString();
        return this;
    }

    public Vote down() {
        this.value = Votable.VoteValue.DOWN.toString();
        return this;
    }

    public boolean isUpvote() {
        return StringUtils.equals((CharSequence)this.value, (CharSequence)Votable.VoteValue.UP.toString());
    }

    public boolean isDownvote() {
        return StringUtils.equals((CharSequence)this.value, (CharSequence)Votable.VoteValue.DOWN.toString());
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Integer getExpiresAfter() {
        if (this.expiresAfter == null) {
            this.expiresAfter = Para.getConfig().voteExpiresAfterSec();
        }
        return this.expiresAfter;
    }

    public void setExpiresAfter(Integer expiresAfter) {
        this.expiresAfter = expiresAfter;
    }

    public Integer getLockedAfter() {
        if (this.lockedAfter == null) {
            this.lockedAfter = Para.getConfig().voteLockedAfterSec();
        }
        return this.lockedAfter;
    }

    public void setLockedAfter(Integer lockedAfter) {
        this.lockedAfter = lockedAfter;
    }

    public boolean isExpired() {
        if (this.getTimestamp() == null || this.getExpiresAfter() == 0) {
            return false;
        }
        long expires = (long)this.getExpiresAfter().intValue() * 1000L;
        long now = Utils.timestamp();
        return this.getTimestamp() + expires <= now;
    }

    public boolean isAmendable() {
        if (this.getTimestamp() == null) {
            return false;
        }
        long now = Utils.timestamp();
        return this.getTimestamp() + (long)this.getLockedAfter().intValue() * 1000L > now;
    }

    @Override
    public final void setId(String id) {
        this.id = id;
    }

    @Override
    public final String getType() {
        return Utils.type(this.getClass());
    }

    @Override
    public final void setType(String type) {
        this.type = type;
    }

    @Override
    public String getAppid() {
        this.appid = this.appid == null ? Para.getConfig().getRootAppIdentifier() : this.appid;
        return this.appid;
    }

    @Override
    public void setAppid(String appid) {
        this.appid = appid;
    }

    @Override
    public String getObjectURI() {
        return CoreUtils.getInstance().getObjectURI(this);
    }

    @Override
    public List<String> getTags() {
        return Collections.emptyList();
    }

    @Override
    public void setTags(List<String> tags) {
    }

    @Override
    public Boolean getStored() {
        if (this.stored == null) {
            this.stored = true;
        }
        return this.stored;
    }

    @Override
    public void setStored(Boolean stored) {
        this.stored = stored;
    }

    @Override
    public Boolean getIndexed() {
        if (this.indexed == null) {
            this.indexed = true;
        }
        return this.indexed;
    }

    @Override
    public void setIndexed(Boolean indexed) {
        this.indexed = indexed;
    }

    @Override
    public Boolean getCached() {
        if (this.cached == null) {
            this.cached = true;
        }
        return this.cached;
    }

    @Override
    public void setCached(Boolean cached) {
        this.cached = cached;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp != null && this.timestamp != 0L ? this.timestamp : null;
    }

    @Override
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String getCreatorid() {
        return this.creatorid;
    }

    @Override
    public void setCreatorid(String creatorid) {
        this.creatorid = creatorid;
    }

    @Override
    public final String getName() {
        return CoreUtils.getInstance().getName(this.name, this.id);
    }

    @Override
    public final void setName(String name) {
        this.name = name == null || !name.isEmpty() ? name : this.name;
    }

    @Override
    public String getPlural() {
        return Utils.singularToPlural(this.getType());
    }

    @Override
    public String getParentid() {
        return this.parentid;
    }

    @Override
    public void setParentid(String parentid) {
        this.parentid = parentid;
    }

    @Override
    public Long getUpdated() {
        return this.updated != null && this.updated != 0L ? this.updated : null;
    }

    @Override
    public void setUpdated(Long updated) {
        this.updated = updated;
    }

    @Override
    public String create() {
        return CoreUtils.getInstance().getDao().create(this.getAppid(), this);
    }

    @Override
    public void update() {
        CoreUtils.getInstance().getDao().update(this.getAppid(), this);
    }

    @Override
    public void delete() {
        CoreUtils.getInstance().getDao().delete(this.getAppid(), this);
    }

    @Override
    public boolean exists() {
        return CoreUtils.getInstance().getDao().read(this.getAppid(), this.getId()) != null;
    }

    @Override
    public boolean voteUp(String userid) {
        return false;
    }

    @Override
    public boolean voteDown(String userid) {
        return false;
    }

    @Override
    public Integer getVotes() {
        return 0;
    }

    @Override
    public void setVotes(Integer votes) {
    }

    @Override
    public Long getVersion() {
        return this.version == null ? 0L : this.version;
    }

    @Override
    public void setVersion(Long version) {
        this.version = version;
    }

    @Override
    public Long countLinks(String type2) {
        return 0L;
    }

    @Override
    public List<Linker> getLinks(String type2, Pager ... pager) {
        return Collections.emptyList();
    }

    @Override
    public <P extends ParaObject> List<P> getLinkedObjects(String type, Pager ... pager) {
        return Collections.emptyList();
    }

    @Override
    public <P extends ParaObject> List<P> findLinkedObjects(String type, String field, String query, Pager ... pager) {
        return Collections.emptyList();
    }

    @Override
    public boolean isLinked(String type2, String id2) {
        return false;
    }

    @Override
    public boolean isLinked(ParaObject toObj) {
        return false;
    }

    @Override
    public String link(String id2) {
        return null;
    }

    @Override
    public void unlink(String type, String id2) {
    }

    @Override
    public void unlinkAll() {
    }

    @Override
    public Long countChildren(String type) {
        return 0L;
    }

    @Override
    public <P extends ParaObject> List<P> getChildren(String type, Pager ... pager) {
        return Collections.emptyList();
    }

    @Override
    public <P extends ParaObject> List<P> getChildren(String type, String field, String term, Pager ... pager) {
        return Collections.emptyList();
    }

    @Override
    public <P extends ParaObject> List<P> findChildren(String type, String query, Pager ... pager) {
        return Collections.emptyList();
    }

    @Override
    public void deleteChildren(String type) {
    }

    public int hashCode() {
        return Objects.hash(this.id, this.value);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vote other = (Vote)obj;
        return Objects.equals(this.id, other.getId()) && Objects.equals(this.value, other.getValue());
    }

    public String toString() {
        return ParaObjectUtils.toJSON(this);
    }
}

