#!/usr/bin/env rhino

// 1.0.0
var JSHINT;
(function(){var require = function (file, cwd) {
    var resolved = require.resolve(file, cwd || '/');
    var mod = require.modules[resolved];
    if (!mod) throw new Error(
        'Failed to resolve module ' + file + ', tried ' + resolved
    );
    var cached = require.cache[resolved];
    var res = cached? cached.exports : mod();
    return res;
};

require.paths = [];
require.modules = {};
require.cache = {};
require.extensions = [".js",".coffee",".json"];

require._core = {
    'assert': true,
    'events': true,
    'fs': true,
    'path': true,
    'vm': true
};

require.resolve = (function () {
    return function (x, cwd) {
        if (!cwd) cwd = '/';
        
        if (require._core[x]) return x;
        var path = require.modules.path();
        cwd = path.resolve('/', cwd);
        var y = cwd || '/';
        
        if (x.match(/^(?:\.\.?\/|\/)/)) {
            var m = loadAsFileSync(path.resolve(y, x))
                || loadAsDirectorySync(path.resolve(y, x));
            if (m) return m;
        }
        
        var n = loadNodeModulesSync(x, y);
        if (n) return n;
        
        throw new Error("Cannot find module '" + x + "'");
        
        function loadAsFileSync (x) {
            x = path.normalize(x);
            if (require.modules[x]) {
                return x;
            }
            
            for (var i = 0; i < require.extensions.length; i++) {
                var ext = require.extensions[i];
                if (require.modules[x + ext]) return x + ext;
            }
        }
        
        function loadAsDirectorySync (x) {
            x = x.replace(/\/+$/, '');
            var pkgfile = path.normalize(x + '/package.json');
            if (require.modules[pkgfile]) {
                var pkg = require.modules[pkgfile]();
                var b = pkg.browserify;
                if (typeof b === 'object' && b.main) {
                    var m = loadAsFileSync(path.resolve(x, b.main));
                    if (m) return m;
                }
                else if (typeof b === 'string') {
                    var m = loadAsFileSync(path.resolve(x, b));
                    if (m) return m;
                }
                else if (pkg.main) {
                    var m = loadAsFileSync(path.resolve(x, pkg.main));
                    if (m) return m;
                }
            }
            
            return loadAsFileSync(x + '/index');
        }
        
        function loadNodeModulesSync (x, start) {
            var dirs = nodeModulesPathsSync(start);
            for (var i = 0; i < dirs.length; i++) {
                var dir = dirs[i];
                var m = loadAsFileSync(dir + '/' + x);
                if (m) return m;
                var n = loadAsDirectorySync(dir + '/' + x);
                if (n) return n;
            }
            
            var m = loadAsFileSync(x);
            if (m) return m;
        }
        
        function nodeModulesPathsSync (start) {
            var parts;
            if (start === '/') parts = [ '' ];
            else parts = path.normalize(start).split('/');
            
            var dirs = [];
            for (var i = parts.length - 1; i >= 0; i--) {
                if (parts[i] === 'node_modules') continue;
                var dir = parts.slice(0, i + 1).join('/') + '/node_modules';
                dirs.push(dir);
            }
            
            return dirs;
        }
    };
})();

require.alias = function (from, to) {
    var path = require.modules.path();
    var res = null;
    try {
        res = require.resolve(from + '/package.json', '/');
    }
    catch (err) {
        res = require.resolve(from, '/');
    }
    var basedir = path.dirname(res);
    
    var keys = (Object.keys || function (obj) {
        var res = [];
        for (var key in obj) res.push(key);
        return res;
    })(require.modules);
    
    for (var i = 0; i < keys.length; i++) {
        var key = keys[i];
        if (key.slice(0, basedir.length + 1) === basedir + '/') {
            var f = key.slice(basedir.length);
            require.modules[to + f] = require.modules[basedir + f];
        }
        else if (key === basedir) {
            require.modules[to] = require.modules[basedir];
        }
    }
};

(function () {
    var process = {};
    var global = typeof window !== 'undefined' ? window : {};
    var definedProcess = false;
    
    require.define = function (filename, fn) {
        if (!definedProcess && require.modules.__browserify_process) {
            process = require.modules.__browserify_process();
            definedProcess = true;
        }
        
        var dirname = require._core[filename]
            ? ''
            : require.modules.path().dirname(filename)
        ;
        
        var require_ = function (file) {
            var requiredModule = require(file, dirname);
            var cached = require.cache[require.resolve(file, dirname)];

            if (cached && cached.parent === null) {
                cached.parent = module_;
            }

            return requiredModule;
        };
        require_.resolve = function (name) {
            return require.resolve(name, dirname);
        };
        require_.modules = require.modules;
        require_.define = require.define;
        require_.cache = require.cache;
        var module_ = {
            id : filename,
            filename: filename,
            exports : {},
            loaded : false,
            parent: null
        };
        
        require.modules[filename] = function () {
            require.cache[filename] = module_;
            fn.call(
                module_.exports,
                require_,
                module_,
                module_.exports,
                dirname,
                filename,
                process,
                global
            );
            module_.loaded = true;
            return module_.exports;
        };
    };
})();


require.define("path",Function(['require','module','exports','__dirname','__filename','process','global'],"function filter (xs, fn) {\n    var res = [];\n    for (var i = 0; i < xs.length; i++) {\n        if (fn(xs[i], i, xs)) res.push(xs[i]);\n    }\n    return res;\n}\n\n// resolves . and .. elements in a path array with directory names there\n// must be no slashes, empty elements, or device names (c:\\) in the array\n// (so also no leading and trailing slashes - it does not distinguish\n// relative and absolute paths)\nfunction normalizeArray(parts, allowAboveRoot) {\n  // if the path tries to go above the root, `up` ends up > 0\n  var up = 0;\n  for (var i = parts.length; i >= 0; i--) {\n    var last = parts[i];\n    if (last == '.') {\n      parts.splice(i, 1);\n    } else if (last === '..') {\n      parts.splice(i, 1);\n      up++;\n    } else if (up) {\n      parts.splice(i, 1);\n      up--;\n    }\n  }\n\n  // if the path is allowed to go above the root, restore leading ..s\n  if (allowAboveRoot) {\n    for (; up--; up) {\n      parts.unshift('..');\n    }\n  }\n\n  return parts;\n}\n\n// Regex to split a filename into [*, dir, basename, ext]\n// posix version\nvar splitPathRe = /^(.+\\/(?!$)|\\/)?((?:.+?)?(\\.[^.]*)?)$/;\n\n// path.resolve([from ...], to)\n// posix version\nexports.resolve = function() {\nvar resolvedPath = '',\n    resolvedAbsolute = false;\n\nfor (var i = arguments.length; i >= -1 && !resolvedAbsolute; i--) {\n  var path = (i >= 0)\n      ? arguments[i]\n      : process.cwd();\n\n  // Skip empty and invalid entries\n  if (typeof path !== 'string' || !path) {\n    continue;\n  }\n\n  resolvedPath = path + '/' + resolvedPath;\n  resolvedAbsolute = path.charAt(0) === '/';\n}\n\n// At this point the path should be resolved to a full absolute path, but\n// handle relative paths to be safe (might happen when process.cwd() fails)\n\n// Normalize the path\nresolvedPath = normalizeArray(filter(resolvedPath.split('/'), function(p) {\n    return !!p;\n  }), !resolvedAbsolute).join('/');\n\n  return ((resolvedAbsolute ? '/' : '') + resolvedPath) || '.';\n};\n\n// path.normalize(path)\n// posix version\nexports.normalize = function(path) {\nvar isAbsolute = path.charAt(0) === '/',\n    trailingSlash = path.slice(-1) === '/';\n\n// Normalize the path\npath = normalizeArray(filter(path.split('/'), function(p) {\n    return !!p;\n  }), !isAbsolute).join('/');\n\n  if (!path && !isAbsolute) {\n    path = '.';\n  }\n  if (path && trailingSlash) {\n    path += '/';\n  }\n  \n  return (isAbsolute ? '/' : '') + path;\n};\n\n\n// posix version\nexports.join = function() {\n  var paths = Array.prototype.slice.call(arguments, 0);\n  return exports.normalize(filter(paths, function(p, index) {\n    return p && typeof p === 'string';\n  }).join('/'));\n};\n\n\nexports.dirname = function(path) {\n  var dir = splitPathRe.exec(path)[1] || '';\n  var isWindows = false;\n  if (!dir) {\n    // No dirname\n    return '.';\n  } else if (dir.length === 1 ||\n      (isWindows && dir.length <= 3 && dir.charAt(1) === ':')) {\n    // It is just a slash or a drive letter with a slash\n    return dir;\n  } else {\n    // It is a full dirname, strip trailing slash\n    return dir.substring(0, dir.length - 1);\n  }\n};\n\n\nexports.basename = function(path, ext) {\n  var f = splitPathRe.exec(path)[2] || '';\n  // TODO: make this comparison case-insensitive on windows?\n  if (ext && f.substr(-1 * ext.length) === ext) {\n    f = f.substr(0, f.length - ext.length);\n  }\n  return f;\n};\n\n\nexports.extname = function(path) {\n  return splitPathRe.exec(path)[3] || '';\n};\n\nexports.relative = function(from, to) {\n  from = exports.resolve(from).substr(1);\n  to = exports.resolve(to).substr(1);\n\n  function trim(arr) {\n    var start = 0;\n    for (; start < arr.length; start++) {\n      if (arr[start] !== '') break;\n    }\n\n    var end = arr.length - 1;\n    for (; end >= 0; end--) {\n      if (arr[end] !== '') break;\n    }\n\n    if (start > end) return [];\n    return arr.slice(start, end - start + 1);\n  }\n\n  var fromParts = trim(from.split('/'));\n  var toParts = trim(to.split('/'));\n\n  var length = Math.min(fromParts.length, toParts.length);\n  var samePartsLength = length;\n  for (var i = 0; i < length; i++) {\n    if (fromParts[i] !== toParts[i]) {\n      samePartsLength = i;\n      break;\n    }\n  }\n\n  var outputParts = [];\n  for (var i = samePartsLength; i < fromParts.length; i++) {\n    outputParts.push('..');\n  }\n\n  outputParts = outputParts.concat(toParts.slice(samePartsLength));\n\n  return outputParts.join('/');\n};\n\n//@ sourceURL=path"
));

require.define("__browserify_process",Function(['require','module','exports','__dirname','__filename','process','global'],"var process = module.exports = {};\n\nprocess.nextTick = (function () {\n    var canSetImmediate = typeof window !== 'undefined'\n        && window.setImmediate;\n    var canPost = typeof window !== 'undefined'\n        && window.postMessage && window.addEventListener\n    ;\n\n    if (canSetImmediate) {\n        return function (f) { return window.setImmediate(f) };\n    }\n\n    if (canPost) {\n        var queue = [];\n        window.addEventListener('message', function (ev) {\n            if (ev.source === window && ev.data === 'browserify-tick') {\n                ev.stopPropagation();\n                if (queue.length > 0) {\n                    var fn = queue.shift();\n                    fn();\n                }\n            }\n        }, true);\n\n        return function nextTick(fn) {\n            queue.push(fn);\n            window.postMessage('browserify-tick', '*');\n        };\n    }\n\n    return function nextTick(fn) {\n        setTimeout(fn, 0);\n    };\n})();\n\nprocess.title = 'browser';\nprocess.browser = true;\nprocess.env = {};\nprocess.argv = [];\n\nprocess.binding = function (name) {\n    if (name === 'evals') return (require)('vm')\n    else throw new Error('No such module. (Possibly not yet loaded)')\n};\n\n(function () {\n    var cwd = '/';\n    var path;\n    process.cwd = function () { return cwd };\n    process.chdir = function (dir) {\n        if (!path) path = require('path');\n        cwd = path.resolve(dir, cwd);\n    };\n})();\n\n//@ sourceURL=__browserify_process"
));

require.define("/node_modules/underscore/package.json",Function(['require','module','exports','__dirname','__filename','process','global'],"module.exports = {\"main\":\"underscore.js\"}\n//@ sourceURL=/node_modules/underscore/package.json"
));

require.define("/node_modules/underscore/underscore.js",Function(['require','module','exports','__dirname','__filename','process','global'],"//     Underscore.js 1.4.4\n//     http://underscorejs.org\n//     (c) 2009-2013 Jeremy Ashkenas, DocumentCloud Inc.\n//     Underscore may be freely distributed under the MIT license.\n\n(function() {\n\n  // Baseline setup\n  // --------------\n\n  // Establish the root object, `window` in the browser, or `global` on the server.\n  var root = this;\n\n  // Save the previous value of the `_` variable.\n  var previousUnderscore = root._;\n\n  // Establish the object that gets returned to break out of a loop iteration.\n  var breaker = {};\n\n  // Save bytes in the minified (but not gzipped) version:\n  var ArrayProto = Array.prototype, ObjProto = Object.prototype, FuncProto = Function.prototype;\n\n  // Create quick reference variables for speed access to core prototypes.\n  var push             = ArrayProto.push,\n      slice            = ArrayProto.slice,\n      concat           = ArrayProto.concat,\n      toString         = ObjProto.toString,\n      hasOwnProperty   = ObjProto.hasOwnProperty;\n\n  // All **ECMAScript 5** native function implementations that we hope to use\n  // are declared here.\n  var\n    nativeForEach      = ArrayProto.forEach,\n    nativeMap          = ArrayProto.map,\n    nativeReduce       = ArrayProto.reduce,\n    nativeReduceRight  = ArrayProto.reduceRight,\n    nativeFilter       = ArrayProto.filter,\n    nativeEvery        = ArrayProto.every,\n    nativeSome         = ArrayProto.some,\n    nativeIndexOf      = ArrayProto.indexOf,\n    nativeLastIndexOf  = ArrayProto.lastIndexOf,\n    nativeIsArray      = Array.isArray,\n    nativeKeys         = Object.keys,\n    nativeBind         = FuncProto.bind;\n\n  // Create a safe reference to the Underscore object for use below.\n  var _ = function(obj) {\n    if (obj instanceof _) return obj;\n    if (!(this instanceof _)) return new _(obj);\n    this._wrapped = obj;\n  };\n\n  // Export the Underscore object for **Node.js**, with\n  // backwards-compatibility for the old `require()` API. If we're in\n  // the browser, add `_` as a global object via a string identifier,\n  // for Closure Compiler \"advanced\" mode.\n  if (typeof exports !== 'undefined') {\n    if (typeof module !== 'undefined' && module.exports) {\n      exports = module.exports = _;\n    }\n    exports._ = _;\n  } else {\n    root._ = _;\n  }\n\n  // Current version.\n  _.VERSION = '1.4.4';\n\n  // Collection Functions\n  // --------------------\n\n  // The cornerstone, an `each` implementation, aka `forEach`.\n  // Handles objects with the built-in `forEach`, arrays, and raw objects.\n  // Delegates to **ECMAScript 5**'s native `forEach` if available.\n  var each = _.each = _.forEach = function(obj, iterator, context) {\n    if (obj == null) return;\n    if (nativeForEach && obj.forEach === nativeForEach) {\n      obj.forEach(iterator, context);\n    } else if (obj.length === +obj.length) {\n      for (var i = 0, l = obj.length; i < l; i++) {\n        if (iterator.call(context, obj[i], i, obj) === breaker) return;\n      }\n    } else {\n      for (var key in obj) {\n        if (_.has(obj, key)) {\n          if (iterator.call(context, obj[key], key, obj) === breaker) return;\n        }\n      }\n    }\n  };\n\n  // Return the results of applying the iterator to each element.\n  // Delegates to **ECMAScript 5**'s native `map` if available.\n  _.map = _.collect = function(obj, iterator, context) {\n    var results = [];\n    if (obj == null) return results;\n    if (nativeMap && obj.map === nativeMap) return obj.map(iterator, context);\n    each(obj, function(value, index, list) {\n      results[results.length] = iterator.call(context, value, index, list);\n    });\n    return results;\n  };\n\n  var reduceError = 'Reduce of empty array with no initial value';\n\n  // **Reduce** builds up a single result from a list of values, aka `inject`,\n  // or `foldl`. Delegates to **ECMAScript 5**'s native `reduce` if available.\n  _.reduce = _.foldl = _.inject = function(obj, iterator, memo, context) {\n    var initial = arguments.length > 2;\n    if (obj == null) obj = [];\n    if (nativeReduce && obj.reduce === nativeReduce) {\n      if (context) iterator = _.bind(iterator, context);\n      return initial ? obj.reduce(iterator, memo) : obj.reduce(iterator);\n    }\n    each(obj, function(value, index, list) {\n      if (!initial) {\n        memo = value;\n        initial = true;\n      } else {\n        memo = iterator.call(context, memo, value, index, list);\n      }\n    });\n    if (!initial) throw new TypeError(reduceError);\n    return memo;\n  };\n\n  // The right-associative version of reduce, also known as `foldr`.\n  // Delegates to **ECMAScript 5**'s native `reduceRight` if available.\n  _.reduceRight = _.foldr = function(obj, iterator, memo, context) {\n    var initial = arguments.length > 2;\n    if (obj == null) obj = [];\n    if (nativeReduceRight && obj.reduceRight === nativeReduceRight) {\n      if (context) iterator = _.bind(iterator, context);\n      return initial ? obj.reduceRight(iterator, memo) : obj.reduceRight(iterator);\n    }\n    var length = obj.length;\n    if (length !== +length) {\n      var keys = _.keys(obj);\n      length = keys.length;\n    }\n    each(obj, function(value, index, list) {\n      index = keys ? keys[--length] : --length;\n      if (!initial) {\n        memo = obj[index];\n        initial = true;\n      } else {\n        memo = iterator.call(context, memo, obj[index], index, list);\n      }\n    });\n    if (!initial) throw new TypeError(reduceError);\n    return memo;\n  };\n\n  // Return the first value which passes a truth test. Aliased as `detect`.\n  _.find = _.detect = function(obj, iterator, context) {\n    var result;\n    any(obj, function(value, index, list) {\n      if (iterator.call(context, value, index, list)) {\n        result = value;\n        return true;\n      }\n    });\n    return result;\n  };\n\n  // Return all the elements that pass a truth test.\n  // Delegates to **ECMAScript 5**'s native `filter` if available.\n  // Aliased as `select`.\n  _.filter = _.select = function(obj, iterator, context) {\n    var results = [];\n    if (obj == null) return results;\n    if (nativeFilter && obj.filter === nativeFilter) return obj.filter(iterator, context);\n    each(obj, function(value, index, list) {\n      if (iterator.call(context, value, index, list)) results[results.length] = value;\n    });\n    return results;\n  };\n\n  // Return all the elements for which a truth test fails.\n  _.reject = function(obj, iterator, context) {\n    return _.filter(obj, function(value, index, list) {\n      return !iterator.call(context, value, index, list);\n    }, context);\n  };\n\n  // Determine whether all of the elements match a truth test.\n  // Delegates to **ECMAScript 5**'s native `every` if available.\n  // Aliased as `all`.\n  _.every = _.all = function(obj, iterator, context) {\n    iterator || (iterator = _.identity);\n    var result = true;\n    if (obj == null) return result;\n    if (nativeEvery && obj.every === nativeEvery) return obj.every(iterator, context);\n    each(obj, function(value, index, list) {\n      if (!(result = result && iterator.call(context, value, index, list))) return breaker;\n    });\n    return !!result;\n  };\n\n  // Determine if at least one element in the object matches a truth test.\n  // Delegates to **ECMAScript 5**'s native `some` if available.\n  // Aliased as `any`.\n  var any = _.some = _.any = function(obj, iterator, context) {\n    iterator || (iterator = _.identity);\n    var result = false;\n    if (obj == null) return result;\n    if (nativeSome && obj.some === nativeSome) return obj.some(iterator, context);\n    each(obj, function(value, index, list) {\n      if (result || (result = iterator.call(context, value, index, list))) return breaker;\n    });\n    return !!result;\n  };\n\n  // Determine if the array or object contains a given value (using `===`).\n  // Aliased as `include`.\n  _.contains = _.include = function(obj, target) {\n    if (obj == null) return false;\n    if (nativeIndexOf && obj.indexOf === nativeIndexOf) return obj.indexOf(target) != -1;\n    return any(obj, function(value) {\n      return value === target;\n    });\n  };\n\n  // Invoke a method (with arguments) on every item in a collection.\n  _.invoke = function(obj, method) {\n    var args = slice.call(arguments, 2);\n    var isFunc = _.isFunction(method);\n    return _.map(obj, function(value) {\n      return (isFunc ? method : value[method]).apply(value, args);\n    });\n  };\n\n  // Convenience version of a common use case of `map`: fetching a property.\n  _.pluck = function(obj, key) {\n    return _.map(obj, function(value){ return value[key]; });\n  };\n\n  // Convenience version of a common use case of `filter`: selecting only objects\n  // containing specific `key:value` pairs.\n  _.where = function(obj, attrs, first) {\n    if (_.isEmpty(attrs)) return first ? null : [];\n    return _[first ? 'find' : 'filter'](obj, function(value) {\n      for (var key in attrs) {\n        if (attrs[key] !== value[key]) return false;\n      }\n      return true;\n    });\n  };\n\n  // Convenience version of a common use case of `find`: getting the first object\n  // containing specific `key:value` pairs.\n  _.findWhere = function(obj, attrs) {\n    return _.where(obj, attrs, true);\n  };\n\n  // Return the maximum element or (element-based computation).\n  // Can't optimize arrays of integers longer than 65,535 elements.\n  // See: https://bugs.webkit.org/show_bug.cgi?id=80797\n  _.max = function(obj, iterator, context) {\n    if (!iterator && _.isArray(obj) && obj[0] === +obj[0] && obj.length < 65535) {\n      return Math.max.apply(Math, obj);\n    }\n    if (!iterator && _.isEmpty(obj)) return -Infinity;\n    var result = {computed : -Infinity, value: -Infinity};\n    each(obj, function(value, index, list) {\n      var computed = iterator ? iterator.call(context, value, index, list) : value;\n      computed >= result.computed && (result = {value : value, computed : computed});\n    });\n    return result.value;\n  };\n\n  // Return the minimum element (or element-based computation).\n  _.min = function(obj, iterator, context) {\n    if (!iterator && _.isArray(obj) && obj[0] === +obj[0] && obj.length < 65535) {\n      return Math.min.apply(Math, obj);\n    }\n    if (!iterator && _.isEmpty(obj)) return Infinity;\n    var result = {computed : Infinity, value: Infinity};\n    each(obj, function(value, index, list) {\n      var computed = iterator ? iterator.call(context, value, index, list) : value;\n      computed < result.computed && (result = {value : value, computed : computed});\n    });\n    return result.value;\n  };\n\n  // Shuffle an array.\n  _.shuffle = function(obj) {\n    var rand;\n    var index = 0;\n    var shuffled = [];\n    each(obj, function(value) {\n      rand = _.random(index++);\n      shuffled[index - 1] = shuffled[rand];\n      shuffled[rand] = value;\n    });\n    return shuffled;\n  };\n\n  // An internal function to generate lookup iterators.\n  var lookupIterator = function(value) {\n    return _.isFunction(value) ? value : function(obj){ return obj[value]; };\n  };\n\n  // Sort the object's values by a criterion produced by an iterator.\n  _.sortBy = function(obj, value, context) {\n    var iterator = lookupIterator(value);\n    return _.pluck(_.map(obj, function(value, index, list) {\n      return {\n        value : value,\n        index : index,\n        criteria : iterator.call(context, value, index, list)\n      };\n    }).sort(function(left, right) {\n      var a = left.criteria;\n      var b = right.criteria;\n      if (a !== b) {\n        if (a > b || a === void 0) return 1;\n        if (a < b || b === void 0) return -1;\n      }\n      return left.index < right.index ? -1 : 1;\n    }), 'value');\n  };\n\n  // An internal function used for aggregate \"group by\" operations.\n  var group = function(obj, value, context, behavior) {\n    var result = {};\n    var iterator = lookupIterator(value || _.identity);\n    each(obj, function(value, index) {\n      var key = iterator.call(context, value, index, obj);\n      behavior(result, key, value);\n    });\n    return result;\n  };\n\n  // Groups the object's values by a criterion. Pass either a string attribute\n  // to group by, or a function that returns the criterion.\n  _.groupBy = function(obj, value, context) {\n    return group(obj, value, context, function(result, key, value) {\n      (_.has(result, key) ? result[key] : (result[key] = [])).push(value);\n    });\n  };\n\n  // Counts instances of an object that group by a certain criterion. Pass\n  // either a string attribute to count by, or a function that returns the\n  // criterion.\n  _.countBy = function(obj, value, context) {\n    return group(obj, value, context, function(result, key) {\n      if (!_.has(result, key)) result[key] = 0;\n      result[key]++;\n    });\n  };\n\n  // Use a comparator function to figure out the smallest index at which\n  // an object should be inserted so as to maintain order. Uses binary search.\n  _.sortedIndex = function(array, obj, iterator, context) {\n    iterator = iterator == null ? _.identity : lookupIterator(iterator);\n    var value = iterator.call(context, obj);\n    var low = 0, high = array.length;\n    while (low < high) {\n      var mid = (low + high) >>> 1;\n      iterator.call(context, array[mid]) < value ? low = mid + 1 : high = mid;\n    }\n    return low;\n  };\n\n  // Safely convert anything iterable into a real, live array.\n  _.toArray = function(obj) {\n    if (!obj) return [];\n    if (_.isArray(obj)) return slice.call(obj);\n    if (obj.length === +obj.length) return _.map(obj, _.identity);\n    return _.values(obj);\n  };\n\n  // Return the number of elements in an object.\n  _.size = function(obj) {\n    if (obj == null) return 0;\n    return (obj.length === +obj.length) ? obj.length : _.keys(obj).length;\n  };\n\n  // Array Functions\n  // ---------------\n\n  // Get the first element of an array. Passing **n** will return the first N\n  // values in the array. Aliased as `head` and `take`. The **guard** check\n  // allows it to work with `_.map`.\n  _.first = _.head = _.take = function(array, n, guard) {\n    if (array == null) return void 0;\n    return (n != null) && !guard ? slice.call(array, 0, n) : array[0];\n  };\n\n  // Returns everything but the last entry of the array. Especially useful on\n  // the arguments object. Passing **n** will return all the values in\n  // the array, excluding the last N. The **guard** check allows it to work with\n  // `_.map`.\n  _.initial = function(array, n, guard) {\n    return slice.call(array, 0, array.length - ((n == null) || guard ? 1 : n));\n  };\n\n  // Get the last element of an array. Passing **n** will return the last N\n  // values in the array. The **guard** check allows it to work with `_.map`.\n  _.last = function(array, n, guard) {\n    if (array == null) return void 0;\n    if ((n != null) && !guard) {\n      return slice.call(array, Math.max(array.length - n, 0));\n    } else {\n      return array[array.length - 1];\n    }\n  };\n\n  // Returns everything but the first entry of the array. Aliased as `tail` and `drop`.\n  // Especially useful on the arguments object. Passing an **n** will return\n  // the rest N values in the array. The **guard**\n  // check allows it to work with `_.map`.\n  _.rest = _.tail = _.drop = function(array, n, guard) {\n    return slice.call(array, (n == null) || guard ? 1 : n);\n  };\n\n  // Trim out all falsy values from an array.\n  _.compact = function(array) {\n    return _.filter(array, _.identity);\n  };\n\n  // Internal implementation of a recursive `flatten` function.\n  var flatten = function(input, shallow, output) {\n    each(input, function(value) {\n      if (_.isArray(value)) {\n        shallow ? push.apply(output, value) : flatten(value, shallow, output);\n      } else {\n        output.push(value);\n      }\n    });\n    return output;\n  };\n\n  // Return a completely flattened version of an array.\n  _.flatten = function(array, shallow) {\n    return flatten(array, shallow, []);\n  };\n\n  // Return a version of the array that does not contain the specified value(s).\n  _.without = function(array) {\n    return _.difference(array, slice.call(arguments, 1));\n  };\n\n  // Produce a duplicate-free version of the array. If the array has already\n  // been sorted, you have the option of using a faster algorithm.\n  // Aliased as `unique`.\n  _.uniq = _.unique = function(array, isSorted, iterator, context) {\n    if (_.isFunction(isSorted)) {\n      context = iterator;\n      iterator = isSorted;\n      isSorted = false;\n    }\n    var initial = iterator ? _.map(array, iterator, context) : array;\n    var results = [];\n    var seen = [];\n    each(initial, function(value, index) {\n      if (isSorted ? (!index || seen[seen.length - 1] !== value) : !_.contains(seen, value)) {\n        seen.push(value);\n        results.push(array[index]);\n      }\n    });\n    return results;\n  };\n\n  // Produce an array that contains the union: each distinct element from all of\n  // the passed-in arrays.\n  _.union = function() {\n    return _.uniq(concat.apply(ArrayProto, arguments));\n  };\n\n  // Produce an array that contains every item shared between all the\n  // passed-in arrays.\n  _.intersection = function(array) {\n    var rest = slice.call(arguments, 1);\n    return _.filter(_.uniq(array), function(item) {\n      return _.every(rest, function(other) {\n        return _.indexOf(other, item) >= 0;\n      });\n    });\n  };\n\n  // Take the difference between one array and a number of other arrays.\n  // Only the elements present in just the first array will remain.\n  _.difference = function(array) {\n    var rest = concat.apply(ArrayProto, slice.call(arguments, 1));\n    return _.filter(array, function(value){ return !_.contains(rest, value); });\n  };\n\n  // Zip together multiple lists into a single array -- elements that share\n  // an index go together.\n  _.zip = function() {\n    var args = slice.call(arguments);\n    var length = _.max(_.pluck(args, 'length'));\n    var results = new Array(length);\n    for (var i = 0; i < length; i++) {\n      results[i] = _.pluck(args, \"\" + i);\n    }\n    return results;\n  };\n\n  // Converts lists into objects. Pass either a single array of `[key, value]`\n  // pairs, or two parallel arrays of the same length -- one of keys, and one of\n  // the corresponding values.\n  _.object = function(list, values) {\n    if (list == null) return {};\n    var result = {};\n    for (var i = 0, l = list.length; i < l; i++) {\n      if (values) {\n        result[list[i]] = values[i];\n      } else {\n        result[list[i][0]] = list[i][1];\n      }\n    }\n    return result;\n  };\n\n  // If the browser doesn't supply us with indexOf (I'm looking at you, **MSIE**),\n  // we need this function. Return the position of the first occurrence of an\n  // item in an array, or -1 if the item is not included in the array.\n  // Delegates to **ECMAScript 5**'s native `indexOf` if available.\n  // If the array is large and already in sort order, pass `true`\n  // for **isSorted** to use binary search.\n  _.indexOf = function(array, item, isSorted) {\n    if (array == null) return -1;\n    var i = 0, l = array.length;\n    if (isSorted) {\n      if (typeof isSorted == 'number') {\n        i = (isSorted < 0 ? Math.max(0, l + isSorted) : isSorted);\n      } else {\n        i = _.sortedIndex(array, item);\n        return array[i] === item ? i : -1;\n      }\n    }\n    if (nativeIndexOf && array.indexOf === nativeIndexOf) return array.indexOf(item, isSorted);\n    for (; i < l; i++) if (array[i] === item) return i;\n    return -1;\n  };\n\n  // Delegates to **ECMAScript 5**'s native `lastIndexOf` if available.\n  _.lastIndexOf = function(array, item, from) {\n    if (array == null) return -1;\n    var hasIndex = from != null;\n    if (nativeLastIndexOf && array.lastIndexOf === nativeLastIndexOf) {\n      return hasIndex ? array.lastIndexOf(item, from) : array.lastIndexOf(item);\n    }\n    var i = (hasIndex ? from : array.length);\n    while (i--) if (array[i] === item) return i;\n    return -1;\n  };\n\n  // Generate an integer Array containing an arithmetic progression. A port of\n  // the native Python `range()` function. See\n  // [the Python documentation](http://docs.python.org/library/functions.html#range).\n  _.range = function(start, stop, step) {\n    if (arguments.length <= 1) {\n      stop = start || 0;\n      start = 0;\n    }\n    step = arguments[2] || 1;\n\n    var len = Math.max(Math.ceil((stop - start) / step), 0);\n    var idx = 0;\n    var range = new Array(len);\n\n    while(idx < len) {\n      range[idx++] = start;\n      start += step;\n    }\n\n    return range;\n  };\n\n  // Function (ahem) Functions\n  // ------------------\n\n  // Create a function bound to a given object (assigning `this`, and arguments,\n  // optionally). Delegates to **ECMAScript 5**'s native `Function.bind` if\n  // available.\n  _.bind = function(func, context) {\n    if (func.bind === nativeBind && nativeBind) return nativeBind.apply(func, slice.call(arguments, 1));\n    var args = slice.call(arguments, 2);\n    return function() {\n      return func.apply(context, args.concat(slice.call(arguments)));\n    };\n  };\n\n  // Partially apply a function by creating a version that has had some of its\n  // arguments pre-filled, without changing its dynamic `this` context.\n  _.partial = function(func) {\n    var args = slice.call(arguments, 1);\n    return function() {\n      return func.apply(this, args.concat(slice.call(arguments)));\n    };\n  };\n\n  // Bind all of an object's methods to that object. Useful for ensuring that\n  // all callbacks defined on an object belong to it.\n  _.bindAll = function(obj) {\n    var funcs = slice.call(arguments, 1);\n    if (funcs.length === 0) funcs = _.functions(obj);\n    each(funcs, function(f) { obj[f] = _.bind(obj[f], obj); });\n    return obj;\n  };\n\n  // Memoize an expensive function by storing its results.\n  _.memoize = function(func, hasher) {\n    var memo = {};\n    hasher || (hasher = _.identity);\n    return function() {\n      var key = hasher.apply(this, arguments);\n      return _.has(memo, key) ? memo[key] : (memo[key] = func.apply(this, arguments));\n    };\n  };\n\n  // Delays a function for the given number of milliseconds, and then calls\n  // it with the arguments supplied.\n  _.delay = function(func, wait) {\n    var args = slice.call(arguments, 2);\n    return setTimeout(function(){ return func.apply(null, args); }, wait);\n  };\n\n  // Defers a function, scheduling it to run after the current call stack has\n  // cleared.\n  _.defer = function(func) {\n    return _.delay.apply(_, [func, 1].concat(slice.call(arguments, 1)));\n  };\n\n  // Returns a function, that, when invoked, will only be triggered at most once\n  // during a given window of time.\n  _.throttle = function(func, wait) {\n    var context, args, timeout, result;\n    var previous = 0;\n    var later = function() {\n      previous = new Date;\n      timeout = null;\n      result = func.apply(context, args);\n    };\n    return function() {\n      var now = new Date;\n      var remaining = wait - (now - previous);\n      context = this;\n      args = arguments;\n      if (remaining <= 0) {\n        clearTimeout(timeout);\n        timeout = null;\n        previous = now;\n        result = func.apply(context, args);\n      } else if (!timeout) {\n        timeout = setTimeout(later, remaining);\n      }\n      return result;\n    };\n  };\n\n  // Returns a function, that, as long as it continues to be invoked, will not\n  // be triggered. The function will be called after it stops being called for\n  // N milliseconds. If `immediate` is passed, trigger the function on the\n  // leading edge, instead of the trailing.\n  _.debounce = function(func, wait, immediate) {\n    var timeout, result;\n    return function() {\n      var context = this, args = arguments;\n      var later = function() {\n        timeout = null;\n        if (!immediate) result = func.apply(context, args);\n      };\n      var callNow = immediate && !timeout;\n      clearTimeout(timeout);\n      timeout = setTimeout(later, wait);\n      if (callNow) result = func.apply(context, args);\n      return result;\n    };\n  };\n\n  // Returns a function that will be executed at most one time, no matter how\n  // often you call it. Useful for lazy initialization.\n  _.once = function(func) {\n    var ran = false, memo;\n    return function() {\n      if (ran) return memo;\n      ran = true;\n      memo = func.apply(this, arguments);\n      func = null;\n      return memo;\n    };\n  };\n\n  // Returns the first function passed as an argument to the second,\n  // allowing you to adjust arguments, run code before and after, and\n  // conditionally execute the original function.\n  _.wrap = function(func, wrapper) {\n    return function() {\n      var args = [func];\n      push.apply(args, arguments);\n      return wrapper.apply(this, args);\n    };\n  };\n\n  // Returns a function that is the composition of a list of functions, each\n  // consuming the return value of the function that follows.\n  _.compose = function() {\n    var funcs = arguments;\n    return function() {\n      var args = arguments;\n      for (var i = funcs.length - 1; i >= 0; i--) {\n        args = [funcs[i].apply(this, args)];\n      }\n      return args[0];\n    };\n  };\n\n  // Returns a function that will only be executed after being called N times.\n  _.after = function(times, func) {\n    if (times <= 0) return func();\n    return function() {\n      if (--times < 1) {\n        return func.apply(this, arguments);\n      }\n    };\n  };\n\n  // Object Functions\n  // ----------------\n\n  // Retrieve the names of an object's properties.\n  // Delegates to **ECMAScript 5**'s native `Object.keys`\n  _.keys = nativeKeys || function(obj) {\n    if (obj !== Object(obj)) throw new TypeError('Invalid object');\n    var keys = [];\n    for (var key in obj) if (_.has(obj, key)) keys[keys.length] = key;\n    return keys;\n  };\n\n  // Retrieve the values of an object's properties.\n  _.values = function(obj) {\n    var values = [];\n    for (var key in obj) if (_.has(obj, key)) values.push(obj[key]);\n    return values;\n  };\n\n  // Convert an object into a list of `[key, value]` pairs.\n  _.pairs = function(obj) {\n    var pairs = [];\n    for (var key in obj) if (_.has(obj, key)) pairs.push([key, obj[key]]);\n    return pairs;\n  };\n\n  // Invert the keys and values of an object. The values must be serializable.\n  _.invert = function(obj) {\n    var result = {};\n    for (var key in obj) if (_.has(obj, key)) result[obj[key]] = key;\n    return result;\n  };\n\n  // Return a sorted list of the function names available on the object.\n  // Aliased as `methods`\n  _.functions = _.methods = function(obj) {\n    var names = [];\n    for (var key in obj) {\n      if (_.isFunction(obj[key])) names.push(key);\n    }\n    return names.sort();\n  };\n\n  // Extend a given object with all the properties in passed-in object(s).\n  _.extend = function(obj) {\n    each(slice.call(arguments, 1), function(source) {\n      if (source) {\n        for (var prop in source) {\n          obj[prop] = source[prop];\n        }\n      }\n    });\n    return obj;\n  };\n\n  // Return a copy of the object only containing the whitelisted properties.\n  _.pick = function(obj) {\n    var copy = {};\n    var keys = concat.apply(ArrayProto, slice.call(arguments, 1));\n    each(keys, function(key) {\n      if (key in obj) copy[key] = obj[key];\n    });\n    return copy;\n  };\n\n   // Return a copy of the object without the blacklisted properties.\n  _.omit = function(obj) {\n    var copy = {};\n    var keys = concat.apply(ArrayProto, slice.call(arguments, 1));\n    for (var key in obj) {\n      if (!_.contains(keys, key)) copy[key] = obj[key];\n    }\n    return copy;\n  };\n\n  // Fill in a given object with default properties.\n  _.defaults = function(obj) {\n    each(slice.call(arguments, 1), function(source) {\n      if (source) {\n        for (var prop in source) {\n          if (obj[prop] == null) obj[prop] = source[prop];\n        }\n      }\n    });\n    return obj;\n  };\n\n  // Create a (shallow-cloned) duplicate of an object.\n  _.clone = function(obj) {\n    if (!_.isObject(obj)) return obj;\n    return _.isArray(obj) ? obj.slice() : _.extend({}, obj);\n  };\n\n  // Invokes interceptor with the obj, and then returns obj.\n  // The primary purpose of this method is to \"tap into\" a method chain, in\n  // order to perform operations on intermediate results within the chain.\n  _.tap = function(obj, interceptor) {\n    interceptor(obj);\n    return obj;\n  };\n\n  // Internal recursive comparison function for `isEqual`.\n  var eq = function(a, b, aStack, bStack) {\n    // Identical objects are equal. `0 === -0`, but they aren't identical.\n    // See the Harmony `egal` proposal: http://wiki.ecmascript.org/doku.php?id=harmony:egal.\n    if (a === b) return a !== 0 || 1 / a == 1 / b;\n    // A strict comparison is necessary because `null == undefined`.\n    if (a == null || b == null) return a === b;\n    // Unwrap any wrapped objects.\n    if (a instanceof _) a = a._wrapped;\n    if (b instanceof _) b = b._wrapped;\n    // Compare `[[Class]]` names.\n    var className = toString.call(a);\n    if (className != toString.call(b)) return false;\n    switch (className) {\n      // Strings, numbers, dates, and booleans are compared by value.\n      case '[object String]':\n        // Primitives and their corresponding object wrappers are equivalent; thus, `\"5\"` is\n        // equivalent to `new String(\"5\")`.\n        return a == String(b);\n      case '[object Number]':\n        // `NaN`s are equivalent, but non-reflexive. An `egal` comparison is performed for\n        // other numeric values.\n        return a != +a ? b != +b : (a == 0 ? 1 / a == 1 / b : a == +b);\n      case '[object Date]':\n      case '[object Boolean]':\n        // Coerce dates and booleans to numeric primitive values. Dates are compared by their\n        // millisecond representations. Note that invalid dates with millisecond representations\n        // of `NaN` are not equivalent.\n        return +a == +b;\n      // RegExps are compared by their source patterns and flags.\n      case '[object RegExp]':\n        return a.source == b.source &&\n               a.global == b.global &&\n               a.multiline == b.multiline &&\n               a.ignoreCase == b.ignoreCase;\n    }\n    if (typeof a != 'object' || typeof b != 'object') return false;\n    // Assume equality for cyclic structures. The algorithm for detecting cyclic\n    // structures is adapted from ES 5.1 section 15.12.3, abstract operation `JO`.\n    var length = aStack.length;\n    while (length--) {\n      // Linear search. Performance is inversely proportional to the number of\n      // unique nested structures.\n      if (aStack[length] == a) return bStack[length] == b;\n    }\n    // Add the first object to the stack of traversed objects.\n    aStack.push(a);\n    bStack.push(b);\n    var size = 0, result = true;\n    // Recursively compare objects and arrays.\n    if (className == '[object Array]') {\n      // Compare array lengths to determine if a deep comparison is necessary.\n      size = a.length;\n      result = size == b.length;\n      if (result) {\n        // Deep compare the contents, ignoring non-numeric properties.\n        while (size--) {\n          if (!(result = eq(a[size], b[size], aStack, bStack))) break;\n        }\n      }\n    } else {\n      // Objects with different constructors are not equivalent, but `Object`s\n      // from different frames are.\n      var aCtor = a.constructor, bCtor = b.constructor;\n      if (aCtor !== bCtor && !(_.isFunction(aCtor) && (aCtor instanceof aCtor) &&\n                               _.isFunction(bCtor) && (bCtor instanceof bCtor))) {\n        return false;\n      }\n      // Deep compare objects.\n      for (var key in a) {\n        if (_.has(a, key)) {\n          // Count the expected number of properties.\n          size++;\n          // Deep compare each member.\n          if (!(result = _.has(b, key) && eq(a[key], b[key], aStack, bStack))) break;\n        }\n      }\n      // Ensure that both objects contain the same number of properties.\n      if (result) {\n        for (key in b) {\n          if (_.has(b, key) && !(size--)) break;\n        }\n        result = !size;\n      }\n    }\n    // Remove the first object from the stack of traversed objects.\n    aStack.pop();\n    bStack.pop();\n    return result;\n  };\n\n  // Perform a deep comparison to check if two objects are equal.\n  _.isEqual = function(a, b) {\n    return eq(a, b, [], []);\n  };\n\n  // Is a given array, string, or object empty?\n  // An \"empty\" object has no enumerable own-properties.\n  _.isEmpty = function(obj) {\n    if (obj == null) return true;\n    if (_.isArray(obj) || _.isString(obj)) return obj.length === 0;\n    for (var key in obj) if (_.has(obj, key)) return false;\n    return true;\n  };\n\n  // Is a given value a DOM element?\n  _.isElement = function(obj) {\n    return !!(obj && obj.nodeType === 1);\n  };\n\n  // Is a given value an array?\n  // Delegates to ECMA5's native Array.isArray\n  _.isArray = nativeIsArray || function(obj) {\n    return toString.call(obj) == '[object Array]';\n  };\n\n  // Is a given variable an object?\n  _.isObject = function(obj) {\n    return obj === Object(obj);\n  };\n\n  // Add some isType methods: isArguments, isFunction, isString, isNumber, isDate, isRegExp.\n  each(['Arguments', 'Function', 'String', 'Number', 'Date', 'RegExp'], function(name) {\n    _['is' + name] = function(obj) {\n      return toString.call(obj) == '[object ' + name + ']';\n    };\n  });\n\n  // Define a fallback version of the method in browsers (ahem, IE), where\n  // there isn't any inspectable \"Arguments\" type.\n  if (!_.isArguments(arguments)) {\n    _.isArguments = function(obj) {\n      return !!(obj && _.has(obj, 'callee'));\n    };\n  }\n\n  // Optimize `isFunction` if appropriate.\n  if (typeof (/./) !== 'function') {\n    _.isFunction = function(obj) {\n      return typeof obj === 'function';\n    };\n  }\n\n  // Is a given object a finite number?\n  _.isFinite = function(obj) {\n    return isFinite(obj) && !isNaN(parseFloat(obj));\n  };\n\n  // Is the given value `NaN`? (NaN is the only number which does not equal itself).\n  _.isNaN = function(obj) {\n    return _.isNumber(obj) && obj != +obj;\n  };\n\n  // Is a given value a boolean?\n  _.isBoolean = function(obj) {\n    return obj === true || obj === false || toString.call(obj) == '[object Boolean]';\n  };\n\n  // Is a given value equal to null?\n  _.isNull = function(obj) {\n    return obj === null;\n  };\n\n  // Is a given variable undefined?\n  _.isUndefined = function(obj) {\n    return obj === void 0;\n  };\n\n  // Shortcut function for checking if an object has a given property directly\n  // on itself (in other words, not on a prototype).\n  _.has = function(obj, key) {\n    return hasOwnProperty.call(obj, key);\n  };\n\n  // Utility Functions\n  // -----------------\n\n  // Run Underscore.js in *noConflict* mode, returning the `_` variable to its\n  // previous owner. Returns a reference to the Underscore object.\n  _.noConflict = function() {\n    root._ = previousUnderscore;\n    return this;\n  };\n\n  // Keep the identity function around for default iterators.\n  _.identity = function(value) {\n    return value;\n  };\n\n  // Run a function **n** times.\n  _.times = function(n, iterator, context) {\n    var accum = Array(n);\n    for (var i = 0; i < n; i++) accum[i] = iterator.call(context, i);\n    return accum;\n  };\n\n  // Return a random integer between min and max (inclusive).\n  _.random = function(min, max) {\n    if (max == null) {\n      max = min;\n      min = 0;\n    }\n    return min + Math.floor(Math.random() * (max - min + 1));\n  };\n\n  // List of HTML entities for escaping.\n  var entityMap = {\n    escape: {\n      '&': '&amp;',\n      '<': '&lt;',\n      '>': '&gt;',\n      '\"': '&quot;',\n      \"'\": '&#x27;',\n      '/': '&#x2F;'\n    }\n  };\n  entityMap.unescape = _.invert(entityMap.escape);\n\n  // Regexes containing the keys and values listed immediately above.\n  var entityRegexes = {\n    escape:   new RegExp('[' + _.keys(entityMap.escape).join('') + ']', 'g'),\n    unescape: new RegExp('(' + _.keys(entityMap.unescape).join('|') + ')', 'g')\n  };\n\n  // Functions for escaping and unescaping strings to/from HTML interpolation.\n  _.each(['escape', 'unescape'], function(method) {\n    _[method] = function(string) {\n      if (string == null) return '';\n      return ('' + string).replace(entityRegexes[method], function(match) {\n        return entityMap[method][match];\n      });\n    };\n  });\n\n  // If the value of the named property is a function then invoke it;\n  // otherwise, return it.\n  _.result = function(object, property) {\n    if (object == null) return null;\n    var value = object[property];\n    return _.isFunction(value) ? value.call(object) : value;\n  };\n\n  // Add your own custom functions to the Underscore object.\n  _.mixin = function(obj) {\n    each(_.functions(obj), function(name){\n      var func = _[name] = obj[name];\n      _.prototype[name] = function() {\n        var args = [this._wrapped];\n        push.apply(args, arguments);\n        return result.call(this, func.apply(_, args));\n      };\n    });\n  };\n\n  // Generate a unique integer id (unique within the entire client session).\n  // Useful for temporary DOM ids.\n  var idCounter = 0;\n  _.uniqueId = function(prefix) {\n    var id = ++idCounter + '';\n    return prefix ? prefix + id : id;\n  };\n\n  // By default, Underscore uses ERB-style template delimiters, change the\n  // following template settings to use alternative delimiters.\n  _.templateSettings = {\n    evaluate    : /<%([\\s\\S]+?)%>/g,\n    interpolate : /<%=([\\s\\S]+?)%>/g,\n    escape      : /<%-([\\s\\S]+?)%>/g\n  };\n\n  // When customizing `templateSettings`, if you don't want to define an\n  // interpolation, evaluation or escaping regex, we need one that is\n  // guaranteed not to match.\n  var noMatch = /(.)^/;\n\n  // Certain characters need to be escaped so that they can be put into a\n  // string literal.\n  var escapes = {\n    \"'\":      \"'\",\n    '\\\\':     '\\\\',\n    '\\r':     'r',\n    '\\n':     'n',\n    '\\t':     't',\n    '\\u2028': 'u2028',\n    '\\u2029': 'u2029'\n  };\n\n  var escaper = /\\\\|'|\\r|\\n|\\t|\\u2028|\\u2029/g;\n\n  // JavaScript micro-templating, similar to John Resig's implementation.\n  // Underscore templating handles arbitrary delimiters, preserves whitespace,\n  // and correctly escapes quotes within interpolated code.\n  _.template = function(text, data, settings) {\n    var render;\n    settings = _.defaults({}, settings, _.templateSettings);\n\n    // Combine delimiters into one regular expression via alternation.\n    var matcher = new RegExp([\n      (settings.escape || noMatch).source,\n      (settings.interpolate || noMatch).source,\n      (settings.evaluate || noMatch).source\n    ].join('|') + '|$', 'g');\n\n    // Compile the template source, escaping string literals appropriately.\n    var index = 0;\n    var source = \"__p+='\";\n    text.replace(matcher, function(match, escape, interpolate, evaluate, offset) {\n      source += text.slice(index, offset)\n        .replace(escaper, function(match) { return '\\\\' + escapes[match]; });\n\n      if (escape) {\n        source += \"'+\\n((__t=(\" + escape + \"))==null?'':_.escape(__t))+\\n'\";\n      }\n      if (interpolate) {\n        source += \"'+\\n((__t=(\" + interpolate + \"))==null?'':__t)+\\n'\";\n      }\n      if (evaluate) {\n        source += \"';\\n\" + evaluate + \"\\n__p+='\";\n      }\n      index = offset + match.length;\n      return match;\n    });\n    source += \"';\\n\";\n\n    // If a variable is not specified, place data values in local scope.\n    if (!settings.variable) source = 'with(obj||{}){\\n' + source + '}\\n';\n\n    source = \"var __t,__p='',__j=Array.prototype.join,\" +\n      \"print=function(){__p+=__j.call(arguments,'');};\\n\" +\n      source + \"return __p;\\n\";\n\n    try {\n      render = new Function(settings.variable || 'obj', '_', source);\n    } catch (e) {\n      e.source = source;\n      throw e;\n    }\n\n    if (data) return render(data, _);\n    var template = function(data) {\n      return render.call(this, data, _);\n    };\n\n    // Provide the compiled function source as a convenience for precompilation.\n    template.source = 'function(' + (settings.variable || 'obj') + '){\\n' + source + '}';\n\n    return template;\n  };\n\n  // Add a \"chain\" function, which will delegate to the wrapper.\n  _.chain = function(obj) {\n    return _(obj).chain();\n  };\n\n  // OOP\n  // ---------------\n  // If Underscore is called as a function, it returns a wrapped object that\n  // can be used OO-style. This wrapper holds altered versions of all the\n  // underscore functions. Wrapped objects may be chained.\n\n  // Helper function to continue chaining intermediate results.\n  var result = function(obj) {\n    return this._chain ? _(obj).chain() : obj;\n  };\n\n  // Add all of the Underscore functions to the wrapper object.\n  _.mixin(_);\n\n  // Add all mutator Array functions to the wrapper.\n  each(['pop', 'push', 'reverse', 'shift', 'sort', 'splice', 'unshift'], function(name) {\n    var method = ArrayProto[name];\n    _.prototype[name] = function() {\n      var obj = this._wrapped;\n      method.apply(obj, arguments);\n      if ((name == 'shift' || name == 'splice') && obj.length === 0) delete obj[0];\n      return result.call(this, obj);\n    };\n  });\n\n  // Add all accessor Array functions to the wrapper.\n  each(['concat', 'join', 'slice'], function(name) {\n    var method = ArrayProto[name];\n    _.prototype[name] = function() {\n      return result.call(this, method.apply(this._wrapped, arguments));\n    };\n  });\n\n  _.extend(_.prototype, {\n\n    // Start chaining a wrapped Underscore object.\n    chain: function() {\n      this._chain = true;\n      return this;\n    },\n\n    // Extracts the result from a wrapped and chained object.\n    value: function() {\n      return this._wrapped;\n    }\n\n  });\n\n}).call(this);\n\n//@ sourceURL=/node_modules/underscore/underscore.js"
));

require.define("events",Function(['require','module','exports','__dirname','__filename','process','global'],"if (!process.EventEmitter) process.EventEmitter = function () {};\n\nvar EventEmitter = exports.EventEmitter = process.EventEmitter;\nvar isArray = typeof Array.isArray === 'function'\n    ? Array.isArray\n    : function (xs) {\n        return Object.prototype.toString.call(xs) === '[object Array]'\n    }\n;\nfunction indexOf (xs, x) {\n    if (xs.indexOf) return xs.indexOf(x);\n    for (var i = 0; i < xs.length; i++) {\n        if (x === xs[i]) return i;\n    }\n    return -1;\n}\n\n// By default EventEmitters will print a warning if more than\n// 10 listeners are added to it. This is a useful default which\n// helps finding memory leaks.\n//\n// Obviously not all Emitters should be limited to 10. This function allows\n// that to be increased. Set to zero for unlimited.\nvar defaultMaxListeners = 10;\nEventEmitter.prototype.setMaxListeners = function(n) {\n  if (!this._events) this._events = {};\n  this._events.maxListeners = n;\n};\n\n\nEventEmitter.prototype.emit = function(type) {\n  // If there is no 'error' event listener then throw.\n  if (type === 'error') {\n    if (!this._events || !this._events.error ||\n        (isArray(this._events.error) && !this._events.error.length))\n    {\n      if (arguments[1] instanceof Error) {\n        throw arguments[1]; // Unhandled 'error' event\n      } else {\n        throw new Error(\"Uncaught, unspecified 'error' event.\");\n      }\n      return false;\n    }\n  }\n\n  if (!this._events) return false;\n  var handler = this._events[type];\n  if (!handler) return false;\n\n  if (typeof handler == 'function') {\n    switch (arguments.length) {\n      // fast cases\n      case 1:\n        handler.call(this);\n        break;\n      case 2:\n        handler.call(this, arguments[1]);\n        break;\n      case 3:\n        handler.call(this, arguments[1], arguments[2]);\n        break;\n      // slower\n      default:\n        var args = Array.prototype.slice.call(arguments, 1);\n        handler.apply(this, args);\n    }\n    return true;\n\n  } else if (isArray(handler)) {\n    var args = Array.prototype.slice.call(arguments, 1);\n\n    var listeners = handler.slice();\n    for (var i = 0, l = listeners.length; i < l; i++) {\n      listeners[i].apply(this, args);\n    }\n    return true;\n\n  } else {\n    return false;\n  }\n};\n\n// EventEmitter is defined in src/node_events.cc\n// EventEmitter.prototype.emit() is also defined there.\nEventEmitter.prototype.addListener = function(type, listener) {\n  if ('function' !== typeof listener) {\n    throw new Error('addListener only takes instances of Function');\n  }\n\n  if (!this._events) this._events = {};\n\n  // To avoid recursion in the case that type == \"newListeners\"! Before\n  // adding it to the listeners, first emit \"newListeners\".\n  this.emit('newListener', type, listener);\n\n  if (!this._events[type]) {\n    // Optimize the case of one listener. Don't need the extra array object.\n    this._events[type] = listener;\n  } else if (isArray(this._events[type])) {\n\n    // Check for listener leak\n    if (!this._events[type].warned) {\n      var m;\n      if (this._events.maxListeners !== undefined) {\n        m = this._events.maxListeners;\n      } else {\n        m = defaultMaxListeners;\n      }\n\n      if (m && m > 0 && this._events[type].length > m) {\n        this._events[type].warned = true;\n        console.error('(node) warning: possible EventEmitter memory ' +\n                      'leak detected. %d listeners added. ' +\n                      'Use emitter.setMaxListeners() to increase limit.',\n                      this._events[type].length);\n        console.trace();\n      }\n    }\n\n    // If we've already got an array, just append.\n    this._events[type].push(listener);\n  } else {\n    // Adding the second element, need to change to array.\n    this._events[type] = [this._events[type], listener];\n  }\n\n  return this;\n};\n\nEventEmitter.prototype.on = EventEmitter.prototype.addListener;\n\nEventEmitter.prototype.once = function(type, listener) {\n  var self = this;\n  self.on(type, function g() {\n    self.removeListener(type, g);\n    listener.apply(this, arguments);\n  });\n\n  return this;\n};\n\nEventEmitter.prototype.removeListener = function(type, listener) {\n  if ('function' !== typeof listener) {\n    throw new Error('removeListener only takes instances of Function');\n  }\n\n  // does not use listeners(), so no side effect of creating _events[type]\n  if (!this._events || !this._events[type]) return this;\n\n  var list = this._events[type];\n\n  if (isArray(list)) {\n    var i = indexOf(list, listener);\n    if (i < 0) return this;\n    list.splice(i, 1);\n    if (list.length == 0)\n      delete this._events[type];\n  } else if (this._events[type] === listener) {\n    delete this._events[type];\n  }\n\n  return this;\n};\n\nEventEmitter.prototype.removeAllListeners = function(type) {\n  // does not use listeners(), so no side effect of creating _events[type]\n  if (type && this._events && this._events[type]) this._events[type] = null;\n  return this;\n};\n\nEventEmitter.prototype.listeners = function(type) {\n  if (!this._events) this._events = {};\n  if (!this._events[type]) this._events[type] = [];\n  if (!isArray(this._events[type])) {\n    this._events[type] = [this._events[type]];\n  }\n  return this._events[type];\n};\n\n//@ sourceURL=events"
));

require.define("/src/shared/vars.js",Function(['require','module','exports','__dirname','__filename','process','global'],"\"use strict\";\n\n// Identifiers provided by the ECMAScript standard.\n\nexports.reservedVars = {\n\targuments : false,\n\tNaN       : false\n};\n\nexports.ecmaIdentifiers = {\n\tArray              : false,\n\tBoolean            : false,\n\tDate               : false,\n\tdecodeURI          : false,\n\tdecodeURIComponent : false,\n\tencodeURI          : false,\n\tencodeURIComponent : false,\n\tError              : false,\n\t\"eval\"             : false,\n\tEvalError          : false,\n\tFunction           : false,\n\thasOwnProperty     : false,\n\tisFinite           : false,\n\tisNaN              : false,\n\tJSON               : false,\n\tMath               : false,\n\tMap                : false,\n\tNumber             : false,\n\tObject             : false,\n\tparseInt           : false,\n\tparseFloat         : false,\n\tRangeError         : false,\n\tReferenceError     : false,\n\tRegExp             : false,\n\tSet                : false,\n\tString             : false,\n\tSyntaxError        : false,\n\tTypeError          : false,\n\tURIError           : false,\n\tWeakMap            : false\n};\n\n// Global variables commonly provided by a web browser environment.\n\nexports.browser = {\n\tArrayBuffer          : false,\n\tArrayBufferView      : false,\n\tAudio                : false,\n\tBlob                 : false,\n\taddEventListener     : false,\n\tapplicationCache     : false,\n\tatob                 : false,\n\tblur                 : false,\n\tbtoa                 : false,\n\tclearInterval        : false,\n\tclearTimeout         : false,\n\tclose                : false,\n\tclosed               : false,\n\tDataView             : false,\n\tDOMParser            : false,\n\tdefaultStatus        : false,\n\tdocument             : false,\n\tElement              : false,\n\tevent                : false,\n\tFileReader           : false,\n\tFloat32Array         : false,\n\tFloat64Array         : false,\n\tFormData             : false,\n\tfocus                : false,\n\tframes               : false,\n\tgetComputedStyle     : false,\n\tHTMLElement          : false,\n\tHTMLAnchorElement    : false,\n\tHTMLBaseElement      : false,\n\tHTMLBlockquoteElement: false,\n\tHTMLBodyElement      : false,\n\tHTMLBRElement        : false,\n\tHTMLButtonElement    : false,\n\tHTMLCanvasElement    : false,\n\tHTMLDirectoryElement : false,\n\tHTMLDivElement       : false,\n\tHTMLDListElement     : false,\n\tHTMLFieldSetElement  : false,\n\tHTMLFontElement      : false,\n\tHTMLFormElement      : false,\n\tHTMLFrameElement     : false,\n\tHTMLFrameSetElement  : false,\n\tHTMLHeadElement      : false,\n\tHTMLHeadingElement   : false,\n\tHTMLHRElement        : false,\n\tHTMLHtmlElement      : false,\n\tHTMLIFrameElement    : false,\n\tHTMLImageElement     : false,\n\tHTMLInputElement     : false,\n\tHTMLIsIndexElement   : false,\n\tHTMLLabelElement     : false,\n\tHTMLLayerElement     : false,\n\tHTMLLegendElement    : false,\n\tHTMLLIElement        : false,\n\tHTMLLinkElement      : false,\n\tHTMLMapElement       : false,\n\tHTMLMenuElement      : false,\n\tHTMLMetaElement      : false,\n\tHTMLModElement       : false,\n\tHTMLObjectElement    : false,\n\tHTMLOListElement     : false,\n\tHTMLOptGroupElement  : false,\n\tHTMLOptionElement    : false,\n\tHTMLParagraphElement : false,\n\tHTMLParamElement     : false,\n\tHTMLPreElement       : false,\n\tHTMLQuoteElement     : false,\n\tHTMLScriptElement    : false,\n\tHTMLSelectElement    : false,\n\tHTMLStyleElement     : false,\n\tHTMLTableCaptionElement: false,\n\tHTMLTableCellElement : false,\n\tHTMLTableColElement  : false,\n\tHTMLTableElement     : false,\n\tHTMLTableRowElement  : false,\n\tHTMLTableSectionElement: false,\n\tHTMLTextAreaElement  : false,\n\tHTMLTitleElement     : false,\n\tHTMLUListElement     : false,\n\tHTMLVideoElement     : false,\n\thistory              : false,\n\tInt16Array           : false,\n\tInt32Array           : false,\n\tInt8Array            : false,\n\tImage                : false,\n\tlength               : false,\n\tlocalStorage         : false,\n\tlocation             : false,\n\tMessageChannel       : false,\n\tMessageEvent         : false,\n\tMessagePort          : false,\n\tmoveBy               : false,\n\tmoveTo               : false,\n\tMutationObserver     : false,\n\tname                 : false,\n\tNode                 : false,\n\tNodeFilter           : false,\n\tnavigator            : false,\n\tonbeforeunload       : true,\n\tonblur               : true,\n\tonerror              : true,\n\tonfocus              : true,\n\tonload               : true,\n\tonresize             : true,\n\tonunload             : true,\n\topen                 : false,\n\topenDatabase         : false,\n\topener               : false,\n\tOption               : false,\n\tparent               : false,\n\tprint                : false,\n\tremoveEventListener  : false,\n\tresizeBy             : false,\n\tresizeTo             : false,\n\tscreen               : false,\n\tscroll               : false,\n\tscrollBy             : false,\n\tscrollTo             : false,\n\tsessionStorage       : false,\n\tsetInterval          : false,\n\tsetTimeout           : false,\n\tSharedWorker         : false,\n\tstatus               : false,\n\ttop                  : false,\n\tUint16Array          : false,\n\tUint32Array          : false,\n\tUint8Array           : false,\n\tUint8ClampedArray    : false,\n\tWebSocket            : false,\n\twindow               : false,\n\tWorker               : false,\n\tXMLHttpRequest       : false,\n\tXMLSerializer        : false,\n\tXPathEvaluator       : false,\n\tXPathException       : false,\n\tXPathExpression      : false,\n\tXPathNamespace       : false,\n\tXPathNSResolver      : false,\n\tXPathResult          : false\n};\n\nexports.devel = {\n\talert  : false,\n\tconfirm: false,\n\tconsole: false,\n\tDebug  : false,\n\topera  : false,\n\tprompt : false\n};\n\nexports.worker = {\n\timportScripts: true,\n\tpostMessage  : true,\n\tself         : true\n};\n\n// Widely adopted global names that are not part of ECMAScript standard\nexports.nonstandard = {\n\tescape  : false,\n\tunescape: false\n};\n\n// Globals provided by popular JavaScript environments.\n\nexports.couch = {\n\t\"require\" : false,\n\trespond   : false,\n\tgetRow    : false,\n\temit      : false,\n\tsend      : false,\n\tstart     : false,\n\tsum       : false,\n\tlog       : false,\n\texports   : false,\n\tmodule    : false,\n\tprovides  : false\n};\n\nexports.node = {\n\t__filename   : false,\n\t__dirname    : false,\n\tBuffer       : false,\n\tDataView     : false,\n\tconsole      : false,\n\texports      : true,  // In Node it is ok to exports = module.exports = foo();\n\tGLOBAL       : false,\n\tglobal       : false,\n\tmodule       : false,\n\tprocess      : false,\n\trequire      : false,\n\tsetTimeout   : false,\n\tclearTimeout : false,\n\tsetInterval  : false,\n\tclearInterval: false\n};\n\nexports.rhino = {\n\tdefineClass  : false,\n\tdeserialize  : false,\n\tgc           : false,\n\thelp         : false,\n\timportPackage: false,\n\t\"java\"       : false,\n\tload         : false,\n\tloadClass    : false,\n\tprint        : false,\n\tquit         : false,\n\treadFile     : false,\n\treadUrl      : false,\n\trunCommand   : false,\n\tseal         : false,\n\tserialize    : false,\n\tspawn        : false,\n\tsync         : false,\n\ttoint32      : false,\n\tversion      : false\n};\n\nexports.wsh = {\n\tActiveXObject            : true,\n\tEnumerator               : true,\n\tGetObject                : true,\n\tScriptEngine             : true,\n\tScriptEngineBuildVersion : true,\n\tScriptEngineMajorVersion : true,\n\tScriptEngineMinorVersion : true,\n\tVBArray                  : true,\n\tWSH                      : true,\n\tWScript                  : true,\n\tXDomainRequest           : true\n};\n\n// Globals provided by popular JavaScript libraries.\n\nexports.dojo = {\n\tdojo     : false,\n\tdijit    : false,\n\tdojox    : false,\n\tdefine\t : false,\n\t\"require\": false\n};\n\nexports.jquery = {\n\t\"$\"    : false,\n\tjQuery : false\n};\n\nexports.mootools = {\n\t\"$\"           : false,\n\t\"$$\"          : false,\n\tAsset         : false,\n\tBrowser       : false,\n\tChain         : false,\n\tClass         : false,\n\tColor         : false,\n\tCookie        : false,\n\tCore          : false,\n\tDocument      : false,\n\tDomReady      : false,\n\tDOMEvent      : false,\n\tDOMReady      : false,\n\tDrag          : false,\n\tElement       : false,\n\tElements      : false,\n\tEvent         : false,\n\tEvents        : false,\n\tFx            : false,\n\tGroup         : false,\n\tHash          : false,\n\tHtmlTable     : false,\n\tIframe        : false,\n\tIframeShim    : false,\n\tInputValidator: false,\n\tinstanceOf    : false,\n\tKeyboard      : false,\n\tLocale        : false,\n\tMask          : false,\n\tMooTools      : false,\n\tNative        : false,\n\tOptions       : false,\n\tOverText      : false,\n\tRequest       : false,\n\tScroller      : false,\n\tSlick         : false,\n\tSlider        : false,\n\tSortables     : false,\n\tSpinner       : false,\n\tSwiff         : false,\n\tTips          : false,\n\tType          : false,\n\ttypeOf        : false,\n\tURI           : false,\n\tWindow        : false\n};\n\nexports.prototypejs = {\n\t\"$\"               : false,\n\t\"$$\"              : false,\n\t\"$A\"              : false,\n\t\"$F\"              : false,\n\t\"$H\"              : false,\n\t\"$R\"              : false,\n\t\"$break\"          : false,\n\t\"$continue\"       : false,\n\t\"$w\"              : false,\n\tAbstract          : false,\n\tAjax              : false,\n\tClass             : false,\n\tEnumerable        : false,\n\tElement           : false,\n\tEvent             : false,\n\tField             : false,\n\tForm              : false,\n\tHash              : false,\n\tInsertion         : false,\n\tObjectRange       : false,\n\tPeriodicalExecuter: false,\n\tPosition          : false,\n\tPrototype         : false,\n\tSelector          : false,\n\tTemplate          : false,\n\tToggle            : false,\n\tTry               : false,\n\tAutocompleter     : false,\n\tBuilder           : false,\n\tControl           : false,\n\tDraggable         : false,\n\tDraggables        : false,\n\tDroppables        : false,\n\tEffect            : false,\n\tSortable          : false,\n\tSortableObserver  : false,\n\tSound             : false,\n\tScriptaculous     : false\n};\n\nexports.yui = {\n\tYUI       : false,\n\tY         : false,\n\tYUI_config: false\n};\n\n\n//@ sourceURL=/src/shared/vars.js"
));

require.define("/src/shared/messages.js",Function(['require','module','exports','__dirname','__filename','process','global'],"\"use strict\";\n\nvar _ = require(\"underscore\");\n\nvar errors = {\n\t// JSHint options\n\tE001: \"Bad option: '{a}'.\",\n\tE002: \"Bad option value.\",\n\n\t// JSHint input\n\tE003: \"Expected a JSON value.\",\n\tE004: \"Input is neither a string nor an array of strings.\",\n\tE005: \"Input is empty.\",\n\tE006: \"Unexpected early end of program.\",\n\n\t// Strict mode\n\tE007: \"Missing \\\"use strict\\\" statement.\",\n\tE008: \"Strict violation.\",\n\tE009: \"Option 'validthis' can't be used in a global scope.\",\n\tE010: \"'with' is not allowed in strict mode.\",\n\n\t// Constants\n\tE011: \"const '{a}' has already been declared.\",\n\tE012: \"const '{a}' is initialized to 'undefined'.\",\n\tE013: \"Attempting to override '{a}' which is a constant.\",\n\n\t// Regular expressions\n\tE014: \"A regular expression literal can be confused with '/='.\",\n\tE015: \"Unclosed regular expression.\",\n\tE016: \"Invalid regular expression.\",\n\n\t// Tokens\n\tE017: \"Unclosed comment.\",\n\tE018: \"Unbegun comment.\",\n\tE019: \"Unmatched '{a}'.\",\n\tE020: \"Expected '{a}' to match '{b}' from line {c} and instead saw '{d}'.\",\n\tE021: \"Expected '{a}' and instead saw '{b}'.\",\n\tE022: \"Line breaking error '{a}'.\",\n\tE023: \"Missing '{a}'.\",\n\tE024: \"Unexpected '{a}'.\",\n\tE025: \"Missing ':' on a case clause.\",\n\tE026: \"Missing '}' to match '{' from line {a}.\",\n\tE027: \"Missing ']' to match '[' form line {a}.\",\n\tE028: \"Illegal comma.\",\n\tE029: \"Unclosed string.\",\n\n\t// Everything else\n\tE030: \"Expected an identifier and instead saw '{a}'.\",\n\tE031: \"Bad assignment.\", // FIXME: Rephrase\n\tE032: \"Expected a small integer and instead saw '{a}'.\",\n\tE033: \"Expected an operator and instead saw '{a}'.\",\n\tE034: \"get/set are ES5 features.\",\n\tE035: \"Missing property name.\",\n\tE036: \"Expected to see a statement and instead saw a block.\",\n\tE037: \"Constant {a} was not declared correctly.\",\n\tE038: \"Variable {a} was not declared correctly.\",\n\tE039: \"Function declarations are not invocable. Wrap the whole function invocation in parens.\",\n\tE040: \"Each value should have its own case label.\",\n\tE041: \"Unrecoverable syntax error.\",\n\tE042: \"Stopping.\",\n\tE043: \"Too many errors.\"\n};\n\nvar warnings = {\n\tW001: \"'hasOwnProperty' is a really bad name.\",\n\tW002: \"Value of '{a}' may be overwritten in IE.\",\n\tW003: \"'{a}' was used before it was defined.\",\n\tW004: \"'{a}' is already defined.\",\n\tW005: \"A dot following a number can be confused with a decimal point.\",\n\tW006: \"Confusing minuses.\",\n\tW007: \"Confusing pluses.\",\n\tW008: \"A leading decimal point can be confused with a dot: '{a}'.\",\n\tW009: \"The array literal notation [] is preferrable.\",\n\tW010: \"The object literal notation {} is preferrable.\",\n\tW011: \"Unexpected space after '{a}'.\",\n\tW012: \"Unexpected space before '{a}'.\",\n\tW013: \"Missing space after '{a}'.\",\n\tW014: \"Bad line breaking before '{a}'.\",\n\tW015: \"Expected '{a}' to have an indentation at {b} instead at {c}.\",\n\tW016: \"Unexpected use of '{a}'.\",\n\tW017: \"Bad operand.\",\n\tW018: \"Confusing use of '{a}'.\",\n\tW019: \"Use the isNaN function to compare with NaN.\",\n\tW020: \"Read only.\",\n\tW021: \"'{a}' is a function.\",\n\tW022: \"Do not assign to the exception parameter.\",\n\tW023: \"Expected an identifier in an assignment and instead saw a function invocation.\",\n\tW024: \"Expected an identifier and instead saw '{a}' (a reserved word).\",\n\tW025: \"Missing name in function declaration.\",\n\tW026: \"Inner functions should be listed at the top of the outer function.\",\n\tW027: \"Unreachable '{a}' after '{b}'.\",\n\tW028: \"Label '{a}' on {b} statement.\",\n\tW029: \"Label '{a}' looks like a javascript url.\",\n\tW030: \"Expected an assignment or function call and instead saw an expression.\",\n\tW031: \"Do not use 'new' for side effects.\",\n\tW032: \"Unnecessary semicolon.\",\n\tW033: \"Missing semicolon.\",\n\tW034: \"Unnecessary directive \\\"{a}\\\".\",\n\tW035: \"Empty block.\",\n\tW036: \"Unexpected /*member '{a}'.\",\n\tW037: \"'{a}' is a statement label.\",\n\tW038: \"'{a}' used out of scope.\",\n\tW039: \"'{a}' is not allowed.\",\n\tW040: \"Possible strict violation.\",\n\tW041: \"Use '{a}' to compare with '{b}'.\",\n\tW042: \"Avoid EOL escaping.\",\n\tW043: \"Bad escaping of EOL. Use option multistr if needed.\",\n\tW044: \"Bad escaping.\",\n\tW045: \"Bad number '{a}'.\",\n\tW046: \"Don't use extra leading zeros '{a}'.\",\n\tW047: \"A trailing decimal point can be confused with a dot: '{a}'.\",\n\tW048: \"Unexpected control character in regular expression.\",\n\tW049: \"Unexpected escaped character '{a}' in regular expression.\",\n\tW050: \"JavaScript URL.\",\n\tW051: \"Variables should not be deleted.\",\n\tW052: \"Unexpected '{a}'.\",\n\tW053: \"Do not use {a} as a constructor.\",\n\tW054: \"The Function constructor is a form of eval.\",\n\tW055: \"A constructor name should start with an uppercase letter.\",\n\tW056: \"Bad constructor.\",\n\tW057: \"Weird construction. Is 'new' unnecessary?\",\n\tW058: \"Missing '()' invoking a constructor.\",\n\tW059: \"Avoid arguments.{a}.\",\n\tW060: \"document.write can be a form of eval.\",\n\tW061: \"eval can be harmful.\",\n\tW062: \"Wrap an immediate function invocation in parens \" +\n\t\t\"to assist the reader in understanding that the expression \" +\n\t\t\"is the result of a function, and not the function itself.\",\n\tW063: \"Math is not a function.\",\n\tW064: \"Missing 'new' prefix when invoking a constructor.\",\n\tW065: \"Missing radix parameter.\",\n\tW066: \"Implied eval. Consider passing a function instead of a string.\",\n\tW067: \"Bad invocation.\",\n\tW068: \"Wrapping non-IIFE function literals in parens is unnecessary.\",\n\tW069: \"['{a}'] is better written in dot notation.\",\n\tW070: \"Extra comma. (it breaks older versions of IE)\",\n\tW071: \"This function has too many statements. ({a})\",\n\tW072: \"This function has too many parameters. ({a})\",\n\tW073: \"Blocks are nested too deeply. ({a})\",\n\tW074: \"This function's cyclomatic complexity is too high. ({a})\",\n\tW075: \"Duplicate key '{a}'.\",\n\tW076: \"Unexpected parameter '{a}' in get {b} function.\",\n\tW077: \"Expected a single parameter in set {a} function.\",\n\tW078: \"Setter is defined without getter.\",\n\tW079: \"Redefinition of '{a}'.\",\n\tW080: \"It's not necessary to initialize '{a}' to 'undefined'.\",\n\tW081: \"Too many var statements.\",\n\tW082: \"Function declarations should not be placed in blocks. \" +\n\t\t\"Use a function expression or move the statement to the top of \" +\n\t\t\"the outer function.\",\n\tW083: \"Don't make functions within a loop.\",\n\tW084: \"Expected a conditional expression and instead saw an assignment.\",\n\tW085: \"Don't use 'with'.\",\n\tW086: \"Expected a 'break' statement before '{a}'.\",\n\tW087: \"Forgotten 'debugger' statement?\",\n\tW088: \"Creating global 'for' variable. Should be 'for (var {a} ...'.\",\n\tW089: \"The body of a for in should be wrapped in an if statement to filter \" +\n\t\t\"unwanted properties from the prototype.\",\n\tW090: \"'{a}' is not a statement label.\",\n\tW091: \"'{a}' is out of scope.\",\n\tW092: \"Wrap the /regexp/ literal in parens to disambiguate the slash operator.\",\n\tW093: \"Did you mean to return a conditional instead of an assignment?\",\n\tW094: \"Unexpected comma.\",\n\tW095: \"Expected a string and instead saw {a}.\",\n\tW096: \"The '{a}' key may produce unexpected results.\",\n\tW097: \"Use the function form of \\\"use strict\\\".\",\n\tW098: \"'{a}' is defined but never used.\",\n\tW099: \"Mixed spaces and tabs.\",\n\tW100: \"This character may get silently deleted by one or more browsers.\",\n\tW101: \"Line is too long.\",\n\tW102: \"Trailing whitespace.\",\n\tW103: \"The '{a}' property is deprecated.\",\n\tW104: \"'{a}' is only available in JavaScript 1.7.\",\n\tW105: \"Unexpected {a} in '{b}'.\",\n\tW106: \"Identifier '{a}' is not in camel case.\",\n\tW107: \"Script URL.\",\n\tW108: \"Strings must use doublequote.\",\n\tW109: \"Strings must use singlequote.\",\n\tW110: \"Mixed double and single quotes.\",\n\tW112: \"Unclosed string.\",\n\tW113: \"Control character in string: {a}.\",\n\tW114: \"Avoid {a}.\",\n\tW115: \"Octal literals are not allowed in strict mode.\",\n\tW116: \"Expected '{a}' and instead saw '{b}'.\",\n\tW117: \"'{a}' is not defined.\",\n};\n\nvar info = {\n\tI001: \"Comma warnings can be turned off with 'laxcomma'.\"\n};\n\nexports.errors = {};\nexports.warnings = {};\nexports.info = {};\n\n_.each(errors, function (desc, code) {\n\texports.errors[code] = { code: code, desc: desc };\n});\n\n_.each(warnings, function (desc, code) {\n\texports.warnings[code] = { code: code, desc: desc };\n});\n\n_.each(info, function (desc, code) {\n\texports.info[code] = { code: code, desc: desc };\n});\n\n//@ sourceURL=/src/shared/messages.js"
));

require.define("/src/stable/lex.js",Function(['require','module','exports','__dirname','__filename','process','global'],"/*\n * Lexical analysis and token construction.\n */\n\n\"use strict\";\n\nvar _      = require(\"underscore\");\nvar events = require(\"events\");\nvar reg    = require(\"./reg.js\");\nvar state  = require(\"./state.js\").state;\n\n// Some of these token types are from JavaScript Parser API\n// while others are specific to JSHint parser.\n// JS Parser API: https://developer.mozilla.org/en-US/docs/SpiderMonkey/Parser_API\n\nvar Token = {\n\tIdentifier: 1,\n\tPunctuator: 2,\n\tNumericLiteral: 3,\n\tStringLiteral: 4,\n\tComment: 5,\n\tKeyword: 6,\n\tNullLiteral: 7,\n\tBooleanLiteral: 8,\n\tRegExp: 9\n};\n\n// This is auto generated from the unicode tables.\n// The tables are at:\n// http://www.fileformat.info/info/unicode/category/Lu/list.htm\n// http://www.fileformat.info/info/unicode/category/Ll/list.htm\n// http://www.fileformat.info/info/unicode/category/Lt/list.htm\n// http://www.fileformat.info/info/unicode/category/Lm/list.htm\n// http://www.fileformat.info/info/unicode/category/Lo/list.htm\n// http://www.fileformat.info/info/unicode/category/Nl/list.htm\n\nvar unicodeLetterTable = [\n\t170, 170, 181, 181, 186, 186, 192, 214,\n\t216, 246, 248, 705, 710, 721, 736, 740, 748, 748, 750, 750,\n\t880, 884, 886, 887, 890, 893, 902, 902, 904, 906, 908, 908,\n\t910, 929, 931, 1013, 1015, 1153, 1162, 1319, 1329, 1366,\n\t1369, 1369, 1377, 1415, 1488, 1514, 1520, 1522, 1568, 1610,\n\t1646, 1647, 1649, 1747, 1749, 1749, 1765, 1766, 1774, 1775,\n\t1786, 1788, 1791, 1791, 1808, 1808, 1810, 1839, 1869, 1957,\n\t1969, 1969, 1994, 2026, 2036, 2037, 2042, 2042, 2048, 2069,\n\t2074, 2074, 2084, 2084, 2088, 2088, 2112, 2136, 2308, 2361,\n\t2365, 2365, 2384, 2384, 2392, 2401, 2417, 2423, 2425, 2431,\n\t2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482,\n\t2486, 2489, 2493, 2493, 2510, 2510, 2524, 2525, 2527, 2529,\n\t2544, 2545, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608,\n\t2610, 2611, 2613, 2614, 2616, 2617, 2649, 2652, 2654, 2654,\n\t2674, 2676, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736,\n\t2738, 2739, 2741, 2745, 2749, 2749, 2768, 2768, 2784, 2785,\n\t2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867,\n\t2869, 2873, 2877, 2877, 2908, 2909, 2911, 2913, 2929, 2929,\n\t2947, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970,\n\t2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001,\n\t3024, 3024, 3077, 3084, 3086, 3088, 3090, 3112, 3114, 3123,\n\t3125, 3129, 3133, 3133, 3160, 3161, 3168, 3169, 3205, 3212,\n\t3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3261, 3261,\n\t3294, 3294, 3296, 3297, 3313, 3314, 3333, 3340, 3342, 3344,\n\t3346, 3386, 3389, 3389, 3406, 3406, 3424, 3425, 3450, 3455,\n\t3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526,\n\t3585, 3632, 3634, 3635, 3648, 3654, 3713, 3714, 3716, 3716,\n\t3719, 3720, 3722, 3722, 3725, 3725, 3732, 3735, 3737, 3743,\n\t3745, 3747, 3749, 3749, 3751, 3751, 3754, 3755, 3757, 3760,\n\t3762, 3763, 3773, 3773, 3776, 3780, 3782, 3782, 3804, 3805,\n\t3840, 3840, 3904, 3911, 3913, 3948, 3976, 3980, 4096, 4138,\n\t4159, 4159, 4176, 4181, 4186, 4189, 4193, 4193, 4197, 4198,\n\t4206, 4208, 4213, 4225, 4238, 4238, 4256, 4293, 4304, 4346,\n\t4348, 4348, 4352, 4680, 4682, 4685, 4688, 4694, 4696, 4696,\n\t4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789,\n\t4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880,\n\t4882, 4885, 4888, 4954, 4992, 5007, 5024, 5108, 5121, 5740,\n\t5743, 5759, 5761, 5786, 5792, 5866, 5870, 5872, 5888, 5900,\n\t5902, 5905, 5920, 5937, 5952, 5969, 5984, 5996, 5998, 6000,\n\t6016, 6067, 6103, 6103, 6108, 6108, 6176, 6263, 6272, 6312,\n\t6314, 6314, 6320, 6389, 6400, 6428, 6480, 6509, 6512, 6516,\n\t6528, 6571, 6593, 6599, 6656, 6678, 6688, 6740, 6823, 6823,\n\t6917, 6963, 6981, 6987, 7043, 7072, 7086, 7087, 7104, 7141,\n\t7168, 7203, 7245, 7247, 7258, 7293, 7401, 7404, 7406, 7409,\n\t7424, 7615, 7680, 7957, 7960, 7965, 7968, 8005, 8008, 8013,\n\t8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061,\n\t8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140,\n\t8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188,\n\t8305, 8305, 8319, 8319, 8336, 8348, 8450, 8450, 8455, 8455,\n\t8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486,\n\t8488, 8488, 8490, 8493, 8495, 8505, 8508, 8511, 8517, 8521,\n\t8526, 8526, 8544, 8584, 11264, 11310, 11312, 11358,\n\t11360, 11492, 11499, 11502, 11520, 11557, 11568, 11621,\n\t11631, 11631, 11648, 11670, 11680, 11686, 11688, 11694,\n\t11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726,\n\t11728, 11734, 11736, 11742, 11823, 11823, 12293, 12295,\n\t12321, 12329, 12337, 12341, 12344, 12348, 12353, 12438,\n\t12445, 12447, 12449, 12538, 12540, 12543, 12549, 12589,\n\t12593, 12686, 12704, 12730, 12784, 12799, 13312, 13312,\n\t19893, 19893, 19968, 19968, 40907, 40907, 40960, 42124,\n\t42192, 42237, 42240, 42508, 42512, 42527, 42538, 42539,\n\t42560, 42606, 42623, 42647, 42656, 42735, 42775, 42783,\n\t42786, 42888, 42891, 42894, 42896, 42897, 42912, 42921,\n\t43002, 43009, 43011, 43013, 43015, 43018, 43020, 43042,\n\t43072, 43123, 43138, 43187, 43250, 43255, 43259, 43259,\n\t43274, 43301, 43312, 43334, 43360, 43388, 43396, 43442,\n\t43471, 43471, 43520, 43560, 43584, 43586, 43588, 43595,\n\t43616, 43638, 43642, 43642, 43648, 43695, 43697, 43697,\n\t43701, 43702, 43705, 43709, 43712, 43712, 43714, 43714,\n\t43739, 43741, 43777, 43782, 43785, 43790, 43793, 43798,\n\t43808, 43814, 43816, 43822, 43968, 44002, 44032, 44032,\n\t55203, 55203, 55216, 55238, 55243, 55291, 63744, 64045,\n\t64048, 64109, 64112, 64217, 64256, 64262, 64275, 64279,\n\t64285, 64285, 64287, 64296, 64298, 64310, 64312, 64316,\n\t64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433,\n\t64467, 64829, 64848, 64911, 64914, 64967, 65008, 65019,\n\t65136, 65140, 65142, 65276, 65313, 65338, 65345, 65370,\n\t65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495,\n\t65498, 65500, 65536, 65547, 65549, 65574, 65576, 65594,\n\t65596, 65597, 65599, 65613, 65616, 65629, 65664, 65786,\n\t65856, 65908, 66176, 66204, 66208, 66256, 66304, 66334,\n\t66352, 66378, 66432, 66461, 66464, 66499, 66504, 66511,\n\t66513, 66517, 66560, 66717, 67584, 67589, 67592, 67592,\n\t67594, 67637, 67639, 67640, 67644, 67644, 67647, 67669,\n\t67840, 67861, 67872, 67897, 68096, 68096, 68112, 68115,\n\t68117, 68119, 68121, 68147, 68192, 68220, 68352, 68405,\n\t68416, 68437, 68448, 68466, 68608, 68680, 69635, 69687,\n\t69763, 69807, 73728, 74606, 74752, 74850, 77824, 78894,\n\t92160, 92728, 110592, 110593, 119808, 119892, 119894, 119964,\n\t119966, 119967, 119970, 119970, 119973, 119974, 119977, 119980,\n\t119982, 119993, 119995, 119995, 119997, 120003, 120005, 120069,\n\t120071, 120074, 120077, 120084, 120086, 120092, 120094, 120121,\n\t120123, 120126, 120128, 120132, 120134, 120134, 120138, 120144,\n\t120146, 120485, 120488, 120512, 120514, 120538, 120540, 120570,\n\t120572, 120596, 120598, 120628, 120630, 120654, 120656, 120686,\n\t120688, 120712, 120714, 120744, 120746, 120770, 120772, 120779,\n\t131072, 131072, 173782, 173782, 173824, 173824, 177972, 177972,\n\t177984, 177984, 178205, 178205, 194560, 195101\n];\n\nvar identifierStartTable = [];\n\nfor (var i = 0; i < 128; i++) {\n\tidentifierStartTable[i] =\n\t\ti === 36 ||           // $\n\t\ti >= 65 && i <= 90 || // A-Z\n\t\ti === 95 ||           // _\n\t\ti >= 97 && i <= 122;  // a-z\n}\n\nvar identifierPartTable = [];\n\nfor (var i = 0; i < 128; i++) {\n\tidentifierPartTable[i] =\n\t\tidentifierStartTable[i] || // $, _, A-Z, a-z\n\t\ti >= 48 && i <= 57;        // 0-9\n}\n\n/*\n * Lexer for JSHint.\n *\n * This object does a char-by-char scan of the provided source code\n * and produces a sequence of tokens.\n *\n *   var lex = new Lexer(\"var i = 0;\");\n *   lex.start();\n *   lex.token(); // returns the next token\n *\n * You have to use the token() method to move the lexer forward\n * but you don't have to use its return value to get tokens. In addition\n * to token() method returning the next token, the Lexer object also\n * emits events.\n *\n *   lex.on(\"Identifier\", function (data) {\n *     if (data.name.indexOf(\"_\") >= 0) {\n *       // Produce a warning.\n *     }\n *   });\n *\n * Note that the token() method returns tokens in a JSLint-compatible\n * format while the event emitter uses a slightly modified version of\n * Mozilla's JavaScript Parser API. Eventually, we will move away from\n * JSLint format.\n */\nfunction Lexer(source) {\n\tvar lines = source;\n\n\tif (typeof lines === \"string\") {\n\t\tlines = lines\n\t\t\t.replace(/\\r\\n/g, \"\\n\")\n\t\t\t.replace(/\\r/g, \"\\n\")\n\t\t\t.split(\"\\n\");\n\t}\n\n\t// If the first line is a shebang (#!), make it a blank and move on.\n\t// Shebangs are used by Node scripts.\n\n\tif (lines[0] && lines[0].substr(0, 2) === \"#!\") {\n\t\tlines[0] = \"\";\n\t}\n\n\tthis.emitter = new events.EventEmitter();\n\tthis.source = source;\n\tthis.lines = lines;\n\tthis.prereg = true;\n\n\tthis.line = 0;\n\tthis.char = 1;\n\tthis.from = 1;\n\tthis.input = \"\";\n\n\tfor (var i = 0; i < state.option.indent; i += 1) {\n\t\tstate.tab += \" \";\n\t}\n}\n\nLexer.prototype = {\n\t_lines: [],\n\n\tget lines() {\n\t\tthis._lines = state.lines;\n\t\treturn this._lines;\n\t},\n\n\tset lines(val) {\n\t\tthis._lines = val;\n\t\tstate.lines = this._lines;\n\t},\n\n\t/*\n\t * Return the next i character without actually moving the\n\t * char pointer.\n\t */\n\tpeek: function (i) {\n\t\treturn this.input.charAt(i || 0);\n\t},\n\n\t/*\n\t * Move the char pointer forward i times.\n\t */\n\tskip: function (i) {\n\t\ti = i || 1;\n\t\tthis.char += i;\n\t\tthis.input = this.input.slice(i);\n\t},\n\n\t/*\n\t * Subscribe to a token event. The API for this method is similar\n\t * Underscore.js i.e. you can subscribe to multiple events with\n\t * one call:\n\t *\n\t *   lex.on(\"Identifier Number\", function (data) {\n\t *     // ...\n\t *   });\n\t */\n\ton: function (names, listener) {\n\t\tnames.split(\" \").forEach(function (name) {\n\t\t\tthis.emitter.on(name, listener);\n\t\t}.bind(this));\n\t},\n\n\t/*\n\t * Trigger a token event. All arguments will be passed to each\n\t * listener.\n\t */\n\ttrigger: function () {\n\t\tthis.emitter.emit.apply(this.emitter, Array.prototype.slice.call(arguments));\n\t},\n\n\t/*\n\t * Extract a punctuator out of the next sequence of characters\n\t * or return 'null' if its not possible.\n\t *\n\t * This method's implementation was heavily influenced by the\n\t * scanPunctuator function in the Esprima parser's source code.\n\t */\n\tscanPunctuator: function () {\n\t\tvar ch1 = this.peek();\n\t\tvar ch2, ch3, ch4;\n\n\t\tswitch (ch1) {\n\t\t// Most common single-character punctuators\n\t\tcase \".\":\n\t\t\tif ((/^[0-9]$/).test(this.peek(1))) {\n\t\t\t\treturn null;\n\t\t\t}\n\n\t\t\t/* falls through */\n\t\tcase \"(\":\n\t\tcase \")\":\n\t\tcase \";\":\n\t\tcase \",\":\n\t\tcase \"{\":\n\t\tcase \"}\":\n\t\tcase \"[\":\n\t\tcase \"]\":\n\t\tcase \":\":\n\t\tcase \"~\":\n\t\tcase \"?\":\n\t\t\treturn {\n\t\t\t\ttype: Token.Punctuator,\n\t\t\t\tvalue: ch1\n\t\t\t};\n\n\t\t// A pound sign (for Node shebangs)\n\t\tcase \"#\":\n\t\t\treturn {\n\t\t\t\ttype: Token.Punctuator,\n\t\t\t\tvalue: ch1\n\t\t\t};\n\n\t\t// We're at the end of input\n\t\tcase \"\":\n\t\t\treturn null;\n\t\t}\n\n\t\t// Peek more characters\n\n\t\tch2 = this.peek(1);\n\t\tch3 = this.peek(2);\n\t\tch4 = this.peek(3);\n\n\t\t// 4-character punctuator: >>>=\n\n\t\tif (ch1 === \">\" && ch2 === \">\" && ch3 === \">\" && ch4 === \"=\") {\n\t\t\treturn {\n\t\t\t\ttype: Token.Punctuator,\n\t\t\t\tvalue: \">>>=\"\n\t\t\t};\n\t\t}\n\n\t\t// 3-character punctuators: === !== >>> <<= >>=\n\n\t\tif (ch1 === \"=\" && ch2 === \"=\" && ch3 === \"=\") {\n\t\t\treturn {\n\t\t\t\ttype: Token.Punctuator,\n\t\t\t\tvalue: \"===\"\n\t\t\t};\n\t\t}\n\n\t\tif (ch1 === \"!\" && ch2 === \"=\" && ch3 === \"=\") {\n\t\t\treturn {\n\t\t\t\ttype: Token.Punctuator,\n\t\t\t\tvalue: \"!==\"\n\t\t\t};\n\t\t}\n\n\t\tif (ch1 === \">\" && ch2 === \">\" && ch3 === \">\") {\n\t\t\treturn {\n\t\t\t\ttype: Token.Punctuator,\n\t\t\t\tvalue: \">>>\"\n\t\t\t};\n\t\t}\n\n\t\tif (ch1 === \"<\" && ch2 === \"<\" && ch3 === \"=\") {\n\t\t\treturn {\n\t\t\t\ttype: Token.Punctuator,\n\t\t\t\tvalue: \"<<=\"\n\t\t\t};\n\t\t}\n\n\t\tif (ch1 === \">\" && ch2 === \">\" && ch3 === \"=\") {\n\t\t\treturn {\n\t\t\t\ttype: Token.Punctuator,\n\t\t\t\tvalue: \"<<=\"\n\t\t\t};\n\t\t}\n\n\t\t// 2-character punctuators: <= >= == != ++ -- << >> && ||\n\t\t// += -= *= %= &= |= ^= (but not /=, see below)\n\t\tif (ch1 === ch2 && (\"+-<>&|\".indexOf(ch1) >= 0)) {\n\t\t\treturn {\n\t\t\t\ttype: Token.Punctuator,\n\t\t\t\tvalue: ch1 + ch2\n\t\t\t};\n\t\t}\n\n\t\tif (\"<>=!+-*%&|^\".indexOf(ch1) >= 0) {\n\t\t\tif (ch2 === \"=\") {\n\t\t\t\treturn {\n\t\t\t\t\ttype: Token.Punctuator,\n\t\t\t\t\tvalue: ch1 + ch2\n\t\t\t\t};\n\t\t\t}\n\n\t\t\treturn {\n\t\t\t\ttype: Token.Punctuator,\n\t\t\t\tvalue: ch1\n\t\t\t};\n\t\t}\n\n\t\t// Special case: /=. We need to make sure that this is an\n\t\t// operator and not a regular expression.\n\n\t\tif (ch1 === \"/\") {\n\t\t\tif (ch2 === \"=\" && /\\/=(?!(\\S*\\/[gim]?))/.test(this.input)) {\n\t\t\t\t// /= is not a part of a regular expression, return it as a\n\t\t\t\t// punctuator.\n\t\t\t\treturn {\n\t\t\t\t\ttype: Token.Punctuator,\n\t\t\t\t\tvalue: \"/=\"\n\t\t\t\t};\n\t\t\t}\n\n\t\t\treturn {\n\t\t\t\ttype: Token.Punctuator,\n\t\t\t\tvalue: \"/\"\n\t\t\t};\n\t\t}\n\n\t\treturn null;\n\t},\n\n\t/*\n\t * Extract a comment out of the next sequence of characters and/or\n\t * lines or return 'null' if its not possible. Since comments can\n\t * span across multiple lines this method has to move the char\n\t * pointer.\n\t *\n\t * In addition to normal JavaScript comments (// and /*) this method\n\t * also recognizes JSHint- and JSLint-specific comments such as\n\t * /*jshint, /*jslint, /*globals and so on.\n\t */\n\tscanComments: function () {\n\t\tvar ch1 = this.peek();\n\t\tvar ch2 = this.peek(1);\n\t\tvar rest = this.input.substr(2);\n\t\tvar startLine = this.line;\n\t\tvar startChar = this.char;\n\n\t\t// Create a comment token object and make sure it\n\t\t// has all the data JSHint needs to work with special\n\t\t// comments.\n\n\t\tfunction commentToken(label, body, opt) {\n\t\t\tvar special = [\"jshint\", \"jslint\", \"members\", \"member\", \"globals\", \"global\", \"exported\"];\n\t\t\tvar isSpecial = false;\n\t\t\tvar value = label + body;\n\t\t\tvar commentType = \"plain\";\n\t\t\topt = opt || {};\n\n\t\t\tif (opt.isMultiline) {\n\t\t\t\tvalue += \"*/\";\n\t\t\t}\n\n\t\t\tspecial.forEach(function (str) {\n\t\t\t\tif (isSpecial) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif (body.substr(0, str.length) === str) {\n\t\t\t\t\tisSpecial = true;\n\t\t\t\t\tlabel = label + str;\n\t\t\t\t\tbody = body.substr(str.length);\n\t\t\t\t}\n\n\t\t\t\tif (!isSpecial && body.charAt(0) === \" \" && body.substr(1, str.length) === str) {\n\t\t\t\t\tisSpecial = true;\n\t\t\t\t\tlabel = label + \" \" + str;\n\t\t\t\t\tbody = body.substr(str.length + 1);\n\t\t\t\t}\n\n\t\t\t\tif (!isSpecial) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tswitch (str) {\n\t\t\t\tcase \"member\":\n\t\t\t\t\tcommentType = \"members\";\n\t\t\t\t\tbreak;\n\t\t\t\tcase \"global\":\n\t\t\t\t\tcommentType = \"globals\";\n\t\t\t\t\tbreak;\n\t\t\t\tdefault:\n\t\t\t\t\tcommentType = str;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\treturn {\n\t\t\t\ttype: Token.Comment,\n\t\t\t\tcommentType: commentType,\n\t\t\t\tvalue: value,\n\t\t\t\tbody: body,\n\t\t\t\tisSpecial: isSpecial,\n\t\t\t\tisMultiline: opt.isMultiline || false,\n\t\t\t\tisMalformed: opt.isMalformed || false\n\t\t\t};\n\t\t}\n\n\t\t// End of unbegun comment. Raise an error and skip that input.\n\t\tif (ch1 === \"*\" && ch2 === \"/\") {\n\t\t\tthis.trigger(\"error\", {\n\t\t\t\tcode: \"E018\",\n\t\t\t\tline: startLine,\n\t\t\t\tcharacter: startChar\n\t\t\t});\n\n\t\t\tthis.skip(2);\n\t\t\treturn null;\n\t\t}\n\n\t\t// Comments must start either with // or /*\n\t\tif (ch1 !== \"/\" || (ch2 !== \"*\" && ch2 !== \"/\")) {\n\t\t\treturn null;\n\t\t}\n\n\t\t// One-line comment\n\t\tif (ch2 === \"/\") {\n\t\t\tthis.skip(this.input.length); // Skip to the EOL.\n\t\t\treturn commentToken(\"//\", rest);\n\t\t}\n\n\t\tvar body = \"\";\n\n\t\t/* Multi-line comment */\n\t\tif (ch2 === \"*\") {\n\t\t\tthis.skip(2);\n\n\t\t\twhile (this.peek() !== \"*\" || this.peek(1) !== \"/\") {\n\t\t\t\tif (this.peek() === \"\") { // End of Line\n\t\t\t\t\tbody += \"\\n\";\n\n\t\t\t\t\t// If we hit EOF and our comment is still unclosed,\n\t\t\t\t\t// trigger an error and end the comment implicitly.\n\t\t\t\t\tif (!this.nextLine()) {\n\t\t\t\t\t\tthis.trigger(\"error\", {\n\t\t\t\t\t\t\tcode: \"E017\",\n\t\t\t\t\t\t\tline: startLine,\n\t\t\t\t\t\t\tcharacter: startChar\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\treturn commentToken(\"/*\", body, {\n\t\t\t\t\t\t\tisMultiline: true,\n\t\t\t\t\t\t\tisMalformed: true\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\tbody += this.peek();\n\t\t\t\t\tthis.skip();\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tthis.skip(2);\n\t\t\treturn commentToken(\"/*\", body, { isMultiline: true });\n\t\t}\n\t},\n\n\t/*\n\t * Extract a keyword out of the next sequence of characters or\n\t * return 'null' if its not possible.\n\t */\n\tscanKeyword: function () {\n\t\tvar result = /^[a-zA-Z_$][a-zA-Z0-9_$]*/.exec(this.input);\n\t\tvar keywords = [\n\t\t\t\"if\", \"in\", \"do\", \"var\", \"for\", \"new\",\n\t\t\t\"try\", \"let\", \"this\", \"else\", \"case\",\n\t\t\t\"void\", \"with\", \"enum\", \"while\", \"break\",\n\t\t\t\"catch\", \"throw\", \"const\", \"yield\", \"class\",\n\t\t\t\"super\", \"return\", \"typeof\", \"delete\",\n\t\t\t\"switch\", \"export\", \"import\", \"default\",\n\t\t\t\"finally\", \"extends\", \"function\", \"continue\",\n\t\t\t\"debugger\", \"instanceof\"\n\t\t];\n\n\t\tif (result && keywords.indexOf(result[0]) >= 0) {\n\t\t\treturn {\n\t\t\t\ttype: Token.Keyword,\n\t\t\t\tvalue: result[0]\n\t\t\t};\n\t\t}\n\n\t\treturn null;\n\t},\n\n\t/*\n\t * Extract a JavaScript identifier out of the next sequence of\n\t * characters or return 'null' if its not possible. In addition,\n\t * to Identifier this method can also produce BooleanLiteral\n\t * (true/false) and NullLiteral (null).\n\t */\n\tscanIdentifier: function () {\n\t\tvar id = \"\";\n\t\tvar index = 0;\n\t\tvar type, char;\n\n\t\t// Detects any character in the Unicode categories \"Uppercase\n\t\t// letter (Lu)\", \"Lowercase letter (Ll)\", \"Titlecase letter\n\t\t// (Lt)\", \"Modifier letter (Lm)\", \"Other letter (Lo)\", or\n\t\t// \"Letter number (Nl)\".\n\t\t//\n\t\t// Both approach and unicodeLetterTable were borrowed from\n\t\t// Google's Traceur.\n\n\t\tfunction isUnicodeLetter(code) {\n\t\t\tfor (var i = 0; i < unicodeLetterTable.length;) {\n\t\t\t\tif (code < unicodeLetterTable[i++]) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\tif (code <= unicodeLetterTable[i++]) {\n\t\t\t\t\treturn true;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn false;\n\t\t}\n\n\t\tfunction isHexDigit(str) {\n\t\t\treturn (/^[0-9a-fA-F]$/).test(str);\n\t\t}\n\n\t\tvar readUnicodeEscapeSequence = function () {\n\t\t\t/*jshint validthis:true */\n\t\t\tindex += 1;\n\n\t\t\tif (this.peek(index) !== \"u\") {\n\t\t\t\treturn null;\n\t\t\t}\n\n\t\t\tvar ch1 = this.peek(index + 1);\n\t\t\tvar ch2 = this.peek(index + 2);\n\t\t\tvar ch3 = this.peek(index + 3);\n\t\t\tvar ch4 = this.peek(index + 4);\n\t\t\tvar code;\n\n\t\t\tif (isHexDigit(ch1) && isHexDigit(ch2) && isHexDigit(ch3) && isHexDigit(ch4)) {\n\t\t\t\tcode = parseInt(ch1 + ch2 + ch3 + ch4, 16);\n\n\t\t\t\tif (isUnicodeLetter(code)) {\n\t\t\t\t\tindex += 5;\n\t\t\t\t\treturn \"\\\\u\" + ch1 + ch2 + ch3 + ch4;\n\t\t\t\t}\n\n\t\t\t\treturn null;\n\t\t\t}\n\n\t\t\treturn null;\n\t\t}.bind(this);\n\n\t\tvar getIdentifierStart = function () {\n\t\t\t/*jshint validthis:true */\n\t\t\tvar chr = this.peek(index);\n\t\t\tvar code = chr.charCodeAt(0);\n\n\t\t\tif (code === 92) {\n\t\t\t\treturn readUnicodeEscapeSequence();\n\t\t\t}\n\n\t\t\tif (code < 128) {\n\t\t\t\tif (identifierStartTable[code]) {\n\t\t\t\t\tindex += 1;\n\t\t\t\t\treturn chr;\n\t\t\t\t}\n\n\t\t\t\treturn null;\n\t\t\t}\n\n\t\t\tif (isUnicodeLetter(code)) {\n\t\t\t\tindex += 1;\n\t\t\t\treturn chr;\n\t\t\t}\n\n\t\t\treturn null;\n\t\t}.bind(this);\n\n\t\tvar getIdentifierPart = function () {\n\t\t\t/*jshint validthis:true */\n\t\t\tvar chr = this.peek(index);\n\t\t\tvar code = chr.charCodeAt(0);\n\n\t\t\tif (code === 92) {\n\t\t\t\treturn readUnicodeEscapeSequence();\n\t\t\t}\n\n\t\t\tif (code < 128) {\n\t\t\t\tif (identifierPartTable[code]) {\n\t\t\t\t\tindex += 1;\n\t\t\t\t\treturn chr;\n\t\t\t\t}\n\n\t\t\t\treturn null;\n\t\t\t}\n\n\t\t\tif (isUnicodeLetter(code)) {\n\t\t\t\tindex += 1;\n\t\t\t\treturn chr;\n\t\t\t}\n\n\t\t\treturn null;\n\t\t}.bind(this);\n\n\t\tchar = getIdentifierStart();\n\t\tif (char === null) {\n\t\t\treturn null;\n\t\t}\n\n\t\tid = char;\n\t\tfor (;;) {\n\t\t\tchar = getIdentifierPart();\n\n\t\t\tif (char === null) {\n\t\t\t\tbreak;\n\t\t\t}\n\n\t\t\tid += char;\n\t\t}\n\n\t\tswitch (id) {\n\t\tcase \"true\":\n\t\tcase \"false\":\n\t\t\ttype = Token.BooleanLiteral;\n\t\t\tbreak;\n\t\tcase \"null\":\n\t\t\ttype = Token.NullLiteral;\n\t\t\tbreak;\n\t\tdefault:\n\t\t\ttype = Token.Identifier;\n\t\t}\n\n\t\treturn {\n\t\t\ttype: type,\n\t\t\tvalue: id\n\t\t};\n\t},\n\n\t/*\n\t * Extract a numeric literal out of the next sequence of\n\t * characters or return 'null' if its not possible. This method\n\t * supports all numeric literals described in section 7.8.3\n\t * of the EcmaScript 5 specification.\n\t *\n\t * This method's implementation was heavily influenced by the\n\t * scanNumericLiteral function in the Esprima parser's source code.\n\t */\n\tscanNumericLiteral: function () {\n\t\tvar index = 0;\n\t\tvar value = \"\";\n\t\tvar length = this.input.length;\n\t\tvar char = this.peek(index);\n\t\tvar bad;\n\n\t\tfunction isDecimalDigit(str) {\n\t\t\treturn (/^[0-9]$/).test(str);\n\t\t}\n\n\t\tfunction isOctalDigit(str) {\n\t\t\treturn (/^[0-7]$/).test(str);\n\t\t}\n\n\t\tfunction isHexDigit(str) {\n\t\t\treturn (/^[0-9a-fA-F]$/).test(str);\n\t\t}\n\n\t\tfunction isIdentifierStart(ch) {\n\t\t\treturn (ch === \"$\") || (ch === \"_\") || (ch === \"\\\\\") ||\n\t\t\t\t(ch >= \"a\" && ch <= \"z\") || (ch >= \"A\" && ch <= \"Z\");\n\t\t}\n\n\t\t// Numbers must start either with a decimal digit or a point.\n\n\t\tif (char !== \".\" && !isDecimalDigit(char)) {\n\t\t\treturn null;\n\t\t}\n\n\t\tif (char !== \".\") {\n\t\t\tvalue = this.peek(index);\n\t\t\tindex += 1;\n\t\t\tchar = this.peek(index);\n\n\t\t\tif (value === \"0\") {\n\t\t\t\t// Base-16 numbers.\n\t\t\t\tif (char === \"x\" || char === \"X\") {\n\t\t\t\t\tindex += 1;\n\t\t\t\t\tvalue += char;\n\n\t\t\t\t\twhile (index < length) {\n\t\t\t\t\t\tchar = this.peek(index);\n\t\t\t\t\t\tif (!isHexDigit(char)) {\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tvalue += char;\n\t\t\t\t\t\tindex += 1;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (value.length <= 2) { // 0x\n\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\ttype: Token.NumericLiteral,\n\t\t\t\t\t\t\tvalue: value,\n\t\t\t\t\t\t\tisMalformed: true\n\t\t\t\t\t\t};\n\t\t\t\t\t}\n\n\t\t\t\t\tif (index < length) {\n\t\t\t\t\t\tchar = this.peek(index);\n\t\t\t\t\t\tif (isIdentifierStart(char)) {\n\t\t\t\t\t\t\treturn null;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\treturn {\n\t\t\t\t\t\ttype: Token.NumericLiteral,\n\t\t\t\t\t\tvalue: value,\n\t\t\t\t\t\tbase: 16,\n\t\t\t\t\t\tisMalformed: false\n\t\t\t\t\t};\n\t\t\t\t}\n\n\t\t\t\t// Base-8 numbers.\n\t\t\t\tif (isOctalDigit(char)) {\n\t\t\t\t\tindex += 1;\n\t\t\t\t\tvalue += char;\n\t\t\t\t\tbad = false;\n\n\t\t\t\t\twhile (index < length) {\n\t\t\t\t\t\tchar = this.peek(index);\n\n\t\t\t\t\t\t// Numbers like '019' (note the 9) are not valid octals\n\t\t\t\t\t\t// but we still parse them and mark as malformed.\n\n\t\t\t\t\t\tif (isDecimalDigit(char)) {\n\t\t\t\t\t\t\tbad = true;\n\t\t\t\t\t\t} else if (!isOctalDigit(char)) {\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tvalue += char;\n\t\t\t\t\t\tindex += 1;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (index < length) {\n\t\t\t\t\t\tchar = this.peek(index);\n\t\t\t\t\t\tif (isIdentifierStart(char)) {\n\t\t\t\t\t\t\treturn null;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\treturn {\n\t\t\t\t\t\ttype: Token.NumericLiteral,\n\t\t\t\t\t\tvalue: value,\n\t\t\t\t\t\tbase: 8,\n\t\t\t\t\t\tisMalformed: false\n\t\t\t\t\t};\n\t\t\t\t}\n\n\t\t\t\t// Decimal numbers that start with '0' such as '09' are illegal\n\t\t\t\t// but we still parse them and return as malformed.\n\n\t\t\t\tif (isDecimalDigit(char)) {\n\t\t\t\t\tindex += 1;\n\t\t\t\t\tvalue += char;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\twhile (index < length) {\n\t\t\t\tchar = this.peek(index);\n\t\t\t\tif (!isDecimalDigit(char)) {\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t\tvalue += char;\n\t\t\t\tindex += 1;\n\t\t\t}\n\t\t}\n\n\t\t// Decimal digits.\n\n\t\tif (char === \".\") {\n\t\t\tvalue += char;\n\t\t\tindex += 1;\n\n\t\t\twhile (index < length) {\n\t\t\t\tchar = this.peek(index);\n\t\t\t\tif (!isDecimalDigit(char)) {\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t\tvalue += char;\n\t\t\t\tindex += 1;\n\t\t\t}\n\t\t}\n\n\t\t// Exponent part.\n\n\t\tif (char === \"e\" || char === \"E\") {\n\t\t\tvalue += char;\n\t\t\tindex += 1;\n\t\t\tchar = this.peek(index);\n\n\t\t\tif (char === \"+\" || char === \"-\") {\n\t\t\t\tvalue += this.peek(index);\n\t\t\t\tindex += 1;\n\t\t\t}\n\n\t\t\tchar = this.peek(index);\n\t\t\tif (isDecimalDigit(char)) {\n\t\t\t\tvalue += char;\n\t\t\t\tindex += 1;\n\n\t\t\t\twhile (index < length) {\n\t\t\t\t\tchar = this.peek(index);\n\t\t\t\t\tif (!isDecimalDigit(char)) {\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t\tvalue += char;\n\t\t\t\t\tindex += 1;\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\treturn null;\n\t\t\t}\n\t\t}\n\n\t\tif (index < length) {\n\t\t\tchar = this.peek(index);\n\t\t\tif (isIdentifierStart(char)) {\n\t\t\t\treturn null;\n\t\t\t}\n\t\t}\n\n\t\treturn {\n\t\t\ttype: Token.NumericLiteral,\n\t\t\tvalue: value,\n\t\t\tbase: 10,\n\t\t\tisMalformed: !isFinite(value)\n\t\t};\n\t},\n\n\t/*\n\t * Extract a string out of the next sequence of characters and/or\n\t * lines or return 'null' if its not possible. Since strings can\n\t * span across multiple lines this method has to move the char\n\t * pointer.\n\t *\n\t * This method recognizes pseudo-multiline JavaScript strings:\n\t *\n\t *   var str = \"hello\\\n\t *   world\";\n   */\n\tscanStringLiteral: function () {\n\t\tvar quote = this.peek();\n\n\t\t// String must start with a quote.\n\t\tif (quote !== \"\\\"\" && quote !== \"'\") {\n\t\t\treturn null;\n\t\t}\n\n\t\t// In JSON strings must always use double quotes.\n\t\tif (state.jsonMode && quote !== \"\\\"\") {\n\t\t\tthis.trigger(\"warning\", {\n\t\t\t\tcode: \"W108\",\n\t\t\t\tline: this.line,\n\t\t\t\tcharacter: this.char // +1?\n\t\t\t});\n\t\t}\n\n\t\tvar value = \"\";\n\t\tvar startLine = this.line;\n\t\tvar startChar = this.char;\n\t\tvar allowNewLine = false;\n\n\t\tthis.skip();\n\n\t\twhile (this.peek() !== quote) {\n\t\t\twhile (this.peek() === \"\") { // End Of Line\n\n\t\t\t\t// If an EOL is not preceded by a backslash, show a warning\n\t\t\t\t// and proceed like it was a legit multi-line string where\n\t\t\t\t// author simply forgot to escape the newline symbol.\n\t\t\t\t//\n\t\t\t\t// Another approach is to implicitly close a string on EOL\n\t\t\t\t// but it generates too many false positives.\n\n\t\t\t\tif (!allowNewLine) {\n\t\t\t\t\tthis.trigger(\"warning\", {\n\t\t\t\t\t\tcode: \"W112\",\n\t\t\t\t\t\tline: this.line,\n\t\t\t\t\t\tcharacter: this.char\n\t\t\t\t\t});\n\t\t\t\t} else {\n\t\t\t\t\tallowNewLine = false;\n\n\t\t\t\t\t// Otherwise show a warning if multistr option was not set.\n\t\t\t\t\t// For JSON, show warning no matter what.\n\n\t\t\t\t\tif (!state.option.multistr) {\n\t\t\t\t\t\tthis.trigger(\"warning\", {\n\t\t\t\t\t\t\tcode: \"W043\",\n\t\t\t\t\t\t\tline: this.line,\n\t\t\t\t\t\t\tcharacter: this.char\n\t\t\t\t\t\t});\n\t\t\t\t\t} else if (state.jsonMode) {\n\t\t\t\t\t\tthis.trigger(\"warning\", {\n\t\t\t\t\t\t\tcode: \"W042\",\n\t\t\t\t\t\t\tline: this.line,\n\t\t\t\t\t\t\tcharacter: this.char\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// If we get an EOF inside of an unclosed string, show an\n\t\t\t\t// error and implicitly close it at the EOF point.\n\n\t\t\t\tif (!this.nextLine()) {\n\t\t\t\t\tthis.trigger(\"error\", {\n\t\t\t\t\t\tcode: \"E029\",\n\t\t\t\t\t\tline: startLine,\n\t\t\t\t\t\tcharacter: startChar\n\t\t\t\t\t});\n\n\t\t\t\t\treturn {\n\t\t\t\t\t\ttype: Token.StringLiteral,\n\t\t\t\t\t\tvalue: value,\n\t\t\t\t\t\tisUnclosed: true,\n\t\t\t\t\t\tquote: quote\n\t\t\t\t\t};\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tallowNewLine = false;\n\t\t\tvar char = this.peek();\n\t\t\tvar jump = 1; // A length of a jump, after we're done\n\t\t\t              // parsing this character.\n\n\t\t\tif (char < \" \") {\n\t\t\t\t// Warn about a control character in a string.\n\t\t\t\tthis.trigger(\"warning\", {\n\t\t\t\t\tcode: \"W113\",\n\t\t\t\t\tline: this.line,\n\t\t\t\t\tcharacter: this.char,\n\t\t\t\t\tdata: [ \"<non-printable>\" ]\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Special treatment for some escaped characters.\n\n\t\t\tif (char === \"\\\\\") {\n\t\t\t\tthis.skip();\n\t\t\t\tchar = this.peek();\n\n\t\t\t\tswitch (char) {\n\t\t\t\tcase \"'\":\n\t\t\t\t\tif (state.jsonMode) {\n\t\t\t\t\t\tthis.trigger(\"warning\", {\n\t\t\t\t\t\t\tcode: \"W114\",\n\t\t\t\t\t\t\tline: this.line,\n\t\t\t\t\t\t\tcharacter: this.char,\n\t\t\t\t\t\t\tdata: [ \"\\\\'\" ]\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t\tbreak;\n\t\t\t\tcase \"b\":\n\t\t\t\t\tchar = \"\\b\";\n\t\t\t\t\tbreak;\n\t\t\t\tcase \"f\":\n\t\t\t\t\tchar = \"\\f\";\n\t\t\t\t\tbreak;\n\t\t\t\tcase \"n\":\n\t\t\t\t\tchar = \"\\n\";\n\t\t\t\t\tbreak;\n\t\t\t\tcase \"r\":\n\t\t\t\t\tchar = \"\\r\";\n\t\t\t\t\tbreak;\n\t\t\t\tcase \"t\":\n\t\t\t\t\tchar = \"\\t\";\n\t\t\t\t\tbreak;\n\t\t\t\tcase \"0\":\n\t\t\t\t\tchar = \"\\0\";\n\n\t\t\t\t\t// Octal literals fail in strict mode.\n\t\t\t\t\t// Check if the number is between 00 and 07.\n\t\t\t\t\tvar n = parseInt(this.peek(), 10);\n\t\t\t\t\tif (n >= 0 && n <= 7 && state.directive[\"use strict\"]) {\n\t\t\t\t\t\tthis.trigger(\"warning\", {\n\t\t\t\t\t\t\tcode: \"W115\",\n\t\t\t\t\t\t\tline: this.line,\n\t\t\t\t\t\t\tcharacter: this.char\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t\tbreak;\n\t\t\t\tcase \"u\":\n\t\t\t\t\tchar = String.fromCharCode(parseInt(this.input.substr(1, 4), 16));\n\t\t\t\t\tjump = 5;\n\t\t\t\t\tbreak;\n\t\t\t\tcase \"v\":\n\t\t\t\t\tif (state.jsonMode) {\n\t\t\t\t\t\tthis.trigger(\"warning\", {\n\t\t\t\t\t\t\tcode: \"W114\",\n\t\t\t\t\t\t\tline: this.line,\n\t\t\t\t\t\t\tcharacter: this.char,\n\t\t\t\t\t\t\tdata: [ \"\\\\v\" ]\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\n\t\t\t\t\tchar = \"\\v\";\n\t\t\t\t\tbreak;\n\t\t\t\tcase \"x\":\n\t\t\t\t\tvar\tx = parseInt(this.input.substr(1, 2), 16);\n\n\t\t\t\t\tif (state.jsonMode) {\n\t\t\t\t\t\tthis.trigger(\"warning\", {\n\t\t\t\t\t\t\tcode: \"W114\",\n\t\t\t\t\t\t\tline: this.line,\n\t\t\t\t\t\t\tcharacter: this.char,\n\t\t\t\t\t\t\tdata: [ \"\\\\x-\" ]\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\n\t\t\t\t\tchar = String.fromCharCode(x);\n\t\t\t\t\tjump = 3;\n\t\t\t\t\tbreak;\n\t\t\t\tcase \"\\\\\":\n\t\t\t\tcase \"\\\"\":\n\t\t\t\tcase \"/\":\n\t\t\t\t\tbreak;\n\t\t\t\tcase \"\":\n\t\t\t\t\tallowNewLine = true;\n\t\t\t\t\tchar = \"\";\n\t\t\t\t\tbreak;\n\t\t\t\tcase \"!\":\n\t\t\t\t\tif (value.slice(value.length - 2) === \"<\") {\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\n\t\t\t\t\t/*falls through */\n\t\t\t\tdefault:\n\t\t\t\t\t// Weird escaping.\n\t\t\t\t\tthis.trigger(\"warning\", {\n\t\t\t\t\t\tcode: \"W044\",\n\t\t\t\t\t\tline: this.line,\n\t\t\t\t\t\tcharacter: this.char\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tvalue += char;\n\t\t\tthis.skip(jump);\n\t\t}\n\n\t\tthis.skip();\n\t\treturn {\n\t\t\ttype: Token.StringLiteral,\n\t\t\tvalue: value,\n\t\t\tisUnclosed: false,\n\t\t\tquote: quote\n\t\t};\n\t},\n\n\t/*\n\t * Extract a regular expression out of the next sequence of\n\t * characters and/or lines or return 'null' if its not possible.\n\t *\n\t * This method is platform dependent: it accepts almost any\n\t * regular expression values but then tries to compile and run\n\t * them using system's RegExp object. This means that there are\n\t * rare edge cases where one JavaScript engine complains about\n\t * your regular expression while others don't.\n\t */\n\tscanRegExp: function () {\n\t\tvar index = 0;\n\t\tvar length = this.input.length;\n\t\tvar char = this.peek();\n\t\tvar value = char;\n\t\tvar body = \"\";\n\t\tvar flags = [];\n\t\tvar malformed = false;\n\t\tvar isCharSet = false;\n\t\tvar terminated;\n\n\t\tvar scanUnexpectedChars = function () {\n\t\t\t// Unexpected control character\n\t\t\tif (char < \" \") {\n\t\t\t\tmalformed = true;\n\t\t\t\tthis.trigger(\"warning\", {\n\t\t\t\t\tcode: \"W048\",\n\t\t\t\t\tline: this.line,\n\t\t\t\t\tcharacter: this.char\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Unexpected escaped character\n\t\t\tif (char === \"<\") {\n\t\t\t\tmalformed = true;\n\t\t\t\tthis.trigger(\"warning\", {\n\t\t\t\t\tcode: \"W049\",\n\t\t\t\t\tline: this.line,\n\t\t\t\t\tcharacter: this.char,\n\t\t\t\t\tdata: [ char ]\n\t\t\t\t});\n\t\t\t}\n\t\t}.bind(this);\n\n\t\t// Regular expressions must start with '/'\n\t\tif (!this.prereg || char !== \"/\") {\n\t\t\treturn null;\n\t\t}\n\n\t\tindex += 1;\n\t\tterminated = false;\n\n\t\t// Try to get everything in between slashes. A couple of\n\t\t// cases aside (see scanUnexpectedChars) we don't really\n\t\t// care whether the resulting expression is valid or not.\n\t\t// We will check that later using the RegExp object.\n\n\t\twhile (index < length) {\n\t\t\tchar = this.peek(index);\n\t\t\tvalue += char;\n\t\t\tbody += char;\n\n\t\t\tif (isCharSet) {\n\t\t\t\tif (char === \"]\") {\n\t\t\t\t\tif (this.peek(index - 1) !== \"\\\\\" || this.peek(index - 2) === \"\\\\\") {\n\t\t\t\t\t\tisCharSet = false;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif (char === \"\\\\\") {\n\t\t\t\t\tindex += 1;\n\t\t\t\t\tchar = this.peek(index);\n\t\t\t\t\tbody += char;\n\t\t\t\t\tvalue += char;\n\n\t\t\t\t\tscanUnexpectedChars();\n\t\t\t\t}\n\n\t\t\t\tindex += 1;\n\t\t\t\tcontinue;\n\t\t\t}\n\n\t\t\tif (char === \"\\\\\") {\n\t\t\t\tindex += 1;\n\t\t\t\tchar = this.peek(index);\n\t\t\t\tbody += char;\n\t\t\t\tvalue += char;\n\n\t\t\t\tscanUnexpectedChars();\n\n\t\t\t\tif (char === \"/\") {\n\t\t\t\t\tindex += 1;\n\t\t\t\t\tcontinue;\n\t\t\t\t}\n\n\t\t\t\tif (char === \"[\") {\n\t\t\t\t\tindex += 1;\n\t\t\t\t\tcontinue;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (char === \"[\") {\n\t\t\t\tisCharSet = true;\n\t\t\t\tindex += 1;\n\t\t\t\tcontinue;\n\t\t\t}\n\n\t\t\tif (char === \"/\") {\n\t\t\t\tbody = body.substr(0, body.length - 1);\n\t\t\t\tterminated = true;\n\t\t\t\tindex += 1;\n\t\t\t\tbreak;\n\t\t\t}\n\n\t\t\tindex += 1;\n\t\t}\n\n\t\t// A regular expression that was never closed is an\n\t\t// error from which we cannot recover.\n\n\t\tif (!terminated) {\n\t\t\tthis.trigger(\"error\", {\n\t\t\t\tcode: \"E015\",\n\t\t\t\tline: this.line,\n\t\t\t\tcharacter: this.from\n\t\t\t});\n\n\t\t\treturn void this.trigger(\"fatal\", {\n\t\t\t\tline: this.line,\n\t\t\t\tfrom: this.from\n\t\t\t});\n\t\t}\n\n\t\t// Parse flags (if any).\n\n\t\twhile (index < length) {\n\t\t\tchar = this.peek(index);\n\t\t\tif (!/[gim]/.test(char)) {\n\t\t\t\tbreak;\n\t\t\t}\n\t\t\tflags.push(char);\n\t\t\tvalue += char;\n\t\t\tindex += 1;\n\t\t}\n\n\t\t// Check regular expression for correctness.\n\n\t\ttry {\n\t\t\tnew RegExp(body, flags.join(\"\"));\n\t\t} catch (err) {\n\t\t\tmalformed = true;\n\t\t\tthis.trigger(\"error\", {\n\t\t\t\tcode: \"E016\",\n\t\t\t\tline: this.line,\n\t\t\t\tcharacter: this.char,\n\t\t\t\tdata: [ err.message ] // Platform dependent!\n\t\t\t});\n\t\t}\n\n\t\treturn {\n\t\t\ttype: Token.RegExp,\n\t\t\tvalue: value,\n\t\t\tflags: flags,\n\t\t\tisMalformed: malformed\n\t\t};\n\t},\n\n\t/*\n\t * Scan for any occurence of mixed tabs and spaces. If smarttabs option\n\t * is on, ignore tabs followed by spaces.\n\t *\n\t * Tabs followed by one space followed by a block comment are allowed.\n\t */\n\tscanMixedSpacesAndTabs: function () {\n\t\tvar at, match;\n\n\t\tif (state.option.smarttabs) {\n\t\t\t// Negative look-behind for \"//\"\n\t\t\tmatch = this.input.match(/(\\/\\/)? \\t/);\n\t\t\tat = match && !match[1] ? 0 : -1;\n\t\t} else {\n\t\t\tat = this.input.search(/ \\t|\\t [^\\*]/);\n\t\t}\n\n\t\treturn at;\n\t},\n\n\t/*\n\t * Scan for characters that get silently deleted by one or more browsers.\n\t */\n\tscanUnsafeChars: function () {\n\t\treturn this.input.search(reg.unsafeChars);\n\t},\n\n\t/*\n\t * Produce the next raw token or return 'null' if no tokens can be matched.\n\t * This method skips over all space characters.\n\t */\n\tnext: function () {\n\t\tthis.from = this.char;\n\n\t\t// Move to the next non-space character.\n\t\tvar start;\n\t\tif (/\\s/.test(this.peek())) {\n\t\t\tstart = this.char;\n\n\t\t\twhile (/\\s/.test(this.peek())) {\n\t\t\t\tthis.from += 1;\n\t\t\t\tthis.skip();\n\t\t\t}\n\n\t\t\tif (this.peek() === \"\") { // EOL\n\t\t\t\tif (state.option.trailing) {\n\t\t\t\t\tthis.trigger(\"warning\", { code: \"W102\", line: this.line, character: start });\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\t// Methods that work with multi-line structures and move the\n\t\t// character pointer.\n\n\t\tvar match = this.scanComments() ||\n\t\t\tthis.scanStringLiteral();\n\n\t\tif (match) {\n\t\t\treturn match;\n\t\t}\n\n\t\t// Methods that don't move the character pointer.\n\n\t\tmatch =\n\t\t\tthis.scanRegExp() ||\n\t\t\tthis.scanPunctuator() ||\n\t\t\tthis.scanKeyword() ||\n\t\t\tthis.scanIdentifier() ||\n\t\t\tthis.scanNumericLiteral();\n\n\t\tif (match) {\n\t\t\tthis.skip(match.value.length);\n\t\t\treturn match;\n\t\t}\n\n\t\t// No token could be matched, give up.\n\n\t\treturn null;\n\t},\n\n\t/*\n\t * Switch to the next line and reset all char pointers. Once\n\t * switched, this method also checks for mixed spaces and tabs\n\t * and other minor warnings.\n\t */\n\tnextLine: function () {\n\t\tvar char;\n\n\t\tif (this.line >= this.lines.length) {\n\t\t\treturn false;\n\t\t}\n\n\t\tthis.input = this.lines[this.line];\n\t\tthis.line += 1;\n\t\tthis.char = 1;\n\t\tthis.from = 1;\n\n\t\tchar = this.scanMixedSpacesAndTabs();\n\t\tif (char >= 0) {\n\t\t\tthis.trigger(\"warning\", { code: \"W099\", line: this.line, character: char + 1 });\n\t\t}\n\n\t\tthis.input = this.input.replace(/\\t/g, state.tab);\n\t\tchar = this.scanUnsafeChars();\n\n\t\tif (char >= 0) {\n\t\t\tthis.trigger(\"warning\", { code: \"W100\", line: this.line, character: char });\n\t\t}\n\n\t\t// If there is a limit on line length, warn when lines get too\n\t\t// long.\n\n\t\tif (state.option.maxlen && state.option.maxlen < this.input.length) {\n\t\t\tthis.trigger(\"warning\", { code: \"W101\", line: this.line, character: this.input.length });\n\t\t}\n\n\t\treturn true;\n\t},\n\n\t/*\n\t * This is simply a synonym for nextLine() method with a friendlier\n\t * public name.\n\t */\n\tstart: function () {\n\t\tthis.nextLine();\n\t},\n\n\t/*\n\t * Produce the next token. This function is called by advance() to get\n\t * the next token. It retuns a token in a JSLint-compatible format.\n\t */\n\ttoken: function () {\n\t\tvar token;\n\n\t\t// Produce a token object.\n\t\tvar create = function (type, value, isProperty) {\n\t\t\t/*jshint validthis:true */\n\t\t\tvar obj;\n\n\t\t\tif (type !== \"(endline)\" && type !== \"(end)\") {\n\t\t\t\tthis.prereg = false;\n\t\t\t}\n\n\t\t\tif (type === \"(punctuator)\") {\n\t\t\t\tswitch (value) {\n\t\t\t\tcase \".\":\n\t\t\t\tcase \")\":\n\t\t\t\tcase \"~\":\n\t\t\t\tcase \"#\":\n\t\t\t\tcase \"]\":\n\t\t\t\t\tthis.prereg = false;\n\t\t\t\t\tbreak;\n\t\t\t\tdefault:\n\t\t\t\t\tthis.prereg = true;\n\t\t\t\t}\n\n\t\t\t\tobj = Object.create(state.syntax[value] || state.syntax[\"(error)\"]);\n\t\t\t}\n\n\t\t\tif (type === \"(identifier)\") {\n\t\t\t\tif (value === \"return\" || value === \"case\" || value === \"typeof\") {\n\t\t\t\t\tthis.prereg = true;\n\t\t\t\t}\n\n\t\t\t\tif (_.has(state.syntax, value)) {\n\t\t\t\t\tobj = Object.create(state.syntax[value] || state.syntax[\"(error)\"]);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (!obj) {\n\t\t\t\tobj = Object.create(state.syntax[type]);\n\t\t\t}\n\n\t\t\tobj.identifier = (type === \"(identifier)\");\n\t\t\tobj.type = obj.type || type;\n\t\t\tobj.value = value;\n\t\t\tobj.line = this.line;\n\t\t\tobj.character = this.char;\n\t\t\tobj.from = this.from;\n\n\t\t\tif (isProperty && obj.identifier) {\n\t\t\t\tobj.isProperty = isProperty;\n\t\t\t}\n\n\t\t\treturn obj;\n\t\t}.bind(this);\n\n\t\tfor (;;) {\n\t\t\tif (!this.input.length) {\n\t\t\t\treturn create(this.nextLine() ? \"(endline)\" : \"(end)\", \"\");\n\t\t\t}\n\n\t\t\ttoken = this.next();\n\n\t\t\tif (!token) {\n\t\t\t\tif (this.input.length) {\n\t\t\t\t\t// Unexpected character.\n\t\t\t\t\tthis.trigger(\"error\", {\n\t\t\t\t\t\tcode: \"E024\",\n\t\t\t\t\t\tline: this.line,\n\t\t\t\t\t\tcharacter: this.char,\n\t\t\t\t\t\tdata: [ this.peek() ]\n\t\t\t\t\t});\n\n\t\t\t\t\tthis.input = \"\";\n\t\t\t\t}\n\n\t\t\t\tcontinue;\n\t\t\t}\n\n\t\t\tswitch (token.type) {\n\t\t\tcase Token.StringLiteral:\n\t\t\t\tthis.trigger(\"String\", {\n\t\t\t\t\tline: this.line,\n\t\t\t\t\tchar: this.char,\n\t\t\t\t\tfrom: this.from,\n\t\t\t\t\tvalue: token.value,\n\t\t\t\t\tquote: token.quote\n\t\t\t\t});\n\n\t\t\t\treturn create(\"(string)\", token.value);\n\t\t\tcase Token.Identifier:\n\t\t\t\tthis.trigger(\"Identifier\", {\n\t\t\t\t\tline: this.line,\n\t\t\t\t\tchar: this.char,\n\t\t\t\t\tfrom: this.form,\n\t\t\t\t\tname: token.value,\n\t\t\t\t\tisProperty: state.tokens.curr.id === \".\"\n\t\t\t\t});\n\n\t\t\t\t/* falls through */\n\t\t\tcase Token.Keyword:\n\t\t\tcase Token.NullLiteral:\n\t\t\tcase Token.BooleanLiteral:\n\t\t\t\treturn create(\"(identifier)\", token.value, state.tokens.curr.id === \".\");\n\n\t\t\tcase Token.NumericLiteral:\n\t\t\t\tif (token.isMalformed) {\n\t\t\t\t\tthis.trigger(\"warning\", {\n\t\t\t\t\t\tcode: \"W045\",\n\t\t\t\t\t\tline: this.line,\n\t\t\t\t\t\tcharacter: this.char,\n\t\t\t\t\t\tdata: [ token.value ]\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\tif (state.jsonMode && token.base === 16) {\n\t\t\t\t\tthis.trigger(\"warning\", {\n\t\t\t\t\t\tcode: \"W114\",\n\t\t\t\t\t\tline: this.line,\n\t\t\t\t\t\tcharacter: this.char,\n\t\t\t\t\t\tdata: [ \"0x-\" ]\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\tif (state.directive[\"use strict\"] && token.base === 8) {\n\t\t\t\t\tthis.trigger(\"warning\", {\n\t\t\t\t\t\tcode: \"W115\",\n\t\t\t\t\t\tline: this.line,\n\t\t\t\t\t\tcharacter: this.char\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\tthis.trigger(\"Number\", {\n\t\t\t\t\tline: this.line,\n\t\t\t\t\tchar: this.char,\n\t\t\t\t\tfrom: this.from,\n\t\t\t\t\tvalue: token.value,\n\t\t\t\t\tbase: token.base,\n\t\t\t\t\tisMalformed: token.malformed\n\t\t\t\t});\n\n\t\t\t\treturn create(\"(number)\", token.value);\n\n\t\t\tcase Token.RegExp:\n\t\t\t\treturn create(\"(regexp)\", token.value);\n\n\t\t\tcase Token.Comment:\n\t\t\t\tstate.tokens.curr.comment = true;\n\n\t\t\t\tif (token.isSpecial) {\n\t\t\t\t\treturn {\n\t\t\t\t\t\tvalue: token.value,\n\t\t\t\t\t\tbody: token.body,\n\t\t\t\t\t\ttype: token.commentType,\n\t\t\t\t\t\tisSpecial: token.isSpecial,\n\t\t\t\t\t\tline: this.line,\n\t\t\t\t\t\tcharacter: this.char,\n\t\t\t\t\t\tfrom: this.from\n\t\t\t\t\t};\n\t\t\t\t}\n\n\t\t\t\tbreak;\n\n\t\t\tcase \"\":\n\t\t\t\tbreak;\n\n\t\t\tdefault:\n\t\t\t\treturn create(\"(punctuator)\", token.value);\n\t\t\t}\n\t\t}\n\t}\n};\n\nexports.Lexer = Lexer;\n//@ sourceURL=/src/stable/lex.js"
));

require.define("/src/stable/reg.js",Function(['require','module','exports','__dirname','__filename','process','global'],"/*\n * Regular expressions. Some of these are stupidly long.\n */\n\n/*jshint maxlen:1000 */\n\n\"use string\";\n\n// Unsafe comment or string (ax)\nexports.unsafeString =\n\t/@cc|<\\/?|script|\\]\\s*\\]|<\\s*!|&lt/i;\n\n// Unsafe characters that are silently deleted by one or more browsers (cx)\nexports.unsafeChars =\n\t/[\\u0000-\\u001f\\u007f-\\u009f\\u00ad\\u0600-\\u0604\\u070f\\u17b4\\u17b5\\u200c-\\u200f\\u2028-\\u202f\\u2060-\\u206f\\ufeff\\ufff0-\\uffff]/;\n\n// Characters in strings that need escaping (nx and nxg)\nexports.needEsc =\n\t/[\\u0000-\\u001f&<\"\\/\\\\\\u007f-\\u009f\\u00ad\\u0600-\\u0604\\u070f\\u17b4\\u17b5\\u200c-\\u200f\\u2028-\\u202f\\u2060-\\u206f\\ufeff\\ufff0-\\uffff]/;\n\nexports.needEscGlobal =\n\t/[\\u0000-\\u001f&<\"\\/\\\\\\u007f-\\u009f\\u00ad\\u0600-\\u0604\\u070f\\u17b4\\u17b5\\u200c-\\u200f\\u2028-\\u202f\\u2060-\\u206f\\ufeff\\ufff0-\\uffff]/g;\n\n// Star slash (lx)\nexports.starSlash = /\\*\\//;\n\n// Identifier (ix)\nexports.identifier = /^([a-zA-Z_$][a-zA-Z0-9_$]*)$/;\n\n// JavaScript URL (jx)\nexports.javascriptURL = /^(?:javascript|jscript|ecmascript|vbscript|mocha|livescript)\\s*:/i;\n\n// Catches /* falls through */ comments (ft)\nexports.fallsThrough = /^\\s*\\/\\*\\s*falls\\sthrough\\s*\\*\\/\\s*$/;\n//@ sourceURL=/src/stable/reg.js"
));

require.define("/src/stable/state.js",Function(['require','module','exports','__dirname','__filename','process','global'],"\"use strict\";\n\nvar state = {\n\tsyntax: {},\n\n\treset: function () {\n\t\tthis.tokens = {\n\t\t\tprev: null,\n\t\t\tnext: null,\n\t\t\tcurr: null\n\t\t},\n\n\t\tthis.option = {};\n\t\tthis.directive = {};\n\t\tthis.jsonMode = false;\n\t\tthis.lines = [];\n\t\tthis.tab = \"\";\n\t\tthis.cache = {}; // Node.JS doesn't have Map. Sniff.\n\t}\n};\n\nexports.state = state;\n//@ sourceURL=/src/stable/state.js"
));

require.define("/src/stable/style.js",Function(['require','module','exports','__dirname','__filename','process','global'],"\"use strict\";\n\nexports.register = function (linter) {\n\t// Check for properties named __proto__. This special property was\n\t// deprecated and then re-introduced for ES6.\n\n\tlinter.on(\"Identifier\", function style_scanProto(data) {\n\t\tif (linter.getOption(\"proto\")) {\n\t\t\treturn;\n\t\t}\n\n\t\tif (data.name === \"__proto__\") {\n\t\t\tlinter.warn(\"W103\", {\n\t\t\t\tline: data.line,\n\t\t\t\tchar: data.char,\n\t\t\t\tdata: [ data.name ]\n\t\t\t});\n\t\t}\n\t});\n\n\t// Check for properties named __iterator__. This is a special property\n\t// available only in browsers with JavaScript 1.7 implementation.\n\n\tlinter.on(\"Identifier\", function style_scanIterator(data) {\n\t\tif (linter.getOption(\"iterator\")) {\n\t\t\treturn;\n\t\t}\n\n\t\tif (data.name === \"__iterator__\") {\n\t\t\tlinter.warn(\"W104\", {\n\t\t\t\tline: data.line,\n\t\t\t\tchar: data.char,\n\t\t\t\tdata: [ data.name ]\n\t\t\t});\n\t\t}\n\t});\n\n\t// Check for dangling underscores.\n\n\tlinter.on(\"Identifier\", function style_scanDangling(data) {\n\t\tif (!linter.getOption(\"nomen\")) {\n\t\t\treturn;\n\t\t}\n\n\t\t// Underscore.js\n\t\tif (data.name === \"_\") {\n\t\t\treturn;\n\t\t}\n\n\t\t// In Node, __dirname and __filename should be ignored.\n\t\tif (linter.getOption(\"node\")) {\n\t\t\tif (/^(__dirname|__filename)$/.test(data.name) && !data.isProperty) {\n\t\t\t\treturn;\n\t\t\t}\n\t\t}\n\n\t\tif (/^(_+.*|.*_+)$/.test(data.name)) {\n\t\t\tlinter.warn(\"W105\", {\n\t\t\t\tline: data.line,\n\t\t\t\tchar: data.from,\n\t\t\t\tdata: [ \"dangling '_'\", data.name ]\n\t\t\t});\n\t\t}\n\t});\n\n\t// Check that all identifiers are using camelCase notation.\n\t// Exceptions: names like MY_VAR and _myVar.\n\n\tlinter.on(\"Identifier\", function style_scanCamelCase(data) {\n\t\tif (!linter.getOption(\"camelcase\")) {\n\t\t\treturn;\n\t\t}\n\n\t\tif (data.name.replace(/^_+/, \"\").indexOf(\"_\") > -1 && !data.name.match(/^[A-Z0-9_]*$/)) {\n\t\t\tlinter.warn(\"W106\", {\n\t\t\t\tline: data.line,\n\t\t\t\tchar: data.from,\n\t\t\t\tdata: [ data.name ]\n\t\t\t});\n\t\t}\n\t});\n\n\t// Enforce consistency in style of quoting.\n\n\tlinter.on(\"String\", function style_scanQuotes(data) {\n\t\tvar quotmark = linter.getOption(\"quotmark\");\n\t\tvar code;\n\n\t\tif (!quotmark) {\n\t\t\treturn;\n\t\t}\n\n\t\t// If quotmark is set to 'single' warn about all double-quotes.\n\n\t\tif (quotmark === \"single\" && data.quote !== \"'\") {\n\t\t\tcode = \"W109\";\n\t\t}\n\n\t\t// If quotmark is set to 'double' warn about all single-quotes.\n\n\t\tif (quotmark === \"double\" && data.quote !== \"\\\"\") {\n\t\t\tcode = \"W108\";\n\t\t}\n\n\t\t// If quotmark is set to true, remember the first quotation style\n\t\t// and then warn about all others.\n\n\t\tif (quotmark === true) {\n\t\t\tif (!linter.getCache(\"quotmark\")) {\n\t\t\t\tlinter.setCache(\"quotmark\", data.quote);\n\t\t\t}\n\n\t\t\tif (linter.getCache(\"quotmark\") !== data.quote) {\n\t\t\t\tcode = \"W110\";\n\t\t\t}\n\t\t}\n\n\t\tif (code) {\n\t\t\tlinter.warn(code, {\n\t\t\t\tline: data.line,\n\t\t\t\tchar: data.char,\n\t\t\t});\n\t\t}\n\t});\n\n\tlinter.on(\"Number\", function style_scanNumbers(data) {\n\t\tif (data.value.charAt(0) === \".\") {\n\t\t\t// Warn about a leading decimal point.\n\t\t\tlinter.warn(\"W008\", {\n\t\t\t\tline: data.line,\n\t\t\t\tchar: data.char,\n\t\t\t\tdata: [ data.value ]\n\t\t\t});\n\t\t}\n\n\t\tif (data.value.substr(data.value.length - 1) === \".\") {\n\t\t\t// Warn about a trailing decimal point.\n\t\t\tlinter.warn(\"W047\", {\n\t\t\t\tline: data.line,\n\t\t\t\tchar: data.char,\n\t\t\t\tdata: [ data.value ]\n\t\t\t});\n\t\t}\n\n\t\tif (/^00+/.test(data.value)) {\n\t\t\t// Multiple leading zeroes.\n\t\t\tlinter.warn(\"W046\", {\n\t\t\t\tline: data.line,\n\t\t\t\tchar: data.char,\n\t\t\t\tdata: [ data.value ]\n\t\t\t});\n\t\t}\n\t});\n\n\t// Warn about script URLs.\n\n\tlinter.on(\"String\", function style_scanJavaScriptURLs(data) {\n\t\tvar re = /^(?:javascript|jscript|ecmascript|vbscript|mocha|livescript)\\s*:/i;\n\n\t\tif (linter.getOption(\"scripturl\")) {\n\t\t\treturn;\n\t\t}\n\n\t\tif (re.test(data.value)) {\n\t\t\tlinter.warn(\"W107\", {\n\t\t\t\tline: data.line,\n\t\t\t\tchar: data.char\n\t\t\t});\n\t\t}\n\t});\n};\n//@ sourceURL=/src/stable/style.js"
));

require.define("/src/stable/jshint.js",Function(['require','module','exports','__dirname','__filename','process','global'],"/*!\n * JSHint, by JSHint Community.\n *\n * This file (and this file only) is licensed under the same slightly modified\n * MIT license that JSLint is. It stops evil-doers everywhere:\n *\n *\t Copyright (c) 2002 Douglas Crockford  (www.JSLint.com)\n *\n *\t Permission is hereby granted, free of charge, to any person obtaining\n *\t a copy of this software and associated documentation files (the \"Software\"),\n *\t to deal in the Software without restriction, including without limitation\n *\t the rights to use, copy, modify, merge, publish, distribute, sublicense,\n *\t and/or sell copies of the Software, and to permit persons to whom\n *\t the Software is furnished to do so, subject to the following conditions:\n *\n *\t The above copyright notice and this permission notice shall be included\n *\t in all copies or substantial portions of the Software.\n *\n *\t The Software shall be used for Good, not Evil.\n *\n *\t THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n *\t IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n *\t FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n *\t AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n *\t LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n *\t FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n *\t DEALINGS IN THE SOFTWARE.\n *\n */\n\n/*jshint quotmark:double */\n\nvar _        = require(\"underscore\");\nvar events   = require(\"events\");\nvar vars     = require(\"../shared/vars.js\");\nvar messages = require(\"../shared/messages.js\");\nvar Lexer    = require(\"./lex.js\").Lexer;\nvar reg      = require(\"./reg.js\");\nvar state    = require(\"./state.js\").state;\nvar style    = require(\"./style.js\");\n\n// We build the application inside a function so that we produce only a single\n// global variable. That function will be invoked immediately, and its return\n// value is the JSHINT function itself.\n\nvar JSHINT = (function () {\n\t\"use strict\";\n\n\tvar anonname,\t\t// The guessed name for anonymous functions.\n\n// These are operators that should not be used with the ! operator.\n\n\t\tbang = {\n\t\t\t\"<\"  : true,\n\t\t\t\"<=\" : true,\n\t\t\t\"==\" : true,\n\t\t\t\"===\": true,\n\t\t\t\"!==\": true,\n\t\t\t\"!=\" : true,\n\t\t\t\">\"  : true,\n\t\t\t\">=\" : true,\n\t\t\t\"+\"  : true,\n\t\t\t\"-\"  : true,\n\t\t\t\"*\"  : true,\n\t\t\t\"/\"  : true,\n\t\t\t\"%\"  : true\n\t\t},\n\n\t\t// These are the JSHint boolean options.\n\t\tboolOptions = {\n\t\t\tasi         : true, // if automatic semicolon insertion should be tolerated\n\t\t\tbitwise     : true, // if bitwise operators should not be allowed\n\t\t\tboss        : true, // if advanced usage of assignments should be allowed\n\t\t\tbrowser     : true, // if the standard browser globals should be predefined\n\t\t\tcamelcase   : true, // if identifiers should be required in camel case\n\t\t\tcouch       : true, // if CouchDB globals should be predefined\n\t\t\tcurly       : true, // if curly braces around all blocks should be required\n\t\t\tdebug       : true, // if debugger statements should be allowed\n\t\t\tdevel       : true, // if logging globals should be predefined (console, alert, etc.)\n\t\t\tdojo        : true, // if Dojo Toolkit globals should be predefined\n\t\t\teqeqeq      : true, // if === should be required\n\t\t\teqnull      : true, // if == null comparisons should be tolerated\n\t\t\tes5         : true, // if ES5 syntax should be allowed\n\t\t\tesnext      : true, // if es.next specific syntax should be allowed\n\t\t\tevil        : true, // if eval should be allowed\n\t\t\texpr        : true, // if ExpressionStatement should be allowed as Programs\n\t\t\tforin       : true, // if for in statements must filter\n\t\t\tfuncscope   : true, // if only function scope should be used for scope tests\n\t\t\tglobalstrict: true, // if global \"use strict\"; should be allowed (also enables 'strict')\n\t\t\timmed       : true, // if immediate invocations must be wrapped in parens\n\t\t\titerator    : true, // if the `__iterator__` property should be allowed\n\t\t\tjquery      : true, // if jQuery globals should be predefined\n\t\t\tlastsemic   : true, // if semicolons may be ommitted for the trailing\n\t\t\t                    // statements inside of a one-line blocks.\n\t\t\tlatedef     : true, // if the use before definition should not be tolerated\n\t\t\tlaxbreak    : true, // if line breaks should not be checked\n\t\t\tlaxcomma    : true, // if line breaks should not be checked around commas\n\t\t\tloopfunc    : true, // if functions should be allowed to be defined within\n\t\t\t                    // loops\n\t\t\tmootools    : true, // if MooTools globals should be predefined\n\t\t\tmultistr    : true, // allow multiline strings\n\t\t\tnewcap      : true, // if constructor names must be capitalized\n\t\t\tnoarg       : true, // if arguments.caller and arguments.callee should be\n\t\t\t                    // disallowed\n\t\t\tnode        : true, // if the Node.js environment globals should be\n\t\t\t                    // predefined\n\t\t\tnoempty     : true, // if empty blocks should be disallowed\n\t\t\tnonew       : true, // if using `new` for side-effects should be disallowed\n\t\t\tnonstandard : true, // if non-standard (but widely adopted) globals should\n\t\t\t                    // be predefined\n\t\t\tnomen       : true, // if names should be checked\n\t\t\tonevar      : true, // if only one var statement per function should be\n\t\t\t                    // allowed\n\t\t\tpassfail    : true, // if the scan should stop on first error\n\t\t\tplusplus    : true, // if increment/decrement should not be allowed\n\t\t\tproto       : true, // if the `__proto__` property should be allowed\n\t\t\tprototypejs : true, // if Prototype and Scriptaculous globals should be\n\t\t\t                    // predefined\n\t\t\trhino       : true, // if the Rhino environment globals should be predefined\n\t\t\tundef       : true, // if variables should be declared before used\n\t\t\tunused      : true, // if variables should be always used\n\t\t\tscripturl   : true, // if script-targeted URLs should be tolerated\n\t\t\tshadow      : true, // if variable shadowing should be tolerated\n\t\t\tsmarttabs   : true, // if smarttabs should be tolerated\n\t\t\t                    // (http://www.emacswiki.org/emacs/SmartTabs)\n\t\t\tstrict      : true, // require the \"use strict\"; pragma\n\t\t\tsub         : true, // if all forms of subscript notation are tolerated\n\t\t\tsupernew    : true, // if `new function () { ... };` and `new Object;`\n\t\t\t                    // should be tolerated\n\t\t\ttrailing    : true, // if trailing whitespace rules apply\n\t\t\tvalidthis   : true, // if 'this' inside a non-constructor function is valid.\n\t\t\t                    // This is a function scoped option only.\n\t\t\twithstmt    : true, // if with statements should be allowed\n\t\t\twhite       : true, // if strict whitespace rules apply\n\t\t\tworker      : true, // if Web Worker script symbols should be allowed\n\t\t\twsh         : true, // if the Windows Scripting Host environment globals\n\t\t\t                    // should be predefined\n\t\t\tyui         : true, // YUI variables should be predefined\n\n\t\t\t// Obsolete options\n\t\t\tonecase     : true, // if one case switch statements should be allowed\n\t\t\tregexp      : true, // if the . should not be allowed in regexp literals\n\t\t\tregexdash   : true  // if unescaped first/last dash (-) inside brackets\n\t\t\t                    // should be tolerated\n\t\t},\n\n\t\t// These are the JSHint options that can take any value\n\t\t// (we use this object to detect invalid options)\n\t\tvalOptions = {\n\t\t\tmaxlen       : false,\n\t\t\tindent       : false,\n\t\t\tmaxerr       : false,\n\t\t\tpredef       : false,\n\t\t\tquotmark     : false, //'single'|'double'|true\n\t\t\tscope        : false,\n\t\t\tmaxstatements: false, // {int} max statements per function\n\t\t\tmaxdepth     : false, // {int} max nested block depth per function\n\t\t\tmaxparams    : false, // {int} max params per function\n\t\t\tmaxcomplexity: false  // {int} max cyclomatic complexity per function\n\t\t},\n\n\t\t// These are JSHint boolean options which are shared with JSLint\n\t\t// where the definition in JSHint is opposite JSLint\n\t\tinvertedOptions = {\n\t\t\tbitwise : true,\n\t\t\tforin   : true,\n\t\t\tnewcap  : true,\n\t\t\tnomen   : true,\n\t\t\tplusplus: true,\n\t\t\tregexp  : true,\n\t\t\tundef   : true,\n\t\t\twhite   : true,\n\n\t\t\t// Inverted and renamed, use JSHint name here\n\t\t\teqeqeq  : true,\n\t\t\tonevar  : true\n\t\t},\n\n\t\t// These are JSHint boolean options which are shared with JSLint\n\t\t// where the name has been changed but the effect is unchanged\n\t\trenamedOptions = {\n\t\t\teqeq   : \"eqeqeq\",\n\t\t\tvars   : \"onevar\",\n\t\t\twindows: \"wsh\"\n\t\t},\n\n\t\tdeclared, // Globals that were declared using /*global ... */ syntax.\n\t\texported, // Variables that are used outside of the current file.\n\n\t\tfunctionicity = [\n\t\t\t\"closure\", \"exception\", \"global\", \"label\",\n\t\t\t\"outer\", \"unused\", \"var\"\n\t\t],\n\n\t\tfunct, // The current function\n\t\tfunctions, // All of the functions\n\n\t\tglobal, // The global scope\n\t\tignored, // Ignored warnings\n\t\timplied, // Implied globals\n\t\tinblock,\n\t\tindent,\n\t\tlookahead,\n\t\tlex,\n\t\tmember,\n\t\tmembersOnly,\n\t\tnoreach,\n\t\tpredefined,\t\t// Global variables defined by option\n\n\t\tscope,  // The current scope\n\t\tstack,\n\t\tunuseds,\n\t\turls,\n\t\tuseESNextSyntax,\n\t\twarnings,\n\n\t\textraModules = [],\n\t\temitter = new events.EventEmitter();\n\n\tfunction checkOption(name, t) {\n\t\tname = name.trim();\n\n\t\tif (/^-W\\d{3}$/g.test(name)) {\n\t\t\treturn true;\n\t\t}\n\n\t\tif (valOptions[name] === undefined && boolOptions[name] === undefined) {\n\t\t\tif (t.type !== \"jslint\" || renamedOptions[name] === undefined) {\n\t\t\t\terror(\"E001\", t, name);\n\t\t\t\treturn false;\n\t\t\t}\n\t\t}\n\n\t\treturn true;\n\t}\n\n\tfunction isString(obj) {\n\t\treturn Object.prototype.toString.call(obj) === \"[object String]\";\n\t}\n\n\tfunction isIdentifier(tkn, value) {\n\t\tif (!tkn)\n\t\t\treturn false;\n\n\t\tif (!tkn.identifier || tkn.value !== value)\n\t\t\treturn false;\n\n\t\treturn true;\n\t}\n\n\tfunction isReserved(token) {\n\t\tif (!token.reserved) {\n\t\t\treturn false;\n\t\t}\n\n\t\tif (token.meta && token.meta.isFutureReservedWord) {\n\t\t\t// ES3 FutureReservedWord in an ES5 environment.\n\t\t\tif (state.option.es5 && !token.meta.es5) {\n\t\t\t\treturn false;\n\t\t\t}\n\n\t\t\t// Some ES5 FutureReservedWord identifiers are active only\n\t\t\t// within a strict mode environment.\n\t\t\tif (token.meta.strictOnly) {\n\t\t\t\tif (!state.option.strict && !state.directive[\"use strict\"]) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (token.isProperty) {\n\t\t\t\treturn false;\n\t\t\t}\n\t\t}\n\n\t\treturn true;\n\t}\n\n\tfunction supplant(str, data) {\n\t\treturn str.replace(/\\{([^{}]*)\\}/g, function (a, b) {\n\t\t\tvar r = data[b];\n\t\t\treturn typeof r === \"string\" || typeof r === \"number\" ? r : a;\n\t\t});\n\t}\n\n\tfunction combine(t, o) {\n\t\tvar n;\n\t\tfor (n in o) {\n\t\t\tif (_.has(o, n) && !_.has(JSHINT.blacklist, n)) {\n\t\t\t\tt[n] = o[n];\n\t\t\t}\n\t\t}\n\t}\n\n\tfunction updatePredefined() {\n\t\tObject.keys(JSHINT.blacklist).forEach(function (key) {\n\t\t\tdelete predefined[key];\n\t\t});\n\t}\n\n\tfunction assume() {\n\t\tif (state.option.couch) {\n\t\t\tcombine(predefined, vars.couch);\n\t\t}\n\n\t\tif (state.option.rhino) {\n\t\t\tcombine(predefined, vars.rhino);\n\t\t}\n\n\t\tif (state.option.prototypejs) {\n\t\t\tcombine(predefined, vars.prototypejs);\n\t\t}\n\n\t\tif (state.option.node) {\n\t\t\tcombine(predefined, vars.node);\n\t\t}\n\n\t\tif (state.option.devel) {\n\t\t\tcombine(predefined, vars.devel);\n\t\t}\n\n\t\tif (state.option.dojo) {\n\t\t\tcombine(predefined, vars.dojo);\n\t\t}\n\n\t\tif (state.option.browser) {\n\t\t\tcombine(predefined, vars.browser);\n\t\t}\n\n\t\tif (state.option.nonstandard) {\n\t\t\tcombine(predefined, vars.nonstandard);\n\t\t}\n\n\t\tif (state.option.jquery) {\n\t\t\tcombine(predefined, vars.jquery);\n\t\t}\n\n\t\tif (state.option.mootools) {\n\t\t\tcombine(predefined, vars.mootools);\n\t\t}\n\n\t\tif (state.option.worker) {\n\t\t\tcombine(predefined, vars.worker);\n\t\t}\n\n\t\tif (state.option.wsh) {\n\t\t\tcombine(predefined, vars.wsh);\n\t\t}\n\n\t\tif (state.option.esnext) {\n\t\t\tuseESNextSyntax();\n\t\t}\n\n\t\tif (state.option.globalstrict && state.option.strict !== false) {\n\t\t\tstate.option.strict = true;\n\t\t}\n\n\t\tif (state.option.yui) {\n\t\t\tcombine(predefined, vars.yui);\n\t\t}\n\t}\n\n\n\t// Produce an error warning.\n\tfunction quit(code, line, chr) {\n\t\tvar percentage = Math.floor((line / state.lines.length) * 100);\n\t\tvar message = messages.errors[code].desc;\n\n\t\tthrow {\n\t\t\tname: \"JSHintError\",\n\t\t\tline: line,\n\t\t\tcharacter: chr,\n\t\t\tmessage: message + \" (\" + percentage + \"% scanned).\",\n\t\t\traw: message\n\t\t};\n\t}\n\n\tfunction isundef(scope, code, token, a) {\n\t\treturn JSHINT.undefs.push([scope, code, token, a]);\n\t}\n\n\tfunction warning(code, t, a, b, c, d) {\n\t\tvar ch, l, w, msg;\n\n\t\tif (/^W\\d{3}$/.test(code)) {\n\t\t\tif (ignored[code]) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tmsg = messages.warnings[code];\n\t\t} else if (/E\\d{3}/.test(code)) {\n\t\t\tmsg = messages.errors[code];\n\t\t} else if (/I\\d{3}/.test(code)) {\n\t\t\tmsg = messages.info[code];\n\t\t}\n\n\t\tt = t || state.tokens.next;\n\t\tif (t.id === \"(end)\") {  // `~\n\t\t\tt = state.tokens.curr;\n\t\t}\n\n\t\tl = t.line || 0;\n\t\tch = t.from || 0;\n\n\t\tw = {\n\t\t\tid: \"(error)\",\n\t\t\traw: msg.desc,\n\t\t\tcode: msg.code,\n\t\t\tevidence: state.lines[l - 1] || \"\",\n\t\t\tline: l,\n\t\t\tcharacter: ch,\n\t\t\tscope: JSHINT.scope,\n\t\t\ta: a,\n\t\t\tb: b,\n\t\t\tc: c,\n\t\t\td: d\n\t\t};\n\n\t\tw.reason = supplant(msg.desc, w);\n\t\tJSHINT.errors.push(w);\n\n\t\tif (state.option.passfail) {\n\t\t\tquit(\"E042\", l, ch);\n\t\t}\n\n\t\twarnings += 1;\n\t\tif (warnings >= state.option.maxerr) {\n\t\t\tquit(\"E043\", l, ch);\n\t\t}\n\n\t\treturn w;\n\t}\n\n\tfunction warningAt(m, l, ch, a, b, c, d) {\n\t\treturn warning(m, {\n\t\t\tline: l,\n\t\t\tfrom: ch\n\t\t}, a, b, c, d);\n\t}\n\n\tfunction error(m, t, a, b, c, d) {\n\t\twarning(m, t, a, b, c, d);\n\t}\n\n\tfunction errorAt(m, l, ch, a, b, c, d) {\n\t\treturn error(m, {\n\t\t\tline: l,\n\t\t\tfrom: ch\n\t\t}, a, b, c, d);\n\t}\n\n\t// Tracking of \"internal\" scripts, like eval containing a static string\n\tfunction addInternalSrc(elem, src) {\n\t\tvar i;\n\t\ti = {\n\t\t\tid: \"(internal)\",\n\t\t\telem: elem,\n\t\t\tvalue: src\n\t\t};\n\t\tJSHINT.internals.push(i);\n\t\treturn i;\n\t}\n\n\tfunction addlabel(t, type, tkn) {\n\t\t// Define t in the current function in the current scope.\n\t\tif (type === \"exception\") {\n\t\t\tif (_.has(funct[\"(context)\"], t)) {\n\t\t\t\tif (funct[t] !== true && !state.option.node) {\n\t\t\t\t\twarning(\"W002\", state.tokens.next, t);\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\tif (_.has(funct, t) && !funct[\"(global)\"]) {\n\t\t\tif (funct[t] === true) {\n\t\t\t\tif (state.option.latedef)\n\t\t\t\t\twarning(\"W003\", state.tokens.next, t);\n\t\t\t} else {\n\t\t\t\tif (!state.option.shadow && type !== \"exception\") {\n\t\t\t\t\twarning(\"W004\", state.tokens.next, t);\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\tfunct[t] = type;\n\n\t\tif (tkn) {\n\t\t\tfunct[\"(tokens)\"][t] = tkn;\n\t\t}\n\n\t\tif (funct[\"(global)\"]) {\n\t\t\tglobal[t] = funct;\n\t\t\tif (_.has(implied, t)) {\n\t\t\t\tif (state.option.latedef) {\n\t\t\t\t\twarning(\"W003\", state.tokens.next, t);\n\t\t\t\t}\n\n\t\t\t\tdelete implied[t];\n\t\t\t}\n\t\t} else {\n\t\t\tscope[t] = funct;\n\t\t}\n\t}\n\n\tfunction doOption() {\n\t\tvar nt = state.tokens.next;\n\t\tvar body = nt.body.split(\",\").map(function (s) { return s.trim(); });\n\t\tvar predef = {};\n\n\t\tif (nt.type === \"globals\") {\n\t\t\tbody.forEach(function (g) {\n\t\t\t\tg = g.split(\":\");\n\t\t\t\tvar key = g[0];\n\t\t\t\tvar val = g[1];\n\n\t\t\t\tif (key.charAt(0) === \"-\") {\n\t\t\t\t\tkey = key.slice(1);\n\t\t\t\t\tval = false;\n\n\t\t\t\t\tJSHINT.blacklist[key] = key;\n\t\t\t\t\tupdatePredefined();\n\t\t\t\t} else {\n\t\t\t\t\tpredef[key] = (val === \"true\");\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tcombine(predefined, predef);\n\n\t\t\tfor (var key in predef) {\n\t\t\t\tif (_.has(predef, key)) {\n\t\t\t\t\tdeclared[key] = nt;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\tif (nt.type === \"exported\") {\n\t\t\tbody.forEach(function (e) {\n\t\t\t\texported[e] = true;\n\t\t\t});\n\t\t}\n\n\t\tif (nt.type === \"members\") {\n\t\t\tmembersOnly = membersOnly || {};\n\n\t\t\tbody.forEach(function (m) {\n\t\t\t\tvar ch1 = m.charAt(0);\n\t\t\t\tvar ch2 = m.charAt(m.length - 1);\n\n\t\t\t\tif (ch1 === ch2 && (ch1 === \"\\\"\" || ch1 === \"'\")) {\n\t\t\t\t\tm = m\n\t\t\t\t\t\t.substr(1, m.length - 2)\n\t\t\t\t\t\t.replace(\"\\\\b\", \"\\b\")\n\t\t\t\t\t\t.replace(\"\\\\t\", \"\\t\")\n\t\t\t\t\t\t.replace(\"\\\\n\", \"\\n\")\n\t\t\t\t\t\t.replace(\"\\\\v\", \"\\v\")\n\t\t\t\t\t\t.replace(\"\\\\f\", \"\\f\")\n\t\t\t\t\t\t.replace(\"\\\\r\", \"\\r\")\n\t\t\t\t\t\t.replace(\"\\\\\\\\\", \"\\\\\")\n\t\t\t\t\t\t.replace(\"\\\\\\\"\", \"\\\"\");\n\t\t\t\t}\n\n\t\t\t\tmembersOnly[m] = false;\n\t\t\t});\n\t\t}\n\n\t\tvar numvals = [\n\t\t\t\"maxstatements\",\n\t\t\t\"maxparams\",\n\t\t\t\"maxdepth\",\n\t\t\t\"maxcomplexity\",\n\t\t\t\"maxerr\",\n\t\t\t\"maxlen\",\n\t\t\t\"indent\"\n\t\t];\n\n\t\tif (nt.type === \"jshint\" || nt.type === \"jslint\") {\n\t\t\tbody.forEach(function (g) {\n\t\t\t\tg = g.split(\":\");\n\t\t\t\tvar key = (g[0] || \"\").trim();\n\t\t\t\tvar val = (g[1] || \"\").trim();\n\n\t\t\t\tif (!checkOption(key, nt)) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif (numvals.indexOf(key) >= 0) {\n\t\t\t\t\tval = +val;\n\n\t\t\t\t\tif (typeof val !== \"number\" || !isFinite(val) || val <= 0 || Math.floor(val) !== val) {\n\t\t\t\t\t\terror(\"E032\", nt, g[1].trim());\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (key === \"indent\") {\n\t\t\t\t\t\tstate.option[\"(explicitIndent)\"] = true;\n\t\t\t\t\t}\n\n\t\t\t\t\tstate.option[key] = val;\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif (key === \"validthis\") {\n\t\t\t\t\t// `validthis` is valid only within a function scope.\n\t\t\t\t\tif (funct[\"(global)\"]) {\n\t\t\t\t\t\terror(\"E009\");\n\t\t\t\t\t} else {\n\t\t\t\t\t\tif (val === \"true\" || val === \"false\") {\n\t\t\t\t\t\t\tstate.option.validthis = (val === \"true\");\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\terror(\"E002\", nt);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif (key === \"quotmark\") {\n\t\t\t\t\tswitch (val) {\n\t\t\t\t\tcase \"true\":\n\t\t\t\t\tcase \"false\":\n\t\t\t\t\t\tstate.option.quotmark = (val === \"true\");\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase \"double\":\n\t\t\t\t\tcase \"single\":\n\t\t\t\t\t\tstate.option.quotmark = val;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tdefault:\n\t\t\t\t\t\terror(\"E002\", nt);\n\t\t\t\t\t}\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif (/^-W\\d{3}$/g.test(key)) {\n\t\t\t\t\tignored[key.slice(1)] = true;\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tvar tn;\n\t\t\t\tif (val === \"true\" || val === \"false\") {\n\t\t\t\t\tif (nt.type === \"jslint\") {\n\t\t\t\t\t\ttn = renamedOptions[key] || key;\n\t\t\t\t\t\tstate.option[tn] = (val === \"true\");\n\n\t\t\t\t\t\tif (invertedOptions[tn] !== undefined) {\n\t\t\t\t\t\t\tstate.option[tn] = !state.option[tn];\n\t\t\t\t\t\t}\n\t\t\t\t\t} else {\n\t\t\t\t\t\tstate.option[key] = (val === \"true\");\n\t\t\t\t\t}\n\n\t\t\t\t\tif (key === \"newcap\") {\n\t\t\t\t\t\tstate.option[\"(explicitNewcap)\"] = true;\n\t\t\t\t\t}\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\terror(\"E002\", nt);\n\t\t\t});\n\n\t\t\tassume();\n\t\t}\n\t}\n\n\t// We need a peek function. If it has an argument, it peeks that much farther\n\t// ahead. It is used to distinguish\n\t//\t   for ( var i in ...\n\t// from\n\t//\t   for ( var i = ...\n\n\tfunction peek(p) {\n\t\tvar i = p || 0, j = 0, t;\n\n\t\twhile (j <= i) {\n\t\t\tt = lookahead[j];\n\t\t\tif (!t) {\n\t\t\t\tt = lookahead[j] = lex.token();\n\t\t\t}\n\t\t\tj += 1;\n\t\t}\n\t\treturn t;\n\t}\n\n\t// Produce the next token. It looks for programming errors.\n\n\tfunction advance(id, t) {\n\t\tswitch (state.tokens.curr.id) {\n\t\tcase \"(number)\":\n\t\t\tif (state.tokens.next.id === \".\") {\n\t\t\t\twarning(\"W005\", state.tokens.curr);\n\t\t\t}\n\t\t\tbreak;\n\t\tcase \"-\":\n\t\t\tif (state.tokens.next.id === \"-\" || state.tokens.next.id === \"--\") {\n\t\t\t\twarning(\"W006\");\n\t\t\t}\n\t\t\tbreak;\n\t\tcase \"+\":\n\t\t\tif (state.tokens.next.id === \"+\" || state.tokens.next.id === \"++\") {\n\t\t\t\twarning(\"W007\");\n\t\t\t}\n\t\t\tbreak;\n\t\t}\n\n\t\tif (state.tokens.curr.type === \"(string)\" || state.tokens.curr.identifier) {\n\t\t\tanonname = state.tokens.curr.value;\n\t\t}\n\n\t\tif (id && state.tokens.next.id !== id) {\n\t\t\tif (t) {\n\t\t\t\tif (state.tokens.next.id === \"(end)\") {\n\t\t\t\t\terror(\"E019\", t, t.id);\n\t\t\t\t} else {\n\t\t\t\t\terror(\"E020\", state.tokens.next, id, t.id, t.line, state.tokens.next.value);\n\t\t\t\t}\n\t\t\t} else if (state.tokens.next.type !== \"(identifier)\" || state.tokens.next.value !== id) {\n\t\t\t\twarning(\"W116\", state.tokens.next, id, state.tokens.next.value);\n\t\t\t}\n\t\t}\n\n\t\tstate.tokens.prev = state.tokens.curr;\n\t\tstate.tokens.curr = state.tokens.next;\n\t\tfor (;;) {\n\t\t\tstate.tokens.next = lookahead.shift() || lex.token();\n\n\t\t\tif (!state.tokens.next) { // No more tokens left, give up\n\t\t\t\tquit(\"E041\", state.tokens.curr.line);\n\t\t\t}\n\n\t\t\tif (state.tokens.next.id === \"(end)\" || state.tokens.next.id === \"(error)\") {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tif (state.tokens.next.isSpecial) {\n\t\t\t\tdoOption();\n\t\t\t} else {\n\t\t\t\tif (state.tokens.next.id !== \"(endline)\") {\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\n\n\t// This is the heart of JSHINT, the Pratt parser. In addition to parsing, it\n\t// is looking for ad hoc lint patterns. We add .fud to Pratt's model, which is\n\t// like .nud except that it is only used on the first token of a statement.\n\t// Having .fud makes it much easier to define statement-oriented languages like\n\t// JavaScript. I retained Pratt's nomenclature.\n\n\t// .nud  Null denotation\n\t// .fud  First null denotation\n\t// .led  Left denotation\n\t//  lbp  Left binding power\n\t//  rbp  Right binding power\n\n\t// They are elements of the parsing method called Top Down Operator Precedence.\n\n\tfunction expression(rbp, initial) {\n\t\tvar left, isArray = false, isObject = false;\n\n\t\tif (state.tokens.next.id === \"(end)\")\n\t\t\terror(\"E006\", state.tokens.curr);\n\n\t\tadvance();\n\n\t\tif (initial) {\n\t\t\tanonname = \"anonymous\";\n\t\t\tfunct[\"(verb)\"] = state.tokens.curr.value;\n\t\t}\n\n\t\tif (initial === true && state.tokens.curr.fud) {\n\t\t\tleft = state.tokens.curr.fud();\n\t\t} else {\n\t\t\tif (state.tokens.curr.nud) {\n\t\t\t\tleft = state.tokens.curr.nud();\n\t\t\t} else {\n\t\t\t\terror(\"E030\", state.tokens.curr, state.tokens.curr.id);\n\t\t\t}\n\n\t\t\twhile (rbp < state.tokens.next.lbp) {\n\t\t\t\tisArray = state.tokens.curr.value === \"Array\";\n\t\t\t\tisObject = state.tokens.curr.value === \"Object\";\n\n\t\t\t\t// #527, new Foo.Array(), Foo.Array(), new Foo.Object(), Foo.Object()\n\t\t\t\t// Line breaks in IfStatement heads exist to satisfy the checkJSHint\n\t\t\t\t// \"Line too long.\" error.\n\t\t\t\tif (left && (left.value || (left.first && left.first.value))) {\n\t\t\t\t\t// If the left.value is not \"new\", or the left.first.value is a \".\"\n\t\t\t\t\t// then safely assume that this is not \"new Array()\" and possibly\n\t\t\t\t\t// not \"new Object()\"...\n\t\t\t\t\tif (left.value !== \"new\" ||\n\t\t\t\t\t  (left.first && left.first.value && left.first.value === \".\")) {\n\t\t\t\t\t\tisArray = false;\n\t\t\t\t\t\t// ...In the case of Object, if the left.value and state.tokens.curr.value\n\t\t\t\t\t\t// are not equal, then safely assume that this not \"new Object()\"\n\t\t\t\t\t\tif (left.value !== state.tokens.curr.value) {\n\t\t\t\t\t\t\tisObject = false;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tadvance();\n\n\t\t\t\tif (isArray && state.tokens.curr.id === \"(\" && state.tokens.next.id === \")\") {\n\t\t\t\t\twarning(\"W009\", state.tokens.curr);\n\t\t\t\t}\n\n\t\t\t\tif (isObject && state.tokens.curr.id === \"(\" && state.tokens.next.id === \")\") {\n\t\t\t\t\twarning(\"W010\", state.tokens.curr);\n\t\t\t\t}\n\n\t\t\t\tif (state.tokens.curr.led) {\n\t\t\t\t\tleft = state.tokens.curr.led(left);\n\t\t\t\t} else {\n\t\t\t\t\terror(\"E033\", state.tokens.curr, state.tokens.curr.id);\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\treturn left;\n\t}\n\n\n// Functions for conformance of style.\n\n\tfunction adjacent(left, right) {\n\t\tleft = left || state.tokens.curr;\n\t\tright = right || state.tokens.next;\n\t\tif (state.option.white) {\n\t\t\tif (left.character !== right.from && left.line === right.line) {\n\t\t\t\tleft.from += (left.character - left.from);\n\t\t\t\twarning(\"W011\", left, left.value);\n\t\t\t}\n\t\t}\n\t}\n\n\tfunction nobreak(left, right) {\n\t\tleft = left || state.tokens.curr;\n\t\tright = right || state.tokens.next;\n\t\tif (state.option.white && (left.character !== right.from || left.line !== right.line)) {\n\t\t\twarning(\"W012\", right, right.value);\n\t\t}\n\t}\n\n\tfunction nospace(left, right) {\n\t\tleft = left || state.tokens.curr;\n\t\tright = right || state.tokens.next;\n\t\tif (state.option.white && !left.comment) {\n\t\t\tif (left.line === right.line) {\n\t\t\t\tadjacent(left, right);\n\t\t\t}\n\t\t}\n\t}\n\n\tfunction nonadjacent(left, right) {\n\t\tif (state.option.white) {\n\t\t\tleft = left || state.tokens.curr;\n\t\t\tright = right || state.tokens.next;\n\n\t\t\tif (left.value === \";\" && right.value === \";\") {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tif (left.line === right.line && left.character === right.from) {\n\t\t\t\tleft.from += (left.character - left.from);\n\t\t\t\twarning(\"W013\", left, left.value);\n\t\t\t}\n\t\t}\n\t}\n\n\tfunction nobreaknonadjacent(left, right) {\n\t\tleft = left || state.tokens.curr;\n\t\tright = right || state.tokens.next;\n\t\tif (!state.option.laxbreak && left.line !== right.line) {\n\t\t\twarning(\"W014\", right, right.id);\n\t\t} else if (state.option.white) {\n\t\t\tleft = left || state.tokens.curr;\n\t\t\tright = right || state.tokens.next;\n\t\t\tif (left.character === right.from) {\n\t\t\t\tleft.from += (left.character - left.from);\n\t\t\t\twarning(\"W013\", left, left.value);\n\t\t\t}\n\t\t}\n\t}\n\n\tfunction indentation(bias) {\n\t\tif (!state.option.white && !state.option[\"(explicitIndent)\"]) {\n\t\t\treturn;\n\t\t}\n\n\t\tif (state.tokens.next.id === \"(end)\") {\n\t\t\treturn;\n\t\t}\n\n\t\tvar i = indent + (bias || 0);\n\t\tif (state.tokens.next.from !== i) {\n\t\t\twarning(\"W015\", state.tokens.next, state.tokens.next.value, i, state.tokens.next.from);\n\t\t}\n\t}\n\n\tfunction nolinebreak(t) {\n\t\tt = t || state.tokens.curr;\n\t\tif (t.line !== state.tokens.next.line) {\n\t\t\twarning(\"E022\", t, t.value);\n\t\t}\n\t}\n\n\n\tfunction comma(opts) {\n\t\topts = opts || {};\n\n\t\tif (state.tokens.curr.line !== state.tokens.next.line) {\n\t\t\tif (!state.option.laxcomma) {\n\t\t\t\tif (comma.first) {\n\t\t\t\t\twarning(\"I001\");\n\t\t\t\t\tcomma.first = false;\n\t\t\t\t}\n\t\t\t\twarning(\"W014\", state.tokens.curr, state.tokens.next.id);\n\t\t\t}\n\t\t} else if (!state.tokens.curr.comment &&\n\t\t\t\tstate.tokens.curr.character !== state.tokens.next.from && state.option.white) {\n\t\t\tstate.tokens.curr.from += (state.tokens.curr.character - state.tokens.curr.from);\n\t\t\twarning(\"W011\", state.tokens.curr, state.tokens.curr.value);\n\t\t}\n\n\t\tadvance(\",\");\n\n\t\t// TODO: This is a temporary solution to fight against false-positives in\n\t\t// arrays and objects with trailing commas (see GH-363). The best solution\n\t\t// would be to extract all whitespace rules out of parser.\n\n\t\tif (state.tokens.next.value !== \"]\" && state.tokens.next.value !== \"}\") {\n\t\t\tnonadjacent(state.tokens.curr, state.tokens.next);\n\t\t}\n\n\t\tif (state.tokens.next.identifier) {\n\t\t\t// Keywords that cannot follow a comma operator.\n\t\t\tswitch (state.tokens.next.value) {\n\t\t\tcase \"break\":\n\t\t\tcase \"case\":\n\t\t\tcase \"catch\":\n\t\t\tcase \"continue\":\n\t\t\tcase \"default\":\n\t\t\tcase \"do\":\n\t\t\tcase \"else\":\n\t\t\tcase \"finally\":\n\t\t\tcase \"for\":\n\t\t\tcase \"if\":\n\t\t\tcase \"in\":\n\t\t\tcase \"instanceof\":\n\t\t\tcase \"return\":\n\t\t\tcase \"switch\":\n\t\t\tcase \"throw\":\n\t\t\tcase \"try\":\n\t\t\tcase \"var\":\n\t\t\tcase \"while\":\n\t\t\tcase \"with\":\n\t\t\t\terror(\"E024\", state.tokens.next, state.tokens.next.value);\n\t\t\t\treturn;\n\t\t\t}\n\t\t}\n\n\t\tif (state.tokens.next.type === \"(punctuator)\") {\n\t\t\tswitch (state.tokens.next.value) {\n\t\t\tcase \"}\":\n\t\t\tcase \"]\":\n\t\t\tcase \",\":\n\t\t\t\tif (opts.allowTrailing) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\t/* falls through */\n\t\t\tcase \")\":\n\t\t\t\terror(\"E024\", state.tokens.next, state.tokens.next.value);\n\t\t\t}\n\t\t}\n\t}\n\n\t// Functional constructors for making the symbols that will be inherited by\n\t// tokens.\n\n\tfunction symbol(s, p) {\n\t\tvar x = state.syntax[s];\n\t\tif (!x || typeof x !== \"object\") {\n\t\t\tstate.syntax[s] = x = {\n\t\t\t\tid: s,\n\t\t\t\tlbp: p,\n\t\t\t\tvalue: s\n\t\t\t};\n\t\t}\n\t\treturn x;\n\t}\n\n\tfunction delim(s) {\n\t\treturn symbol(s, 0);\n\t}\n\n\tfunction stmt(s, f) {\n\t\tvar x = delim(s);\n\t\tx.identifier = x.reserved = true;\n\t\tx.fud = f;\n\t\treturn x;\n\t}\n\n\tfunction blockstmt(s, f) {\n\t\tvar x = stmt(s, f);\n\t\tx.block = true;\n\t\treturn x;\n\t}\n\n\tfunction reserveName(x) {\n\t\tvar c = x.id.charAt(0);\n\t\tif ((c >= \"a\" && c <= \"z\") || (c >= \"A\" && c <= \"Z\")) {\n\t\t\tx.identifier = x.reserved = true;\n\t\t}\n\t\treturn x;\n\t}\n\n\tfunction prefix(s, f) {\n\t\tvar x = symbol(s, 150);\n\t\treserveName(x);\n\t\tx.nud = (typeof f === \"function\") ? f : function () {\n\t\t\tthis.right = expression(150);\n\t\t\tthis.arity = \"unary\";\n\t\t\tif (this.id === \"++\" || this.id === \"--\") {\n\t\t\t\tif (state.option.plusplus) {\n\t\t\t\t\twarning(\"W016\", this, this.id);\n\t\t\t\t} else if ((!this.right.identifier || isReserved(this.right)) &&\n\t\t\t\t\t\tthis.right.id !== \".\" && this.right.id !== \"[\") {\n\t\t\t\t\twarning(\"W017\", this);\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn this;\n\t\t};\n\t\treturn x;\n\t}\n\n\tfunction type(s, f) {\n\t\tvar x = delim(s);\n\t\tx.type = s;\n\t\tx.nud = f;\n\t\treturn x;\n\t}\n\n\tfunction reserve(name, func) {\n\t\tvar x = type(name, func);\n\t\tx.identifier = true;\n\t\tx.reserved = true;\n\t\treturn x;\n\t}\n\n\tfunction FutureReservedWord(name, meta) {\n\t\tvar x = type(name, function () {\n\t\t\treturn this;\n\t\t});\n\n\t\tmeta = meta || {};\n\t\tmeta.isFutureReservedWord = true;\n\n\t\tx.value = name;\n\t\tx.identifier = true;\n\t\tx.reserved = true;\n\t\tx.meta = meta;\n\n\t\treturn x;\n\t}\n\n\tfunction reservevar(s, v) {\n\t\treturn reserve(s, function () {\n\t\t\tif (typeof v === \"function\") {\n\t\t\t\tv(this);\n\t\t\t}\n\t\t\treturn this;\n\t\t});\n\t}\n\n\tfunction infix(s, f, p, w) {\n\t\tvar x = symbol(s, p);\n\t\treserveName(x);\n\t\tx.led = function (left) {\n\t\t\tif (!w) {\n\t\t\t\tnobreaknonadjacent(state.tokens.prev, state.tokens.curr);\n\t\t\t\tnonadjacent(state.tokens.curr, state.tokens.next);\n\t\t\t}\n\t\t\tif (s === \"in\" && left.id === \"!\") {\n\t\t\t\twarning(\"W018\", left, \"!\");\n\t\t\t}\n\t\t\tif (typeof f === \"function\") {\n\t\t\t\treturn f(left, this);\n\t\t\t} else {\n\t\t\t\tthis.left = left;\n\t\t\t\tthis.right = expression(p);\n\t\t\t\treturn this;\n\t\t\t}\n\t\t};\n\t\treturn x;\n\t}\n\n\tfunction relation(s, f) {\n\t\tvar x = symbol(s, 100);\n\n\t\tx.led = function (left) {\n\t\t\tnobreaknonadjacent(state.tokens.prev, state.tokens.curr);\n\t\t\tnonadjacent(state.tokens.curr, state.tokens.next);\n\t\t\tvar right = expression(100);\n\n\t\t\tif (isIdentifier(left, \"NaN\") || isIdentifier(right, \"NaN\")) {\n\t\t\t\twarning(\"W019\", this);\n\t\t\t} else if (f) {\n\t\t\t\tf.apply(this, [left, right]);\n\t\t\t}\n\n\t\t\tif (!left || !right) {\n\t\t\t\tquit(\"E041\", state.tokens.curr.line);\n\t\t\t}\n\n\t\t\tif (left.id === \"!\") {\n\t\t\t\twarning(\"W018\", left, \"!\");\n\t\t\t}\n\n\t\t\tif (right.id === \"!\") {\n\t\t\t\twarning(\"W018\", right, \"!\");\n\t\t\t}\n\n\t\t\tthis.left = left;\n\t\t\tthis.right = right;\n\t\t\treturn this;\n\t\t};\n\t\treturn x;\n\t}\n\n\tfunction isPoorRelation(node) {\n\t\treturn node &&\n\t\t\t  ((node.type === \"(number)\" && +node.value === 0) ||\n\t\t\t   (node.type === \"(string)\" && node.value === \"\") ||\n\t\t\t   (node.type === \"null\" && !state.option.eqnull) ||\n\t\t\t\tnode.type === \"true\" ||\n\t\t\t\tnode.type === \"false\" ||\n\t\t\t\tnode.type === \"undefined\");\n\t}\n\n\tfunction assignop(s) {\n\t\tsymbol(s, 20).exps = true;\n\n\t\treturn infix(s, function (left, that) {\n\t\t\tthat.left = left;\n\n\t\t\tif (predefined[left.value] === false &&\n\t\t\t\t\tscope[left.value][\"(global)\"] === true) {\n\t\t\t\twarning(\"W020\", left);\n\t\t\t} else if (left[\"function\"]) {\n\t\t\t\twarning(\"W021\", left, left.value);\n\t\t\t}\n\n\t\t\tif (left) {\n\t\t\t\tif (state.option.esnext && funct[left.value] === \"const\") {\n\t\t\t\t\terror(\"E013\", left, left.value);\n\t\t\t\t}\n\n\t\t\t\tif (left.id === \".\" || left.id === \"[\") {\n\t\t\t\t\tif (!left.left || left.left.value === \"arguments\") {\n\t\t\t\t\t\twarning(\"E031\", that);\n\t\t\t\t\t}\n\t\t\t\t\tthat.right = expression(19);\n\t\t\t\t\treturn that;\n\t\t\t\t} else if (left.identifier && !isReserved(left)) {\n\t\t\t\t\tif (funct[left.value] === \"exception\") {\n\t\t\t\t\t\twarning(\"W022\", left);\n\t\t\t\t\t}\n\t\t\t\t\tthat.right = expression(19);\n\t\t\t\t\treturn that;\n\t\t\t\t}\n\n\t\t\t\tif (left === state.syntax[\"function\"]) {\n\t\t\t\t\twarning(\"W023\", state.tokens.curr);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\terror(\"E031\", that);\n\t\t}, 20);\n\t}\n\n\n\tfunction bitwise(s, f, p) {\n\t\tvar x = symbol(s, p);\n\t\treserveName(x);\n\t\tx.led = (typeof f === \"function\") ? f : function (left) {\n\t\t\tif (state.option.bitwise) {\n\t\t\t\twarning(\"W016\", this, this.id);\n\t\t\t}\n\t\t\tthis.left = left;\n\t\t\tthis.right = expression(p);\n\t\t\treturn this;\n\t\t};\n\t\treturn x;\n\t}\n\n\n\tfunction bitwiseassignop(s) {\n\t\tsymbol(s, 20).exps = true;\n\t\treturn infix(s, function (left, that) {\n\t\t\tif (state.option.bitwise) {\n\t\t\t\twarning(\"W016\", that, that.id);\n\t\t\t}\n\t\t\tnonadjacent(state.tokens.prev, state.tokens.curr);\n\t\t\tnonadjacent(state.tokens.curr, state.tokens.next);\n\t\t\tif (left) {\n\t\t\t\tif (left.id === \".\" || left.id === \"[\" ||\n\t\t\t\t\t\t(left.identifier && !isReserved(left))) {\n\t\t\t\t\texpression(19);\n\t\t\t\t\treturn that;\n\t\t\t\t}\n\t\t\t\tif (left === state.syntax[\"function\"]) {\n\t\t\t\t\twarning(\"W023\", state.tokens.curr);\n\t\t\t\t}\n\t\t\t\treturn that;\n\t\t\t}\n\t\t\terror(\"E031\", that);\n\t\t}, 20);\n\t}\n\n\n\tfunction suffix(s) {\n\t\tvar x = symbol(s, 150);\n\n\t\tx.led = function (left) {\n\t\t\tif (state.option.plusplus) {\n\t\t\t\twarning(\"W016\", this, this.id);\n\t\t\t} else if ((!left.identifier || isReserved(left)) && left.id !== \".\" && left.id !== \"[\") {\n\t\t\t\twarning(\"W017\", this);\n\t\t\t}\n\n\t\t\tthis.left = left;\n\t\t\treturn this;\n\t\t};\n\t\treturn x;\n\t}\n\n\t// fnparam means that this identifier is being defined as a function\n\t// argument (see identifier())\n\t// prop means that this identifier is that of an object property\n\n\tfunction optionalidentifier(fnparam, prop) {\n\t\tif (!state.tokens.next.identifier) {\n\t\t\treturn;\n\t\t}\n\n\t\tadvance();\n\n\t\tvar curr = state.tokens.curr;\n\t\tvar meta = curr.meta || {};\n\t\tvar val  = state.tokens.curr.value;\n\n\t\tif (!isReserved(curr)) {\n\t\t\treturn val;\n\t\t}\n\n\t\tif (prop) {\n\t\t\tif (state.option.es5 || meta.isFutureReservedWord) {\n\t\t\t\treturn val;\n\t\t\t}\n\t\t}\n\n\t\tif (fnparam && val === \"undefined\") {\n\t\t\treturn val;\n\t\t}\n\n\t\twarning(\"W024\", state.tokens.curr, state.tokens.curr.id);\n\t\treturn val;\n\t}\n\n\t// fnparam means that this identifier is being defined as a function\n\t// argument\n\t// prop means that this identifier is that of an object property\n\tfunction identifier(fnparam, prop) {\n\t\tvar i = optionalidentifier(fnparam, prop);\n\t\tif (i) {\n\t\t\treturn i;\n\t\t}\n\t\tif (state.tokens.curr.id === \"function\" && state.tokens.next.id === \"(\") {\n\t\t\twarning(\"W025\");\n\t\t} else {\n\t\t\terror(\"E030\", state.tokens.next, state.tokens.next.value);\n\t\t}\n\t}\n\n\n\tfunction reachable(s) {\n\t\tvar i = 0, t;\n\t\tif (state.tokens.next.id !== \";\" || noreach) {\n\t\t\treturn;\n\t\t}\n\t\tfor (;;) {\n\t\t\tt = peek(i);\n\t\t\tif (t.reach) {\n\t\t\t\treturn;\n\t\t\t}\n\t\t\tif (t.id !== \"(endline)\") {\n\t\t\t\tif (t.id === \"function\") {\n\t\t\t\t\tif (!state.option.latedef) {\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\n\t\t\t\t\twarning(\"W026\", t);\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\n\t\t\t\twarning(\"W027\", t, t.value, s);\n\t\t\t\tbreak;\n\t\t\t}\n\t\t\ti += 1;\n\t\t}\n\t}\n\n\n\tfunction statement(noindent) {\n\t\tvar i = indent, r, s = scope, t = state.tokens.next;\n\n\t\tif (t.id === \";\") {\n\t\t\tadvance(\";\");\n\t\t\treturn;\n\t\t}\n\n\t\t// Is this a labelled statement?\n\t\tvar res = isReserved(t);\n\n\t\t// We're being more tolerant here: if someone uses\n\t\t// a FutureReservedWord as a label, we warn but proceed\n\t\t// anyway.\n\n\t\tif (res && t.meta && t.meta.isFutureReservedWord) {\n\t\t\twarning(\"W024\", t, t.id);\n\t\t\tres = false;\n\t\t}\n\n\t\tif (t.identifier && !res && peek().id === \":\") {\n\t\t\tadvance();\n\t\t\tadvance(\":\");\n\t\t\tscope = Object.create(s);\n\t\t\taddlabel(t.value, \"label\");\n\n\t\t\tif (!state.tokens.next.labelled && state.tokens.next.value !== \"{\") {\n\t\t\t\twarning(\"W028\", state.tokens.next, t.value, state.tokens.next.value);\n\t\t\t}\n\n\t\t\tif (reg.javascriptURL.test(t.value + \":\")) {\n\t\t\t\twarning(\"W029\", t, t.value);\n\t\t\t}\n\n\t\t\tstate.tokens.next.label = t.value;\n\t\t\tt = state.tokens.next;\n\t\t}\n\n\t\t// Is it a lonely block?\n\n\t\tif (t.id === \"{\") {\n\t\t\tblock(true, true);\n\t\t\treturn;\n\t\t}\n\n\t\t// Parse the statement.\n\n\t\tif (!noindent) {\n\t\t\tindentation();\n\t\t}\n\t\tr = expression(0, true);\n\n\t\t// Look for the final semicolon.\n\n\t\tif (!t.block) {\n\t\t\tif (!state.option.expr && (!r || !r.exps)) {\n\t\t\t\twarning(\"W030\", state.tokens.curr);\n\t\t\t} else if (state.option.nonew && r.id === \"(\" && r.left.id === \"new\") {\n\t\t\t\twarning(\"W031\", t);\n\t\t\t}\n\n\t\t\tif (state.tokens.next.id === \",\") {\n\t\t\t\treturn comma();\n\t\t\t}\n\n\t\t\tif (state.tokens.next.id !== \";\") {\n\t\t\t\tif (!state.option.asi) {\n\t\t\t\t\t// If this is the last statement in a block that ends on\n\t\t\t\t\t// the same line *and* option lastsemic is on, ignore the warning.\n\t\t\t\t\t// Otherwise, complain about missing semicolon.\n\t\t\t\t\tif (!state.option.lastsemic || state.tokens.next.id !== \"}\" ||\n\t\t\t\t\t\tstate.tokens.next.line !== state.tokens.curr.line) {\n\t\t\t\t\t\twarningAt(\"W033\", state.tokens.curr.line, state.tokens.curr.character);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tadjacent(state.tokens.curr, state.tokens.next);\n\t\t\t\tadvance(\";\");\n\t\t\t\tnonadjacent(state.tokens.curr, state.tokens.next);\n\t\t\t}\n\t\t}\n\n\t\t// Restore the indentation.\n\n\t\tindent = i;\n\t\tscope = s;\n\t\treturn r;\n\t}\n\n\n\tfunction statements(startLine) {\n\t\tvar a = [], p;\n\n\t\twhile (!state.tokens.next.reach && state.tokens.next.id !== \"(end)\") {\n\t\t\tif (state.tokens.next.id === \";\") {\n\t\t\t\tp = peek();\n\n\t\t\t\tif (!p || (p.id !== \"(\" && p.id !== \"[\")) {\n\t\t\t\t\twarning(\"W032\");\n\t\t\t\t}\n\n\t\t\t\tadvance(\";\");\n\t\t\t} else {\n\t\t\t\ta.push(statement(startLine === state.tokens.next.line));\n\t\t\t}\n\t\t}\n\t\treturn a;\n\t}\n\n\n\t/*\n\t * read all directives\n\t * recognizes a simple form of asi, but always\n\t * warns, if it is used\n\t */\n\tfunction directives() {\n\t\tvar i, p, pn;\n\n\t\tfor (;;) {\n\t\t\tif (state.tokens.next.id === \"(string)\") {\n\t\t\t\tp = peek(0);\n\t\t\t\tif (p.id === \"(endline)\") {\n\t\t\t\t\ti = 1;\n\t\t\t\t\tdo {\n\t\t\t\t\t\tpn = peek(i);\n\t\t\t\t\t\ti = i + 1;\n\t\t\t\t\t} while (pn.id === \"(endline)\");\n\n\t\t\t\t\tif (pn.id !== \";\") {\n\t\t\t\t\t\tif (pn.id !== \"(string)\" && pn.id !== \"(number)\" &&\n\t\t\t\t\t\t\tpn.id !== \"(regexp)\" && pn.identifier !== true &&\n\t\t\t\t\t\t\tpn.id !== \"}\") {\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\t\t\t\t\t\twarning(\"W033\", state.tokens.next);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tp = pn;\n\t\t\t\t\t}\n\t\t\t\t} else if (p.id === \"}\") {\n\t\t\t\t\t// Directive with no other statements, warn about missing semicolon\n\t\t\t\t\twarning(\"W033\", p);\n\t\t\t\t} else if (p.id !== \";\") {\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\n\t\t\t\tindentation();\n\t\t\t\tadvance();\n\t\t\t\tif (state.directive[state.tokens.curr.value]) {\n\t\t\t\t\twarning(\"W034\", state.tokens.curr, state.tokens.curr.value);\n\t\t\t\t}\n\n\t\t\t\tif (state.tokens.curr.value === \"use strict\") {\n\t\t\t\t\tif (!state.option[\"(explicitNewcap)\"])\n\t\t\t\t\t\tstate.option.newcap = true;\n\t\t\t\t\tstate.option.undef = true;\n\t\t\t\t}\n\n\t\t\t\t// there's no directive negation, so always set to true\n\t\t\t\tstate.directive[state.tokens.curr.value] = true;\n\n\t\t\t\tif (p.id === \";\") {\n\t\t\t\t\tadvance(\";\");\n\t\t\t\t}\n\t\t\t\tcontinue;\n\t\t\t}\n\t\t\tbreak;\n\t\t}\n\t}\n\n\n\t/*\n\t * Parses a single block. A block is a sequence of statements wrapped in\n\t * braces.\n\t *\n\t * ordinary - true for everything but function bodies and try blocks.\n\t * stmt\t\t- true if block can be a single statement (e.g. in if/for/while).\n\t * isfunc\t- true if block is a function body\n\t */\n\tfunction block(ordinary, stmt, isfunc) {\n\t\tvar a,\n\t\t\tb = inblock,\n\t\t\told_indent = indent,\n\t\t\tm,\n\t\t\ts = scope,\n\t\t\tt,\n\t\t\tline,\n\t\t\td;\n\n\t\tinblock = ordinary;\n\n\t\tif (!ordinary || !state.option.funcscope)\n\t\t\tscope = Object.create(scope);\n\n\t\tnonadjacent(state.tokens.curr, state.tokens.next);\n\t\tt = state.tokens.next;\n\n\t\tvar metrics = funct[\"(metrics)\"];\n\t\tmetrics.nestedBlockDepth += 1;\n\t\tmetrics.verifyMaxNestedBlockDepthPerFunction();\n\n\t\tif (state.tokens.next.id === \"{\") {\n\t\t\tadvance(\"{\");\n\t\t\tline = state.tokens.curr.line;\n\t\t\tif (state.tokens.next.id !== \"}\") {\n\t\t\t\tindent += state.option.indent;\n\t\t\t\twhile (!ordinary && state.tokens.next.from > indent) {\n\t\t\t\t\tindent += state.option.indent;\n\t\t\t\t}\n\n\t\t\t\tif (isfunc) {\n\t\t\t\t\tm = {};\n\t\t\t\t\tfor (d in state.directive) {\n\t\t\t\t\t\tif (_.has(state.directive, d)) {\n\t\t\t\t\t\t\tm[d] = state.directive[d];\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\tdirectives();\n\n\t\t\t\t\tif (state.option.strict && funct[\"(context)\"][\"(global)\"]) {\n\t\t\t\t\t\tif (!m[\"use strict\"] && !state.directive[\"use strict\"]) {\n\t\t\t\t\t\t\twarning(\"E007\");\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\ta = statements(line);\n\n\t\t\t\tmetrics.statementCount += a.length;\n\n\t\t\t\tif (isfunc) {\n\t\t\t\t\tstate.directive = m;\n\t\t\t\t}\n\n\t\t\t\tindent -= state.option.indent;\n\t\t\t\tif (line !== state.tokens.next.line) {\n\t\t\t\t\tindentation();\n\t\t\t\t}\n\t\t\t} else if (line !== state.tokens.next.line) {\n\t\t\t\tindentation();\n\t\t\t}\n\t\t\tadvance(\"}\", t);\n\t\t\tindent = old_indent;\n\t\t} else if (!ordinary) {\n\t\t\terror(\"E021\", state.tokens.next, \"{\", state.tokens.next.value);\n\t\t} else {\n\t\t\tif (!stmt || state.option.curly) {\n\t\t\t\twarning(\"W116\", state.tokens.next, \"{\", state.tokens.next.value);\n\t\t\t}\n\n\t\t\tnoreach = true;\n\t\t\tindent += state.option.indent;\n\t\t\t// test indentation only if statement is in new line\n\t\t\ta = [statement(state.tokens.next.line === state.tokens.curr.line)];\n\t\t\tindent -= state.option.indent;\n\t\t\tnoreach = false;\n\t\t}\n\t\tfunct[\"(verb)\"] = null;\n\t\tif (!ordinary || !state.option.funcscope) scope = s;\n\t\tinblock = b;\n\t\tif (ordinary && state.option.noempty && (!a || a.length === 0)) {\n\t\t\twarning(\"W035\");\n\t\t}\n\t\tmetrics.nestedBlockDepth -= 1;\n\t\treturn a;\n\t}\n\n\n\tfunction countMember(m) {\n\t\tif (membersOnly && typeof membersOnly[m] !== \"boolean\") {\n\t\t\twarning(\"W036\", state.tokens.curr, m);\n\t\t}\n\t\tif (typeof member[m] === \"number\") {\n\t\t\tmember[m] += 1;\n\t\t} else {\n\t\t\tmember[m] = 1;\n\t\t}\n\t}\n\n\n\tfunction note_implied(tkn) {\n\t\tvar name = tkn.value, line = tkn.line, a = implied[name];\n\t\tif (typeof a === \"function\") {\n\t\t\ta = false;\n\t\t}\n\n\t\tif (!a) {\n\t\t\ta = [line];\n\t\t\timplied[name] = a;\n\t\t} else if (a[a.length - 1] !== line) {\n\t\t\ta.push(line);\n\t\t}\n\t}\n\n\n\t// Build the syntax table by declaring the syntactic elements of the language.\n\n\ttype(\"(number)\", function () {\n\t\treturn this;\n\t});\n\n\ttype(\"(string)\", function () {\n\t\treturn this;\n\t});\n\n\tstate.syntax[\"(identifier)\"] = {\n\t\ttype: \"(identifier)\",\n\t\tlbp: 0,\n\t\tidentifier: true,\n\t\tnud: function () {\n\t\t\tvar v = this.value,\n\t\t\t\ts = scope[v],\n\t\t\t\tf;\n\n\t\t\tif (typeof s === \"function\") {\n\t\t\t\t// Protection against accidental inheritance.\n\t\t\t\ts = undefined;\n\t\t\t} else if (typeof s === \"boolean\") {\n\t\t\t\tf = funct;\n\t\t\t\tfunct = functions[0];\n\t\t\t\taddlabel(v, \"var\");\n\t\t\t\ts = funct;\n\t\t\t\tfunct = f;\n\t\t\t}\n\n\t\t\t// The name is in scope and defined in the current function.\n\t\t\tif (funct === s) {\n\t\t\t\t// Change 'unused' to 'var', and reject labels.\n\t\t\t\tswitch (funct[v]) {\n\t\t\t\tcase \"unused\":\n\t\t\t\t\tfunct[v] = \"var\";\n\t\t\t\t\tbreak;\n\t\t\t\tcase \"unction\":\n\t\t\t\t\tfunct[v] = \"function\";\n\t\t\t\t\tthis[\"function\"] = true;\n\t\t\t\t\tbreak;\n\t\t\t\tcase \"function\":\n\t\t\t\t\tthis[\"function\"] = true;\n\t\t\t\t\tbreak;\n\t\t\t\tcase \"label\":\n\t\t\t\t\twarning(\"W037\", state.tokens.curr, v);\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t} else if (funct[\"(global)\"]) {\n\t\t\t\t// The name is not defined in the function.  If we are in the global\n\t\t\t\t// scope, then we have an undefined variable.\n\t\t\t\t//\n\t\t\t\t// Operators typeof and delete do not raise runtime errors even if\n\t\t\t\t// the base object of a reference is null so no need to display warning\n\t\t\t\t// if we're inside of typeof or delete.\n\n\t\t\t\tif (typeof predefined[v] !== \"boolean\") {\n\t\t\t\t\t// Attempting to subscript a null reference will throw an\n\t\t\t\t\t// error, even within the typeof and delete operators\n\t\t\t\t\tif (!(anonname === \"typeof\" || anonname === \"delete\") ||\n\t\t\t\t\t\t(state.tokens.next && (state.tokens.next.value === \".\" ||\n\t\t\t\t\t\t\tstate.tokens.next.value === \"[\"))) {\n\n\t\t\t\t\t\tisundef(funct, \"W117\", state.tokens.curr, v);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tnote_implied(state.tokens.curr);\n\t\t\t} else {\n\t\t\t\t// If the name is already defined in the current\n\t\t\t\t// function, but not as outer, then there is a scope error.\n\n\t\t\t\tswitch (funct[v]) {\n\t\t\t\tcase \"closure\":\n\t\t\t\tcase \"function\":\n\t\t\t\tcase \"var\":\n\t\t\t\tcase \"unused\":\n\t\t\t\t\twarning(\"W038\", state.tokens.curr, v);\n\t\t\t\t\tbreak;\n\t\t\t\tcase \"label\":\n\t\t\t\t\twarning(\"W037\", state.tokens.curr, v);\n\t\t\t\t\tbreak;\n\t\t\t\tcase \"outer\":\n\t\t\t\tcase \"global\":\n\t\t\t\t\tbreak;\n\t\t\t\tdefault:\n\t\t\t\t\t// If the name is defined in an outer function, make an outer entry,\n\t\t\t\t\t// and if it was unused, make it var.\n\t\t\t\t\tif (s === true) {\n\t\t\t\t\t\tfunct[v] = true;\n\t\t\t\t\t} else if (s === null) {\n\t\t\t\t\t\twarning(\"W039\", state.tokens.curr, v);\n\t\t\t\t\t\tnote_implied(state.tokens.curr);\n\t\t\t\t\t} else if (typeof s !== \"object\") {\n\t\t\t\t\t\t// Operators typeof and delete do not raise runtime errors even\n\t\t\t\t\t\t// if the base object of a reference is null so no need to\n\t\t\t\t\t\t//\n\t\t\t\t\t\t// display warning if we're inside of typeof or delete.\n\t\t\t\t\t\t// Attempting to subscript a null reference will throw an\n\t\t\t\t\t\t// error, even within the typeof and delete operators\n\t\t\t\t\t\tif (!(anonname === \"typeof\" || anonname === \"delete\") ||\n\t\t\t\t\t\t\t(state.tokens.next &&\n\t\t\t\t\t\t\t\t(state.tokens.next.value === \".\" || state.tokens.next.value === \"[\"))) {\n\n\t\t\t\t\t\t\tisundef(funct, \"W117\", state.tokens.curr, v);\n\t\t\t\t\t\t}\n\t\t\t\t\t\tfunct[v] = true;\n\t\t\t\t\t\tnote_implied(state.tokens.curr);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tswitch (s[v]) {\n\t\t\t\t\t\tcase \"function\":\n\t\t\t\t\t\tcase \"unction\":\n\t\t\t\t\t\t\tthis[\"function\"] = true;\n\t\t\t\t\t\t\ts[v] = \"closure\";\n\t\t\t\t\t\t\tfunct[v] = s[\"(global)\"] ? \"global\" : \"outer\";\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase \"var\":\n\t\t\t\t\t\tcase \"unused\":\n\t\t\t\t\t\t\ts[v] = \"closure\";\n\t\t\t\t\t\t\tfunct[v] = s[\"(global)\"] ? \"global\" : \"outer\";\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase \"closure\":\n\t\t\t\t\t\t\tfunct[v] = s[\"(global)\"] ? \"global\" : \"outer\";\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase \"label\":\n\t\t\t\t\t\t\twarning(\"W037\", state.tokens.curr, v);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn this;\n\t\t},\n\t\tled: function () {\n\t\t\terror(\"E033\", state.tokens.next, state.tokens.next.value);\n\t\t}\n\t};\n\n\ttype(\"(regexp)\", function () {\n\t\treturn this;\n\t});\n\n\t// ECMAScript parser\n\n\tdelim(\"(endline)\");\n\tdelim(\"(begin)\");\n\tdelim(\"(end)\").reach = true;\n\tdelim(\"(error)\").reach = true;\n\tdelim(\"}\").reach = true;\n\tdelim(\")\");\n\tdelim(\"]\");\n\tdelim(\"\\\"\").reach = true;\n\tdelim(\"'\").reach = true;\n\tdelim(\";\");\n\tdelim(\":\").reach = true;\n\tdelim(\",\");\n\tdelim(\"#\");\n\n\treserve(\"else\");\n\treserve(\"case\").reach = true;\n\treserve(\"catch\");\n\treserve(\"default\").reach = true;\n\treserve(\"finally\");\n\treservevar(\"arguments\", function (x) {\n\t\tif (state.directive[\"use strict\"] && funct[\"(global)\"]) {\n\t\t\twarning(\"E008\", x);\n\t\t}\n\t});\n\treservevar(\"eval\");\n\treservevar(\"false\");\n\treservevar(\"Infinity\");\n\treservevar(\"null\");\n\treservevar(\"this\", function (x) {\n\t\tif (state.directive[\"use strict\"] && !state.option.validthis && ((funct[\"(statement)\"] &&\n\t\t\t\tfunct[\"(name)\"].charAt(0) > \"Z\") || funct[\"(global)\"])) {\n\t\t\twarning(\"W040\", x);\n\t\t}\n\t});\n\treservevar(\"true\");\n\treservevar(\"undefined\");\n\n\tassignop(\"=\", \"assign\", 20);\n\tassignop(\"+=\", \"assignadd\", 20);\n\tassignop(\"-=\", \"assignsub\", 20);\n\tassignop(\"*=\", \"assignmult\", 20);\n\tassignop(\"/=\", \"assigndiv\", 20).nud = function () {\n\t\terror(\"E014\");\n\t};\n\tassignop(\"%=\", \"assignmod\", 20);\n\n\tbitwiseassignop(\"&=\", \"assignbitand\", 20);\n\tbitwiseassignop(\"|=\", \"assignbitor\", 20);\n\tbitwiseassignop(\"^=\", \"assignbitxor\", 20);\n\tbitwiseassignop(\"<<=\", \"assignshiftleft\", 20);\n\tbitwiseassignop(\">>=\", \"assignshiftright\", 20);\n\tbitwiseassignop(\">>>=\", \"assignshiftrightunsigned\", 20);\n\tinfix(\"?\", function (left, that) {\n\t\tthat.left = left;\n\t\tthat.right = expression(10);\n\t\tadvance(\":\");\n\t\tthat[\"else\"] = expression(10);\n\t\treturn that;\n\t}, 30);\n\n\tinfix(\"||\", \"or\", 40);\n\tinfix(\"&&\", \"and\", 50);\n\tbitwise(\"|\", \"bitor\", 70);\n\tbitwise(\"^\", \"bitxor\", 80);\n\tbitwise(\"&\", \"bitand\", 90);\n\trelation(\"==\", function (left, right) {\n\t\tvar eqnull = state.option.eqnull && (left.value === \"null\" || right.value === \"null\");\n\n\t\tif (!eqnull && state.option.eqeqeq)\n\t\t\twarning(\"W116\", this, \"===\", \"==\");\n\t\telse if (isPoorRelation(left))\n\t\t\twarning(\"W041\", this, \"===\", left.value);\n\t\telse if (isPoorRelation(right))\n\t\t\twarning(\"W041\", this, \"===\", right.value);\n\n\t\treturn this;\n\t});\n\trelation(\"===\");\n\trelation(\"!=\", function (left, right) {\n\t\tvar eqnull = state.option.eqnull &&\n\t\t\t\t(left.value === \"null\" || right.value === \"null\");\n\n\t\tif (!eqnull && state.option.eqeqeq) {\n\t\t\twarning(\"W116\", this, \"!==\", \"!=\");\n\t\t} else if (isPoorRelation(left)) {\n\t\t\twarning(\"W041\", this, \"!==\", left.value);\n\t\t} else if (isPoorRelation(right)) {\n\t\t\twarning(\"W041\", this, \"!==\", right.value);\n\t\t}\n\t\treturn this;\n\t});\n\trelation(\"!==\");\n\trelation(\"<\");\n\trelation(\">\");\n\trelation(\"<=\");\n\trelation(\">=\");\n\tbitwise(\"<<\", \"shiftleft\", 120);\n\tbitwise(\">>\", \"shiftright\", 120);\n\tbitwise(\">>>\", \"shiftrightunsigned\", 120);\n\tinfix(\"in\", \"in\", 120);\n\tinfix(\"instanceof\", \"instanceof\", 120);\n\tinfix(\"+\", function (left, that) {\n\t\tvar right = expression(130);\n\t\tif (left && right && left.id === \"(string)\" && right.id === \"(string)\") {\n\t\t\tleft.value += right.value;\n\t\t\tleft.character = right.character;\n\t\t\tif (!state.option.scripturl && reg.javascriptURL.test(left.value)) {\n\t\t\t\twarning(\"W050\", left);\n\t\t\t}\n\t\t\treturn left;\n\t\t}\n\t\tthat.left = left;\n\t\tthat.right = right;\n\t\treturn that;\n\t}, 130);\n\tprefix(\"+\", \"num\");\n\tprefix(\"+++\", function () {\n\t\twarning(\"W007\");\n\t\tthis.right = expression(150);\n\t\tthis.arity = \"unary\";\n\t\treturn this;\n\t});\n\tinfix(\"+++\", function (left) {\n\t\twarning(\"W007\");\n\t\tthis.left = left;\n\t\tthis.right = expression(130);\n\t\treturn this;\n\t}, 130);\n\tinfix(\"-\", \"sub\", 130);\n\tprefix(\"-\", \"neg\");\n\tprefix(\"---\", function () {\n\t\twarning(\"W006\");\n\t\tthis.right = expression(150);\n\t\tthis.arity = \"unary\";\n\t\treturn this;\n\t});\n\tinfix(\"---\", function (left) {\n\t\twarning(\"W006\");\n\t\tthis.left = left;\n\t\tthis.right = expression(130);\n\t\treturn this;\n\t}, 130);\n\tinfix(\"*\", \"mult\", 140);\n\tinfix(\"/\", \"div\", 140);\n\tinfix(\"%\", \"mod\", 140);\n\n\tsuffix(\"++\", \"postinc\");\n\tprefix(\"++\", \"preinc\");\n\tstate.syntax[\"++\"].exps = true;\n\n\tsuffix(\"--\", \"postdec\");\n\tprefix(\"--\", \"predec\");\n\tstate.syntax[\"--\"].exps = true;\n\tprefix(\"delete\", function () {\n\t\tvar p = expression(0);\n\t\tif (!p || (p.id !== \".\" && p.id !== \"[\")) {\n\t\t\twarning(\"W051\");\n\t\t}\n\t\tthis.first = p;\n\t\treturn this;\n\t}).exps = true;\n\n\tprefix(\"~\", function () {\n\t\tif (state.option.bitwise) {\n\t\t\twarning(\"W052\", this, \"~\");\n\t\t}\n\t\texpression(150);\n\t\treturn this;\n\t});\n\n\tprefix(\"!\", function () {\n\t\tthis.right = expression(150);\n\t\tthis.arity = \"unary\";\n\n\t\tif (!this.right) { // '!' followed by nothing? Give up.\n\t\t\tquit(\"E041\", this.line || 0);\n\t\t}\n\n\t\tif (bang[this.right.id] === true) {\n\t\t\twarning(\"W018\", this, \"!\");\n\t\t}\n\t\treturn this;\n\t});\n\n\tprefix(\"typeof\", \"typeof\");\n\tprefix(\"new\", function () {\n\t\tvar c = expression(155), i;\n\t\tif (c && c.id !== \"function\") {\n\t\t\tif (c.identifier) {\n\t\t\t\tc[\"new\"] = true;\n\t\t\t\tswitch (c.value) {\n\t\t\t\tcase \"Number\":\n\t\t\t\tcase \"String\":\n\t\t\t\tcase \"Boolean\":\n\t\t\t\tcase \"Math\":\n\t\t\t\tcase \"JSON\":\n\t\t\t\t\twarning(\"W053\", state.tokens.prev, c.value);\n\t\t\t\t\tbreak;\n\t\t\t\tcase \"Function\":\n\t\t\t\t\tif (!state.option.evil) {\n\t\t\t\t\t\twarning(\"W054\");\n\t\t\t\t\t}\n\t\t\t\t\tbreak;\n\t\t\t\tcase \"Date\":\n\t\t\t\tcase \"RegExp\":\n\t\t\t\t\tbreak;\n\t\t\t\tdefault:\n\t\t\t\t\tif (c.id !== \"function\") {\n\t\t\t\t\t\ti = c.value.substr(0, 1);\n\t\t\t\t\t\tif (state.option.newcap && (i < \"A\" || i > \"Z\") && !_.has(global, c.value)) {\n\t\t\t\t\t\t\twarning(\"W055\", state.tokens.curr);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tif (c.id !== \".\" && c.id !== \"[\" && c.id !== \"(\") {\n\t\t\t\t\twarning(\"W056\", state.tokens.curr);\n\t\t\t\t}\n\t\t\t}\n\t\t} else {\n\t\t\tif (!state.option.supernew)\n\t\t\t\twarning(\"W057\", this);\n\t\t}\n\t\tadjacent(state.tokens.curr, state.tokens.next);\n\t\tif (state.tokens.next.id !== \"(\" && !state.option.supernew) {\n\t\t\twarning(\"W058\", state.tokens.curr, state.tokens.curr.value);\n\t\t}\n\t\tthis.first = c;\n\t\treturn this;\n\t});\n\tstate.syntax[\"new\"].exps = true;\n\n\tprefix(\"void\").exps = true;\n\n\tinfix(\".\", function (left, that) {\n\t\tadjacent(state.tokens.prev, state.tokens.curr);\n\t\tnobreak();\n\t\tvar m = identifier(false, true);\n\n\t\tif (typeof m === \"string\") {\n\t\t\tcountMember(m);\n\t\t}\n\n\t\tthat.left = left;\n\t\tthat.right = m;\n\n\t\tif (m && m === \"hasOwnProperty\" && state.tokens.next.value === \"=\") {\n\t\t\twarning(\"W001\");\n\t\t}\n\n\t\tif (left && left.value === \"arguments\" && (m === \"callee\" || m === \"caller\")) {\n\t\t\tif (state.option.noarg)\n\t\t\t\twarning(\"W059\", left, m);\n\t\t\telse if (state.directive[\"use strict\"])\n\t\t\t\terror(\"E008\");\n\t\t} else if (!state.option.evil && left && left.value === \"document\" &&\n\t\t\t\t(m === \"write\" || m === \"writeln\")) {\n\t\t\twarning(\"W060\", left);\n\t\t}\n\n\t\tif (!state.option.evil && (m === \"eval\" || m === \"execScript\")) {\n\t\t\twarning(\"W061\");\n\t\t}\n\n\t\treturn that;\n\t}, 160, true);\n\n\tinfix(\"(\", function (left, that) {\n\t\tif (state.tokens.prev.id !== \"}\" && state.tokens.prev.id !== \")\") {\n\t\t\tnobreak(state.tokens.prev, state.tokens.curr);\n\t\t}\n\n\t\tnospace();\n\t\tif (state.option.immed && !left.immed && left.id === \"function\") {\n\t\t\twarning(\"W062\");\n\t\t}\n\n\t\tvar n = 0;\n\t\tvar p = [];\n\n\t\tif (left) {\n\t\t\tif (left.type === \"(identifier)\") {\n\t\t\t\tif (left.value.match(/^[A-Z]([A-Z0-9_$]*[a-z][A-Za-z0-9_$]*)?$/)) {\n\t\t\t\t\tif (\"Number String Boolean Date Object\".indexOf(left.value) === -1) {\n\t\t\t\t\t\tif (left.value === \"Math\") {\n\t\t\t\t\t\t\twarning(\"W063\", left);\n\t\t\t\t\t\t} else if (state.option.newcap) {\n\t\t\t\t\t\t\twarning(\"W064\", left);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\tif (state.tokens.next.id !== \")\") {\n\t\t\tfor (;;) {\n\t\t\t\tp[p.length] = expression(10);\n\t\t\t\tn += 1;\n\t\t\t\tif (state.tokens.next.id !== \",\") {\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t\tcomma();\n\t\t\t}\n\t\t}\n\n\t\tadvance(\")\");\n\t\tnospace(state.tokens.prev, state.tokens.curr);\n\n\t\tif (typeof left === \"object\") {\n\t\t\tif (left.value === \"parseInt\" && n === 1) {\n\t\t\t\twarning(\"W065\", state.tokens.curr);\n\t\t\t}\n\t\t\tif (!state.option.evil) {\n\t\t\t\tif (left.value === \"eval\" || left.value === \"Function\" ||\n\t\t\t\t\t\tleft.value === \"execScript\") {\n\t\t\t\t\twarning(\"W061\", left);\n\n\t\t\t\t\tif (p[0] && [0].id === \"(string)\") {\n\t\t\t\t\t\taddInternalSrc(left, p[0].value);\n\t\t\t\t\t}\n\t\t\t\t} else if (p[0] && p[0].id === \"(string)\" &&\n\t\t\t\t\t   (left.value === \"setTimeout\" ||\n\t\t\t\t\t\tleft.value === \"setInterval\")) {\n\t\t\t\t\twarning(\"W066\", left);\n\t\t\t\t\taddInternalSrc(left, p[0].value);\n\n\t\t\t\t// window.setTimeout/setInterval\n\t\t\t\t} else if (p[0] && p[0].id === \"(string)\" &&\n\t\t\t\t\t   left.value === \".\" &&\n\t\t\t\t\t   left.left.value === \"window\" &&\n\t\t\t\t\t   (left.right === \"setTimeout\" ||\n\t\t\t\t\t\tleft.right === \"setInterval\")) {\n\t\t\t\t\twarning(\"W066\", left);\n\t\t\t\t\taddInternalSrc(left, p[0].value);\n\t\t\t\t}\n\t\t\t}\n\t\t\tif (!left.identifier && left.id !== \".\" && left.id !== \"[\" &&\n\t\t\t\t\tleft.id !== \"(\" && left.id !== \"&&\" && left.id !== \"||\" &&\n\t\t\t\t\tleft.id !== \"?\") {\n\t\t\t\twarning(\"W067\", left);\n\t\t\t}\n\t\t}\n\n\t\tthat.left = left;\n\t\treturn that;\n\t}, 155, true).exps = true;\n\n\tprefix(\"(\", function () {\n\t\tnospace();\n\n\t\tif (state.tokens.next.id === \"function\") {\n\t\t\tstate.tokens.next.immed = true;\n\t\t}\n\n\t\tvar exprs = [];\n\n\t\tif (state.tokens.next.id !== \")\") {\n\t\t\tfor (;;) {\n\t\t\t\texprs.push(expression(0));\n\t\t\t\tif (state.tokens.next.id !== \",\") {\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t\tcomma();\n\t\t\t}\n\t\t}\n\n\t\tadvance(\")\", this);\n\t\tnospace(state.tokens.prev, state.tokens.curr);\n\t\tif (state.option.immed && exprs[0].id === \"function\") {\n\t\t\tif (state.tokens.next.id !== \"(\" &&\n\t\t\t  (state.tokens.next.id !== \".\" || (peek().value !== \"call\" && peek().value !== \"apply\"))) {\n\t\t\t\twarning(\"W068\", this);\n\t\t\t}\n\t\t}\n\n\t\treturn exprs[0];\n\t});\n\n\tinfix(\"[\", function (left, that) {\n\t\tnobreak(state.tokens.prev, state.tokens.curr);\n\t\tnospace();\n\t\tvar e = expression(0), s;\n\t\tif (e && e.type === \"(string)\") {\n\t\t\tif (!state.option.evil && (e.value === \"eval\" || e.value === \"execScript\")) {\n\t\t\t\twarning(\"W061\", that);\n\t\t\t}\n\n\t\t\tcountMember(e.value);\n\t\t\tif (!state.option.sub && reg.identifier.test(e.value)) {\n\t\t\t\ts = state.syntax[e.value];\n\t\t\t\tif (!s || !isReserved(s)) {\n\t\t\t\t\twarning(\"W069\", state.tokens.prev, e.value);\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\tadvance(\"]\", that);\n\n\t\tif (e && e.value === \"hasOwnProperty\" && state.tokens.next.value === \"=\") {\n\t\t\twarning(\"W001\");\n\t\t}\n\n\t\tnospace(state.tokens.prev, state.tokens.curr);\n\t\tthat.left = left;\n\t\tthat.right = e;\n\t\treturn that;\n\t}, 160, true);\n\n\tprefix(\"[\", function () {\n\t\tvar b = state.tokens.curr.line !== state.tokens.next.line;\n\t\tthis.first = [];\n\t\tif (b) {\n\t\t\tindent += state.option.indent;\n\t\t\tif (state.tokens.next.from === indent + state.option.indent) {\n\t\t\t\tindent += state.option.indent;\n\t\t\t}\n\t\t}\n\t\twhile (state.tokens.next.id !== \"(end)\") {\n\t\t\twhile (state.tokens.next.id === \",\") {\n\t\t\t\tif (!state.option.es5)\n\t\t\t\t\twarning(\"W070\");\n\t\t\t\tadvance(\",\");\n\t\t\t}\n\t\t\tif (state.tokens.next.id === \"]\") {\n\t\t\t\tbreak;\n\t\t\t}\n\t\t\tif (b && state.tokens.curr.line !== state.tokens.next.line) {\n\t\t\t\tindentation();\n\t\t\t}\n\t\t\tthis.first.push(expression(10));\n\t\t\tif (state.tokens.next.id === \",\") {\n\t\t\t\tcomma({ allowTrailing: true });\n\t\t\t\tif (state.tokens.next.id === \"]\" && !state.option.es5) {\n\t\t\t\t\twarning(\"W070\", state.tokens.curr);\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tbreak;\n\t\t\t}\n\t\t}\n\t\tif (b) {\n\t\t\tindent -= state.option.indent;\n\t\t\tindentation();\n\t\t}\n\t\tadvance(\"]\", this);\n\t\treturn this;\n\t}, 160);\n\n\n\tfunction property_name() {\n\t\tvar id = optionalidentifier(false, true);\n\n\t\tif (!id) {\n\t\t\tif (state.tokens.next.id === \"(string)\") {\n\t\t\t\tid = state.tokens.next.value;\n\t\t\t\tadvance();\n\t\t\t} else if (state.tokens.next.id === \"(number)\") {\n\t\t\t\tid = state.tokens.next.value.toString();\n\t\t\t\tadvance();\n\t\t\t}\n\t\t}\n\n\t\tif (id === \"hasOwnProperty\") {\n\t\t\twarning(\"W001\");\n\t\t}\n\n\t\treturn id;\n\t}\n\n\n\tfunction functionparams() {\n\t\tvar next   = state.tokens.next;\n\t\tvar params = [];\n\t\tvar ident;\n\n\t\tadvance(\"(\");\n\t\tnospace();\n\n\t\tif (state.tokens.next.id === \")\") {\n\t\t\tadvance(\")\");\n\t\t\treturn;\n\t\t}\n\n\t\tfor (;;) {\n\t\t\tident = identifier(true);\n\t\t\tparams.push(ident);\n\t\t\taddlabel(ident, \"unused\", state.tokens.curr);\n\t\t\tif (state.tokens.next.id === \",\") {\n\t\t\t\tcomma();\n\t\t\t} else {\n\t\t\t\tadvance(\")\", next);\n\t\t\t\tnospace(state.tokens.prev, state.tokens.curr);\n\t\t\t\treturn params;\n\t\t\t}\n\t\t}\n\t}\n\n\n\tfunction doFunction(name, statement) {\n\t\tvar f;\n\t\tvar oldOption = state.option;\n\t\tvar oldScope  = scope;\n\n\t\tstate.option = Object.create(state.option);\n\t\tscope  = Object.create(scope);\n\n\t\tfunct = {\n\t\t\t\"(name)\"     : name || \"\\\"\" + anonname + \"\\\"\",\n\t\t\t\"(line)\"     : state.tokens.next.line,\n\t\t\t\"(character)\": state.tokens.next.character,\n\t\t\t\"(context)\"  : funct,\n\t\t\t\"(breakage)\" : 0,\n\t\t\t\"(loopage)\"  : 0,\n\t\t\t\"(metrics)\"  : createMetrics(state.tokens.next),\n\t\t\t\"(scope)\"    : scope,\n\t\t\t\"(statement)\": statement,\n\t\t\t\"(tokens)\"   : {}\n\t\t};\n\n\t\tf = funct;\n\t\tstate.tokens.curr.funct = funct;\n\n\t\tfunctions.push(funct);\n\n\t\tif (name) {\n\t\t\taddlabel(name, \"function\");\n\t\t}\n\n\t\tfunct[\"(params)\"] = functionparams();\n\t\tfunct[\"(metrics)\"].verifyMaxParametersPerFunction(funct[\"(params)\"]);\n\n\t\tblock(false, false, true);\n\n\t\tfunct[\"(metrics)\"].verifyMaxStatementsPerFunction();\n\t\tfunct[\"(metrics)\"].verifyMaxComplexityPerFunction();\n\n\t\tif (state.option.unused === false) {\n\t\t\tfunct[\"(ignoreUnused)\"] = true;\n\t\t}\n\n\t\tscope = oldScope;\n\t\tstate.option = oldOption;\n\t\tfunct[\"(last)\"] = state.tokens.curr.line;\n\t\tfunct[\"(lastcharacter)\"] = state.tokens.curr.character;\n\t\tfunct = funct[\"(context)\"];\n\n\t\treturn f;\n\t}\n\n\tfunction createMetrics(functionStartToken) {\n\t\treturn {\n\t\t\tstatementCount: 0,\n\t\t\tnestedBlockDepth: -1,\n\t\t\tComplexityCount: 1,\n\t\t\tverifyMaxStatementsPerFunction: function () {\n\t\t\t\tif (state.option.maxstatements &&\n\t\t\t\t\tthis.statementCount > state.option.maxstatements) {\n\t\t\t\t\twarning(\"W071\", functionStartToken, this.statementCount);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tverifyMaxParametersPerFunction: function (params) {\n\t\t\t\tparams = params || [];\n\n\t\t\t\tif (state.option.maxparams && params.length > state.option.maxparams) {\n\t\t\t\t\twarning(\"W072\", functionStartToken, params.length);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tverifyMaxNestedBlockDepthPerFunction: function () {\n\t\t\t\tif (state.option.maxdepth &&\n\t\t\t\t\tthis.nestedBlockDepth > 0 &&\n\t\t\t\t\tthis.nestedBlockDepth === state.option.maxdepth + 1) {\n\t\t\t\t\twarning(\"W073\", null, this.nestedBlockDepth);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tverifyMaxComplexityPerFunction: function () {\n\t\t\t\tvar max = state.option.maxcomplexity;\n\t\t\t\tvar cc = this.ComplexityCount;\n\t\t\t\tif (max && cc > max) {\n\t\t\t\t\twarning(\"W074\", functionStartToken, cc);\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\t}\n\n\tfunction increaseComplexityCount() {\n\t\tfunct[\"(metrics)\"].ComplexityCount += 1;\n\t}\n\n\t// Parse assignments that were found instead of conditionals.\n\t// For example: if (a = 1) { ... }\n\n\tfunction parseCondAssignment() {\n\t\tswitch (state.tokens.next.id) {\n\t\tcase \"=\":\n\t\tcase \"+=\":\n\t\tcase \"-=\":\n\t\tcase \"*=\":\n\t\tcase \"%=\":\n\t\tcase \"&=\":\n\t\tcase \"|=\":\n\t\tcase \"^=\":\n\t\tcase \"/=\":\n\t\t\tif (!state.option.boss) {\n\t\t\t\twarning(\"W084\");\n\t\t\t}\n\n\t\t\tadvance(state.tokens.next.id);\n\t\t\texpression(20);\n\t\t}\n\t}\n\n\n\t(function (x) {\n\t\tx.nud = function () {\n\t\t\tvar b, f, i, p, t;\n\t\t\tvar props = {}; // All properties, including accessors\n\n\t\t\tfunction saveProperty(name, tkn) {\n\t\t\t\tif (props[name] && _.has(props, name))\n\t\t\t\t\twarning(\"W075\", state.tokens.next, i);\n\t\t\t\telse\n\t\t\t\t\tprops[name] = {};\n\n\t\t\t\tprops[name].basic = true;\n\t\t\t\tprops[name].basictkn = tkn;\n\t\t\t}\n\n\t\t\tfunction saveSetter(name, tkn) {\n\t\t\t\tif (props[name] && _.has(props, name)) {\n\t\t\t\t\tif (props[name].basic || props[name].setter)\n\t\t\t\t\t\twarning(\"W075\", state.tokens.next, i);\n\t\t\t\t} else {\n\t\t\t\t\tprops[name] = {};\n\t\t\t\t}\n\n\t\t\t\tprops[name].setter = true;\n\t\t\t\tprops[name].setterToken = tkn;\n\t\t\t}\n\n\t\t\tfunction saveGetter(name) {\n\t\t\t\tif (props[name] && _.has(props, name)) {\n\t\t\t\t\tif (props[name].basic || props[name].getter)\n\t\t\t\t\t\twarning(\"W075\", state.tokens.next, i);\n\t\t\t\t} else {\n\t\t\t\t\tprops[name] = {};\n\t\t\t\t}\n\n\t\t\t\tprops[name].getter = true;\n\t\t\t\tprops[name].getterToken = state.tokens.curr;\n\t\t\t}\n\n\t\t\tb = state.tokens.curr.line !== state.tokens.next.line;\n\t\t\tif (b) {\n\t\t\t\tindent += state.option.indent;\n\t\t\t\tif (state.tokens.next.from === indent + state.option.indent) {\n\t\t\t\t\tindent += state.option.indent;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tfor (;;) {\n\t\t\t\tif (state.tokens.next.id === \"}\") {\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\n\t\t\t\tif (b) {\n\t\t\t\t\tindentation();\n\t\t\t\t}\n\n\t\t\t\tif (state.tokens.next.value === \"get\" && peek().id !== \":\") {\n\t\t\t\t\tadvance(\"get\");\n\n\t\t\t\t\tif (!state.option.es5) {\n\t\t\t\t\t\terror(\"E034\");\n\t\t\t\t\t}\n\n\t\t\t\t\ti = property_name();\n\t\t\t\t\tif (!i) {\n\t\t\t\t\t\terror(\"E035\");\n\t\t\t\t\t}\n\n\t\t\t\t\tsaveGetter(i);\n\t\t\t\t\tt = state.tokens.next;\n\t\t\t\t\tadjacent(state.tokens.curr, state.tokens.next);\n\t\t\t\t\tf = doFunction();\n\t\t\t\t\tp = f[\"(params)\"];\n\n\t\t\t\t\tif (p) {\n\t\t\t\t\t\twarning(\"W076\", t, p[0], i);\n\t\t\t\t\t}\n\n\t\t\t\t\tadjacent(state.tokens.curr, state.tokens.next);\n\t\t\t\t} else if (state.tokens.next.value === \"set\" && peek().id !== \":\") {\n\t\t\t\t\tadvance(\"set\");\n\n\t\t\t\t\tif (!state.option.es5) {\n\t\t\t\t\t\terror(\"E034\");\n\t\t\t\t\t}\n\n\t\t\t\t\ti = property_name();\n\t\t\t\t\tif (!i) {\n\t\t\t\t\t\terror(\"E035\");\n\t\t\t\t\t}\n\n\t\t\t\t\tsaveSetter(i, state.tokens.next);\n\t\t\t\t\tt = state.tokens.next;\n\t\t\t\t\tadjacent(state.tokens.curr, state.tokens.next);\n\t\t\t\t\tf = doFunction();\n\t\t\t\t\tp = f[\"(params)\"];\n\n\t\t\t\t\tif (!p || p.length !== 1) {\n\t\t\t\t\t\twarning(\"W077\", t, i);\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\ti = property_name();\n\t\t\t\t\tsaveProperty(i, state.tokens.next);\n\n\t\t\t\t\tif (typeof i !== \"string\") {\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\n\t\t\t\t\tadvance(\":\");\n\t\t\t\t\tnonadjacent(state.tokens.curr, state.tokens.next);\n\t\t\t\t\texpression(10);\n\t\t\t\t}\n\n\t\t\t\tcountMember(i);\n\t\t\t\tif (state.tokens.next.id === \",\") {\n\t\t\t\t\tcomma({ allowTrailing: true });\n\t\t\t\t\tif (state.tokens.next.id === \",\") {\n\t\t\t\t\t\twarning(\"W070\", state.tokens.curr);\n\t\t\t\t\t} else if (state.tokens.next.id === \"}\" && !state.option.es5) {\n\t\t\t\t\t\twarning(\"W070\", state.tokens.curr);\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t}\n\t\t\tif (b) {\n\t\t\t\tindent -= state.option.indent;\n\t\t\t\tindentation();\n\t\t\t}\n\t\t\tadvance(\"}\", this);\n\n\t\t\t// Check for lonely setters if in the ES5 mode.\n\t\t\tif (state.option.es5) {\n\t\t\t\tfor (var name in props) {\n\t\t\t\t\tif (_.has(props, name) && props[name].setter && !props[name].getter) {\n\t\t\t\t\t\twarning(\"W078\", props[name].setterToken);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn this;\n\t\t};\n\t\tx.fud = function () {\n\t\t\terror(\"E036\", state.tokens.curr);\n\t\t};\n\t}(delim(\"{\")));\n\n\t// This Function is called when esnext option is set to true\n\t// it adds the `const` statement to JSHINT\n\n\tuseESNextSyntax = function () {\n\t\tvar conststatement = stmt(\"const\", function (prefix) {\n\t\t\tvar id, name, value;\n\n\t\t\tthis.first = [];\n\t\t\tfor (;;) {\n\t\t\t\tnonadjacent(state.tokens.curr, state.tokens.next);\n\t\t\t\tid = identifier();\n\t\t\t\tif (funct[id] === \"const\") {\n\t\t\t\t\twarning(\"E011\", null, id);\n\t\t\t\t}\n\t\t\t\tif (funct[\"(global)\"] && predefined[id] === false) {\n\t\t\t\t\twarning(\"W079\", state.tokens.curr, id);\n\t\t\t\t}\n\t\t\t\taddlabel(id, \"const\");\n\t\t\t\tif (prefix) {\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t\tname = state.tokens.curr;\n\t\t\t\tthis.first.push(state.tokens.curr);\n\n\t\t\t\tif (state.tokens.next.id !== \"=\") {\n\t\t\t\t\twarning(\"E012\", state.tokens.curr, id);\n\t\t\t\t}\n\n\t\t\t\tif (state.tokens.next.id === \"=\") {\n\t\t\t\t\tnonadjacent(state.tokens.curr, state.tokens.next);\n\t\t\t\t\tadvance(\"=\");\n\t\t\t\t\tnonadjacent(state.tokens.curr, state.tokens.next);\n\t\t\t\t\tif (state.tokens.next.id === \"undefined\") {\n\t\t\t\t\t\twarning(\"W080\", state.tokens.curr, id);\n\t\t\t\t\t}\n\t\t\t\t\tif (peek(0).id === \"=\" && state.tokens.next.identifier) {\n\t\t\t\t\t\terror(\"E037\", state.tokens.next, state.tokens.next.value);\n\t\t\t\t\t}\n\t\t\t\t\tvalue = expression(0);\n\t\t\t\t\tname.first = value;\n\t\t\t\t}\n\n\t\t\t\tif (state.tokens.next.id !== \",\") {\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t\tcomma();\n\t\t\t}\n\t\t\treturn this;\n\t\t});\n\t\tconststatement.exps = true;\n\t};\n\n\tvar varstatement = stmt(\"var\", function (prefix) {\n\t\t// JavaScript does not have block scope. It only has function scope. So,\n\t\t// declaring a variable in a block can have unexpected consequences.\n\t\tvar id, name, value;\n\n\t\tif (funct[\"(onevar)\"] && state.option.onevar) {\n\t\t\twarning(\"W081\");\n\t\t} else if (!funct[\"(global)\"]) {\n\t\t\tfunct[\"(onevar)\"] = true;\n\t\t}\n\n\t\tthis.first = [];\n\n\t\tfor (;;) {\n\t\t\tnonadjacent(state.tokens.curr, state.tokens.next);\n\t\t\tid = identifier();\n\n\t\t\tif (state.option.esnext && funct[id] === \"const\") {\n\t\t\t\twarning(\"E011\", null, id);\n\t\t\t}\n\n\t\t\tif (funct[\"(global)\"] && predefined[id] === false) {\n\t\t\t\twarning(\"W079\", state.tokens.curr, id);\n\t\t\t}\n\n\t\t\taddlabel(id, \"unused\", state.tokens.curr);\n\n\t\t\tif (prefix) {\n\t\t\t\tbreak;\n\t\t\t}\n\n\t\t\tname = state.tokens.curr;\n\t\t\tthis.first.push(state.tokens.curr);\n\n\t\t\tif (state.tokens.next.id === \"=\") {\n\t\t\t\tnonadjacent(state.tokens.curr, state.tokens.next);\n\t\t\t\tadvance(\"=\");\n\t\t\t\tnonadjacent(state.tokens.curr, state.tokens.next);\n\t\t\t\tif (state.tokens.next.id === \"undefined\") {\n\t\t\t\t\twarning(\"W080\", state.tokens.curr, id);\n\t\t\t\t}\n\t\t\t\tif (peek(0).id === \"=\" && state.tokens.next.identifier) {\n\t\t\t\t\terror(\"E038\", state.tokens.next, state.tokens.next.value);\n\t\t\t\t}\n\t\t\t\tvalue = expression(0);\n\t\t\t\tname.first = value;\n\t\t\t}\n\t\t\tif (state.tokens.next.id !== \",\") {\n\t\t\t\tbreak;\n\t\t\t}\n\t\t\tcomma();\n\t\t}\n\t\treturn this;\n\t});\n\tvarstatement.exps = true;\n\n\tblockstmt(\"function\", function () {\n\t\tif (inblock) {\n\t\t\twarning(\"W082\", state.tokens.curr);\n\n\t\t}\n\t\tvar i = identifier();\n\t\tif (state.option.esnext && funct[i] === \"const\") {\n\t\t\twarning(\"E011\", null, i);\n\t\t}\n\t\tadjacent(state.tokens.curr, state.tokens.next);\n\t\taddlabel(i, \"unction\", state.tokens.curr);\n\n\t\tdoFunction(i, { statement: true });\n\t\tif (state.tokens.next.id === \"(\" && state.tokens.next.line === state.tokens.curr.line) {\n\t\t\terror(\"E039\");\n\t\t}\n\t\treturn this;\n\t});\n\n\tprefix(\"function\", function () {\n\t\tvar i = optionalidentifier();\n\t\tif (i) {\n\t\t\tadjacent(state.tokens.curr, state.tokens.next);\n\t\t} else {\n\t\t\tnonadjacent(state.tokens.curr, state.tokens.next);\n\t\t}\n\t\tdoFunction(i);\n\t\tif (!state.option.loopfunc && funct[\"(loopage)\"]) {\n\t\t\twarning(\"W083\");\n\t\t}\n\t\treturn this;\n\t});\n\n\tblockstmt(\"if\", function () {\n\t\tvar t = state.tokens.next;\n\t\tincreaseComplexityCount();\n\t\tadvance(\"(\");\n\t\tnonadjacent(this, t);\n\t\tnospace();\n\t\texpression(20);\n\t\tparseCondAssignment();\n\t\tadvance(\")\", t);\n\t\tnospace(state.tokens.prev, state.tokens.curr);\n\t\tblock(true, true);\n\t\tif (state.tokens.next.id === \"else\") {\n\t\t\tnonadjacent(state.tokens.curr, state.tokens.next);\n\t\t\tadvance(\"else\");\n\t\t\tif (state.tokens.next.id === \"if\" || state.tokens.next.id === \"switch\") {\n\t\t\t\tstatement(true);\n\t\t\t} else {\n\t\t\t\tblock(true, true);\n\t\t\t}\n\t\t}\n\t\treturn this;\n\t});\n\n\tblockstmt(\"try\", function () {\n\t\tvar b;\n\n\t\tfunction doCatch() {\n\t\t\tvar oldScope = scope;\n\t\t\tvar e;\n\n\t\t\tadvance(\"catch\");\n\t\t\tnonadjacent(state.tokens.curr, state.tokens.next);\n\t\t\tadvance(\"(\");\n\n\t\t\tscope = Object.create(oldScope);\n\n\t\t\te = state.tokens.next.value;\n\t\t\tif (state.tokens.next.type !== \"(identifier)\") {\n\t\t\t\te = null;\n\t\t\t\twarning(\"E030\", state.tokens.next, e);\n\t\t\t}\n\n\t\t\tadvance();\n\t\t\tadvance(\")\");\n\n\t\t\tfunct = {\n\t\t\t\t\"(name)\"     : \"(catch)\",\n\t\t\t\t\"(line)\"     : state.tokens.next.line,\n\t\t\t\t\"(character)\": state.tokens.next.character,\n\t\t\t\t\"(context)\"  : funct,\n\t\t\t\t\"(breakage)\" : funct[\"(breakage)\"],\n\t\t\t\t\"(loopage)\"  : funct[\"(loopage)\"],\n\t\t\t\t\"(scope)\"    : scope,\n\t\t\t\t\"(statement)\": false,\n\t\t\t\t\"(metrics)\"  : createMetrics(state.tokens.next),\n\t\t\t\t\"(catch)\"    : true,\n\t\t\t\t\"(tokens)\"   : {}\n\t\t\t};\n\n\t\t\tif (e) {\n\t\t\t\taddlabel(e, \"exception\");\n\t\t\t}\n\n\t\t\tstate.tokens.curr.funct = funct;\n\t\t\tfunctions.push(funct);\n\n\t\t\tblock(false);\n\n\t\t\tscope = oldScope;\n\n\t\t\tfunct[\"(last)\"] = state.tokens.curr.line;\n\t\t\tfunct[\"(lastcharacter)\"] = state.tokens.curr.character;\n\t\t\tfunct = funct[\"(context)\"];\n\t\t}\n\n\t\tblock(false);\n\n\t\tif (state.tokens.next.id === \"catch\") {\n\t\t\tincreaseComplexityCount();\n\t\t\tdoCatch();\n\t\t\tb = true;\n\t\t}\n\n\t\tif (state.tokens.next.id === \"finally\") {\n\t\t\tadvance(\"finally\");\n\t\t\tblock(false);\n\t\t\treturn;\n\t\t} else if (!b) {\n\t\t\terror(\"E021\", state.tokens.next, \"catch\", state.tokens.next.value);\n\t\t}\n\n\t\treturn this;\n\t});\n\n\tblockstmt(\"while\", function () {\n\t\tvar t = state.tokens.next;\n\t\tfunct[\"(breakage)\"] += 1;\n\t\tfunct[\"(loopage)\"] += 1;\n\t\tincreaseComplexityCount();\n\t\tadvance(\"(\");\n\t\tnonadjacent(this, t);\n\t\tnospace();\n\t\texpression(20);\n\t\tparseCondAssignment();\n\t\tadvance(\")\", t);\n\t\tnospace(state.tokens.prev, state.tokens.curr);\n\t\tblock(true, true);\n\t\tfunct[\"(breakage)\"] -= 1;\n\t\tfunct[\"(loopage)\"] -= 1;\n\t\treturn this;\n\t}).labelled = true;\n\n\tblockstmt(\"with\", function () {\n\t\tvar t = state.tokens.next;\n\t\tif (state.directive[\"use strict\"]) {\n\t\t\terror(\"E010\", state.tokens.curr);\n\t\t} else if (!state.option.withstmt) {\n\t\t\twarning(\"W085\", state.tokens.curr);\n\t\t}\n\n\t\tadvance(\"(\");\n\t\tnonadjacent(this, t);\n\t\tnospace();\n\t\texpression(0);\n\t\tadvance(\")\", t);\n\t\tnospace(state.tokens.prev, state.tokens.curr);\n\t\tblock(true, true);\n\n\t\treturn this;\n\t});\n\n\tblockstmt(\"switch\", function () {\n\t\tvar t = state.tokens.next,\n\t\t\tg = false;\n\t\tfunct[\"(breakage)\"] += 1;\n\t\tadvance(\"(\");\n\t\tnonadjacent(this, t);\n\t\tnospace();\n\t\tthis.condition = expression(20);\n\t\tadvance(\")\", t);\n\t\tnospace(state.tokens.prev, state.tokens.curr);\n\t\tnonadjacent(state.tokens.curr, state.tokens.next);\n\t\tt = state.tokens.next;\n\t\tadvance(\"{\");\n\t\tnonadjacent(state.tokens.curr, state.tokens.next);\n\t\tindent += state.option.indent;\n\t\tthis.cases = [];\n\n\t\tfor (;;) {\n\t\t\tswitch (state.tokens.next.id) {\n\t\t\tcase \"case\":\n\t\t\t\tswitch (funct[\"(verb)\"]) {\n\t\t\t\tcase \"break\":\n\t\t\t\tcase \"case\":\n\t\t\t\tcase \"continue\":\n\t\t\t\tcase \"return\":\n\t\t\t\tcase \"switch\":\n\t\t\t\tcase \"throw\":\n\t\t\t\t\tbreak;\n\t\t\t\tdefault:\n\t\t\t\t\t// You can tell JSHint that you don't use break intentionally by\n\t\t\t\t\t// adding a comment /* falls through */ on a line just before\n\t\t\t\t\t// the next `case`.\n\t\t\t\t\tif (!reg.fallsThrough.test(state.lines[state.tokens.next.line - 2])) {\n\t\t\t\t\t\twarning(\"W086\", state.tokens.curr, \"case\");\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tindentation(-state.option.indent);\n\t\t\t\tadvance(\"case\");\n\t\t\t\tthis.cases.push(expression(20));\n\t\t\t\tincreaseComplexityCount();\n\t\t\t\tg = true;\n\t\t\t\tadvance(\":\");\n\t\t\t\tfunct[\"(verb)\"] = \"case\";\n\t\t\t\tbreak;\n\t\t\tcase \"default\":\n\t\t\t\tswitch (funct[\"(verb)\"]) {\n\t\t\t\tcase \"break\":\n\t\t\t\tcase \"continue\":\n\t\t\t\tcase \"return\":\n\t\t\t\tcase \"throw\":\n\t\t\t\t\tbreak;\n\t\t\t\tdefault:\n\t\t\t\t\t// Do not display a warning if 'default' is the first statement or if\n\t\t\t\t\t// there is a special /* falls through */ comment.\n\t\t\t\t\tif (this.cases.length) {\n\t\t\t\t\t\tif (!reg.fallsThrough.test(state.lines[state.tokens.next.line - 2])) {\n\t\t\t\t\t\t\twarning(\"W086\", state.tokens.curr, \"default\");\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tindentation(-state.option.indent);\n\t\t\t\tadvance(\"default\");\n\t\t\t\tg = true;\n\t\t\t\tadvance(\":\");\n\t\t\t\tbreak;\n\t\t\tcase \"}\":\n\t\t\t\tindent -= state.option.indent;\n\t\t\t\tindentation();\n\t\t\t\tadvance(\"}\", t);\n\t\t\t\tfunct[\"(breakage)\"] -= 1;\n\t\t\t\tfunct[\"(verb)\"] = undefined;\n\t\t\t\treturn;\n\t\t\tcase \"(end)\":\n\t\t\t\terror(\"E023\", state.tokens.next, \"}\");\n\t\t\t\treturn;\n\t\t\tdefault:\n\t\t\t\tif (g) {\n\t\t\t\t\tswitch (state.tokens.curr.id) {\n\t\t\t\t\tcase \",\":\n\t\t\t\t\t\terror(\"E040\");\n\t\t\t\t\t\treturn;\n\t\t\t\t\tcase \":\":\n\t\t\t\t\t\tg = false;\n\t\t\t\t\t\tstatements();\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tdefault:\n\t\t\t\t\t\terror(\"E025\", state.tokens.curr);\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\tif (state.tokens.curr.id === \":\") {\n\t\t\t\t\t\tadvance(\":\");\n\t\t\t\t\t\terror(\"E024\", state.tokens.curr, \":\");\n\t\t\t\t\t\tstatements();\n\t\t\t\t\t} else {\n\t\t\t\t\t\terror(\"E021\", state.tokens.next, \"case\", state.tokens.next.value);\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}).labelled = true;\n\n\tstmt(\"debugger\", function () {\n\t\tif (!state.option.debug) {\n\t\t\twarning(\"W087\");\n\t\t}\n\t\treturn this;\n\t}).exps = true;\n\n\t(function () {\n\t\tvar x = stmt(\"do\", function () {\n\t\t\tfunct[\"(breakage)\"] += 1;\n\t\t\tfunct[\"(loopage)\"] += 1;\n\t\t\tincreaseComplexityCount();\n\n\t\t\tthis.first = block(true);\n\t\t\tadvance(\"while\");\n\t\t\tvar t = state.tokens.next;\n\t\t\tnonadjacent(state.tokens.curr, t);\n\t\t\tadvance(\"(\");\n\t\t\tnospace();\n\t\t\texpression(20);\n\t\t\tparseCondAssignment();\n\t\t\tadvance(\")\", t);\n\t\t\tnospace(state.tokens.prev, state.tokens.curr);\n\t\t\tfunct[\"(breakage)\"] -= 1;\n\t\t\tfunct[\"(loopage)\"] -= 1;\n\t\t\treturn this;\n\t\t});\n\t\tx.labelled = true;\n\t\tx.exps = true;\n\t}());\n\n\tblockstmt(\"for\", function () {\n\t\tvar s, t = state.tokens.next;\n\t\tfunct[\"(breakage)\"] += 1;\n\t\tfunct[\"(loopage)\"] += 1;\n\t\tincreaseComplexityCount();\n\t\tadvance(\"(\");\n\t\tnonadjacent(this, t);\n\t\tnospace();\n\t\tif (peek(state.tokens.next.id === \"var\" ? 1 : 0).id === \"in\") {\n\t\t\tif (state.tokens.next.id === \"var\") {\n\t\t\t\tadvance(\"var\");\n\t\t\t\tvarstatement.fud.call(varstatement, true);\n\t\t\t} else {\n\t\t\t\tswitch (funct[state.tokens.next.value]) {\n\t\t\t\tcase \"unused\":\n\t\t\t\t\tfunct[state.tokens.next.value] = \"var\";\n\t\t\t\t\tbreak;\n\t\t\t\tcase \"var\":\n\t\t\t\t\tbreak;\n\t\t\t\tdefault:\n\t\t\t\t\twarning(\"W088\", state.tokens.next, state.tokens.next.value);\n\t\t\t\t}\n\t\t\t\tadvance();\n\t\t\t}\n\t\t\tadvance(\"in\");\n\t\t\texpression(20);\n\t\t\tadvance(\")\", t);\n\t\t\ts = block(true, true);\n\t\t\tif (state.option.forin && s && (s.length > 1 || typeof s[0] !== \"object\" ||\n\t\t\t\t\ts[0].value !== \"if\")) {\n\t\t\t\twarning(\"W089\", this);\n\t\t\t}\n\t\t\tfunct[\"(breakage)\"] -= 1;\n\t\t\tfunct[\"(loopage)\"] -= 1;\n\t\t\treturn this;\n\t\t} else {\n\t\t\tif (state.tokens.next.id !== \";\") {\n\t\t\t\tif (state.tokens.next.id === \"var\") {\n\t\t\t\t\tadvance(\"var\");\n\t\t\t\t\tvarstatement.fud.call(varstatement);\n\t\t\t\t} else {\n\t\t\t\t\tfor (;;) {\n\t\t\t\t\t\texpression(0, \"for\");\n\t\t\t\t\t\tif (state.tokens.next.id !== \",\") {\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tcomma();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t\tnolinebreak(state.tokens.curr);\n\t\t\tadvance(\";\");\n\t\t\tif (state.tokens.next.id !== \";\") {\n\t\t\t\texpression(20);\n\t\t\t\tparseCondAssignment();\n\t\t\t}\n\t\t\tnolinebreak(state.tokens.curr);\n\t\t\tadvance(\";\");\n\t\t\tif (state.tokens.next.id === \";\") {\n\t\t\t\terror(\"E021\", state.tokens.next, \")\", \";\");\n\t\t\t}\n\t\t\tif (state.tokens.next.id !== \")\") {\n\t\t\t\tfor (;;) {\n\t\t\t\t\texpression(0, \"for\");\n\t\t\t\t\tif (state.tokens.next.id !== \",\") {\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t\tcomma();\n\t\t\t\t}\n\t\t\t}\n\t\t\tadvance(\")\", t);\n\t\t\tnospace(state.tokens.prev, state.tokens.curr);\n\t\t\tblock(true, true);\n\t\t\tfunct[\"(breakage)\"] -= 1;\n\t\t\tfunct[\"(loopage)\"] -= 1;\n\t\t\treturn this;\n\t\t}\n\t}).labelled = true;\n\n\n\tstmt(\"break\", function () {\n\t\tvar v = state.tokens.next.value;\n\n\t\tif (funct[\"(breakage)\"] === 0)\n\t\t\twarning(\"W052\", state.tokens.next, this.value);\n\n\t\tif (!state.option.asi)\n\t\t\tnolinebreak(this);\n\n\t\tif (state.tokens.next.id !== \";\") {\n\t\t\tif (state.tokens.curr.line === state.tokens.next.line) {\n\t\t\t\tif (funct[v] !== \"label\") {\n\t\t\t\t\twarning(\"W090\", state.tokens.next, v);\n\t\t\t\t} else if (scope[v] !== funct) {\n\t\t\t\t\twarning(\"W091\", state.tokens.next, v);\n\t\t\t\t}\n\t\t\t\tthis.first = state.tokens.next;\n\t\t\t\tadvance();\n\t\t\t}\n\t\t}\n\t\treachable(\"break\");\n\t\treturn this;\n\t}).exps = true;\n\n\n\tstmt(\"continue\", function () {\n\t\tvar v = state.tokens.next.value;\n\n\t\tif (funct[\"(breakage)\"] === 0)\n\t\t\twarning(\"W052\", state.tokens.next, this.value);\n\n\t\tif (!state.option.asi)\n\t\t\tnolinebreak(this);\n\n\t\tif (state.tokens.next.id !== \";\") {\n\t\t\tif (state.tokens.curr.line === state.tokens.next.line) {\n\t\t\t\tif (funct[v] !== \"label\") {\n\t\t\t\t\twarning(\"W090\", state.tokens.next, v);\n\t\t\t\t} else if (scope[v] !== funct) {\n\t\t\t\t\twarning(\"W091\", state.tokens.next, v);\n\t\t\t\t}\n\t\t\t\tthis.first = state.tokens.next;\n\t\t\t\tadvance();\n\t\t\t}\n\t\t} else if (!funct[\"(loopage)\"]) {\n\t\t\twarning(\"W052\", state.tokens.next, this.value);\n\t\t}\n\t\treachable(\"continue\");\n\t\treturn this;\n\t}).exps = true;\n\n\n\tstmt(\"return\", function () {\n\t\tif (this.line === state.tokens.next.line) {\n\t\t\tif (state.tokens.next.id === \"(regexp)\")\n\t\t\t\twarning(\"W092\");\n\n\t\t\tif (state.tokens.next.id !== \";\" && !state.tokens.next.reach) {\n\t\t\t\tnonadjacent(state.tokens.curr, state.tokens.next);\n\t\t\t\tthis.first = expression(0);\n\n\t\t\t\tif (this.first.value === \"=\" && !state.option.boss) {\n\t\t\t\t\twarningAt(\"W093\", this.first.line, this.first.character);\n\t\t\t\t}\n\t\t\t}\n\t\t} else if (!state.option.asi) {\n\t\t\tnolinebreak(this); // always warn (Line breaking error)\n\t\t}\n\t\treachable(\"return\");\n\t\treturn this;\n\t}).exps = true;\n\n\n\tstmt(\"throw\", function () {\n\t\tnolinebreak(this);\n\t\tnonadjacent(state.tokens.curr, state.tokens.next);\n\t\tthis.first = expression(20);\n\t\treachable(\"throw\");\n\t\treturn this;\n\t}).exps = true;\n\n\t// Future Reserved Words\n\n\tFutureReservedWord(\"abstract\");\n\tFutureReservedWord(\"boolean\");\n\tFutureReservedWord(\"byte\");\n\tFutureReservedWord(\"char\");\n\tFutureReservedWord(\"class\", { es5: true });\n\tFutureReservedWord(\"double\");\n\tFutureReservedWord(\"enum\", { es5: true });\n\tFutureReservedWord(\"export\", { es5: true });\n\tFutureReservedWord(\"extends\", { es5: true });\n\tFutureReservedWord(\"final\");\n\tFutureReservedWord(\"float\");\n\tFutureReservedWord(\"goto\");\n\tFutureReservedWord(\"implements\", { es5: true, strictOnly: true });\n\tFutureReservedWord(\"import\", { es5: true });\n\tFutureReservedWord(\"int\");\n\tFutureReservedWord(\"interface\");\n\tFutureReservedWord(\"let\", { es5: true, strictOnly: true });\n\tFutureReservedWord(\"long\");\n\tFutureReservedWord(\"native\");\n\tFutureReservedWord(\"package\", { es5: true, strictOnly: true });\n\tFutureReservedWord(\"private\", { es5: true, strictOnly: true });\n\tFutureReservedWord(\"protected\", { es5: true, strictOnly: true });\n\tFutureReservedWord(\"public\", { es5: true, strictOnly: true });\n\tFutureReservedWord(\"short\");\n\tFutureReservedWord(\"static\", { es5: true, strictOnly: true });\n\tFutureReservedWord(\"super\", { es5: true });\n\tFutureReservedWord(\"synchronized\");\n\tFutureReservedWord(\"throws\");\n\tFutureReservedWord(\"transient\");\n\tFutureReservedWord(\"volatile\");\n\tFutureReservedWord(\"yield\", { es5: true, strictOnly: true });\n\n\t// Parse JSON\n\n\tfunction jsonValue() {\n\n\t\tfunction jsonObject() {\n\t\t\tvar o = {}, t = state.tokens.next;\n\t\t\tadvance(\"{\");\n\t\t\tif (state.tokens.next.id !== \"}\") {\n\t\t\t\tfor (;;) {\n\t\t\t\t\tif (state.tokens.next.id === \"(end)\") {\n\t\t\t\t\t\terror(\"E026\", state.tokens.next, t.line);\n\t\t\t\t\t} else if (state.tokens.next.id === \"}\") {\n\t\t\t\t\t\twarning(\"W094\", state.tokens.curr);\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t} else if (state.tokens.next.id === \",\") {\n\t\t\t\t\t\terror(\"E028\", state.tokens.next);\n\t\t\t\t\t} else if (state.tokens.next.id !== \"(string)\") {\n\t\t\t\t\t\twarning(\"W095\", state.tokens.next, state.tokens.next.value);\n\t\t\t\t\t}\n\t\t\t\t\tif (o[state.tokens.next.value] === true) {\n\t\t\t\t\t\twarning(\"W075\", state.tokens.next, state.tokens.next.value);\n\t\t\t\t\t} else if ((state.tokens.next.value === \"__proto__\" &&\n\t\t\t\t\t\t!state.option.proto) || (state.tokens.next.value === \"__iterator__\" &&\n\t\t\t\t\t\t!state.option.iterator)) {\n\t\t\t\t\t\twarning(\"W096\", state.tokens.next, state.tokens.next.value);\n\t\t\t\t\t} else {\n\t\t\t\t\t\to[state.tokens.next.value] = true;\n\t\t\t\t\t}\n\t\t\t\t\tadvance();\n\t\t\t\t\tadvance(\":\");\n\t\t\t\t\tjsonValue();\n\t\t\t\t\tif (state.tokens.next.id !== \",\") {\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t\tadvance(\",\");\n\t\t\t\t}\n\t\t\t}\n\t\t\tadvance(\"}\");\n\t\t}\n\n\t\tfunction jsonArray() {\n\t\t\tvar t = state.tokens.next;\n\t\t\tadvance(\"[\");\n\t\t\tif (state.tokens.next.id !== \"]\") {\n\t\t\t\tfor (;;) {\n\t\t\t\t\tif (state.tokens.next.id === \"(end)\") {\n\t\t\t\t\t\terror(\"E027\", state.tokens.next, t.line);\n\t\t\t\t\t} else if (state.tokens.next.id === \"]\") {\n\t\t\t\t\t\twarning(\"W094\", state.tokens.curr);\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t} else if (state.tokens.next.id === \",\") {\n\t\t\t\t\t\terror(\"E028\", state.tokens.next);\n\t\t\t\t\t}\n\t\t\t\t\tjsonValue();\n\t\t\t\t\tif (state.tokens.next.id !== \",\") {\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t\tadvance(\",\");\n\t\t\t\t}\n\t\t\t}\n\t\t\tadvance(\"]\");\n\t\t}\n\n\t\tswitch (state.tokens.next.id) {\n\t\tcase \"{\":\n\t\t\tjsonObject();\n\t\t\tbreak;\n\t\tcase \"[\":\n\t\t\tjsonArray();\n\t\t\tbreak;\n\t\tcase \"true\":\n\t\tcase \"false\":\n\t\tcase \"null\":\n\t\tcase \"(number)\":\n\t\tcase \"(string)\":\n\t\t\tadvance();\n\t\t\tbreak;\n\t\tcase \"-\":\n\t\t\tadvance(\"-\");\n\t\t\tif (state.tokens.curr.character !== state.tokens.next.from) {\n\t\t\t\twarning(\"W011\", state.tokens.curr);\n\t\t\t}\n\t\t\tadjacent(state.tokens.curr, state.tokens.next);\n\t\t\tadvance(\"(number)\");\n\t\t\tbreak;\n\t\tdefault:\n\t\t\terror(\"E003\", state.tokens.next);\n\t\t}\n\t}\n\n\n\t// The actual JSHINT function itself.\n\tvar itself = function (s, o, g) {\n\t\tvar a, i, k, x;\n\t\tvar optionKeys;\n\t\tvar newOptionObj = {};\n\n\t\tstate.reset();\n\n\t\tif (o && o.scope) {\n\t\t\tJSHINT.scope = o.scope;\n\t\t} else {\n\t\t\tJSHINT.errors = [];\n\t\t\tJSHINT.undefs = [];\n\t\t\tJSHINT.internals = [];\n\t\t\tJSHINT.blacklist = {};\n\t\t\tJSHINT.scope = \"(main)\";\n\t\t}\n\n\t\tpredefined = Object.create(null);\n\t\tcombine(predefined, vars.ecmaIdentifiers);\n\t\tcombine(predefined, vars.reservedVars);\n\n\t\tcombine(predefined, g || {});\n\n\t\tdeclared = Object.create(null);\n\t\texported = Object.create(null);\n\t\tignored = Object.create(null);\n\n\t\tif (o) {\n\t\t\ta = o.predef;\n\t\t\tif (a) {\n\t\t\t\tif (!Array.isArray(a) && typeof a === \"object\") {\n\t\t\t\t\ta = Object.keys(a);\n\t\t\t\t}\n\n\t\t\t\ta.forEach(function (item) {\n\t\t\t\t\tvar slice, prop;\n\n\t\t\t\t\tif (item[0] === \"-\") {\n\t\t\t\t\t\tslice = item.slice(1);\n\t\t\t\t\t\tJSHINT.blacklist[slice] = slice;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tprop = Object.getOwnPropertyDescriptor(o.predef, item);\n\t\t\t\t\t\tpredefined[item] = prop ? prop.value : false;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\toptionKeys = Object.keys(o);\n\t\t\tfor (x = 0; x < optionKeys.length; x++) {\n\t\t\t\tif (/^-W\\d{3}$/g.test(optionKeys[x])) {\n\t\t\t\t\tignored[optionKeys[x].slice(1)] = true;\n\t\t\t\t} else {\n\t\t\t\t\tnewOptionObj[optionKeys[x]] = o[optionKeys[x]];\n\n\t\t\t\t\tif (optionKeys[x] === \"newcap\" && o[optionKeys[x]] === false)\n\t\t\t\t\t\tnewOptionObj[\"(explicitNewcap)\"] = true;\n\n\t\t\t\t\tif (optionKeys[x] === \"indent\")\n\t\t\t\t\t\tnewOptionObj[\"(explicitIndent)\"] = true;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\tstate.option = newOptionObj;\n\n\t\tstate.option.indent = state.option.indent || 4;\n\t\tstate.option.maxerr = state.option.maxerr || 50;\n\n\t\tindent = 1;\n\t\tglobal = Object.create(predefined);\n\t\tscope = global;\n\t\tfunct = {\n\t\t\t\"(global)\":   true,\n\t\t\t\"(name)\":\t  \"(global)\",\n\t\t\t\"(scope)\":\t  scope,\n\t\t\t\"(breakage)\": 0,\n\t\t\t\"(loopage)\":  0,\n\t\t\t\"(tokens)\":   {},\n\t\t\t\"(metrics)\":   createMetrics(state.tokens.next)\n\t\t};\n\t\tfunctions = [funct];\n\t\turls = [];\n\t\tstack = null;\n\t\tmember = {};\n\t\tmembersOnly = null;\n\t\timplied = {};\n\t\tinblock = false;\n\t\tlookahead = [];\n\t\twarnings = 0;\n\t\tunuseds = [];\n\n\t\tif (!isString(s) && !Array.isArray(s)) {\n\t\t\terrorAt(\"E004\", 0);\n\t\t\treturn false;\n\t\t}\n\n\t\tif (isString(s) && /^\\s*$/g.test(s)) {\n\t\t\terrorAt(\"E005\", 0);\n\t\t\treturn false;\n\t\t}\n\n\t\tif (s.length === 0) {\n\t\t\terrorAt(\"E005\", 0);\n\t\t\treturn false;\n\t\t}\n\n\t\tvar api = {\n\t\t\tget isJSON() {\n\t\t\t\treturn state.jsonMode;\n\t\t\t},\n\n\t\t\tgetOption: function (name) {\n\t\t\t\treturn state.option[name] || null;\n\t\t\t},\n\n\t\t\tgetCache: function (name) {\n\t\t\t\treturn state.cache[name];\n\t\t\t},\n\n\t\t\tsetCache: function (name, value) {\n\t\t\t\tstate.cache[name] = value;\n\t\t\t},\n\n\t\t\twarn: function (code, data) {\n\t\t\t\twarningAt.apply(null, [ code, data.line, data.char ].concat(data.data));\n\t\t\t},\n\n\t\t\ton: function (names, listener) {\n\t\t\t\tnames.split(\" \").forEach(function (name) {\n\t\t\t\t\temitter.on(name, listener);\n\t\t\t\t}.bind(this));\n\t\t\t}\n\t\t};\n\n\t\temitter.removeAllListeners();\n\t\t(extraModules || []).forEach(function (func) {\n\t\t\tfunc(api);\n\t\t});\n\n\t\tstate.tokens.prev = state.tokens.curr = state.tokens.next = state.syntax[\"(begin)\"];\n\n\t\tlex = new Lexer(s);\n\n\t\tlex.on(\"warning\", function (ev) {\n\t\t\twarningAt.apply(null, [ ev.code, ev.line, ev.character].concat(ev.data));\n\t\t});\n\n\t\tlex.on(\"error\", function (ev) {\n\t\t\terrorAt.apply(null, [ ev.code, ev.line, ev.character ].concat(ev.data));\n\t\t});\n\n\t\tlex.on(\"fatal\", function (ev) {\n\t\t\tquit(\"E041\", ev.line, ev.from);\n\t\t});\n\n\t\tlex.on(\"Identifier\", function (ev) {\n\t\t\temitter.emit(\"Identifier\", ev);\n\t\t});\n\n\t\tlex.on(\"String\", function (ev) {\n\t\t\temitter.emit(\"String\", ev);\n\t\t});\n\n\t\tlex.on(\"Number\", function (ev) {\n\t\t\temitter.emit(\"Number\", ev);\n\t\t});\n\n\t\tlex.start();\n\n\t\t// Check options\n\t\tfor (var name in o) {\n\t\t\tif (_.has(o, name)) {\n\t\t\t\tcheckOption(name, state.tokens.curr);\n\t\t\t}\n\t\t}\n\n\t\tassume();\n\n\t\t// combine the passed globals after we've assumed all our options\n\t\tcombine(predefined, g || {});\n\n\t\t//reset values\n\t\tcomma.first = true;\n\n\t\ttry {\n\t\t\tadvance();\n\t\t\tswitch (state.tokens.next.id) {\n\t\t\tcase \"{\":\n\t\t\tcase \"[\":\n\t\t\t\tstate.option.laxbreak = true;\n\t\t\t\tstate.jsonMode = true;\n\t\t\t\tjsonValue();\n\t\t\t\tbreak;\n\t\t\tdefault:\n\t\t\t\tdirectives();\n\n\t\t\t\tif (state.directive[\"use strict\"]) {\n\t\t\t\t\tif (!state.option.globalstrict && !state.option.node) {\n\t\t\t\t\t\twarning(\"W097\", state.tokens.prev);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tstatements();\n\t\t\t}\n\t\t\tadvance((state.tokens.next && state.tokens.next.value !== \".\")\t? \"(end)\" : undefined);\n\n\t\t\tvar markDefined = function (name, context) {\n\t\t\t\tdo {\n\t\t\t\t\tif (typeof context[name] === \"string\") {\n\t\t\t\t\t\t// JSHINT marks unused variables as 'unused' and\n\t\t\t\t\t\t// unused function declaration as 'unction'. This\n\t\t\t\t\t\t// code changes such instances back 'var' and\n\t\t\t\t\t\t// 'closure' so that the code in JSHINT.data()\n\t\t\t\t\t\t// doesn't think they're unused.\n\n\t\t\t\t\t\tif (context[name] === \"unused\")\n\t\t\t\t\t\t\tcontext[name] = \"var\";\n\t\t\t\t\t\telse if (context[name] === \"unction\")\n\t\t\t\t\t\t\tcontext[name] = \"closure\";\n\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t}\n\n\t\t\t\t\tcontext = context[\"(context)\"];\n\t\t\t\t} while (context);\n\n\t\t\t\treturn false;\n\t\t\t};\n\n\t\t\tvar clearImplied = function (name, line) {\n\t\t\t\tif (!implied[name])\n\t\t\t\t\treturn;\n\n\t\t\t\tvar newImplied = [];\n\t\t\t\tfor (var i = 0; i < implied[name].length; i += 1) {\n\t\t\t\t\tif (implied[name][i] !== line)\n\t\t\t\t\t\tnewImplied.push(implied[name][i]);\n\t\t\t\t}\n\n\t\t\t\tif (newImplied.length === 0)\n\t\t\t\t\tdelete implied[name];\n\t\t\t\telse\n\t\t\t\t\timplied[name] = newImplied;\n\t\t\t};\n\n\t\t\tvar warnUnused = function (name, tkn) {\n\t\t\t\tvar line = tkn.line;\n\t\t\t\tvar chr  = tkn.character;\n\n\t\t\t\tif (state.option.unused)\n\t\t\t\t\twarningAt(\"W098\", line, chr, name);\n\n\t\t\t\tunuseds.push({\n\t\t\t\t\tname: name,\n\t\t\t\t\tline: line,\n\t\t\t\t\tcharacter: chr\n\t\t\t\t});\n\t\t\t};\n\n\t\t\tvar checkUnused = function (func, key) {\n\t\t\t\tvar type = func[key];\n\t\t\t\tvar tkn = func[\"(tokens)\"][key];\n\n\t\t\t\tif (key.charAt(0) === \"(\")\n\t\t\t\t\treturn;\n\n\t\t\t\tif (type !== \"unused\" && type !== \"unction\")\n\t\t\t\t\treturn;\n\n\t\t\t\t// Params are checked separately from other variables.\n\t\t\t\tif (func[\"(params)\"] && func[\"(params)\"].indexOf(key) !== -1)\n\t\t\t\t\treturn;\n\n\t\t\t\t// Variable is in global scope and defined as exported.\n\t\t\t\tif (func[\"(global)\"] && _.has(exported, key)) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\twarnUnused(key, tkn);\n\t\t\t};\n\n\t\t\t// Check queued 'x is not defined' instances to see if they're still undefined.\n\t\t\tfor (i = 0; i < JSHINT.undefs.length; i += 1) {\n\t\t\t\tk = JSHINT.undefs[i].slice(0);\n\n\t\t\t\tif (markDefined(k[2].value, k[0])) {\n\t\t\t\t\tclearImplied(k[2].value, k[2].line);\n\t\t\t\t} else if (state.option.undef) {\n\t\t\t\t\twarning.apply(warning, k.slice(1));\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tfunctions.forEach(function (func) {\n\t\t\t\tif (func[\"(ignoreUnused)\"]) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tfor (var key in func) {\n\t\t\t\t\tif (_.has(func, key)) {\n\t\t\t\t\t\tcheckUnused(func, key);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif (!func[\"(params)\"])\n\t\t\t\t\treturn;\n\n\t\t\t\tvar params = func[\"(params)\"].slice();\n\t\t\t\tvar param  = params.pop();\n\t\t\t\tvar type;\n\n\t\t\t\twhile (param) {\n\t\t\t\t\ttype = func[param];\n\n\t\t\t\t\t// 'undefined' is a special case for (function (window, undefined) { ... })();\n\t\t\t\t\t// patterns.\n\n\t\t\t\t\tif (param === \"undefined\")\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\tif (type !== \"unused\" && type !== \"unction\")\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\twarnUnused(param, func[\"(tokens)\"][param]);\n\t\t\t\t\tparam = params.pop();\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tfor (var key in declared) {\n\t\t\t\tif (_.has(declared, key) && !_.has(global, key)) {\n\t\t\t\t\twarnUnused(key, declared[key]);\n\t\t\t\t}\n\t\t\t}\n\t\t} catch (err) {\n\t\t\tif (err && err.name === \"JSHintError\") {\n\t\t\t\tvar nt = state.tokens.next || {};\n\t\t\t\tJSHINT.errors.push({\n\t\t\t\t\tscope     : \"(main)\",\n\t\t\t\t\traw       : err.raw,\n\t\t\t\t\treason    : err.message,\n\t\t\t\t\tline      : err.line || nt.line,\n\t\t\t\t\tcharacter : err.character || nt.from\n\t\t\t\t}, null);\n\t\t\t} else {\n\t\t\t\tthrow err;\n\t\t\t}\n\t\t}\n\n\t\t// Loop over the listed \"internals\", and check them as well.\n\n\t\tif (JSHINT.scope === \"(main)\") {\n\t\t\to = o || {};\n\n\t\t\tfor (i = 0; i < JSHINT.internals.length; i += 1) {\n\t\t\t\tk = JSHINT.internals[i];\n\t\t\t\to.scope = k.elem;\n\t\t\t\titself(k.value, o, g);\n\t\t\t}\n\t\t}\n\n\t\treturn JSHINT.errors.length === 0;\n\t};\n\n\t// Modules.\n\titself.addModule = function (func) {\n\t\textraModules.push(func);\n\t};\n\n\titself.addModule(style.register);\n\n\t// Data summary.\n\titself.data = function () {\n\t\tvar data = {\n\t\t\tfunctions: [],\n\t\t\toptions: state.option\n\t\t};\n\t\tvar implieds = [];\n\t\tvar members = [];\n\t\tvar fu, f, i, j, n, globals;\n\n\t\tif (itself.errors.length) {\n\t\t\tdata.errors = itself.errors;\n\t\t}\n\n\t\tif (state.jsonMode) {\n\t\t\tdata.json = true;\n\t\t}\n\n\t\tfor (n in implied) {\n\t\t\tif (_.has(implied, n)) {\n\t\t\t\timplieds.push({\n\t\t\t\t\tname: n,\n\t\t\t\t\tline: implied[n]\n\t\t\t\t});\n\t\t\t}\n\t\t}\n\n\t\tif (implieds.length > 0) {\n\t\t\tdata.implieds = implieds;\n\t\t}\n\n\t\tif (urls.length > 0) {\n\t\t\tdata.urls = urls;\n\t\t}\n\n\t\tglobals = Object.keys(scope);\n\t\tif (globals.length > 0) {\n\t\t\tdata.globals = globals;\n\t\t}\n\n\t\tfor (i = 1; i < functions.length; i += 1) {\n\t\t\tf = functions[i];\n\t\t\tfu = {};\n\n\t\t\tfor (j = 0; j < functionicity.length; j += 1) {\n\t\t\t\tfu[functionicity[j]] = [];\n\t\t\t}\n\n\t\t\tfor (j = 0; j < functionicity.length; j += 1) {\n\t\t\t\tif (fu[functionicity[j]].length === 0) {\n\t\t\t\t\tdelete fu[functionicity[j]];\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tfu.name = f[\"(name)\"];\n\t\t\tfu.param = f[\"(params)\"];\n\t\t\tfu.line = f[\"(line)\"];\n\t\t\tfu.character = f[\"(character)\"];\n\t\t\tfu.last = f[\"(last)\"];\n\t\t\tfu.lastcharacter = f[\"(lastcharacter)\"];\n\t\t\tdata.functions.push(fu);\n\t\t}\n\n\t\tif (unuseds.length > 0) {\n\t\t\tdata.unused = unuseds;\n\t\t}\n\n\t\tmembers = [];\n\t\tfor (n in member) {\n\t\t\tif (typeof member[n] === \"number\") {\n\t\t\t\tdata.member = member;\n\t\t\t\tbreak;\n\t\t\t}\n\t\t}\n\n\t\treturn data;\n\t};\n\n\titself.jshint = itself;\n\n\treturn itself;\n}());\n\n// Make JSHINT a Node module, if possible.\nif (typeof exports === \"object\" && exports) {\n\texports.JSHINT = JSHINT;\n}\n\n//@ sourceURL=/src/stable/jshint.js"
));
require("/src/stable/jshint.js");

JSHINT = require('/src/stable/jshint.js').JSHINT;})();

/*jshint boss: true, rhino: true, unused: true, undef: true, white: true, quotmark: double */
/*global JSHINT */

(function (args) {
	"use strict";

	var filenames = [];
	var optstr; // arg1=val1,arg2=val2,...
	var predef; // global1=true,global2,global3,...
	var opts   = {};
	var retval = 0;

	args.forEach(function (arg) {
		if (arg.indexOf("=") > -1) {
			if (!optstr) {
				// First time it's the options.
				optstr = arg;
			} else {
				predef = arg;
			}

			return;
		}

		if (optstr) {
			predef = arg;
			return;
		}

		filenames.push(arg);
	});

	if (filenames.length === 0) {
		print("Usage: jshint.js file.js");
		quit(1);
	}

	if (optstr) {
		optstr.split(",").forEach(function (arg) {
			var o = arg.split("=");
			if (o[0] === "indent") {
				opts[o[0]] = parseInt(o[1], 10);
			} else {
				opts[o[0]] = (function (ov) {
					switch (ov) {
					case "true":
						return true;
					case "false":
						return false;
					default:
						return ov;
					}
				}(o[1]));
			}
		});
	}

	if (predef) {
		opts.predef = {};

		predef.split(",").forEach(function (arg) {
			var global = arg.split("=");
			opts.predef[global[0]] = global[1] === "true" ? true : false;
		});
	}

	filenames.forEach(function (name) {
		var input = readFile(name);

		if (!input) {
			print("jshint: Couldn't open file " + name);
			quit(1);
		}

		if (!JSHINT(input, opts)) {
			for (var i = 0, err; err = JSHINT.errors[i]; i += 1) {
				print(err.reason + " (" + name + ":" + err.line + ":" + err.character + ")");
				print("> " + (err.evidence || "").replace(/^\s*(\S*(\s+\S+)*)\s*$/, "$1"));
				print("");
			}
			retval = 1;
		}
	});

	quit(retval);
}(arguments));
