/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangException;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangRangeException;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class OtpErlangString
extends OtpErlangObject
implements Serializable,
Cloneable {
    static final long serialVersionUID = -7053595217604929233L;
    private final String str;

    public OtpErlangString(String string) {
        this.str = string;
    }

    public OtpErlangString(OtpErlangList otpErlangList) throws OtpErlangException {
        String string = otpErlangList.stringValue();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            int n3 = string.codePointAt(n2);
            if (!OtpErlangString.isValidCodePoint(n3)) {
                throw new OtpErlangRangeException("Invalid CodePoint: " + n3);
            }
            n2 = string.offsetByCodePoints(n2, 1);
        }
        this.str = string;
    }

    public OtpErlangString(OtpInputStream otpInputStream) throws OtpErlangDecodeException {
        this.str = otpInputStream.read_string();
    }

    public String stringValue() {
        return this.str;
    }

    public String toString() {
        return "\"" + this.str + "\"";
    }

    public void encode(OtpOutputStream otpOutputStream) {
        otpOutputStream.write_string(this.str);
    }

    public boolean equals(Object object) {
        if (object instanceof String) {
            return this.str.compareTo((String)object) == 0;
        }
        if (object instanceof OtpErlangString) {
            return this.str.compareTo(((OtpErlangString)object).str) == 0;
        }
        return false;
    }

    protected int doHashCode() {
        return this.str.hashCode();
    }

    public static int[] stringToCodePoints(String string) {
        int n = string.codePointCount(0, string.length());
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            nArray[i] = string.codePointAt(n2);
            n2 = string.offsetByCodePoints(n2, 1);
        }
        return nArray;
    }

    public static boolean isValidCodePoint(int n) {
        return n >>> 16 <= 16 && (n & 0xFFFFF800) != 55296 && (n & 0xFFFFFFFE) != 65534;
    }

    public static String newString(byte[] byArray) {
        try {
            return new String(byArray, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray);
        }
    }
}

