/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpLocalNode;
import com.ericsson.otp.erlang.OtpOutputStream;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OtpErlangPid
extends OtpErlangObject
implements Serializable,
Cloneable,
Comparable<Object> {
    static final long serialVersionUID = 1664394142301803659L;
    private final String node;
    private final int id;
    private final int serial;
    private final int creation;

    @Deprecated
    public OtpErlangPid(OtpLocalNode otpLocalNode) {
        OtpErlangPid otpErlangPid = otpLocalNode.createPid();
        this.id = otpErlangPid.id;
        this.serial = otpErlangPid.serial;
        this.creation = otpErlangPid.creation;
        this.node = otpErlangPid.node;
    }

    public OtpErlangPid(OtpInputStream otpInputStream) throws OtpErlangDecodeException {
        OtpErlangPid otpErlangPid = otpInputStream.read_pid();
        this.node = otpErlangPid.node();
        this.id = otpErlangPid.id();
        this.serial = otpErlangPid.serial();
        this.creation = otpErlangPid.creation();
    }

    public OtpErlangPid(String string, int n, int n2, int n3) {
        this.node = string;
        this.id = n & Short.MAX_VALUE;
        this.serial = n2 & 0x1FFF;
        this.creation = n3 & 3;
    }

    public int serial() {
        return this.serial;
    }

    public int id() {
        return this.id;
    }

    public int creation() {
        return this.creation;
    }

    public String node() {
        return this.node;
    }

    @Override
    public String toString() {
        return "#Pid<" + this.node.toString() + "." + this.id + "." + this.serial + ">";
    }

    @Override
    public void encode(OtpOutputStream otpOutputStream) {
        otpOutputStream.write_pid(this.node, this.id, this.serial, this.creation);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof OtpErlangPid)) {
            return false;
        }
        OtpErlangPid otpErlangPid = (OtpErlangPid)object;
        return this.creation == otpErlangPid.creation && this.serial == otpErlangPid.serial && this.id == otpErlangPid.id && this.node.compareTo(otpErlangPid.node) == 0;
    }

    @Override
    protected int doHashCode() {
        OtpErlangObject.Hash hash = new OtpErlangObject.Hash(5);
        hash.combine(this.creation, this.serial);
        hash.combine(this.id, this.node.hashCode());
        return hash.valueOf();
    }

    @Override
    public int compareTo(Object object) {
        if (!(object instanceof OtpErlangPid)) {
            return -1;
        }
        OtpErlangPid otpErlangPid = (OtpErlangPid)object;
        if (this.creation == otpErlangPid.creation) {
            if (this.serial == otpErlangPid.serial) {
                if (this.id == otpErlangPid.id) {
                    return this.node.compareTo(otpErlangPid.node);
                }
                return this.id - otpErlangPid.id;
            }
            return this.serial - otpErlangPid.serial;
        }
        return this.creation - otpErlangPid.creation;
    }
}

