/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.builders;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.entity.Metadata;
import com.epam.ta.reportportal.entity.user.User;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.entity.user.UserType;
import com.epam.ta.reportportal.ws.model.user.CreateUserRQConfirm;
import com.epam.ta.reportportal.ws.model.user.CreateUserRQFull;
import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Supplier;

public class UserBuilder
implements Supplier<User> {
    public static final String USER_LAST_LOGIN = "last_login";
    private User user;

    public UserBuilder() {
        this.user = new User();
    }

    public UserBuilder(User user) {
        this.user = user;
    }

    public UserBuilder addCreateUserRQ(CreateUserRQConfirm request) {
        if (request != null) {
            this.fillUser(request.getLogin(), request.getEmail(), request.getFullName());
        }
        return this;
    }

    public UserBuilder addCreateUserFullRQ(CreateUserRQFull request) {
        Optional.ofNullable(request).ifPresent(it -> this.fillUser(it.getLogin(), it.getEmail(), it.getFullName()));
        return this;
    }

    public UserBuilder addPassword(String password) {
        this.user.setPassword(password);
        return this;
    }

    public UserBuilder addUserRole(UserRole userRole) {
        this.user.setRole(userRole);
        return this;
    }

    @Override
    public User get() {
        return this.user;
    }

    private void fillUser(String login, String email, String fullName) {
        this.user.setLogin(EntityUtils.normalizeId((String)login));
        this.user.setEmail(EntityUtils.normalizeId((String)email.trim()));
        this.user.setFullName(fullName);
        this.user.setUserType(UserType.INTERNAL);
        this.user.setExpired(false);
        HashMap<String, Date> meta = new HashMap<String, Date>();
        meta.put(USER_LAST_LOGIN, new Date());
        this.user.setMetadata(new Metadata(meta));
    }
}

