/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.builders;

import com.epam.ta.reportportal.entity.enums.IntegrationGroupEnum;
import com.epam.ta.reportportal.entity.integration.IntegrationType;
import com.epam.ta.reportportal.entity.integration.IntegrationTypeDetails;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.function.Supplier;
import javax.validation.constraints.NotNull;

public class IntegrationTypeBuilder
implements Supplier<IntegrationType> {
    private final IntegrationType integrationType;

    public IntegrationTypeBuilder() {
        this.integrationType = new IntegrationType();
        this.integrationType.setCreationDate(LocalDateTime.now());
        this.integrationType.setDetails(IntegrationTypeBuilder.createIntegrationTypeDetails());
    }

    public IntegrationTypeBuilder(IntegrationType integrationType) {
        this.integrationType = integrationType;
        if (this.integrationType.getDetails() == null) {
            this.integrationType.setDetails(IntegrationTypeBuilder.createIntegrationTypeDetails());
        }
    }

    public static IntegrationTypeDetails createIntegrationTypeDetails() {
        IntegrationTypeDetails integrationTypeDetails = new IntegrationTypeDetails();
        integrationTypeDetails.setDetails((Map)Maps.newHashMap());
        return integrationTypeDetails;
    }

    public IntegrationTypeBuilder setName(String name) {
        this.integrationType.setName(name);
        return this;
    }

    public IntegrationTypeBuilder setIntegrationGroup(IntegrationGroupEnum integrationGroup) {
        this.integrationType.setIntegrationGroup(integrationGroup);
        return this;
    }

    public IntegrationTypeBuilder setDetails(IntegrationTypeDetails typeDetails) {
        this.integrationType.setDetails(typeDetails);
        return this;
    }

    public IntegrationTypeBuilder setEnabled(boolean enabled) {
        this.integrationType.setEnabled(enabled);
        return this;
    }

    @Override
    @NotNull
    public IntegrationType get() {
        return this.integrationType;
    }
}

