/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.builders;

import com.epam.ta.reportportal.entity.dashboard.Dashboard;
import com.epam.ta.reportportal.entity.dashboard.DashboardWidget;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.ws.model.dashboard.CreateDashboardRQ;
import com.epam.ta.reportportal.ws.model.dashboard.UpdateDashboardRQ;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class DashboardBuilder
implements Supplier<Dashboard> {
    private Dashboard dashboard;

    public DashboardBuilder() {
        this.dashboard = new Dashboard();
    }

    public DashboardBuilder(Dashboard dashboard) {
        this.dashboard = dashboard;
    }

    public DashboardBuilder addDashboardRq(CreateDashboardRQ rq) {
        this.dashboard.setName(rq.getName());
        this.dashboard.setDescription(rq.getDescription());
        Optional.ofNullable(rq.getShare()).ifPresent(it -> this.dashboard.setShared(it.booleanValue()));
        return this;
    }

    public DashboardBuilder addProject(Long projectId) {
        Project project = new Project();
        project.setId(projectId);
        this.dashboard.setProject(project);
        return this;
    }

    public DashboardBuilder addUpdateRq(UpdateDashboardRQ rq) {
        Optional.ofNullable(rq.getName()).ifPresent(name -> this.dashboard.setName(name));
        Optional.ofNullable(rq.getDescription()).ifPresent(description -> this.dashboard.setDescription(description));
        Optional.ofNullable(rq.getShare()).ifPresent(share -> this.dashboard.setShared(share.booleanValue()));
        Optional.ofNullable(rq.getWidgets()).ifPresent(widgets -> {
            for (DashboardWidget dashboardWidget : this.dashboard.getDashboardWidgets()) {
                widgets.stream().filter(updWidget -> Objects.equals(dashboardWidget.getId().getWidgetId(), updWidget.getWidgetId())).forEach(updWidget -> {
                    Optional.ofNullable(updWidget.getWidgetPosition()).ifPresent(position -> {
                        dashboardWidget.setPositionX(position.getX());
                        dashboardWidget.setPositionY(position.getY());
                    });
                    Optional.ofNullable(updWidget.getWidgetSize()).ifPresent(size -> {
                        dashboardWidget.setWidth(size.getWidth());
                        dashboardWidget.setHeight(size.getHeight());
                    });
                });
            }
        });
        return this;
    }

    public DashboardBuilder addOwner(String owner) {
        this.dashboard.setOwner(owner);
        return this;
    }

    @Override
    public Dashboard get() {
        return this.dashboard;
    }
}

