/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.item.FinishTestItemHandler;
import com.epam.ta.reportportal.core.item.StartTestItemHandler;
import com.epam.ta.reportportal.core.logging.HttpLogging;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.ws.model.EntryCreatedAsyncRS;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v2/{projectName}/item"})
@PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
public class TestItemAsyncController {
    private final StartTestItemHandler startTestItemHandler;
    private final FinishTestItemHandler finishTestItemHandler;

    @Autowired
    public TestItemAsyncController(@Qualifier(value="startTestItemHandlerAsync") StartTestItemHandler startTestItemHandler, @Qualifier(value="finishTestItemHandlerAsync") FinishTestItemHandler finishTestItemHandler) {
        this.startTestItemHandler = startTestItemHandler;
        this.finishTestItemHandler = finishTestItemHandler;
    }

    @HttpLogging
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="Start a root test item")
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')")
    public EntryCreatedAsyncRS startRootItem(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @RequestBody @Validated StartTestItemRQ startTestItemRQ) {
        return this.startTestItemHandler.startRootItem(user, ProjectExtractor.extractProjectDetails(user, projectName), startTestItemRQ);
    }

    @HttpLogging
    @PostMapping(value={"/{parentItem}"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="Start a child test item")
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')")
    public EntryCreatedAsyncRS startChildItem(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @PathVariable String parentItem, @RequestBody @Validated StartTestItemRQ startTestItemRQ) {
        return this.startTestItemHandler.startChildItem(user, ProjectExtractor.extractProjectDetails(user, projectName), startTestItemRQ, parentItem);
    }

    @HttpLogging
    @PutMapping(value={"/{testItemId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Finish test item")
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')")
    public OperationCompletionRS finishTestItem(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @PathVariable String testItemId, @RequestBody @Validated FinishTestItemRQ finishExecutionRQ) {
        return this.finishTestItemHandler.finishTestItem(user, ProjectExtractor.extractProjectDetails(user, projectName), testItemId, finishExecutionRQ);
    }
}

