/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.analyzer.auto.SearchLogService;
import com.epam.ta.reportportal.core.log.CreateLogHandler;
import com.epam.ta.reportportal.core.log.DeleteLogHandler;
import com.epam.ta.reportportal.core.log.GetLogHandler;
import com.epam.ta.reportportal.entity.log.Log;
import com.epam.ta.reportportal.util.ControllerUtils;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.ws.model.BatchElementCreatedRS;
import com.epam.ta.reportportal.ws.model.BatchSaveOperatingRS;
import com.epam.ta.reportportal.ws.model.EntryCreatedAsyncRS;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.log.LogResource;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import com.epam.ta.reportportal.ws.model.log.SearchLogRq;
import com.epam.ta.reportportal.ws.model.log.SearchLogRs;
import com.epam.ta.reportportal.ws.resolver.FilterFor;
import com.epam.ta.reportportal.ws.resolver.SortFor;
import com.google.common.collect.ImmutableMap;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Map;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.SortDefault;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/v1/{projectName}/log"})
@PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
public class LogController {
    private final CreateLogHandler createLogHandler;
    private final DeleteLogHandler deleteLogHandler;
    private final GetLogHandler getLogHandler;
    private final SearchLogService searchLogService;
    private final Validator validator;

    @Autowired
    public LogController(@Autowired CreateLogHandler createLogHandler, DeleteLogHandler deleteLogHandler, GetLogHandler getLogHandler, SearchLogService searchLogService, Validator validator) {
        this.createLogHandler = createLogHandler;
        this.deleteLogHandler = deleteLogHandler;
        this.getLogHandler = getLogHandler;
        this.searchLogService = searchLogService;
        this.validator = validator;
    }

    @PostMapping(consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="Create log")
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')")
    public EntryCreatedAsyncRS createLog(@PathVariable String projectName, @RequestBody SaveLogRQ createLogRQ, @AuthenticationPrincipal ReportPortalUser user) {
        ControllerUtils.validateSaveRQ(this.validator, createLogRQ);
        return this.createLogHandler.createLog(createLogRQ, null, ProjectExtractor.extractProjectDetails(user, projectName));
    }

    @PostMapping(consumes={"multipart/form-data"})
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')")
    public ResponseEntity<BatchSaveOperatingRS> createLog(@PathVariable String projectName, @RequestPart(value="json_request_part") SaveLogRQ[] createLogRQs, HttpServletRequest request, @AuthenticationPrincipal ReportPortalUser user) {
        Map<String, MultipartFile> uploadedFiles = ControllerUtils.getUploadedFiles(request);
        BatchSaveOperatingRS response = new BatchSaveOperatingRS();
        for (SaveLogRQ createLogRq : createLogRQs) {
            try {
                EntryCreatedAsyncRS responseItem;
                String filename;
                ControllerUtils.validateSaveRQ(this.validator, createLogRq);
                String string = filename = createLogRq.getFile() == null ? null : createLogRq.getFile().getName();
                if (StringUtils.isEmpty((CharSequence)filename)) {
                    responseItem = this.createLog(projectName, createLogRq, user);
                } else {
                    MultipartFile data = ControllerUtils.findByFileName(filename, uploadedFiles);
                    BusinessRule.expect((Object)data, (Predicate)Predicates.notNull()).verify(ErrorType.BINARY_DATA_CANNOT_BE_SAVED, new Object[]{Suppliers.formattedSupplier((String)"There is no request part or file with name {}", (Object[])new Object[]{filename})});
                    responseItem = this.createLogHandler.createLog(createLogRq, data, ProjectExtractor.extractProjectDetails(user, projectName));
                }
                response.addResponse(new BatchElementCreatedRS(responseItem.getId()));
            }
            catch (Exception e) {
                response.addResponse(new BatchElementCreatedRS(ExceptionUtils.getStackTrace((Throwable)e), ExceptionUtils.getMessage((Throwable)e)));
            }
        }
        return new ResponseEntity((Object)response, HttpStatus.CREATED);
    }

    @RequestMapping(value={"/{logId}"}, method={RequestMethod.DELETE})
    @ApiOperation(value="Delete log")
    @Transactional
    public OperationCompletionRS deleteLog(@PathVariable String projectName, @PathVariable Long logId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.deleteLogHandler.deleteLog(logId, ProjectExtractor.extractProjectDetails(user, projectName), user);
    }

    @RequestMapping(method={RequestMethod.GET})
    @ApiOperation(value="Get logs by filter")
    @Transactional(readOnly=true)
    public Iterable<LogResource> getLogs(@PathVariable String projectName, @RequestParam(value="filter.under.path", required=false) String underPath, @FilterFor(value=Log.class) Filter filter, @SortDefault(value={"logTime"}) @SortFor(value=Log.class) Pageable pageable, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getLogHandler.getLogs(underPath, ProjectExtractor.extractProjectDetails(user, projectName), filter, pageable);
    }

    @GetMapping(value={"/{logId}/page"})
    @ApiOperation(value="Get logs by filter")
    @Transactional(readOnly=true)
    public Map<String, Serializable> getPageNumber(@PathVariable String projectName, @PathVariable Long logId, @FilterFor(value=Log.class) Filter filter, @SortFor(value=Log.class) Pageable pageable, @AuthenticationPrincipal ReportPortalUser user) {
        return ImmutableMap.builder().put((Object)"number", (Object)this.getLogHandler.getPageNumber(logId, ProjectExtractor.extractProjectDetails(user, projectName), filter, pageable)).build();
    }

    @GetMapping(value={"/{logId}"})
    @ApiOperation(value="Get log by ID")
    @Transactional(readOnly=true)
    public LogResource getLog(@PathVariable String projectName, @PathVariable String logId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getLogHandler.getLog(logId, ProjectExtractor.extractProjectDetails(user, projectName), user);
    }

    @GetMapping(value={"/uuid/{logId}"})
    @ApiOperation(value="Get log by UUID")
    @Transactional(readOnly=true)
    public LogResource getLogByUuid(@PathVariable String projectName, @PathVariable String logId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getLogHandler.getLog(logId, ProjectExtractor.extractProjectDetails(user, projectName), user);
    }

    @GetMapping(value={"/nested/{parentId}"})
    @ApiOperation(value="Get nested steps with logs for the parent Test Item")
    @Transactional(readOnly=true)
    public Iterable<?> getNestedItems(@PathVariable String projectName, @PathVariable Long parentId, @ApiParam(required=false) @RequestParam Map<String, String> params, @FilterFor(value=Log.class) Filter filter, @SortFor(value=Log.class) Pageable pageable, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getLogHandler.getNestedItems(parentId, ProjectExtractor.extractProjectDetails(user, projectName), params, (Queryable)filter, pageable);
    }

    @PostMapping(value={"search/{itemId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Search test items with similar error logs")
    public Iterable<SearchLogRs> searchLogs(@PathVariable String projectName, @RequestBody SearchLogRq request, @PathVariable Long itemId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.searchLogService.search(itemId, request, ProjectExtractor.extractProjectDetails(user, projectName));
    }
}

