/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.file.DeleteFilesHandler;
import com.epam.ta.reportportal.core.file.GetFileHandler;
import com.epam.ta.reportportal.core.user.EditUserHandler;
import com.epam.ta.reportportal.entity.attachment.BinaryData;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/v1/data"})
public class FileStorageController {
    private final EditUserHandler editUserHandler;
    private final GetFileHandler getFileHandler;
    private final DeleteFilesHandler deleteFilesHandler;

    @Autowired
    public FileStorageController(EditUserHandler editUserHandler, GetFileHandler getFileHandler, DeleteFilesHandler deleteFilesHandler) {
        this.editUserHandler = editUserHandler;
        this.getFileHandler = getFileHandler;
        this.deleteFilesHandler = deleteFilesHandler;
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
    @GetMapping(value={"/{projectName}/{dataId}"})
    public void getFile(@PathVariable String projectName, @PathVariable(value="dataId") Long dataId, HttpServletResponse response, @AuthenticationPrincipal ReportPortalUser user) {
        this.toResponse(response, this.getFileHandler.loadFileById(dataId, ProjectExtractor.extractProjectDetails(user, projectName)));
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/photo"})
    @ApiOperation(value="Get photo of current user")
    public void getMyPhoto(@AuthenticationPrincipal ReportPortalUser user, HttpServletResponse response, @RequestParam(value="loadThumbnail", required=false) boolean loadThumbnail) {
        this.toResponse(response, this.getFileHandler.getUserPhoto(user, loadThumbnail));
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'notCustomerPermission')")
    @GetMapping(value={"/{projectName}/userphoto"})
    @ApiOperation(value="Get user's photo")
    public void getUserPhoto(@PathVariable String projectName, @RequestParam(value="id") String username, @RequestParam(value="loadThumbnail", required=false) boolean loadThumbnail, HttpServletResponse response, @AuthenticationPrincipal ReportPortalUser user) {
        BinaryData userPhoto = this.getFileHandler.getUserPhoto(EntityUtils.normalizeId((String)username), user, projectName, loadThumbnail);
        this.toResponse(response, userPhoto);
    }

    @Transactional
    @PostMapping(value={"/photo"}, consumes={"multipart/form-data"})
    @ApiOperation(value="Upload user's photo")
    public OperationCompletionRS uploadPhoto(@RequestParam(value="file") MultipartFile file, @AuthenticationPrincipal ReportPortalUser user) {
        return this.editUserHandler.uploadPhoto(EntityUtils.normalizeId((String)user.getUsername()), file);
    }

    @Transactional
    @DeleteMapping(value={"/photo"})
    @ApiOperation(value="Delete user's photo")
    public OperationCompletionRS deletePhoto(@AuthenticationPrincipal ReportPortalUser user) {
        return this.editUserHandler.deletePhoto(EntityUtils.normalizeId((String)user.getUsername()));
    }

    @Transactional
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @PostMapping(value={"/clean"}, consumes={"multipart/form-data"})
    @ApiOperation(value="Remove attachments from file storage according to uploaded csv file")
    public OperationCompletionRS removeAttachmentsByCsv(@RequestParam(value="file") MultipartFile file, @AuthenticationPrincipal ReportPortalUser user) {
        return this.deleteFilesHandler.removeFilesByCsv(file);
    }

    private void toResponse(HttpServletResponse response, BinaryData binaryData) {
        if (binaryData.getInputStream() != null) {
            try {
                response.setContentType(binaryData.getContentType());
                IOUtils.copy((InputStream)binaryData.getInputStream(), (OutputStream)response.getOutputStream());
            }
            catch (IOException e) {
                throw new ReportPortalException("Unable to retrieve binary data from data storage", (Throwable)e);
            }
        } else {
            response.setStatus(HttpStatus.NO_CONTENT.value());
        }
    }
}

