/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.activity.ActivityHandler;
import com.epam.ta.reportportal.entity.activity.Activity;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.ws.model.ActivityResource;
import com.epam.ta.reportportal.ws.resolver.FilterFor;
import com.epam.ta.reportportal.ws.resolver.SortFor;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/{projectName}/activity"})
@Transactional(readOnly=true)
@PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
public class ActivityController {
    private final ActivityHandler activityHandler;
    private final ProjectExtractor projectExtractor;

    @Autowired
    public ActivityController(ActivityHandler activityHandler, ProjectExtractor projectExtractor) {
        this.activityHandler = activityHandler;
        this.projectExtractor = projectExtractor;
    }

    @RequestMapping(value={"", "/"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get activities for project")
    public Iterable<ActivityResource> getActivities(@PathVariable String projectName, @FilterFor(value=Activity.class) Filter filter, @FilterFor(value=Activity.class) Queryable predefinedFilter, @SortFor(value=Activity.class) Pageable pageable, @AuthenticationPrincipal ReportPortalUser user) {
        ReportPortalUser.ProjectDetails projectDetails = this.projectExtractor.extractProjectDetailsAdmin(user, EntityUtils.normalizeId((String)projectName));
        return this.activityHandler.getActivitiesHistory(projectDetails, filter, predefinedFilter, pageable);
    }

    @RequestMapping(value={"/{activityId}"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public ActivityResource getActivity(@PathVariable String projectName, @PathVariable Long activityId, @AuthenticationPrincipal ReportPortalUser user) {
        ReportPortalUser.ProjectDetails projectDetails = this.projectExtractor.extractProjectDetailsAdmin(user, EntityUtils.normalizeId((String)projectName));
        return this.activityHandler.getActivity(projectDetails, activityId);
    }

    @RequestMapping(value={"/item/{itemId}"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get activities for test item")
    public Iterable<ActivityResource> getTestItemActivities(@PathVariable String projectName, @PathVariable Long itemId, @FilterFor(value=Activity.class) Filter filter, @SortFor(value=Activity.class) Pageable pageable, @AuthenticationPrincipal ReportPortalUser user) {
        ReportPortalUser.ProjectDetails projectDetails = this.projectExtractor.extractProjectDetailsAdmin(user, EntityUtils.normalizeId((String)projectName));
        return this.activityHandler.getItemActivities(projectDetails, itemId, filter, pageable);
    }
}

