/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job.service.impl;

import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.job.PageUtil;
import com.epam.ta.reportportal.job.service.AttachmentCleanerService;
import com.epam.ta.reportportal.job.service.LogCleanerService;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LogCleanerServiceImpl
implements LogCleanerService {
    private final Integer itemPageSize;
    private final AttachmentCleanerService attachmentCleanerService;
    private final TestItemRepository testItemRepository;
    private final LogRepository logRepository;

    @Autowired
    public LogCleanerServiceImpl(@Value(value="${rp.environment.variable.clean.items.size}") Integer itemPageSize, AttachmentCleanerService attachmentCleanerService, TestItemRepository testItemRepository, LogRepository logRepository) {
        this.itemPageSize = itemPageSize;
        this.attachmentCleanerService = attachmentCleanerService;
        this.testItemRepository = testItemRepository;
        this.logRepository = logRepository;
    }

    @Override
    @Transactional
    public long removeOutdatedLogs(Long launchId, LocalDateTime startTimeBound, AtomicLong attachmentsCount, AtomicLong thumbnailsCount) {
        Duration period = Duration.between(LocalDateTime.now(), startTimeBound);
        AtomicLong logsCount = new AtomicLong(0L);
        PageUtil.iterateOverContent(this.itemPageSize, pageable -> this.testItemRepository.findTestItemIdsByLaunchId(launchId, pageable), itemIds -> {
            this.attachmentCleanerService.removeOutdatedItemsAttachments((Collection<Long>)itemIds, startTimeBound, attachmentsCount, thumbnailsCount);
            long removedCount = this.logRepository.deleteByPeriodAndTestItemIds(period, (Collection)itemIds);
            logsCount.addAndGet(removedCount);
        });
        this.attachmentCleanerService.removeOutdatedLaunchesAttachments(Collections.singletonList(launchId), startTimeBound, attachmentsCount, thumbnailsCount);
        long removedCount = this.logRepository.deleteByPeriodAndLaunchIds(period, Collections.singletonList(launchId));
        logsCount.addAndGet(removedCount);
        return logsCount.get();
    }
}

