/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job;

import com.epam.ta.reportportal.dao.ActivityRepository;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.entity.enums.ProjectAttributeEnum;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectUtils;
import com.epam.ta.reportportal.job.PageUtil;
import com.epam.ta.reportportal.job.service.LogCleanerService;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.math.NumberUtils;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"!unittest"})
public class CleanLogsJob
implements Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(CleanLogsJob.class);
    private final Integer threadsCount;
    private final Integer launchesLimit;
    private final LogCleanerService logCleaner;
    private final ProjectRepository projectRepository;
    private final ActivityRepository activityRepository;
    private final LaunchRepository launchRepository;

    public CleanLogsJob(@Value(value="${rp.environment.variable.clean.logs.pool}") Integer threadsCount, @Value(value="${rp.environment.variable.clean.launches.size}") Integer launchesLimit, LogCleanerService logCleaner, ProjectRepository projectRepository, ActivityRepository activityRepository, LaunchRepository launchRepository) {
        this.threadsCount = threadsCount;
        this.launchesLimit = launchesLimit;
        this.logCleaner = logCleaner;
        this.projectRepository = projectRepository;
        this.activityRepository = activityRepository;
        this.launchRepository = launchRepository;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        LOGGER.info("Cleaning outdated logs has been started");
        ExecutorService executor = Executors.newFixedThreadPool(this.threadsCount, new ThreadFactoryBuilder().setNameFormat("clean-logs-job-thread-%d").build());
        PageUtil.iterateOverPages(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"id")}), arg_0 -> ((ProjectRepository)this.projectRepository).findAllIdsAndProjectAttributes(arg_0), projects -> projects.forEach(project -> {
            try {
                LOGGER.info("Cleaning outdated logs for project {} has been started", (Object)project.getId());
                this.proceedLogsRemoving((Project)project, executor);
            }
            catch (Exception e) {
                LOGGER.error("Cleaning outdated logs for project {} has been failed", (Object)project.getId(), (Object)e);
            }
        }));
        executor.shutdown();
        LOGGER.info("Cleaning logs has been finished");
    }

    private void proceedLogsRemoving(Project project, ExecutorService executor) {
        ProjectUtils.extractAttributeValue((Project)project, (ProjectAttributeEnum)ProjectAttributeEnum.KEEP_LOGS).map(it -> Duration.ofSeconds(NumberUtils.toLong((String)it, (long)0L))).filter(it -> !it.isZero()).ifPresent(period -> {
            this.activityRepository.deleteModifiedLaterAgo(project.getId(), period);
            this.cleanLogs(project, (Duration)period, executor);
        });
    }

    private void cleanLogs(Project project, Duration period, ExecutorService executor) {
        LocalDateTime startTimeBound = LocalDateTime.now(ZoneOffset.UTC).minus(period);
        AtomicLong removedLogsCount = new AtomicLong(0L);
        AtomicLong attachmentsCount = new AtomicLong(0L);
        AtomicLong thumbnailsCount = new AtomicLong(0L);
        PageUtil.iterateOverContent(this.launchesLimit, pageable -> this.launchRepository.findIdsByProjectIdAndStartTimeBefore(project.getId(), startTimeBound, pageable.getPageSize(), pageable.getOffset()), launchIds -> CompletableFuture.allOf((CompletableFuture[])launchIds.stream().map(launchId -> CompletableFuture.supplyAsync(() -> this.logCleaner.removeOutdatedLogs((Long)launchId, startTimeBound, attachmentsCount, thumbnailsCount), executor).thenAcceptAsync(removedLogsCount::addAndGet, (Executor)executor)).toArray(CompletableFuture[]::new)).join());
        LOGGER.info("Cleaning outdated logs for project {} has been finished. Removed {} logs with {} attachments and {} thumbnails", new Object[]{project.getId(), removedLogsCount.get(), attachmentsCount.get(), thumbnailsCount.get()});
    }
}

