/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job;

import com.epam.ta.reportportal.dao.ActivityRepository;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.entity.enums.ProjectAttributeEnum;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectUtils;
import com.epam.ta.reportportal.job.PageUtil;
import com.epam.ta.reportportal.job.service.LaunchCleanerService;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.math.NumberUtils;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"!unittest"})
public class CleanLaunchesJob
implements Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(CleanLaunchesJob.class);
    private final Integer threadsCount;
    private final Integer launchesLimit;
    private final LaunchCleanerService launchCleanerService;
    private final ProjectRepository projectRepository;
    private final ActivityRepository activityRepository;
    private final LaunchRepository launchRepository;

    @Autowired
    public CleanLaunchesJob(@Value(value="${rp.environment.variable.clean.launches.pool}") Integer threadsCount, @Value(value="${rp.environment.variable.clean.launches.size}") Integer launchesLimit, LaunchCleanerService launchCleanerService, ProjectRepository projectRepository, ActivityRepository activityRepository, LaunchRepository launchRepository) {
        this.threadsCount = threadsCount;
        this.launchesLimit = launchesLimit;
        this.launchCleanerService = launchCleanerService;
        this.projectRepository = projectRepository;
        this.activityRepository = activityRepository;
        this.launchRepository = launchRepository;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        LOGGER.info("Cleaning outdated launches has been started");
        ExecutorService executor = Executors.newFixedThreadPool(this.threadsCount, new ThreadFactoryBuilder().setNameFormat("clean-launches-job-thread-%d").build());
        PageUtil.iterateOverPages(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"id")}), arg_0 -> ((ProjectRepository)this.projectRepository).findAllIdsAndProjectAttributes(arg_0), projects -> projects.forEach(p -> {
            try {
                this.proceedLaunchesCleaning((Project)p, executor);
            }
            catch (Exception ex) {
                LOGGER.error("Cleaning outdated launches for project {} has been failed", (Object)p.getId(), (Object)ex);
            }
        }));
        executor.shutdown();
        LOGGER.info("Cleaning outdated launches has been finished");
    }

    private void proceedLaunchesCleaning(Project project, ExecutorService executorService) {
        ProjectUtils.extractAttributeValue((Project)project, (ProjectAttributeEnum)ProjectAttributeEnum.KEEP_LAUNCHES).map(it -> Duration.ofSeconds(NumberUtils.toLong((String)it, (long)0L))).filter(it -> !it.isZero()).ifPresent(period -> {
            this.activityRepository.deleteModifiedLaterAgo(project.getId(), period);
            this.cleanLaunches(project.getId(), (Duration)period, executorService);
        });
    }

    private void cleanLaunches(Long projectId, Duration period, ExecutorService executorService) {
        LocalDateTime startTimeBound = LocalDateTime.now(ZoneOffset.UTC).minus(period);
        AtomicLong removedLaunches = new AtomicLong(0L);
        AtomicLong removedAttachments = new AtomicLong(0L);
        AtomicLong removedThumbnails = new AtomicLong(0L);
        PageUtil.iterateOverContent(this.launchesLimit, pageable -> this.launchRepository.findIdsByProjectIdAndStartTimeBefore(projectId, startTimeBound, pageable.getPageSize()), ids -> {
            CompletableFuture.allOf((CompletableFuture[])ids.stream().map(id -> CompletableFuture.runAsync(() -> this.launchCleanerService.cleanLaunch((Long)id, removedAttachments, removedThumbnails), executorService)).toArray(CompletableFuture[]::new)).join();
            removedLaunches.addAndGet(ids.size());
        });
        LOGGER.info("Cleaning outdated launches for project {} has been finished. Total launches removed: {}. Attachments removed: {}. Thumbnails removed: {}", new Object[]{projectId, removedLaunches.get(), removedAttachments.get(), removedThumbnails.get()});
    }
}

