/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.demodata.service;

import com.epam.ta.reportportal.binary.AttachmentBinaryDataService;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.demodata.service.Attachment;
import com.epam.ta.reportportal.demodata.service.ContentUtils;
import com.epam.ta.reportportal.entity.attachment.AttachmentMetaInfo;
import com.epam.ta.reportportal.entity.enums.LogLevel;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.log.Log;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.util.MultipartFileUtils;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.List;
import java.util.SplittableRandom;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
class DemoLogsService {
    private static final int MIN_LOGS_COUNT = 5;
    private static final int MAX_LOGS_COUNT = 30;
    private static final int BINARY_CONTENT_PROBABILITY = 7;
    private SplittableRandom random = new SplittableRandom();
    private LogRepository logRepository;
    private LaunchRepository launchRepository;
    private TestItemRepository testItemRepository;
    private AttachmentBinaryDataService attachmentBinaryDataService;

    public DemoLogsService(LogRepository logRepository, LaunchRepository launchRepository, TestItemRepository testItemRepository, AttachmentBinaryDataService attachmentBinaryDataService) {
        this.logRepository = logRepository;
        this.launchRepository = launchRepository;
        this.testItemRepository = testItemRepository;
        this.attachmentBinaryDataService = attachmentBinaryDataService;
    }

    List<Log> generateDemoLaunchLogs(String launchUUid, StatusEnum status) {
        Launch launch = (Launch)this.launchRepository.findByUuid(launchUUid).orElseThrow(() -> new ReportPortalException(ErrorType.UNCLASSIFIED_REPORT_PORTAL_ERROR, new Object[0]));
        int logsCount = this.random.nextInt(5, 30);
        List<Log> logs = IntStream.range(1, logsCount).mapToObj(it -> {
            Log log = new Log();
            log.setLogLevel(Integer.valueOf(this.infoLevel().toInt()));
            log.setLaunch(launch);
            log.setLogTime(LocalDateTime.now());
            log.setLogMessage(ContentUtils.getLogMessage());
            log.setUuid(UUID.randomUUID().toString());
            return log;
        }).collect(Collectors.toList());
        if (StatusEnum.FAILED.equals((Object)status)) {
            List<String> errors = ContentUtils.getErrorLogs();
            logs.addAll(errors.stream().map(msg -> {
                Log log = new Log();
                log.setLogLevel(Integer.valueOf(this.errorLevel().toInt()));
                log.setLogTime(LocalDateTime.now());
                log.setLaunch(launch);
                log.setLogMessage(msg);
                log.setUuid(UUID.randomUUID().toString());
                return log;
            }).collect(Collectors.toList()));
        }
        this.logRepository.saveAll(logs);
        return logs;
    }

    List<Log> generateDemoLogs(String itemUuid, StatusEnum status) {
        TestItem testItem = (TestItem)this.testItemRepository.findByUuid(itemUuid).orElseThrow(() -> new ReportPortalException(ErrorType.UNCLASSIFIED_REPORT_PORTAL_ERROR, new Object[0]));
        int logsCount = this.random.nextInt(5, 30);
        List<Log> logs = IntStream.range(1, logsCount).mapToObj(it -> {
            Log log = new Log();
            log.setLogLevel(Integer.valueOf(this.infoLevel().toInt()));
            log.setLogTime(LocalDateTime.now());
            log.setTestItem(testItem);
            log.setLogMessage(ContentUtils.getLogMessage());
            log.setUuid(UUID.randomUUID().toString());
            return log;
        }).collect(Collectors.toList());
        if (StatusEnum.FAILED.equals((Object)status)) {
            List<String> errors = ContentUtils.getErrorLogs();
            logs.addAll(errors.stream().map(msg -> {
                Log log = new Log();
                log.setLogLevel(Integer.valueOf(this.errorLevel().toInt()));
                log.setLogTime(LocalDateTime.now());
                log.setTestItem(testItem);
                log.setLogMessage(msg);
                log.setUuid(UUID.randomUUID().toString());
                return log;
            }).collect(Collectors.toList()));
        }
        this.logRepository.saveAll(logs);
        return logs;
    }

    void attachFiles(List<Log> logs, Long projectId, String launchUuid) {
        Launch launch = (Launch)this.launchRepository.findByUuid(launchUuid).orElseThrow(() -> new ReportPortalException(ErrorType.UNCLASSIFIED_REPORT_PORTAL_ERROR, new Object[0]));
        this.createAttachments(logs, projectId, launch.getId(), null, launchUuid);
    }

    void attachFiles(List<Log> logs, Long projectId, String itemUuid, String launchUuid) {
        Launch launch = (Launch)this.launchRepository.findByUuid(launchUuid).orElseThrow(() -> new ReportPortalException(ErrorType.UNCLASSIFIED_REPORT_PORTAL_ERROR, new Object[0]));
        TestItem item = (TestItem)this.testItemRepository.findByUuid(itemUuid).orElseThrow(() -> new ReportPortalException(ErrorType.UNCLASSIFIED_REPORT_PORTAL_ERROR, new Object[0]));
        this.createAttachments(logs, projectId, launch.getId(), item.getItemId(), launchUuid);
    }

    private void createAttachments(List<Log> logs, Long projectId, Long launchId, Long itemId, String launchUuid) {
        BooleanHolder binaryDataAttached = new BooleanHolder();
        logs.forEach(it -> {
            if (LogLevel.ERROR.toInt() >= it.getLogLevel()) {
                if (ContentUtils.getWithProbability(7)) {
                    this.createAttachment(projectId, itemId, launchId, (Log)it, launchUuid);
                }
            } else if (!binaryDataAttached.getValue() && ContentUtils.getWithProbability(7)) {
                this.createAttachment(projectId, itemId, launchId, (Log)it, launchUuid);
                binaryDataAttached.setValue(true);
            }
        });
    }

    private void createAttachment(Long projectId, Long testItemId, Long launchId, Log it, String launchUuid) {
        Attachment attachment = Attachment.values()[this.random.nextInt(Attachment.values().length)];
        try {
            this.attachmentBinaryDataService.saveFileAndAttachToLog((MultipartFile)MultipartFileUtils.getMultipartFile(attachment.getResource().getPath()), AttachmentMetaInfo.builder().withProjectId(projectId).withLaunchId(launchId).withItemId(testItemId).withLogId(it.getId()).withLaunchUuid(launchUuid).withLogUuid(it.getUuid()).build());
        }
        catch (IOException e) {
            throw new ReportPortalException(ErrorType.UNCLASSIFIED_REPORT_PORTAL_ERROR, new Object[]{"Error generating demo data."});
        }
    }

    private LogLevel infoLevel() {
        int i = this.random.nextInt(50);
        if (i < 10) {
            return LogLevel.DEBUG;
        }
        if (i < 20) {
            return LogLevel.WARN;
        }
        if (i < 30) {
            return LogLevel.TRACE;
        }
        return LogLevel.INFO;
    }

    private LogLevel errorLevel() {
        return this.random.nextBoolean() ? LogLevel.ERROR : LogLevel.FATAL;
    }

    private static class BooleanHolder {
        private boolean value = false;

        BooleanHolder() {
        }

        public boolean getValue() {
            return this.value;
        }

        public void setValue(boolean value) {
            this.value = value;
        }
    }
}

