/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.loader.materialized.handler;

import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.widget.content.loader.materialized.MaterializedWidgetContentLoader;
import com.epam.ta.reportportal.core.widget.content.loader.materialized.handler.MaterializedWidgetStateHandler;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.epam.ta.reportportal.entity.widget.WidgetType;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
public class ReadyMaterializedWidgetStateHandler
implements MaterializedWidgetStateHandler {
    private final MaterializedWidgetStateHandler refreshWidgetStateHandler;
    private final Map<WidgetType, MaterializedWidgetContentLoader> materializedWidgetContentLoaderMapping;

    public ReadyMaterializedWidgetStateHandler(@Qualifier(value="createdMaterializedWidgetStateHandler") MaterializedWidgetStateHandler refreshWidgetStateHandler, @Qualifier(value="materializedWidgetContentLoaderMapping") Map<WidgetType, MaterializedWidgetContentLoader> materializedWidgetContentLoaderMapping) {
        this.refreshWidgetStateHandler = refreshWidgetStateHandler;
        this.materializedWidgetContentLoaderMapping = materializedWidgetContentLoaderMapping;
    }

    @Override
    public Map<String, Object> handleWidgetState(Widget widget, MultiValueMap<String, String> params) {
        if (BooleanUtils.toBoolean((String)((String)params.getFirst((Object)"refresh")))) {
            return this.refreshWidgetStateHandler.handleWidgetState(widget, params);
        }
        WidgetType widgetType = (WidgetType)WidgetType.findByName((String)widget.getWidgetType()).orElseThrow(() -> new ReportPortalException(ErrorType.UNABLE_TO_CREATE_WIDGET, new Object[]{Suppliers.formattedSupplier((String)"Unsupported widget type '{}'", (Object[])new Object[]{widget.getWidgetType()})}));
        return Optional.ofNullable(this.materializedWidgetContentLoaderMapping.get(widgetType)).map(loader -> loader.loadContent(widget, params)).orElseGet(Collections::emptyMap);
    }
}

