/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.loader.materialized.generator;

import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.core.widget.content.loader.materialized.generator.AbstractViewGenerator;
import com.epam.ta.reportportal.core.widget.util.WidgetOptionUtil;
import com.epam.ta.reportportal.dao.WidgetContentRepository;
import com.epam.ta.reportportal.dao.WidgetRepository;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.epam.ta.reportportal.entity.widget.content.healthcheck.HealthCheckTableInitParams;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
public class HealthCheckTableGenerator
extends AbstractViewGenerator {
    public static final String CUSTOM_COLUMN = "customColumn";
    private final WidgetContentRepository widgetContentRepository;

    @Autowired
    public HealthCheckTableGenerator(WidgetRepository widgetRepository, WidgetContentRepository widgetContentRepository) {
        super(widgetRepository);
        this.widgetContentRepository = widgetContentRepository;
    }

    @Override
    protected void generateView(boolean refresh, String viewName, Widget widget, Filter launchesFilter, Sort launchesSort, MultiValueMap<String, String> params) {
        this.widgetContentRepository.generateComponentHealthCheckTable(refresh, this.getInitParams(widget, viewName), launchesFilter, launchesSort, widget.getItemsCount(), WidgetOptionUtil.getBooleanByKey("latest", widget.getWidgetOptions()));
    }

    private HealthCheckTableInitParams getInitParams(Widget widget, String viewName) {
        List attributeKeys = WidgetOptionUtil.getListByKey("attributeKeys", widget.getWidgetOptions());
        return Optional.ofNullable(WidgetOptionUtil.getValueByKey(CUSTOM_COLUMN, widget.getWidgetOptions())).map(custom -> HealthCheckTableInitParams.of((String)viewName, (List)attributeKeys, (String)custom)).orElseGet(() -> HealthCheckTableInitParams.of((String)viewName, (List)attributeKeys));
    }
}

