/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.loader.materialized.generator;

import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.core.widget.content.loader.materialized.generator.ViewGenerator;
import com.epam.ta.reportportal.core.widget.util.WidgetOptionUtil;
import com.epam.ta.reportportal.dao.WidgetRepository;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.epam.ta.reportportal.entity.widget.WidgetState;
import com.epam.ta.reportportal.ws.converter.builders.WidgetBuilder;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;

public abstract class AbstractViewGenerator
implements ViewGenerator {
    public static final Logger LOGGER = LoggerFactory.getLogger(AbstractViewGenerator.class);
    private static final String LAST_REFRESH = "lastRefresh";
    private final WidgetRepository widgetRepository;

    public AbstractViewGenerator(WidgetRepository widgetRepository) {
        this.widgetRepository = widgetRepository;
    }

    protected abstract void generateView(boolean var1, String var2, Widget var3, Filter var4, Sort var5, MultiValueMap<String, String> var6);

    @Override
    @Transactional
    public void generate(boolean refresh, String viewName, Widget widget, Filter launchesFilter, Sort launchesSort, MultiValueMap<String, String> params) {
        try {
            LOGGER.debug("Widget {} - {}. Generation started", (Object)widget.getWidgetType(), (Object)widget.getId());
            this.generateView(refresh, viewName, widget, launchesFilter, launchesSort, params);
            LOGGER.debug("Widget {} - {}. Generation finished", (Object)widget.getWidgetType(), (Object)widget.getId());
            this.widgetRepository.save((Object)new WidgetBuilder(widget).addOption("state", WidgetState.READY.getValue()).addOption("viewName", viewName).addOption(LAST_REFRESH, Date.from(LocalDateTime.now().atZone(ZoneOffset.UTC).toInstant())).get());
            LOGGER.debug("Widget {} - {}. State updated to: {}", new Object[]{widget.getWidgetType(), widget.getId(), WidgetOptionUtil.getValueByKey("state", widget.getWidgetOptions())});
        }
        catch (Exception exc) {
            LOGGER.error("Error during view creation: " + exc.getMessage());
            this.widgetRepository.save((Object)new WidgetBuilder(widget).addOption("state", WidgetState.FAILED.getValue()).get());
            LOGGER.error("Generation failed. Widget {} - {}. State updated to: {}", new Object[]{widget.getWidgetType(), widget.getId(), WidgetOptionUtil.getValueByKey("state", widget.getWidgetOptions())});
        }
    }
}

