/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.loader;

import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.core.widget.content.LoadContentStrategy;
import com.epam.ta.reportportal.core.widget.content.loader.AbstractStatisticsContentLoader;
import com.epam.ta.reportportal.core.widget.util.WidgetFilterUtil;
import com.epam.ta.reportportal.core.widget.util.WidgetOptionUtil;
import com.epam.ta.reportportal.dao.WidgetContentRepository;
import com.epam.ta.reportportal.entity.widget.WidgetOptions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class LineChartContentLoader
extends AbstractStatisticsContentLoader
implements LoadContentStrategy {
    @Autowired
    private WidgetContentRepository widgetContentRepository;

    @Override
    public Map<String, ?> loadContent(List<String> contentFields, Map<Filter, Sort> filterSortMapping, WidgetOptions widgetOptions, int limit) {
        Optional<AbstractStatisticsContentLoader.Period> period;
        Filter filter = WidgetFilterUtil.GROUP_FILTERS.apply(filterSortMapping.keySet());
        Sort sort = WidgetFilterUtil.GROUP_SORTS.apply(filterSortMapping.values());
        List content = this.widgetContentRepository.launchStatistics(filter, contentFields, sort, limit);
        String timeLineOption = Optional.ofNullable(widgetOptions).map(wo -> WidgetOptionUtil.getValueByKey("timeline", wo)).orElse("");
        if (StringUtils.isNotBlank((CharSequence)timeLineOption) && (period = AbstractStatisticsContentLoader.Period.findByName(timeLineOption)).isPresent()) {
            return CollectionUtils.isEmpty((Collection)content) ? Collections.emptyMap() : Collections.singletonMap("result", this.groupByDate(content, period.get()));
        }
        return CollectionUtils.isEmpty((Collection)content) ? Collections.emptyMap() : Collections.singletonMap("result", content);
    }
}

