/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.user.impl;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.jasper.GetJasperReportHandler;
import com.epam.ta.reportportal.core.user.GetUserHandler;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.dao.UserCreationBidRepository;
import com.epam.ta.reportportal.dao.UserRepository;
import com.epam.ta.reportportal.entity.jasper.ReportFormat;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectUtils;
import com.epam.ta.reportportal.entity.user.ProjectUser;
import com.epam.ta.reportportal.entity.user.User;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.util.PersonalProjectService;
import com.epam.ta.reportportal.ws.converter.PagedResourcesAssembler;
import com.epam.ta.reportportal.ws.converter.converters.UserConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.YesNoRS;
import com.epam.ta.reportportal.ws.model.user.UserBidRS;
import com.epam.ta.reportportal.ws.model.user.UserResource;
import com.google.common.base.Preconditions;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.jooq.Operator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class GetUserHandlerImpl
implements GetUserHandler {
    private final UserRepository userRepository;
    private final UserCreationBidRepository userCreationBidRepository;
    private final ProjectRepository projectRepository;
    private final PersonalProjectService personalProjectService;
    private final GetJasperReportHandler<User> jasperReportHandler;

    @Autowired
    public GetUserHandlerImpl(UserRepository userRepo, UserCreationBidRepository userCreationBidRepository, ProjectRepository projectRepository, PersonalProjectService personalProjectService, @Qualifier(value="userJasperReportHandler") GetJasperReportHandler<User> jasperReportHandler) {
        this.userRepository = (UserRepository)Preconditions.checkNotNull((Object)userRepo);
        this.userCreationBidRepository = (UserCreationBidRepository)Preconditions.checkNotNull((Object)userCreationBidRepository);
        this.projectRepository = projectRepository;
        this.personalProjectService = personalProjectService;
        this.jasperReportHandler = jasperReportHandler;
    }

    @Override
    public UserResource getUser(String username, ReportPortalUser loggedInUser) {
        User user = (User)this.userRepository.findByLogin(username.toLowerCase()).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{username}));
        return UserConverter.TO_RESOURCE.apply(user);
    }

    @Override
    public UserResource getUser(ReportPortalUser loggedInUser) {
        User user = (User)this.userRepository.findByLogin(loggedInUser.getUsername()).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{loggedInUser.getUsername()}));
        return UserConverter.TO_RESOURCE.apply(user);
    }

    @Override
    public Iterable<UserResource> getUsers(Filter filter, Pageable pageable, ReportPortalUser.ProjectDetails projectDetails) {
        filter.withCondition((ConvertibleCondition)new FilterCondition(Condition.EQUALS, false, "false", "expired"));
        filter.withCondition((ConvertibleCondition)new FilterCondition(Condition.EQUALS, false, String.valueOf(projectDetails.getProjectId()), "projectId"));
        return (Iterable)PagedResourcesAssembler.pageConverter(UserConverter.TO_RESOURCE).apply((Page<User>)this.userRepository.findByFilterExcluding((Queryable)filter, pageable, new String[]{"email"}));
    }

    @Override
    public UserBidRS getBidInformation(String uuid) {
        Optional bid = this.userCreationBidRepository.findById((Object)uuid);
        return bid.map(b -> {
            UserBidRS rs = new UserBidRS();
            rs.setIsActive(true);
            rs.setEmail(b.getEmail());
            rs.setUuid(b.getUuid());
            return rs;
        }).orElseGet(() -> {
            UserBidRS rs = new UserBidRS();
            rs.setIsActive(false);
            return rs;
        });
    }

    @Override
    public YesNoRS validateInfo(String username, String email) {
        if (null != username) {
            Optional user = this.userRepository.findByLogin(EntityUtils.normalizeId((String)username));
            return user.isPresent() ? new YesNoRS(true) : new YesNoRS(false);
        }
        if (null != email) {
            Optional user = this.userRepository.findByEmail(EntityUtils.normalizeId((String)email));
            return user.isPresent() ? new YesNoRS(true) : new YesNoRS(false);
        }
        return new YesNoRS(false);
    }

    @Override
    public Map<String, UserResource.AssignedProject> getUserProjects(String userName) {
        return this.projectRepository.findUserProjects(userName).stream().collect(Collectors.toMap(Project::getName, it -> {
            UserResource.AssignedProject assignedProject = new UserResource.AssignedProject();
            assignedProject.setEntryType(it.getProjectType().name());
            ProjectUser projectUser = ProjectUtils.findUserConfigByLogin((Project)it, (String)userName);
            Optional.ofNullable(Optional.ofNullable(projectUser).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{userName})).getProjectRole()).ifPresent(role -> assignedProject.setProjectRole(role.name()));
            return assignedProject;
        }));
    }

    @Override
    public Iterable<UserResource> getAllUsers(Queryable filter, Pageable pageable) {
        Page users = this.userRepository.findByFilter(filter, pageable);
        return (Iterable)PagedResourcesAssembler.pageConverter(UserConverter.TO_RESOURCE).apply((Page<User>)users);
    }

    @Override
    public void exportUsers(ReportFormat reportFormat, OutputStream outputStream, Queryable filter) {
        List users = this.userRepository.findByFilter(filter);
        List data = users.stream().map(this.jasperReportHandler::convertParams).collect(Collectors.toList());
        JRBeanCollectionDataSource jrDataSource = new JRBeanCollectionDataSource(data);
        JasperPrint jasperPrint = this.jasperReportHandler.getJasperPrint(null, (JRDataSource)jrDataSource);
        this.jasperReportHandler.writeReport(reportFormat, outputStream, jasperPrint);
    }

    @Override
    public Iterable<UserResource> searchUsers(String term, Pageable pageable) {
        Filter filter = Filter.builder().withTarget(User.class).withCondition((ConvertibleCondition)new FilterCondition(Operator.OR, Condition.CONTAINS, false, term, "user")).withCondition((ConvertibleCondition)new FilterCondition(Operator.OR, Condition.CONTAINS, false, term, "email")).build();
        return (Iterable)PagedResourcesAssembler.pageConverter(UserConverter.TO_RESOURCE).apply((Page<User>)this.userRepository.findByFilter((Queryable)filter, pageable));
    }
}

