/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.project.impl;

import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.analyzer.auto.LogIndexer;
import com.epam.ta.reportportal.core.analyzer.auto.client.AnalyzerServiceClient;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerStatusCache;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerUtils;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.ProjectIndexEvent;
import com.epam.ta.reportportal.core.events.attachment.DeleteProjectAttachmentsEvent;
import com.epam.ta.reportportal.core.project.DeleteProjectHandler;
import com.epam.ta.reportportal.core.project.content.remover.ProjectContentRemover;
import com.epam.ta.reportportal.dao.IssueTypeRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.dao.UserRepository;
import com.epam.ta.reportportal.entity.item.issue.IssueType;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectIssueType;
import com.epam.ta.reportportal.entity.user.User;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.DeleteBulkRQ;
import com.epam.ta.reportportal.ws.model.DeleteBulkRS;
import com.epam.ta.reportportal.ws.model.ErrorRS;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.google.common.cache.Cache;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class DeleteProjectHandlerImpl
implements DeleteProjectHandler {
    private final ProjectRepository projectRepository;
    private final UserRepository userRepository;
    private final LogIndexer logIndexer;
    private final AnalyzerServiceClient analyzerServiceClient;
    private final AnalyzerStatusCache analyzerStatusCache;
    private final MessageBus messageBus;
    private final ApplicationEventPublisher eventPublisher;
    private final IssueTypeRepository issueTypeRepository;
    private final ProjectContentRemover projectContentRemover;

    @Autowired
    public DeleteProjectHandlerImpl(ProjectRepository projectRepository, UserRepository userRepository, LogIndexer logIndexer, AnalyzerServiceClient analyzerServiceClient, AnalyzerStatusCache analyzerStatusCache, MessageBus messageBus, ApplicationEventPublisher eventPublisher, IssueTypeRepository issueTypeRepository, ProjectContentRemover projectContentRemover) {
        this.projectRepository = projectRepository;
        this.userRepository = userRepository;
        this.logIndexer = logIndexer;
        this.analyzerServiceClient = analyzerServiceClient;
        this.analyzerStatusCache = analyzerStatusCache;
        this.messageBus = messageBus;
        this.eventPublisher = eventPublisher;
        this.issueTypeRepository = issueTypeRepository;
        this.projectContentRemover = projectContentRemover;
    }

    @Override
    public OperationCompletionRS deleteProject(Long projectId) {
        Project project = (Project)this.projectRepository.findById((Object)projectId).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectId}));
        return this.deleteProject(project);
    }

    @Override
    public OperationCompletionRS deleteProjectIndex(String projectName, String username) {
        BusinessRule.expect((Object)this.analyzerServiceClient.hasClients(), Predicate.isEqual(true)).verify(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{"There are no analyzer deployed."});
        Project project = (Project)this.projectRepository.findByName(projectName).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName}));
        User user = (User)this.userRepository.findByLogin(username).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{username}));
        BusinessRule.expect((Object)AnalyzerUtils.getAnalyzerConfig(project).isIndexingRunning(), Predicate.isEqual(false)).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{"Index can not be removed until index generation proceeds."});
        Cache<Long, Long> analyzeStatus = this.analyzerStatusCache.getAnalyzeStatus("autoAnalyzer").orElseThrow(() -> new ReportPortalException(ErrorType.ANALYZER_NOT_FOUND, new Object[]{"autoAnalyzer"}));
        BusinessRule.expect((Object)analyzeStatus.asMap().containsValue(project.getId()), Predicate.isEqual(false)).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{"Index can not be removed until index generation proceeds."});
        this.logIndexer.deleteIndex(project.getId());
        this.messageBus.publishActivity(new ProjectIndexEvent(project.getId(), project.getName(), user.getId(), user.getLogin(), false));
        return new OperationCompletionRS("Project index with name = '" + projectName + "' is successfully deleted.");
    }

    @Override
    public DeleteBulkRS deleteProjects(DeleteBulkRQ deleteBulkRQ) {
        ArrayList exceptions = Lists.newArrayList();
        ArrayList notFound = Lists.newArrayList();
        ArrayList deleted = Lists.newArrayList();
        deleteBulkRQ.getIds().forEach(projectId -> {
            try {
                Optional project = this.projectRepository.findById(projectId);
                if (project.isPresent()) {
                    this.deleteProject((Project)project.get());
                    deleted.add(projectId);
                } else {
                    notFound.add(projectId);
                }
            }
            catch (ReportPortalException ex) {
                exceptions.add(ex);
            }
        });
        return new DeleteBulkRS((List)deleted, (List)notFound, exceptions.stream().map(ex -> {
            ErrorRS errorResponse = new ErrorRS();
            errorResponse.setErrorType(ex.getErrorType());
            errorResponse.setMessage(ex.getMessage());
            return errorResponse;
        }).collect(Collectors.toList()));
    }

    private OperationCompletionRS deleteProject(Project project) {
        Set defaultIssueTypeIds = this.issueTypeRepository.getDefaultIssueTypes().stream().map(IssueType::getId).collect(Collectors.toSet());
        Set issueTypesToRemove = project.getProjectIssueTypes().stream().map(ProjectIssueType::getIssueType).filter(issueType -> !defaultIssueTypeIds.contains(issueType.getId())).collect(Collectors.toSet());
        this.projectContentRemover.removeContent(project);
        this.projectRepository.delete((Object)project);
        this.issueTypeRepository.deleteAll(issueTypesToRemove);
        this.logIndexer.deleteIndex(project.getId());
        this.eventPublisher.publishEvent((Object)new DeleteProjectAttachmentsEvent(project.getId()));
        return new OperationCompletionRS("Project with id = '" + project.getId() + "' has been successfully deleted.");
    }
}

