/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.log.impl;

import com.epam.ta.reportportal.commons.BinaryDataMetaInfo;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.configs.rabbit.DeserializablePair;
import com.epam.ta.reportportal.core.log.CreateLogHandler;
import com.epam.ta.reportportal.core.log.impl.SaveLogBinaryDataTaskAsync;
import com.epam.ta.reportportal.util.ReportingQueueService;
import com.epam.ta.reportportal.ws.model.EntryCreatedAsyncRS;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import com.epam.ta.reportportal.ws.rabbit.RequestType;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.inject.Provider;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="asyncCreateLogHandler")
public class CreateLogHandlerAsyncImpl
implements CreateLogHandler {
    @Autowired
    private Provider<SaveLogBinaryDataTaskAsync> saveLogBinaryDataTask;
    @Autowired
    @Qualifier(value="saveLogsTaskExecutor")
    private TaskExecutor taskExecutor;
    @Autowired
    private ReportingQueueService reportingQueueService;
    @Autowired
    @Qualifier(value="rabbitTemplate")
    AmqpTemplate amqpTemplate;

    @Override
    @Nonnull
    public EntryCreatedAsyncRS createLog(@Nonnull SaveLogRQ request, MultipartFile file, ReportPortalUser.ProjectDetails projectDetails) {
        this.validate(request);
        request.setUuid(UUID.randomUUID().toString());
        if (file != null) {
            CompletableFuture.supplyAsync(((SaveLogBinaryDataTaskAsync)this.saveLogBinaryDataTask.get()).withRequest(request).withFile(file).withProjectId(projectDetails.getProjectId()), (Executor)this.taskExecutor).thenAccept(metaInfo -> this.sendMessage(request, (BinaryDataMetaInfo)metaInfo, projectDetails.getProjectId()));
        } else {
            this.sendMessage(request, null, projectDetails.getProjectId());
        }
        EntryCreatedAsyncRS response = new EntryCreatedAsyncRS();
        response.setId(request.getUuid());
        return response;
    }

    protected void sendMessage(SaveLogRQ request, BinaryDataMetaInfo metaInfo, Long projectId) {
        this.amqpTemplate.convertAndSend("reporting", this.reportingQueueService.getReportingQueueKey(request.getLaunchUuid()), DeserializablePair.of(request, metaInfo), message -> {
            Map headers = message.getMessageProperties().getHeaders();
            headers.put("requestType", RequestType.LOG);
            headers.put("projectId", projectId);
            headers.put("itemId", request.getItemUuid());
            return message;
        });
    }
}

