/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.impl;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.LaunchStartedEvent;
import com.epam.ta.reportportal.core.launch.StartLaunchHandler;
import com.epam.ta.reportportal.core.launch.rerun.RerunHandler;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.UserRepository;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.converter.builders.LaunchBuilder;
import com.epam.ta.reportportal.ws.converter.converters.LaunchConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRS;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Primary
@Transactional
class StartLaunchHandlerImpl
implements StartLaunchHandler {
    private final UserRepository userRepository;
    private final LaunchRepository launchRepository;
    private final MessageBus messageBus;
    private final RerunHandler rerunHandler;

    @Autowired
    public StartLaunchHandlerImpl(UserRepository userRepository, LaunchRepository launchRepository, MessageBus messageBus, RerunHandler rerunHandler) {
        this.userRepository = userRepository;
        this.launchRepository = launchRepository;
        this.messageBus = messageBus;
        this.rerunHandler = rerunHandler;
    }

    @Override
    @Transactional
    public StartLaunchRS startLaunch(ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails, StartLaunchRQ request) {
        this.validateRoles(projectDetails, request);
        Long userId = (Long)this.userRepository.findIdByLoginForUpdate(user.getUsername()).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{user.getUsername()}));
        if (request.isRerun()) {
            return this.rerunHandler.handleLaunch(request, projectDetails.getProjectId(), user);
        }
        Launch launch = new LaunchBuilder().addStartRQ(request).addAttributes(request.getAttributes()).addProject(projectDetails.getProjectId()).addUserId(userId).get();
        this.launchRepository.save((Object)launch);
        this.launchRepository.refresh((Object)launch);
        this.messageBus.publishActivity(new LaunchStartedEvent(LaunchConverter.TO_ACTIVITY_RESOURCE.apply(launch), user.getUserId(), user.getUsername()));
        StartLaunchRS response = new StartLaunchRS();
        response.setId(launch.getUuid());
        response.setNumber(launch.getNumber());
        return response;
    }
}

