/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.identity;

import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class IdentityUtil {
    private IdentityUtil() {
    }

    public static List<Long> getParentIds(TestItem testItem) {
        return IdentityUtil.getIds(testItem.getPath(), false);
    }

    public static List<Long> getItemTreeIds(TestItem testItem) {
        return IdentityUtil.getIds(testItem.getPath(), true);
    }

    private static List<Long> getIds(String path, boolean includeLast) {
        String[] ids = path.split("\\.");
        return Stream.of(ids).limit(includeLast ? (long)ids.length : (long)(ids.length - 1)).map(id -> {
            try {
                return Long.parseLong(id);
            }
            catch (NumberFormatException e) {
                throw new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Incorrect path value: " + id});
            }
        }).collect(Collectors.toList());
    }
}

