/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.integration.plugin.impl;

import com.epam.reportportal.extension.common.ExtensionPoint;
import com.epam.reportportal.extension.common.IntegrationTypeProperties;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.integration.plugin.PluginLoader;
import com.epam.ta.reportportal.core.plugin.PluginInfo;
import com.epam.ta.reportportal.dao.IntegrationTypeRepository;
import com.epam.ta.reportportal.entity.integration.IntegrationTypeDetails;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.filesystem.DataStore;
import com.epam.ta.reportportal.ws.converter.builders.IntegrationTypeBuilder;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.pf4j.PluginDescriptor;
import org.pf4j.PluginDescriptorFinder;
import org.pf4j.PluginException;
import org.pf4j.PluginWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PluginLoaderImpl
implements PluginLoader {
    private final String pluginsRootPath;
    private final DataStore dataStore;
    private final IntegrationTypeRepository integrationTypeRepository;
    private final PluginDescriptorFinder pluginDescriptorFinder;

    @Autowired
    public PluginLoaderImpl(@Value(value="${rp.plugins.path}") String pluginsRootPath, DataStore dataStore, IntegrationTypeRepository integrationTypeRepository, PluginDescriptorFinder pluginDescriptorFinder) {
        this.pluginsRootPath = pluginsRootPath;
        this.dataStore = dataStore;
        this.integrationTypeRepository = integrationTypeRepository;
        this.pluginDescriptorFinder = pluginDescriptorFinder;
    }

    @Override
    @NotNull
    public PluginInfo extractPluginInfo(Path pluginPath) throws PluginException {
        PluginDescriptor pluginDescriptor = this.pluginDescriptorFinder.find(pluginPath);
        return new PluginInfo(pluginDescriptor.getPluginId(), pluginDescriptor.getVersion());
    }

    @Override
    public IntegrationTypeDetails resolvePluginDetails(PluginInfo pluginInfo) {
        this.integrationTypeRepository.findByName(pluginInfo.getId()).flatMap(it -> Optional.ofNullable(it.getDetails())).flatMap(typeDetails -> IntegrationTypeProperties.VERSION.getValue(typeDetails.getDetails()).map(String::valueOf)).ifPresent(version -> BusinessRule.expect((Object)version, v -> !v.equalsIgnoreCase(pluginInfo.getVersion())).verify(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Plugin with ID = '{}' of the same VERSION = '{}' has already been uploaded.", (Object[])new Object[]{pluginInfo.getId(), pluginInfo.getVersion()})}));
        IntegrationTypeDetails pluginDetails = IntegrationTypeBuilder.createIntegrationTypeDetails();
        IntegrationTypeProperties.VERSION.setValue(pluginDetails, (Object)pluginInfo.getVersion());
        return pluginDetails;
    }

    @Override
    public boolean validatePluginExtensionClasses(PluginWrapper plugin) {
        return plugin.getPluginManager().getExtensionClasses(plugin.getPluginId()).stream().map(ExtensionPoint::findByExtension).anyMatch(Optional::isPresent);
    }

    @Override
    public String saveToDataStore(String fileName, InputStream fileStream) throws ReportPortalException {
        return this.dataStore.save(fileName, fileStream);
    }

    @Override
    public void savePlugin(Path pluginPath, InputStream fileStream) throws IOException {
        Files.copy(fileStream, pluginPath, StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public void copyFromDataStore(String fileId, Path pluginPath, Path resourcesPath) throws IOException {
        if (Objects.nonNull(pluginPath.getParent())) {
            Files.createDirectories(pluginPath.getParent(), new FileAttribute[0]);
        }
        try (InputStream inputStream = this.dataStore.load(fileId);){
            Files.copy(inputStream, pluginPath, StandardCopyOption.REPLACE_EXISTING);
        }
        this.copyPluginResource(pluginPath, resourcesPath);
    }

    @Override
    public void deleteFromDataStore(String fileId) {
        this.dataStore.delete(fileId);
    }

    @Override
    public void copyPluginResource(Path pluginPath, Path resourcesTargetPath) throws IOException {
        if (Objects.nonNull(resourcesTargetPath.getParent())) {
            Files.createDirectories(resourcesTargetPath.getParent(), new FileAttribute[0]);
        }
        try (JarFile jar = new JarFile(pluginPath.toFile());){
            if (!Files.isDirectory(resourcesTargetPath, new LinkOption[0])) {
                Files.createDirectories(resourcesTargetPath, new FileAttribute[0]);
            }
            this.copyJarResourcesRecursively(resourcesTargetPath, jar);
        }
    }

    private void copyJarResourcesRecursively(Path destination, JarFile jarFile) {
        jarFile.stream().filter(jarEntry -> jarEntry.getName().startsWith("resources")).forEach(entry -> {
            try {
                this.copyResources(jarFile, (JarEntry)entry, destination);
            }
            catch (IOException e) {
                throw new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{e.getMessage()});
            }
        });
    }

    private void copyResources(JarFile jarFile, JarEntry entry, Path destination) throws IOException {
        String fileName = StringUtils.substringAfter((String)entry.getName(), (String)"resources/");
        if (!entry.isDirectory()) {
            try (InputStream entryInputStream = jarFile.getInputStream(entry);){
                FileUtils.copyToFile((InputStream)entryInputStream, (File)new File(destination.toFile(), fileName));
            }
        } else {
            Files.createDirectories(Paths.get(destination.toString(), fileName), new FileAttribute[0]);
        }
    }

    @Override
    public void deleteTempPlugin(String pluginFileDirectory, String pluginFileName) throws IOException {
        Files.deleteIfExists(Paths.get(pluginFileDirectory, pluginFileName));
    }
}

