/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.integration.migration;

import com.epam.ta.reportportal.core.integration.migration.AbstractSecretMigrationService;
import com.epam.ta.reportportal.core.integration.util.property.BtsProperties;
import com.epam.ta.reportportal.dao.IntegrationRepository;
import java.util.Map;
import org.jasypt.util.text.BasicTextEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class RallySecretMigrationService
extends AbstractSecretMigrationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RallySecretMigrationService.class);
    private static final String RALLY_INTEGRATION_TYPE_NAME = "rally";

    @Autowired
    public RallySecretMigrationService(IntegrationRepository integrationRepository, BasicTextEncryptor encryptor) {
        super(integrationRepository, encryptor);
    }

    @Override
    @Transactional
    public void migrate() {
        LOGGER.debug("Migration of rally secrets has been started");
        this.integrationRepository.findAllByTypeIn(new String[]{RALLY_INTEGRATION_TYPE_NAME}).forEach(it -> RallySecretMigrationService.extractParams(it).ifPresent(params -> {
            BtsProperties.OAUTH_ACCESS_KEY.getParam((Map<String, Object>)params).ifPresent(key -> BtsProperties.OAUTH_ACCESS_KEY.setParam(it.getParams(), this.encryptor.encrypt(key)));
            BtsProperties.PASSWORD.getParam((Map<String, Object>)params).ifPresent(pass -> BtsProperties.PASSWORD.setParam(it.getParams(), this.encryptor.encrypt(pass)));
        }));
        LOGGER.debug("Migration of rally secrets has been finished");
    }
}

