/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.dashboard.impl;

import com.epam.ta.reportportal.auth.acl.ShareableObjectsHandler;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.dashboard.CreateDashboardHandler;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.DashboardCreatedEvent;
import com.epam.ta.reportportal.dao.DashboardRepository;
import com.epam.ta.reportportal.entity.dashboard.Dashboard;
import com.epam.ta.reportportal.ws.converter.builders.DashboardBuilder;
import com.epam.ta.reportportal.ws.converter.converters.DashboardConverter;
import com.epam.ta.reportportal.ws.model.EntryCreatedRS;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.dashboard.CreateDashboardRQ;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CreateDashboardHandlerImpl
implements CreateDashboardHandler {
    private final DashboardRepository dashboardRepository;
    private final MessageBus messageBus;
    private final ShareableObjectsHandler aclHandler;

    @Autowired
    public CreateDashboardHandlerImpl(DashboardRepository dashboardRepository, MessageBus messageBus, ShareableObjectsHandler aclHandler) {
        this.dashboardRepository = dashboardRepository;
        this.messageBus = messageBus;
        this.aclHandler = aclHandler;
    }

    @Override
    public EntryCreatedRS createDashboard(ReportPortalUser.ProjectDetails projectDetails, CreateDashboardRQ rq, ReportPortalUser user) {
        BusinessRule.expect((Object)this.dashboardRepository.existsByNameAndOwnerAndProjectId(rq.getName(), user.getUsername(), projectDetails.getProjectId()), BooleanUtils::isFalse).verify(ErrorType.RESOURCE_ALREADY_EXISTS, new Object[]{rq.getName()});
        Dashboard dashboard = new DashboardBuilder().addDashboardRq(rq).addProject(projectDetails.getProjectId()).addOwner(user.getUsername()).get();
        this.dashboardRepository.save((Object)dashboard);
        this.aclHandler.initAcl(dashboard, user.getUsername(), projectDetails.getProjectId(), BooleanUtils.isTrue((Boolean)rq.getShare()));
        this.messageBus.publishActivity(new DashboardCreatedEvent(DashboardConverter.TO_ACTIVITY_RESOURCE.apply(dashboard), user.getUserId(), user.getUsername()));
        return new EntryCreatedRS(dashboard.getId());
    }
}

