/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs;

import com.epam.ta.reportportal.auth.CombinedTokenStore;
import com.epam.ta.reportportal.auth.UserRoleHierarchy;
import com.epam.ta.reportportal.auth.basic.DatabaseUserDetailsService;
import com.epam.ta.reportportal.auth.permissions.PermissionEvaluatorFactoryBean;
import com.epam.ta.reportportal.dao.ServerSettingsRepository;
import com.epam.ta.reportportal.entity.ServerSettings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Profile;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.access.vote.AffirmativeBased;
import org.springframework.security.access.vote.AuthenticatedVoter;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.method.configuration.GlobalMethodSecurityConfiguration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.springframework.security.oauth2.provider.expression.OAuth2WebSecurityExpressionHandler;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.DefaultAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.DefaultTokenServices;
import org.springframework.security.oauth2.provider.token.DefaultUserAuthenticationConverter;
import org.springframework.security.oauth2.provider.token.TokenEnhancer;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.UserAuthenticationConverter;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;
import org.springframework.security.web.access.expression.DefaultWebSecurityExpressionHandler;
import org.springframework.security.web.access.expression.WebExpressionVoter;
import org.springframework.util.StringUtils;

@Configuration
class SecurityConfiguration {
    SecurityConfiguration() {
    }

    @Bean
    public PermissionEvaluatorFactoryBean permissionEvaluator() {
        return new PermissionEvaluatorFactoryBean();
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Configuration
    @EnableResourceServer
    public static class SecurityServerConfiguration
    extends ResourceServerConfigurerAdapter {
        private static final String SECRET_KEY = "secret.key";
        @Value(value="${rp.jwt.signing-key}")
        private String signingKey;
        @Autowired
        private PermissionEvaluator permissionEvaluator;
        @Autowired
        private DatabaseUserDetailsService userDetailsService;
        @Autowired
        private ServerSettingsRepository serverSettingsRepository;

        @Bean
        public static PermissionEvaluatorFactoryBean permissionEvaluatorFactoryBean() {
            return new PermissionEvaluatorFactoryBean();
        }

        @Bean
        public static RoleHierarchy userRoleHierarchy() {
            return new UserRoleHierarchy();
        }

        @Bean
        public TokenStore tokenStore() {
            return new CombinedTokenStore(this.accessTokenConverter());
        }

        @Bean
        @Profile(value={"!unittest"})
        public JwtAccessTokenConverter accessTokenConverter() {
            JwtAccessTokenConverter jwtConverter = new JwtAccessTokenConverter();
            jwtConverter.setSigningKey(this.getSecret());
            DefaultAccessTokenConverter accessTokenConverter = new DefaultAccessTokenConverter();
            DefaultUserAuthenticationConverter defaultUserAuthenticationConverter = new DefaultUserAuthenticationConverter();
            defaultUserAuthenticationConverter.setUserDetailsService((UserDetailsService)this.userDetailsService);
            accessTokenConverter.setUserTokenConverter((UserAuthenticationConverter)defaultUserAuthenticationConverter);
            jwtConverter.setAccessTokenConverter((AccessTokenConverter)accessTokenConverter);
            return jwtConverter;
        }

        private String getSecret() {
            if (!StringUtils.isEmpty((Object)this.signingKey)) {
                return this.signingKey;
            }
            Optional secretKey = this.serverSettingsRepository.findByKey(SECRET_KEY);
            return secretKey.isPresent() ? ((ServerSettings)secretKey.get()).getValue() : this.serverSettingsRepository.generateSecret();
        }

        @Bean
        @Primary
        public DefaultTokenServices tokenServices() {
            DefaultTokenServices defaultTokenServices = new DefaultTokenServices();
            defaultTokenServices.setTokenStore(this.tokenStore());
            defaultTokenServices.setSupportRefreshToken(true);
            defaultTokenServices.setTokenEnhancer((TokenEnhancer)this.accessTokenConverter());
            return defaultTokenServices;
        }

        private DefaultWebSecurityExpressionHandler webSecurityExpressionHandler() {
            OAuth2WebSecurityExpressionHandler handler = new OAuth2WebSecurityExpressionHandler();
            handler.setRoleHierarchy(SecurityServerConfiguration.userRoleHierarchy());
            handler.setPermissionEvaluator(this.permissionEvaluator);
            return handler;
        }

        private AccessDecisionManager webAccessDecisionManager() {
            ArrayList accessDecisionVoters = Lists.newArrayList();
            accessDecisionVoters.add(new AuthenticatedVoter());
            WebExpressionVoter webVoter = new WebExpressionVoter();
            webVoter.setExpressionHandler((SecurityExpressionHandler)this.webSecurityExpressionHandler());
            accessDecisionVoters.add(webVoter);
            return new AffirmativeBased((List)accessDecisionVoters);
        }

        public void configure(HttpSecurity http) throws Exception {
            ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry)http.authorizeRequests().accessDecisionManager(this.webAccessDecisionManager())).antMatchers(new String[]{"/**/user/registration/info*", "/**/user/registration**", "/**/user/password/reset/*", "/**/user/password/reset**", "/**/user/password/restore**", "/documentation.html", "/health", "/info"})).permitAll().antMatchers(new String[]{"/api-internal/**"})).hasRole("COMPONENT").antMatchers(new String[]{"/v2/**", "/swagger-resources", "/certificate/**", "/api/**", "/**"})).hasRole("USER").anyRequest()).authenticated().and()).csrf().disable();
        }
    }

    @Configuration
    @EnableGlobalMethodSecurity(proxyTargetClass=true, prePostEnabled=true)
    public static class MethodSecurityConfig
    extends GlobalMethodSecurityConfiguration {
        @Autowired
        private RoleHierarchy roleHierarchy;
        @Autowired
        private PermissionEvaluator permissionEvaluator;

        protected MethodSecurityExpressionHandler createExpressionHandler() {
            DefaultMethodSecurityExpressionHandler handler = new DefaultMethodSecurityExpressionHandler();
            handler.setRoleHierarchy(this.roleHierarchy);
            handler.setPermissionEvaluator(this.permissionEvaluator);
            return handler;
        }
    }
}

