/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs;

import com.epam.ta.reportportal.core.item.identity.TestItemUniqueIdGenerator;
import com.epam.ta.reportportal.core.item.impl.merge.strategy.BasicLaunchMergeStrategy;
import com.epam.ta.reportportal.core.item.impl.merge.strategy.BasicStatisticsCalculationStrategy;
import com.epam.ta.reportportal.core.item.impl.merge.strategy.DeepLaunchMergeStrategy;
import com.epam.ta.reportportal.core.item.impl.merge.strategy.LaunchMergeFactory;
import com.epam.ta.reportportal.core.item.impl.merge.strategy.MergeStrategyType;
import com.epam.ta.reportportal.core.item.impl.merge.strategy.StatisticsCalculationFactory;
import com.epam.ta.reportportal.core.item.merge.LaunchMergeStrategy;
import com.epam.ta.reportportal.core.item.merge.StatisticsCalculationStrategy;
import com.epam.ta.reportportal.dao.AttachmentRepository;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MergeStrategyConfig {
    private final TestItemRepository testItemRepository;
    private final LaunchRepository launchRepository;
    private final TestItemUniqueIdGenerator testItemUniqueIdGenerator;
    private final LogRepository logRepository;
    private final AttachmentRepository attachmentRepository;

    @Autowired
    public MergeStrategyConfig(TestItemRepository testItemRepository, LaunchRepository launchRepository, TestItemUniqueIdGenerator testItemUniqueIdGenerator, LogRepository logRepository, AttachmentRepository attachmentRepository) {
        this.testItemRepository = testItemRepository;
        this.launchRepository = launchRepository;
        this.testItemUniqueIdGenerator = testItemUniqueIdGenerator;
        this.logRepository = logRepository;
        this.attachmentRepository = attachmentRepository;
    }

    @Bean
    public Map<MergeStrategyType, StatisticsCalculationStrategy> statisticsCalculationStrategyMaping() {
        return Collections.singletonMap(MergeStrategyType.BASIC, new BasicStatisticsCalculationStrategy());
    }

    @Bean
    public StatisticsCalculationFactory statisticsCalculationFactory() {
        return new StatisticsCalculationFactory(this.statisticsCalculationStrategyMaping());
    }

    @Bean
    public Map<MergeStrategyType, LaunchMergeStrategy> launchMergeStrategyMapping() {
        return ImmutableMap.builder().put((Object)MergeStrategyType.BASIC, (Object)new BasicLaunchMergeStrategy(this.launchRepository, this.testItemRepository, this.logRepository, this.attachmentRepository, this.testItemUniqueIdGenerator, this.statisticsCalculationFactory())).put((Object)MergeStrategyType.DEEP, (Object)new DeepLaunchMergeStrategy(this.launchRepository, this.testItemRepository, this.logRepository, this.attachmentRepository, this.testItemUniqueIdGenerator)).build();
    }

    @Bean
    public LaunchMergeFactory launchMergeFactory() {
        return new LaunchMergeFactory(this.launchMergeStrategyMapping());
    }
}

