/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.bts.handler.impl;

import com.epam.reportportal.extension.bugtracking.BtsConstants;
import com.epam.reportportal.extension.bugtracking.BtsExtension;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.bts.handler.CreateTicketHandler;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.TicketPostedEvent;
import com.epam.ta.reportportal.core.integration.GetIntegrationHandler;
import com.epam.ta.reportportal.core.plugin.PluginBox;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.integration.Integration;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.converter.converters.TestItemConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.activity.TestItemActivityResource;
import com.epam.ta.reportportal.ws.model.externalsystem.PostTicketRQ;
import com.epam.ta.reportportal.ws.model.externalsystem.Ticket;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CreateTicketHandlerImpl
implements CreateTicketHandler {
    private final TestItemRepository testItemRepository;
    private final MessageBus messageBus;
    private final PluginBox pluginBox;
    private final GetIntegrationHandler getIntegrationHandler;

    @Autowired
    public CreateTicketHandlerImpl(TestItemRepository testItemRepository, PluginBox pluginBox, MessageBus messageBus, GetIntegrationHandler getIntegrationHandler) {
        this.testItemRepository = testItemRepository;
        this.pluginBox = pluginBox;
        this.messageBus = messageBus;
        this.getIntegrationHandler = getIntegrationHandler;
    }

    @Override
    public Ticket createIssue(PostTicketRQ postTicketRQ, Long integrationId, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        this.validatePostTicketRQ(postTicketRQ);
        List testItems = Optional.ofNullable(postTicketRQ.getBackLinks()).map(links -> this.testItemRepository.findAllById(links.keySet())).orElseGet(Collections::emptyList);
        List<TestItemActivityResource> before = testItems.stream().map(it -> TestItemConverter.TO_ACTIVITY_RESOURCE.apply((TestItem)it, projectDetails.getProjectId())).collect(Collectors.toList());
        Integration integration = this.getIntegrationHandler.getEnabledBtsIntegration(projectDetails, integrationId);
        BusinessRule.expect((Object)BtsConstants.DEFECT_FORM_FIELDS.getParam(integration.getParams()), (Predicate)Predicates.notNull()).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"There aren't any submitted BTS fields!"});
        BtsExtension btsExtension = this.pluginBox.getInstance(integration.getType().getName(), BtsExtension.class).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"BugTracking plugin for {} isn't installed", (Object[])new Object[]{BtsConstants.PROJECT.getParam(integration.getParams())}).get()}));
        Ticket ticket = btsExtension.submitTicket(postTicketRQ, integration);
        before.forEach(it -> this.messageBus.publishActivity(new TicketPostedEvent(ticket, user.getUserId(), user.getUsername(), (TestItemActivityResource)it)));
        return ticket;
    }

    private void validatePostTicketRQ(PostTicketRQ postTicketRQ) {
        if (postTicketRQ.getIsIncludeLogs() || postTicketRQ.getIsIncludeScreenshots()) {
            BusinessRule.expect((Object)postTicketRQ.getBackLinks(), (Predicate)Predicates.notNull()).verify(ErrorType.UNABLE_POST_TICKET, new Object[]{"Test item id should be specified, when logs required in ticket description."});
        }
    }
}

