/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.auto.impl;

import com.epam.ta.reportportal.core.analyzer.auto.AnalyzerService;
import com.epam.ta.reportportal.core.analyzer.auto.client.AnalyzerServiceClient;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerStatusCache;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerUtils;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.ItemIssueTypeDefinedEvent;
import com.epam.ta.reportportal.core.events.activity.LinkTicketEvent;
import com.epam.ta.reportportal.core.item.impl.IssueTypeHandler;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.activity.ActivityAction;
import com.epam.ta.reportportal.entity.enums.LogLevel;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.item.issue.IssueEntity;
import com.epam.ta.reportportal.entity.item.issue.IssueType;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.converter.builders.IssueEntityBuilder;
import com.epam.ta.reportportal.ws.converter.converters.TestItemConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.activity.TestItemActivityResource;
import com.epam.ta.reportportal.ws.model.analyzer.AnalyzedItemRs;
import com.epam.ta.reportportal.ws.model.analyzer.IndexLaunch;
import com.epam.ta.reportportal.ws.model.analyzer.IndexTestItem;
import com.epam.ta.reportportal.ws.model.analyzer.RelevantItemInfo;
import com.epam.ta.reportportal.ws.model.project.AnalyzerConfig;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AnalyzerServiceImpl
implements AnalyzerService {
    private static final Logger LOGGER = LogManager.getLogger((String)AnalyzerServiceImpl.class.getName());
    private final AnalyzerStatusCache analyzerStatusCache;
    private final AnalyzerServiceClient analyzerServicesClient;
    private final LogRepository logRepository;
    private final IssueTypeHandler issueTypeHandler;
    private final TestItemRepository testItemRepository;
    private final MessageBus messageBus;

    @Autowired
    public AnalyzerServiceImpl(AnalyzerStatusCache analyzerStatusCache, AnalyzerServiceClient analyzerServicesClient, LogRepository logRepository, IssueTypeHandler issueTypeHandler, TestItemRepository testItemRepository, MessageBus messageBus) {
        this.analyzerStatusCache = analyzerStatusCache;
        this.analyzerServicesClient = analyzerServicesClient;
        this.logRepository = logRepository;
        this.issueTypeHandler = issueTypeHandler;
        this.testItemRepository = testItemRepository;
        this.messageBus = messageBus;
    }

    @Override
    public boolean hasAnalyzers() {
        return this.analyzerServicesClient.hasClients();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runAnalyzers(Launch launch, List<Long> testItemIds, AnalyzerConfig analyzerConfig) {
        try {
            this.analyzerStatusCache.analyzeStarted("autoAnalyzer", launch.getId(), launch.getProjectId());
            List toAnalyze = this.testItemRepository.findAllById(testItemIds);
            Optional<IndexLaunch> rqLaunch = this.prepareLaunch(launch, analyzerConfig, toAnalyze);
            rqLaunch.ifPresent(rq -> this.analyzeLaunch(launch, toAnalyze, (IndexLaunch)rq));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.analyzerStatusCache.analyzeFinished("autoAnalyzer", launch.getId());
        }
    }

    private Optional<IndexLaunch> prepareLaunch(Launch launch, AnalyzerConfig analyzerConfig, List<TestItem> toAnalyze) {
        if (launch == null) {
            return Optional.empty();
        }
        List<IndexTestItem> indexTestItems = this.prepareItems(toAnalyze);
        if (!indexTestItems.isEmpty()) {
            IndexLaunch rqLaunch = new IndexLaunch();
            rqLaunch.setLaunchId(launch.getId());
            rqLaunch.setLaunchName(launch.getName());
            rqLaunch.setProjectId(launch.getProjectId());
            rqLaunch.setAnalyzerConfig(analyzerConfig);
            rqLaunch.setTestItems(indexTestItems);
            return Optional.of(rqLaunch);
        }
        return Optional.empty();
    }

    private List<IndexTestItem> prepareItems(List<TestItem> testItems) {
        return testItems.stream().map(it -> AnalyzerUtils.fromTestItem(it, this.logRepository.findAllUnderTestItemByLaunchIdAndTestItemIdsAndLogLevelGte(it.getLaunchId(), Collections.singletonList(it.getItemId()), LogLevel.ERROR.toInt()))).filter(it -> !CollectionUtils.isEmpty((Collection)it.getLogs())).collect(Collectors.toList());
    }

    private void analyzeLaunch(Launch launch, List<TestItem> toAnalyze, IndexLaunch rq) {
        LOGGER.info("Start analysis for launch with id '{}'", (Object)rq.getLaunchId());
        Map<String, List<AnalyzedItemRs>> analyzedMap = this.analyzerServicesClient.analyze(rq);
        if (!MapUtils.isEmpty(analyzedMap)) {
            analyzedMap.forEach((key, value) -> this.updateTestItems((String)key, (List<AnalyzedItemRs>)value, toAnalyze, launch.getProjectId()));
        }
    }

    private List<TestItem> updateTestItems(String analyzerInstance, List<AnalyzedItemRs> rs, List<TestItem> testItems, Long projectId) {
        return rs.stream().map(analyzed -> {
            Optional<TestItem> toUpdate = testItems.stream().filter(item -> item.getItemId().equals(analyzed.getItemId())).findAny();
            toUpdate.ifPresent(testItem -> {
                LOGGER.debug("Analysis has found a match: {}", analyzed);
                if (!testItem.getItemResults().getIssue().getIssueType().getLocator().equals(analyzed.getLocator())) {
                    TestItemActivityResource before = TestItemConverter.TO_ACTIVITY_RESOURCE.apply((TestItem)testItem, projectId);
                    RelevantItemInfo relevantItemInfo = this.updateTestItemIssue(projectId, (AnalyzedItemRs)analyzed, (TestItem)testItem);
                    TestItemActivityResource after = TestItemConverter.TO_ACTIVITY_RESOURCE.apply((TestItem)testItem, projectId);
                    this.testItemRepository.save(testItem);
                    this.messageBus.publishActivity(new ItemIssueTypeDefinedEvent(before, after, analyzerInstance, relevantItemInfo));
                    Optional.ofNullable(after.getTickets()).ifPresent(it -> this.messageBus.publishActivity(new LinkTicketEvent(before, after, analyzerInstance, ActivityAction.LINK_ISSUE_AA)));
                }
            });
            return toUpdate;
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private RelevantItemInfo updateTestItemIssue(Long projectId, AnalyzedItemRs rs, TestItem testItem) {
        IssueType issueType = this.issueTypeHandler.defineIssueType(projectId, rs.getLocator());
        IssueEntity issueEntity = new IssueEntityBuilder(testItem.getItemResults().getIssue()).addIssueType(issueType).addIgnoreFlag(testItem.getItemResults().getIssue().getIgnoreAnalyzer()).addAutoAnalyzedFlag(true).get();
        issueEntity.setIssueId(testItem.getItemId());
        issueEntity.setTestItemResults(testItem.getItemResults());
        testItem.getItemResults().setIssue(issueEntity);
        return Optional.ofNullable(rs.getRelevantItemId()).map(relevantItemId -> this.updateIssueFromRelevantItem(issueEntity, (Long)relevantItemId)).orElse(null);
    }

    private RelevantItemInfo updateIssueFromRelevantItem(IssueEntity issue, Long relevantItemId) {
        TestItem relevantItem = (TestItem)this.testItemRepository.findById((Object)relevantItemId).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{relevantItemId}));
        if (relevantItem.getItemResults().getIssue() != null) {
            issue.setIssueDescription(Strings.emptyToNull((String)(Strings.nullToEmpty((String)issue.getIssueDescription()) + Strings.nullToEmpty((String)relevantItem.getItemResults().getIssue().getIssueDescription()))));
            issue.setTickets((Set)Sets.newHashSet((Iterable)relevantItem.getItemResults().getIssue().getTickets()));
        }
        return AnalyzerUtils.TO_RELEVANT_ITEM_INFO.apply(relevantItem);
    }
}

