/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.auto.client.impl;

import com.epam.ta.reportportal.core.analyzer.auto.client.RabbitMqManagementClient;
import com.epam.ta.reportportal.core.analyzer.auto.client.impl.AnalyzerUtils;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.rabbitmq.http.client.Client;
import com.rabbitmq.http.client.domain.ExchangeInfo;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class RabbitMqManagementClientTemplate
implements RabbitMqManagementClient {
    private final Client rabbitClient;

    public RabbitMqManagementClientTemplate(Client rabbitClient) {
        this.rabbitClient = rabbitClient;
        try {
            rabbitClient.createVhost("analyzer");
        }
        catch (JsonProcessingException e) {
            throw new ReportPortalException(ErrorType.UNCLASSIFIED_REPORT_PORTAL_ERROR, new Object[]{"Unable to create RabbitMq virtual host"});
        }
    }

    @Override
    public List<ExchangeInfo> getAnalyzerExchangesInfo() {
        List client = this.rabbitClient.getExchanges("analyzer");
        if (client == null) {
            throw new ReportPortalException(ErrorType.ANALYZER_NOT_FOUND, new Object[]{"analyzer"});
        }
        return client.stream().filter(it -> it.getArguments().get("analyzer") != null).sorted(Comparator.comparingInt(AnalyzerUtils.EXCHANGE_PRIORITY)).collect(Collectors.toList());
    }
}

