/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.auth.util;

import com.epam.ta.reportportal.entity.user.UserRole;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.common.util.SerializationUtils;

public final class AuthUtils {
    public static final Function<UserRole, List<GrantedAuthority>> AS_AUTHORITIES = userRole -> Collections.singletonList(new SimpleGrantedAuthority(userRole.getAuthority()));

    private AuthUtils() {
    }

    public static <T> T deserializeSafely(byte[] data, @Nullable Consumer<T> mismatchCallback) {
        try {
            return (T)SerializationUtils.deserialize((byte[])data);
        }
        catch (IllegalArgumentException e) {
            boolean serialUidMismatch = InvalidClassException.class.equals(e.getCause().getClass());
            if (!serialUidMismatch) {
                throw e;
            }
            try {
                SerialUidReplacingInputStream is = new SerialUidReplacingInputStream(new ByteArrayInputStream(data));
                Object t = is.readObject();
                if (null != mismatchCallback) {
                    mismatchCallback.accept(t);
                }
                return (T)t;
            }
            catch (IOException | ClassNotFoundException e1) {
                throw new IllegalArgumentException("Unable to serialize object", e1);
            }
        }
    }

    public static class SerialUidReplacingInputStream
    extends ObjectInputStream {
        private static Logger logger = LoggerFactory.getLogger(SerialUidReplacingInputStream.class);

        public SerialUidReplacingInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
            Class<?> localClass;
            ObjectStreamClass resultClassDescriptor = super.readClassDescriptor();
            try {
                localClass = Class.forName(resultClassDescriptor.getName());
            }
            catch (ClassNotFoundException e) {
                logger.error("No local class for " + resultClassDescriptor.getName(), (Throwable)e);
                return resultClassDescriptor;
            }
            ObjectStreamClass localClassDescriptor = ObjectStreamClass.lookup(localClass);
            if (localClassDescriptor != null) {
                long localSUID = localClassDescriptor.getSerialVersionUID();
                long streamSUID = resultClassDescriptor.getSerialVersionUID();
                if (streamSUID != localSUID) {
                    StringBuffer s = new StringBuffer("Overriding serialized class version mismatch: ");
                    s.append("local serialVersionUID = ").append(localSUID);
                    s.append(" stream serialVersionUID = ").append(streamSUID);
                    InvalidClassException e = new InvalidClassException(s.toString());
                    logger.error("Potentially Fatal Deserialization Operation.", (Throwable)e);
                    resultClassDescriptor = localClassDescriptor;
                }
            }
            return resultClassDescriptor;
        }
    }
}

