/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.validation;

import com.epam.ta.reportportal.commons.accessible.Accessible;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

public class JaskonRequiredPropertiesValidator
implements Validator {
    private static final Logger LOGGER = LoggerFactory.getLogger(JaskonRequiredPropertiesValidator.class);

    public boolean supports(Class<?> clazz) {
        return AnnotationUtils.isAnnotationDeclaredLocally(JsonInclude.class, clazz);
    }

    public void validate(Object object, Errors errors) {
        for (Field field : this.collectFields(object.getClass())) {
            if (AnnotationUtils.isAnnotationDeclaredLocally(JsonInclude.class, field.getType())) {
                try {
                    Object innerObject = Accessible.on((Object)object).field(field).getValue();
                    if (null != innerObject) {
                        errors.pushNestedPath(field.getName());
                        this.validate(innerObject, errors);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("JaskonRequiredPropertiesValidator error: " + e.getMessage(), (Throwable)e);
                }
            }
            if (!field.isAnnotationPresent(JsonProperty.class) || !field.getAnnotation(JsonProperty.class).required()) continue;
            String errorCode = "NotNull." + field.getName();
            ValidationUtils.rejectIfEmpty((Errors)errors, (String)field.getName(), (String)errorCode, (Object[])new Object[]{errorCode});
        }
        if (errors.getNestedPath() != null && errors.getNestedPath().length() != 0) {
            errors.popNestedPath();
        }
    }

    private List<Field> collectFields(Class<?> clazz) {
        List<Object> fields = null;
        if (!Object.class.equals(clazz.getSuperclass())) {
            fields = this.collectFields(clazz.getSuperclass());
        }
        fields = fields == null ? new ArrayList() : fields;
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        return fields;
    }
}

