/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.resolver;

import javax.annotation.Nonnull;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableHandlerMethodArgumentResolver;
import org.springframework.data.web.SortHandlerMethodArgumentResolver;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;

public class PagingHandlerMethodArgumentResolver
extends PageableHandlerMethodArgumentResolver {
    public static final int CUT_DEFAULT_PAGE_SIZE = 10;
    public static final int CUT_DEFAULT_OFFSET = 300;
    public static final int DEFAULT_PAGE_SIZE = 50;
    public static final int MAX_PAGE_SIZE = 300000;

    public PagingHandlerMethodArgumentResolver() {
    }

    public PagingHandlerMethodArgumentResolver(SortHandlerMethodArgumentResolver sortResolver) {
        super(sortResolver);
    }

    @Nonnull
    public Pageable resolveArgument(MethodParameter methodParameter, @Nullable ModelAndViewContainer mavContainer, NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) {
        Pageable pageable = super.resolveArgument(methodParameter, mavContainer, webRequest, binderFactory);
        String pageSize = webRequest.getParameter(this.getParameterNameToUse(this.getSizeParameterName(), methodParameter));
        if (pageSize != null) {
            pageable = PageRequest.of((int)pageable.getPageNumber(), (int)Integer.parseInt(pageSize), (Sort)pageable.getSort());
        }
        if (0 == pageable.getPageSize()) {
            return PageRequest.of((int)pageable.getPageNumber(), (int)50, (Sort)pageable.getSort());
        }
        if (300000 < pageable.getPageSize()) {
            return PageRequest.of((int)pageable.getPageNumber(), (int)300000, (Sort)pageable.getSort());
        }
        return pageable;
    }
}

