/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.resolver;

import com.epam.ta.reportportal.ws.resolver.JacksonViewAware;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;

public class JacksonViewAwareModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;

    public JacksonViewAwareModule(ObjectMapper objectMapper) {
        this.addSerializer(JacksonViewAware.class, (JsonSerializer)new JacksonViewAwareSerializer(objectMapper));
    }

    public static class JacksonViewAwareSerializer
    extends StdScalarSerializer<JacksonViewAware> {
        private ObjectMapper objectMapper;

        protected JacksonViewAwareSerializer(ObjectMapper objectMapper) {
            super(JacksonViewAware.class);
            this.objectMapper = objectMapper;
        }

        public void serialize(JacksonViewAware value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            this.objectMapper.writerWithView(value.getView()).writeValue(jgen, value.getPojo());
        }
    }
}

